/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.unusedImport;

import com.intellij.codeInsight.intention.QuickFixFactory;
import com.intellij.codeInspection.GlobalInspectionContext;
import com.intellij.codeInspection.GlobalSimpleInspectionTool;
import com.intellij.codeInspection.InspectionManager;
import com.intellij.codeInspection.ProblemDescriptionsProcessor;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.java.analysis.JavaAnalysisBundle;
import com.intellij.modcommand.ModCommandAction;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiImportList;
import com.intellij.psi.PsiImportStatementBase;
import com.intellij.psi.PsiJavaFile;
import com.intellij.psi.codeStyle.JavaCodeStyleManager;
import com.intellij.psi.util.FileTypeUtils;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public final class MissortedImportsInspection
extends GlobalSimpleInspectionTool {
    @NonNls
    public static final String SHORT_NAME = "MISSORTED_IMPORTS";

    public void checkFile(@NotNull PsiFile psiFile, @NotNull InspectionManager manager, @NotNull ProblemsHolder problemsHolder, @NotNull GlobalInspectionContext globalContext, @NotNull ProblemDescriptionsProcessor problemDescriptionsProcessor) {
        PsiJavaFile javaFile;
        block12: {
            block11: {
                if (psiFile == null) {
                    MissortedImportsInspection.$$$reportNull$$$0(0);
                }
                if (manager == null) {
                    MissortedImportsInspection.$$$reportNull$$$0(1);
                }
                if (problemsHolder == null) {
                    MissortedImportsInspection.$$$reportNull$$$0(2);
                }
                if (globalContext == null) {
                    MissortedImportsInspection.$$$reportNull$$$0(3);
                }
                if (problemDescriptionsProcessor == null) {
                    MissortedImportsInspection.$$$reportNull$$$0(4);
                }
                if (!(psiFile instanceof PsiJavaFile)) break block11;
                javaFile = (PsiJavaFile)psiFile;
                if (!FileTypeUtils.isInServerPageFile((PsiElement)psiFile)) break block12;
            }
            return;
        }
        PsiImportList importList = javaFile.getImportList();
        if (importList == null) {
            return;
        }
        PsiImportStatementBase[] imports = importList.getAllImportStatements();
        int currentEntryIndex = 0;
        for (PsiImportStatementBase importStatement : imports) {
            ProgressManager.checkCanceled();
            if (importStatement.isForeignFileImport()) continue;
            int entryIndex = JavaCodeStyleManager.getInstance((Project)javaFile.getProject()).findEntryIndex(importStatement);
            if (entryIndex < currentEntryIndex) {
                ModCommandAction fix = QuickFixFactory.getInstance().createOptimizeImportsFix(false, (PsiFile)javaFile);
                problemsHolder.problem((PsiElement)importList, MissortedImportsInspection.getDisplayNameText()).fix(fix).register();
                return;
            }
            currentEntryIndex = entryIndex;
        }
    }

    @NotNull
    public String getShortName() {
        return SHORT_NAME;
    }

    public boolean worksInBatchModeOnly() {
        return false;
    }

    @NotNull
    @Nls
    public static String getDisplayNameText() {
        String string = JavaAnalysisBundle.message((String)"missorted.imports.inspection.display.name", (Object[])new Object[0]);
        if (string == null) {
            MissortedImportsInspection.$$$reportNull$$$0(5);
        }
        return string;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 5 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiFile";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "manager";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "problemsHolder";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "globalContext";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "problemDescriptionsProcessor";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/codeInspection/unusedImport/MissortedImportsInspection";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/codeInspection/unusedImport/MissortedImportsInspection";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getDisplayNameText";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "checkFile";
                break;
            }
            case 5: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 5 -> new IllegalStateException(string);
        };
    }
}

