/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.unusedImport;

import com.intellij.codeInspection.GlobalInspectionContext;
import com.intellij.codeInspection.GlobalSimpleInspectionTool;
import com.intellij.codeInspection.InspectionManager;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptionsProcessor;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.codeInspection.unusedImport.ImportsAreUsedVisitor;
import com.intellij.java.analysis.JavaAnalysisBundle;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiErrorElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiImportModuleStatement;
import com.intellij.psi.PsiImportStatementBase;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.PsiJavaFile;
import com.intellij.psi.PsiJavaModuleReferenceElement;
import com.intellij.psi.util.FileTypeUtils;
import com.intellij.psi.util.PsiTreeUtil;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.fixes.DeleteImportFix;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public final class UnusedImportInspection
extends GlobalSimpleInspectionTool {
    @NonNls
    public static final String SHORT_NAME = "UNUSED_IMPORT";

    public void checkFile(@NotNull PsiFile psiFile, @NotNull InspectionManager manager, @NotNull ProblemsHolder problemsHolder, @NotNull GlobalInspectionContext globalContext, @NotNull ProblemDescriptionsProcessor problemDescriptionsProcessor) {
        PsiJavaFile javaFile;
        block12: {
            block11: {
                if (psiFile == null) {
                    UnusedImportInspection.$$$reportNull$$$0(0);
                }
                if (manager == null) {
                    UnusedImportInspection.$$$reportNull$$$0(1);
                }
                if (problemsHolder == null) {
                    UnusedImportInspection.$$$reportNull$$$0(2);
                }
                if (globalContext == null) {
                    UnusedImportInspection.$$$reportNull$$$0(3);
                }
                if (problemDescriptionsProcessor == null) {
                    UnusedImportInspection.$$$reportNull$$$0(4);
                }
                if (!(psiFile instanceof PsiJavaFile)) break block11;
                javaFile = (PsiJavaFile)psiFile;
                if (!FileTypeUtils.isInServerPageFile((PsiElement)psiFile)) break block12;
            }
            return;
        }
        ImportsAreUsedVisitor visitor2 = new ImportsAreUsedVisitor(javaFile);
        javaFile.accept((PsiElementVisitor)visitor2);
        for (PsiImportStatementBase unusedImportStatement : visitor2.getUnusedImportStatements()) {
            PsiJavaCodeReferenceElement reference;
            if (unusedImportStatement instanceof PsiImportModuleStatement) {
                PsiImportModuleStatement moduleStatement = (PsiImportModuleStatement)unusedImportStatement;
                PsiJavaModuleReferenceElement moduleReference = moduleStatement.getModuleReference();
                if (moduleReference == null) continue;
                reference = moduleReference.getReference();
            } else {
                reference = unusedImportStatement.getImportReference();
            }
            if (reference == null || reference.multiResolve(false).length <= 0 || PsiTreeUtil.skipWhitespacesForward((PsiElement)unusedImportStatement) instanceof PsiErrorElement) continue;
            problemsHolder.registerProblem((PsiElement)unusedImportStatement, InspectionGadgetsBundle.message("unused.import.problem.descriptor", new Object[0]), new LocalQuickFix[]{new DeleteImportFix()});
        }
    }

    @NotNull
    public String getShortName() {
        return SHORT_NAME;
    }

    public boolean worksInBatchModeOnly() {
        return false;
    }

    @NotNull
    @Nls
    public static String getDisplayNameText() {
        String string = JavaAnalysisBundle.message((String)"unused.import.display.name", (Object[])new Object[0]);
        if (string == null) {
            UnusedImportInspection.$$$reportNull$$$0(5);
        }
        return string;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 5 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiFile";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "manager";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "problemsHolder";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "globalContext";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "problemDescriptionsProcessor";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/codeInspection/unusedImport/UnusedImportInspection";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/codeInspection/unusedImport/UnusedImportInspection";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getDisplayNameText";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "checkFile";
                break;
            }
            case 5: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 5 -> new IllegalStateException(string);
        };
    }
}

