/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.util;

import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiParenthesizedExpression;
import com.intellij.psi.PsiPolyadicExpression;
import com.intellij.psi.PsiPrimitiveType;
import com.intellij.psi.PsiType;
import com.intellij.psi.util.PsiUtil;
import com.siyeh.ig.psiutils.CommentTracker;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.Nullable;

public final class ChangeToAppendUtil {
    @Nullable
    public static PsiExpression buildAppendExpression(PsiExpression appendable, PsiExpression concatenation) {
        if (concatenation == null) {
            return null;
        }
        PsiType type = appendable.getType();
        if (type == null) {
            return null;
        }
        boolean useStringValueOf = !type.equalsToText("java.lang.StringBuffer") && !type.equalsToText("java.lang.StringBuilder");
        StringBuilder result = ChangeToAppendUtil.buildAppendExpression(concatenation, useStringValueOf, new StringBuilder(appendable.getText()));
        if (result == null) {
            return null;
        }
        PsiElementFactory factory = JavaPsiFacade.getElementFactory((Project)appendable.getProject());
        return factory.createExpressionFromText(result.toString(), (PsiElement)appendable);
    }

    /*
     * Enabled aggressive block sorting
     */
    @Nullable
    public static StringBuilder buildAppendExpression(@Nullable PsiExpression concatenation, boolean useStringValueOf, @NonNls StringBuilder out) {
        PsiPolyadicExpression polyadicExpression;
        block14: {
            PsiType type;
            block13: {
                if (concatenation == null) {
                    return null;
                }
                type = concatenation.getType();
                if (!(concatenation instanceof PsiPolyadicExpression)) break block13;
                polyadicExpression = (PsiPolyadicExpression)concatenation;
                if (type != null && type.equalsToText("java.lang.String")) break block14;
            }
            if (concatenation instanceof PsiParenthesizedExpression) {
                PsiParenthesizedExpression parenthesizedExpression = (PsiParenthesizedExpression)concatenation;
                PsiExpression expression = parenthesizedExpression.getExpression();
                if (expression == null) return out;
                return ChangeToAppendUtil.buildAppendExpression(expression, useStringValueOf, out);
            }
            ChangeToAppendUtil.append(CommentTracker.textWithSurroundingComments((PsiElement)concatenation), useStringValueOf && (type == null || !type.equalsToText("java.lang.String")), out);
            return out;
        }
        PsiExpression[] operands = polyadicExpression.getOperands();
        boolean isConstant = true;
        boolean isPrimitiveOrBoxed = true;
        boolean isString = false;
        StringBuilder builder = new StringBuilder();
        PsiExpression[] psiExpressionArray = operands;
        int n = psiExpressionArray.length;
        int n2 = 0;
        while (true) {
            if (n2 >= n) {
                if (builder.isEmpty()) return out;
                ChangeToAppendUtil.append(builder, false, out);
                return out;
            }
            PsiExpression operand = psiExpressionArray[n2];
            PsiType operandType = operand.getType();
            if ((isConstant &= PsiUtil.isConstantExpression((PsiExpression)operand)) || !isString && (isPrimitiveOrBoxed &= PsiPrimitiveType.getOptionallyUnboxedType((PsiType)operandType) != null)) {
                if (!builder.isEmpty()) {
                    builder.append('+');
                }
                if (operandType != null && operandType.equalsToText("java.lang.String")) {
                    isString = true;
                }
                builder.append(CommentTracker.textWithSurroundingComments((PsiElement)operand));
            } else if (!operand.textMatches((CharSequence)"\"\"")) {
                if (!builder.isEmpty()) {
                    ChangeToAppendUtil.append(builder, useStringValueOf && !isString, out);
                    builder.setLength(0);
                }
                ChangeToAppendUtil.buildAppendExpression(operand, useStringValueOf, out);
            }
            ++n2;
        }
    }

    private static void append(CharSequence text, boolean useStringValueOf, StringBuilder out) {
        out.append(".append(");
        if (useStringValueOf) {
            out.append("String.valueOf(").append(text).append(')');
        } else {
            out.append(text);
        }
        out.append(')');
    }
}

