/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.util;

import com.intellij.codeInsight.DumbAwareAnnotationUtil;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiCall;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionList;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.PsiLiteralExpression;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiNewExpression;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiType;
import com.intellij.psi.util.PsiTreeUtil;
import com.siyeh.ig.callMatcher.CallHandler;
import com.siyeh.ig.callMatcher.CallMapper;
import com.siyeh.ig.callMatcher.CallMatcher;
import com.siyeh.ig.psiutils.ExpressionUtils;
import java.time.temporal.ChronoField;
import java.time.temporal.ChronoUnit;
import java.util.Arrays;
import java.util.Map;
import java.util.Optional;
import java.util.function.BiPredicate;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class ChronoUtil {
    public static final String TEMPORAL_FIELD = "java.time.temporal.TemporalField";
    public static final String TEMPORAL_UNIT = "java.time.temporal.TemporalUnit";
    public static final String CHRONO_FIELD = "java.time.temporal.ChronoField";
    public static final String CHRONO_UNIT = "java.time.temporal.ChronoUnit";
    private static final String JAVA_TEXT_SIMPLE_DATE_FORMAT = "java.text.SimpleDateFormat";
    private static final CallMatcher FORMAT_PATTERN_METHOD_MATCHER = CallMatcher.anyOf(CallMatcher.instanceCall("java.text.SimpleDateFormat", "applyPattern", "applyLocalizedPattern").parameterTypes("java.lang.String"), CallMatcher.staticCall("java.time.format.DateTimeFormatter", "ofPattern"), CallMatcher.instanceCall("java.time.format.DateTimeFormatterBuilder", "appendPattern").parameterTypes("java.lang.String"));
    public static final CallMatcher CHRONO_GET_MATCHERS = CallMatcher.anyOf(CallMatcher.instanceCall("java.time.LocalDate", "get").parameterTypes("java.time.temporal.TemporalField"), CallMatcher.instanceCall("java.time.LocalDateTime", "get").parameterTypes("java.time.temporal.TemporalField"), CallMatcher.instanceCall("java.time.LocalTime", "get").parameterTypes("java.time.temporal.TemporalField"), CallMatcher.instanceCall("java.time.OffsetTime", "get").parameterTypes("java.time.temporal.TemporalField"), CallMatcher.instanceCall("java.time.OffsetDateTime", "get").parameterTypes("java.time.temporal.TemporalField"), CallMatcher.instanceCall("java.time.ZonedDateTime", "get").parameterTypes("java.time.temporal.TemporalField"));
    public static final CallMatcher CHRONO_GET_LONG_MATCHERS = CallMatcher.anyOf(CallMatcher.instanceCall("java.time.LocalDate", "getLong").parameterTypes("java.time.temporal.TemporalField"), CallMatcher.instanceCall("java.time.LocalDateTime", "getLong").parameterTypes("java.time.temporal.TemporalField"), CallMatcher.instanceCall("java.time.LocalTime", "getLong").parameterTypes("java.time.temporal.TemporalField"), CallMatcher.instanceCall("java.time.OffsetTime", "getLong").parameterTypes("java.time.temporal.TemporalField"), CallMatcher.instanceCall("java.time.OffsetDateTime", "getLong").parameterTypes("java.time.temporal.TemporalField"), CallMatcher.instanceCall("java.time.ZonedDateTime", "getLong").parameterTypes("java.time.temporal.TemporalField"));
    public static final CallMatcher CHRONO_ALL_GET_MATCHERS = CallMatcher.anyOf(CHRONO_GET_MATCHERS, CHRONO_GET_LONG_MATCHERS);
    public static final CallMatcher CHRONO_WITH_MATCHERS = CallMatcher.anyOf(CallMatcher.instanceCall("java.time.LocalDate", "with").parameterTypes("java.time.temporal.TemporalField", "long"), CallMatcher.instanceCall("java.time.LocalDateTime", "with").parameterTypes("java.time.temporal.TemporalField", "long"), CallMatcher.instanceCall("java.time.LocalTime", "with").parameterTypes("java.time.temporal.TemporalField", "long"), CallMatcher.instanceCall("java.time.OffsetTime", "with").parameterTypes("java.time.temporal.TemporalField", "long"), CallMatcher.instanceCall("java.time.OffsetDateTime", "with").parameterTypes("java.time.temporal.TemporalField", "long"), CallMatcher.instanceCall("java.time.ZonedDateTime", "with").parameterTypes("java.time.temporal.TemporalField", "long"));
    public static final CallMatcher CHRONO_PLUS_MINUS_MATCHERS = CallMatcher.anyOf(CallMatcher.instanceCall("java.time.LocalDate", "plus", "minus").parameterTypes("long", "java.time.temporal.TemporalUnit"), CallMatcher.instanceCall("java.time.LocalDateTime", "plus", "minus").parameterTypes("long", "java.time.temporal.TemporalUnit"), CallMatcher.instanceCall("java.time.LocalTime", "plus", "minus").parameterTypes("long", "java.time.temporal.TemporalUnit"), CallMatcher.instanceCall("java.time.OffsetTime", "plus", "minus").parameterTypes("long", "java.time.temporal.TemporalUnit"), CallMatcher.instanceCall("java.time.OffsetDateTime", "plus", "minus").parameterTypes("long", "java.time.temporal.TemporalUnit"), CallMatcher.instanceCall("java.time.ZonedDateTime", "plus", "minus").parameterTypes("long", "java.time.temporal.TemporalUnit"));
    public static final Map<String, ChronoField> chronoFieldMap = Arrays.stream(ChronoField.values()).collect(Collectors.toMap(t -> t.name(), t -> t));
    private static final Map<String, ChronoUnit> chronoUnitMap = Arrays.stream(ChronoUnit.values()).collect(Collectors.toMap(t -> t.name(), t -> t));
    private static final CallMapper<ArgumentMatcher> SKIP_ARGUMENT_METHOD_HANDLER = new CallMapper(CallHandler.of(FORMAT_PATTERN_METHOD_MATCHER, methodCall -> ChronoUtil.argumentNumber(0, (PsiCall)methodCall)));
    private static final Map<String, BiPredicate<PsiNewExpression, PsiElement>> SKIP_ARGUMENT_CONSTRUCTOR_HANDLER = Map.ofEntries(Map.entry("java.text.SimpleDateFormat", (expression, psiElement) -> ChronoUtil.argumentNumber(0, (PsiCall)expression).test(psiElement)));

    private static ArgumentMatcher argumentNumber(int number, @NotNull PsiCall callExpression) {
        if (callExpression == null) {
            ChronoUtil.$$$reportNull$$$0(0);
        }
        return psiElement -> {
            PsiExpressionList argumentList = callExpression.getArgumentList();
            if (argumentList == null) {
                return false;
            }
            PsiExpression[] expressions = argumentList.getExpressions();
            if (number < 0 || number >= expressions.length) {
                return false;
            }
            return PsiTreeUtil.isAncestor((PsiElement)expressions[number], (PsiElement)psiElement, (boolean)false);
        };
    }

    @Nullable
    public static ChronoField getChronoField(@NotNull String name) {
        if (name == null) {
            ChronoUtil.$$$reportNull$$$0(1);
        }
        return chronoFieldMap.get(name);
    }

    public static ChronoUnit getChronoUnit(String name) {
        return chronoUnitMap.get(name);
    }

    public static boolean isWithSupported(@Nullable PsiMethod method, @Nullable ChronoField chronoField) {
        if (method == null || chronoField == null) {
            return false;
        }
        if (!"with".equals(method.getName())) {
            return false;
        }
        if (!CHRONO_WITH_MATCHERS.methodMatches(method)) {
            return false;
        }
        String classQualifiedName = ChronoUtil.getQualifiedName(method);
        if (classQualifiedName == null) {
            return false;
        }
        return ChronoUtil.isAvailableByType(chronoField, classQualifiedName);
    }

    public static boolean isPatternForDateFormat(@NotNull PsiLiteralExpression literalExpression) {
        if (literalExpression == null) {
            ChronoUtil.$$$reportNull$$$0(2);
        }
        if (!ChronoUtil.hasStringType(literalExpression)) {
            return false;
        }
        PsiElement element = ExpressionUtils.getPassThroughParent((PsiExpression)literalExpression);
        if (element == null) {
            return false;
        }
        if (!(element instanceof PsiExpressionList)) {
            return false;
        }
        PsiExpressionList expressionList = (PsiExpressionList)element;
        PsiElement psiElement = expressionList.getParent();
        if (!(psiElement instanceof PsiCall)) {
            return false;
        }
        PsiCall psiCall = (PsiCall)psiElement;
        if (psiCall instanceof PsiMethodCallExpression) {
            PsiMethodCallExpression callExpression = (PsiMethodCallExpression)psiCall;
            return ChronoUtil.isCallExpressionContainsDateFormatMethods(literalExpression, callExpression);
        }
        if (psiCall instanceof PsiNewExpression) {
            PsiNewExpression newExpression = (PsiNewExpression)psiCall;
            return ChronoUtil.isConstructorOfSimpleDateFormat(literalExpression, newExpression);
        }
        return false;
    }

    private static boolean hasStringType(PsiLiteralExpression literalExpression) {
        if (!DumbService.isDumb((Project)literalExpression.getProject())) {
            PsiType type = literalExpression.getType();
            return type != null && type.equalsToText("java.lang.String");
        }
        String text = literalExpression.getText();
        return text.startsWith("\"") && text.endsWith("\"");
    }

    private static boolean isCallExpressionContainsDateFormatMethods(@NotNull PsiLiteralExpression literalExpression, PsiMethodCallExpression callExpression) {
        if (literalExpression == null) {
            ChronoUtil.$$$reportNull$$$0(3);
        }
        if (!DumbService.isDumb((Project)literalExpression.getProject())) {
            ArgumentMatcher matcher = SKIP_ARGUMENT_METHOD_HANDLER.mapFirst(callExpression);
            if (matcher == null) {
                return false;
            }
            return matcher.test(literalExpression);
        }
        PsiReferenceExpression referenceExpression = callExpression.getMethodExpression();
        String referenceName = referenceExpression.getReferenceName();
        return referenceName != null && (referenceName.equals("applyPattern") || referenceName.equals("applyLocalizedPattern") || referenceName.equals("ofPattern") || referenceName.equals("appendPattern"));
    }

    private static boolean isConstructorOfSimpleDateFormat(@NotNull PsiLiteralExpression literalExpression, PsiNewExpression newExpression) {
        PsiJavaCodeReferenceElement reference;
        if (literalExpression == null) {
            ChronoUtil.$$$reportNull$$$0(4);
        }
        if ((reference = newExpression.getClassReference()) == null) {
            return false;
        }
        if (!DumbService.isDumb((Project)literalExpression.getProject())) {
            BiPredicate<PsiNewExpression, PsiElement> predicate = SKIP_ARGUMENT_CONSTRUCTOR_HANDLER.get(reference.getQualifiedName());
            if (predicate == null) {
                return false;
            }
            return predicate.test(newExpression, (PsiElement)literalExpression);
        }
        String text = DumbAwareAnnotationUtil.getFormattedReferenceFqn((String)reference.getText());
        if (reference.isQualified() && text.equals(JAVA_TEXT_SIMPLE_DATE_FORMAT)) {
            return true;
        }
        String name = reference.getReferenceName();
        return name != null && name.equals("SimpleDateFormat");
    }

    @Nullable
    public static String getQualifiedName(@NotNull PsiMethod method) {
        if (method == null) {
            ChronoUtil.$$$reportNull$$$0(5);
        }
        return Optional.ofNullable(method.getContainingClass()).map(c -> c.getQualifiedName()).orElse(null);
    }

    public static boolean isAnyGetSupported(@Nullable PsiMethod method, @Nullable ChronoField chronoField) {
        if (method == null || chronoField == null) {
            return false;
        }
        String methodName = method.getName();
        if (!"get".equals(methodName) && !"getLong".equals(methodName)) {
            return false;
        }
        if (!CHRONO_ALL_GET_MATCHERS.methodMatches(method)) {
            return false;
        }
        if ("get".equals(methodName) && !chronoField.range().isIntValue()) {
            return false;
        }
        String classQualifiedName = ChronoUtil.getQualifiedName(method);
        if (classQualifiedName == null) {
            return false;
        }
        return ChronoUtil.isAvailableByType(chronoField, classQualifiedName);
    }

    public static boolean isPlusMinusSupported(@Nullable PsiMethod method, @Nullable ChronoUnit chronoUnit) {
        if (method == null || chronoUnit == null) {
            return false;
        }
        String methodName = method.getName();
        if (!"plus".equals(methodName) && !"minus".equals(methodName)) {
            return false;
        }
        if (!CHRONO_PLUS_MINUS_MATCHERS.methodMatches(method)) {
            return false;
        }
        String classQualifiedName = ChronoUtil.getQualifiedName(method);
        if (classQualifiedName == null) {
            return false;
        }
        return ChronoUtil.isAvailableByType(chronoUnit, classQualifiedName);
    }

    public static boolean isAvailableByType(@NotNull ChronoField chronoField, @NotNull String classQualifiedName) {
        if (chronoField == null) {
            ChronoUtil.$$$reportNull$$$0(6);
        }
        if (classQualifiedName == null) {
            ChronoUtil.$$$reportNull$$$0(7);
        }
        return switch (classQualifiedName) {
            case "java.time.LocalTime" -> chronoField.isTimeBased();
            case "java.time.LocalDateTime" -> {
                if (chronoField.isTimeBased() || chronoField.isDateBased()) {
                    yield true;
                }
                yield false;
            }
            case "java.time.LocalDate" -> chronoField.isDateBased();
            case "java.time.OffsetTime" -> {
                if (chronoField.isTimeBased() || chronoField == ChronoField.OFFSET_SECONDS) {
                    yield true;
                }
                yield false;
            }
            case "java.time.OffsetDateTime" -> true;
            case "java.time.ZonedDateTime" -> true;
            default -> false;
        };
    }

    private static boolean isAvailableByType(@NotNull ChronoUnit chronoUnit, @NotNull String classQualifiedName) {
        if (chronoUnit == null) {
            ChronoUtil.$$$reportNull$$$0(8);
        }
        if (classQualifiedName == null) {
            ChronoUtil.$$$reportNull$$$0(9);
        }
        return switch (classQualifiedName) {
            case "java.time.LocalTime" -> chronoUnit.isTimeBased();
            case "java.time.LocalDateTime" -> {
                if (chronoUnit != ChronoUnit.FOREVER) {
                    yield true;
                }
                yield false;
            }
            case "java.time.LocalDate" -> chronoUnit.isDateBased();
            case "java.time.OffsetTime" -> chronoUnit.isTimeBased();
            case "java.time.OffsetDateTime" -> {
                if (chronoUnit != ChronoUnit.FOREVER) {
                    yield true;
                }
                yield false;
            }
            case "java.time.ZonedDateTime" -> {
                if (chronoUnit != ChronoUnit.FOREVER) {
                    yield true;
                }
                yield false;
            }
            default -> false;
        };
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "callExpression";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "literalExpression";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "method";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "chronoField";
                break;
            }
            case 7: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "classQualifiedName";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "chronoUnit";
                break;
            }
        }
        objectArray2[1] = "com/intellij/codeInspection/util/ChronoUtil";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "argumentNumber";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "getChronoField";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "isPatternForDateFormat";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "isCallExpressionContainsDateFormatMethods";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "isConstructorOfSimpleDateFormat";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "getQualifiedName";
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                objectArray = objectArray2;
                objectArray2[2] = "isAvailableByType";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private static interface ArgumentMatcher
    extends Predicate<PsiElement> {
    }
}

