/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.find.findUsages;

import com.ibm.icu.text.ListFormatter;
import com.intellij.DynamicBundle;
import com.intellij.analysis.AnalysisBundle;
import com.intellij.find.findUsages.PersistentFindUsagesOptions;
import com.intellij.ide.util.PropertiesComponent;
import com.intellij.openapi.project.Project;
import com.intellij.psi.search.SearchScope;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;

public abstract class JavaFindUsagesOptions
extends PersistentFindUsagesOptions {
    public boolean isSkipImportStatements;

    public JavaFindUsagesOptions(@NotNull Project project) {
        if (project == null) {
            JavaFindUsagesOptions.$$$reportNull$$$0(0);
        }
        super(project);
        this.isUsages = true;
    }

    public JavaFindUsagesOptions(@NotNull SearchScope searchScope) {
        if (searchScope == null) {
            JavaFindUsagesOptions.$$$reportNull$$$0(1);
        }
        super(searchScope);
        this.isUsages = true;
    }

    public final void setDefaults(@NotNull Project project) {
        if (project == null) {
            JavaFindUsagesOptions.$$$reportNull$$$0(2);
        }
        this.setDefaults(PropertiesComponent.getInstance((Project)project), this.findPrefix());
    }

    protected void setDefaults(@NotNull PropertiesComponent properties, @NotNull String prefix) {
        if (properties == null) {
            JavaFindUsagesOptions.$$$reportNull$$$0(3);
        }
        if (prefix == null) {
            JavaFindUsagesOptions.$$$reportNull$$$0(4);
        }
        this.isSearchForTextOccurrences = properties.getBoolean(prefix + "isSearchForTextOccurrences", true);
        this.isUsages = properties.getBoolean(prefix + "isUsages", true);
    }

    public final void storeDefaults(@NotNull Project project) {
        if (project == null) {
            JavaFindUsagesOptions.$$$reportNull$$$0(5);
        }
        this.storeDefaults(PropertiesComponent.getInstance((Project)project), this.findPrefix());
    }

    protected void storeDefaults(@NotNull PropertiesComponent properties, @NotNull String prefix) {
        if (properties == null) {
            JavaFindUsagesOptions.$$$reportNull$$$0(6);
        }
        if (prefix == null) {
            JavaFindUsagesOptions.$$$reportNull$$$0(7);
        }
        properties.setValue(prefix + "isUsages", this.isUsages, true);
        properties.setValue(prefix + "isSearchForTextOccurrences", this.isSearchForTextOccurrences, true);
    }

    @NotNull
    private String findPrefix() {
        String string = ((Object)((Object)this)).getClass().getSimpleName() + ".";
        if (string == null) {
            JavaFindUsagesOptions.$$$reportNull$$$0(8);
        }
        return string;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!super.equals(o)) {
            return false;
        }
        if (((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        return this.isSkipImportStatements == ((JavaFindUsagesOptions)((Object)o)).isSkipImportStatements;
    }

    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + (this.isSkipImportStatements ? 1 : 0);
        return result;
    }

    protected void addUsageTypes(@NotNull List<? super String> to) {
        if (to == null) {
            JavaFindUsagesOptions.$$$reportNull$$$0(9);
        }
        if (this.isUsages) {
            to.add(AnalysisBundle.message((String)"find.usages.panel.title.usages", (Object[])new Object[0]));
        }
    }

    @NotNull
    public final String generateUsagesString() {
        ArrayList strings = new ArrayList();
        this.addUsageTypes(strings);
        if (strings.isEmpty()) {
            String string = AnalysisBundle.message((String)"find.usages.panel.title.usages", (Object[])new Object[0]);
            if (string == null) {
                JavaFindUsagesOptions.$$$reportNull$$$0(10);
            }
            return string;
        }
        return JavaFindUsagesOptions.formatOrList(strings);
    }

    @NotNull
    @Nls
    private static String formatOrList(Collection<?> list) {
        String string = ListFormatter.getInstance((Locale)DynamicBundle.getLocale(), (ListFormatter.Type)ListFormatter.Type.OR, (ListFormatter.Width)ListFormatter.Width.WIDE).format(list);
        if (string == null) {
            JavaFindUsagesOptions.$$$reportNull$$$0(11);
        }
        return string;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 8, 10, 11 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "searchScope";
                break;
            }
            case 3: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "properties";
                break;
            }
            case 4: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "prefix";
                break;
            }
            case 8: 
            case 10: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/find/findUsages/JavaFindUsagesOptions";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "to";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/find/findUsages/JavaFindUsagesOptions";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "findPrefix";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "generateUsagesString";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "formatOrList";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "setDefaults";
                break;
            }
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "storeDefaults";
                break;
            }
            case 8: 
            case 10: 
            case 11: {
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "addUsageTypes";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 8, 10, 11 -> new IllegalStateException(string);
        };
    }
}

