/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.roots.impl;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.components.Service;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.AnnotationOrderRootType;
import com.intellij.openapi.roots.JavaModuleExternalPaths;
import com.intellij.openapi.roots.JavadocOrderRootType;
import com.intellij.openapi.roots.ModuleExtension;
import com.intellij.openapi.roots.OrderRootType;
import com.intellij.openapi.roots.PersistentOrderRootType;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.InvalidDataException;
import com.intellij.openapi.util.WriteExternalException;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.pointers.VirtualFilePointerContainer;
import com.intellij.openapi.vfs.pointers.VirtualFilePointerManager;
import com.intellij.serviceContainer.NonInjectable;
import com.intellij.util.ArrayUtilRt;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;

public final class JavaModuleExternalPathsImpl
extends JavaModuleExternalPaths {
    private static final String ROOT_ELEMENT = "root";
    private volatile Map<? extends OrderRootType, ? extends VirtualFilePointerContainer> myOrderRootPointerContainers = Map.of();
    private final JavaModuleExternalPathsImpl mySource;
    private final Project myProject;

    public JavaModuleExternalPathsImpl(Module module) {
        this(module.getProject(), null);
    }

    @NonInjectable
    private JavaModuleExternalPathsImpl(Project project, JavaModuleExternalPathsImpl source) {
        this.myProject = project;
        this.mySource = source;
        if (source != null) {
            this.copyContainersFrom(source);
        }
    }

    @NotNull
    public ModuleExtension getModifiableModel(boolean writable) {
        return new JavaModuleExternalPathsImpl(this.myProject, this);
    }

    public void commit() {
        this.mySource.copyContainersFrom(this);
    }

    public String @NotNull [] getJavadocUrls() {
        VirtualFilePointerContainer container = this.myOrderRootPointerContainers.get(JavadocOrderRootType.getInstance());
        String[] stringArray = container != null ? container.getUrls() : ArrayUtilRt.EMPTY_STRING_ARRAY;
        if (stringArray == null) {
            JavaModuleExternalPathsImpl.$$$reportNull$$$0(0);
        }
        return stringArray;
    }

    public VirtualFile @NotNull [] getExternalAnnotationsRoots() {
        VirtualFilePointerContainer container = this.myOrderRootPointerContainers.get(AnnotationOrderRootType.getInstance());
        VirtualFile[] virtualFileArray = container != null ? container.getFiles() : VirtualFile.EMPTY_ARRAY;
        if (virtualFileArray == null) {
            JavaModuleExternalPathsImpl.$$$reportNull$$$0(1);
        }
        return virtualFileArray;
    }

    public String @NotNull [] getExternalAnnotationsUrls() {
        VirtualFilePointerContainer container = this.myOrderRootPointerContainers.get(AnnotationOrderRootType.getInstance());
        String[] stringArray = container != null ? container.getUrls() : ArrayUtilRt.EMPTY_STRING_ARRAY;
        if (stringArray == null) {
            JavaModuleExternalPathsImpl.$$$reportNull$$$0(2);
        }
        return stringArray;
    }

    public void setJavadocUrls(String @NotNull [] urls) {
        if (urls == null) {
            JavaModuleExternalPathsImpl.$$$reportNull$$$0(3);
        }
        this.setRootUrls(JavadocOrderRootType.getInstance(), urls);
    }

    public void setExternalAnnotationUrls(String @NotNull [] urls) {
        if (urls == null) {
            JavaModuleExternalPathsImpl.$$$reportNull$$$0(4);
        }
        this.setRootUrls(AnnotationOrderRootType.getInstance(), urls);
    }

    private void setRootUrls(OrderRootType orderRootType, String @NotNull [] urls) {
        VirtualFilePointerContainer container;
        if (urls == null) {
            JavaModuleExternalPathsImpl.$$$reportNull$$$0(5);
        }
        if ((container = this.myOrderRootPointerContainers.get(orderRootType)) == null) {
            if (urls.length == 0) {
                return;
            }
            Disposable myDisposable = (Disposable)this.myProject.getService(ProjectLevelDisposableService.class);
            container = VirtualFilePointerManager.getInstance().createContainer(myDisposable, null);
            HashMap<? extends OrderRootType, ? extends VirtualFilePointerContainer> newMap = new HashMap<OrderRootType, VirtualFilePointerContainer>(this.myOrderRootPointerContainers);
            newMap.put((OrderRootType)orderRootType, (VirtualFilePointerContainer)container);
            this.myOrderRootPointerContainers = Map.copyOf(newMap);
        } else {
            container.clear();
        }
        for (String url : urls) {
            container.add(url);
        }
    }

    public void readExternal(@NotNull Element element) throws InvalidDataException {
        if (element == null) {
            JavaModuleExternalPathsImpl.$$$reportNull$$$0(6);
        }
        HashMap<PersistentOrderRootType, VirtualFilePointerContainer> newMap = new HashMap<PersistentOrderRootType, VirtualFilePointerContainer>();
        for (PersistentOrderRootType orderRootType : OrderRootType.getAllPersistentTypesList()) {
            Element pathsElement;
            String paths = orderRootType.getModulePathsName();
            if (paths == null || (pathsElement = element.getChild(paths)) == null || pathsElement.getChildren(ROOT_ELEMENT).isEmpty()) continue;
            Disposable myDisposable = (Disposable)this.myProject.getService(ProjectLevelDisposableService.class);
            VirtualFilePointerContainer container = VirtualFilePointerManager.getInstance().createContainer(myDisposable, null);
            newMap.put(orderRootType, container);
            container.readExternal(pathsElement, ROOT_ELEMENT, false);
        }
        this.myOrderRootPointerContainers = Map.copyOf(newMap);
    }

    public void writeExternal(@NotNull Element element) throws WriteExternalException {
        if (element == null) {
            JavaModuleExternalPathsImpl.$$$reportNull$$$0(7);
        }
        ArrayList<Element> toWrite = null;
        for (OrderRootType orderRootType : this.myOrderRootPointerContainers.keySet()) {
            VirtualFilePointerContainer container = this.myOrderRootPointerContainers.get(orderRootType);
            if (container == null || container.isEmpty()) continue;
            Element content = new Element(((PersistentOrderRootType)orderRootType).getModulePathsName());
            container.writeExternal(content, ROOT_ELEMENT, false);
            if (toWrite == null) {
                toWrite = new ArrayList<Element>();
            }
            toWrite.add(content);
        }
        if (toWrite != null) {
            toWrite.sort(Comparator.comparing(Element::getName));
            for (Element element2 : toWrite) {
                element.addContent(element2);
            }
        }
    }

    private void copyContainersFrom(@NotNull JavaModuleExternalPathsImpl source) {
        if (source == null) {
            JavaModuleExternalPathsImpl.$$$reportNull$$$0(8);
        }
        Disposable myDisposable = (Disposable)this.myProject.getService(ProjectLevelDisposableService.class);
        List newEntries = ContainerUtil.map(source.myOrderRootPointerContainers.entrySet(), e -> Map.entry((OrderRootType)e.getKey(), ((VirtualFilePointerContainer)e.getValue()).clone(myDisposable, null)));
        this.myOrderRootPointerContainers = Map.ofEntries(newEntries.toArray(new Map.Entry[0]));
    }

    public boolean isChanged() {
        if (this.myOrderRootPointerContainers.size() != this.mySource.myOrderRootPointerContainers.size()) {
            return true;
        }
        for (OrderRootType orderRootType : this.myOrderRootPointerContainers.keySet()) {
            String[] otherUrls;
            VirtualFilePointerContainer container = this.myOrderRootPointerContainers.get(orderRootType);
            VirtualFilePointerContainer otherContainer = this.mySource.myOrderRootPointerContainers.get(orderRootType);
            if (container == null || otherContainer == null) {
                if (container == otherContainer) continue;
                return true;
            }
            String[] urls = container.getUrls();
            if (urls.length != (otherUrls = otherContainer.getUrls()).length) {
                return true;
            }
            for (int i = 0; i < urls.length; ++i) {
                if (Comparing.strEqual((String)urls[i], (String)otherUrls[i])) continue;
                return true;
            }
        }
        return false;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 3, 4, 5, 6, 7, 8 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/roots/impl/JavaModuleExternalPathsImpl";
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "urls";
                break;
            }
            case 6: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "source";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getJavadocUrls";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getExternalAnnotationsRoots";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getExternalAnnotationsUrls";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/roots/impl/JavaModuleExternalPathsImpl";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "setJavadocUrls";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "setExternalAnnotationUrls";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "setRootUrls";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "readExternal";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "writeExternal";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "copyContainersFrom";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 3, 4, 5, 6, 7, 8 -> new IllegalArgumentException(string);
        };
    }

    @Service(value={Service.Level.PROJECT})
    private static final class ProjectLevelDisposableService
    implements Disposable {
        private ProjectLevelDisposableService() {
        }

        public void dispose() {
        }
    }
}

