/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl;

import com.intellij.java.workspace.entities.JavaSourceRootPropertiesEntity;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ContentEntry;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.roots.SourceFolder;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.platform.backend.workspace.WorkspaceModelChangeListener;
import com.intellij.platform.backend.workspace.WorkspaceModelTopics;
import com.intellij.platform.workspace.jps.entities.ModuleEntity;
import com.intellij.platform.workspace.storage.EntityChange;
import com.intellij.platform.workspace.storage.EntityStorage;
import com.intellij.platform.workspace.storage.VersionedStorageChange;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.util.SmartList;
import com.intellij.util.containers.MultiMap;
import com.intellij.workspaceModel.ide.impl.legacyBridge.module.ModuleEntityUtils;
import com.intellij.workspaceModel.ide.legacyBridge.ModuleBridge;
import java.util.Collection;
import java.util.Iterator;
import java.util.function.BiConsumer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jps.model.java.JavaModuleSourceRootTypes;

public class PackagePrefixIndex {
    private static final Object LOCK = new Object();
    private MultiMap<String, Module> myMap;
    private final Project myProject;

    public PackagePrefixIndex(Project project) {
        this.myProject = project;
        project.getMessageBus().connect().subscribe(WorkspaceModelTopics.CHANGED, (Object)new WorkspaceModelChangeListener(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void changed(@NotNull VersionedStorageChange event) {
                MultiMap<String, Module> map;
                if (event == null) {
                    1.$$$reportNull$$$0(0);
                }
                Iterator iterator = LOCK;
                synchronized (iterator) {
                    map = PackagePrefixIndex.this.myMap;
                }
                if (map != null) {
                    for (EntityChange change : event.getChanges(JavaSourceRootPropertiesEntity.class)) {
                        JavaSourceRootPropertiesEntity newEntity;
                        JavaSourceRootPropertiesEntity oldEntity = (JavaSourceRootPropertiesEntity)change.getOldEntity();
                        if (oldEntity != null) {
                            1.updateMap(oldEntity, (EntityStorage)event.getStorageBefore(), (prefix, module) -> map.remove(prefix, module));
                        }
                        if ((newEntity = (JavaSourceRootPropertiesEntity)change.getNewEntity()) == null) continue;
                        1.updateMap(newEntity, (EntityStorage)event.getStorageAfter(), (prefix, module) -> map.putValue(prefix, module));
                    }
                }
            }

            private static void updateMap(@NotNull JavaSourceRootPropertiesEntity entity, @NotNull EntityStorage storageAfter, @NotNull BiConsumer<? super String, ? super Module> updater) {
                ModuleBridge module;
                String prefix;
                if (entity == null) {
                    1.$$$reportNull$$$0(1);
                }
                if (storageAfter == null) {
                    1.$$$reportNull$$$0(2);
                }
                if (updater == null) {
                    1.$$$reportNull$$$0(3);
                }
                if (StringUtil.isNotEmpty((String)(prefix = entity.getPackagePrefix())) && (module = ModuleEntityUtils.findModule((ModuleEntity)entity.getSourceRoot().getContentRoot().getModule(), (EntityStorage)storageAfter)) != null) {
                    updater.accept(prefix, (Module)module);
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[3];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "event";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "entity";
                        break;
                    }
                    case 2: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "storageAfter";
                        break;
                    }
                    case 3: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "updater";
                        break;
                    }
                }
                objectArray2[1] = "com/intellij/psi/impl/PackagePrefixIndex$1";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "changed";
                        break;
                    }
                    case 1: 
                    case 2: 
                    case 3: {
                        objectArray = objectArray2;
                        objectArray2[2] = "updateMap";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Collection<String> getAllPackagePrefixes(@Nullable GlobalSearchScope scope) {
        MultiMap map;
        Object object = LOCK;
        synchronized (object) {
            map = this.myMap;
        }
        if (map != null) {
            return PackagePrefixIndex.getAllPackagePrefixes(scope, map);
        }
        map = new MultiMap();
        for (Module module : ModuleManager.getInstance((Project)this.myProject).getModules()) {
            for (ContentEntry entry : ModuleRootManager.getInstance((Module)module).getContentEntries()) {
                for (SourceFolder folder : entry.getSourceFolders(JavaModuleSourceRootTypes.SOURCES)) {
                    String prefix = folder.getPackagePrefix();
                    if (!StringUtil.isNotEmpty((String)prefix)) continue;
                    map.putValue((Object)prefix, (Object)module);
                }
            }
        }
        Object object2 = LOCK;
        synchronized (object2) {
            if (this.myMap == null) {
                this.myMap = map;
            }
            return PackagePrefixIndex.getAllPackagePrefixes(scope, this.myMap);
        }
    }

    private static Collection<String> getAllPackagePrefixes(GlobalSearchScope scope, MultiMap<String, Module> map) {
        if (scope == null) {
            return map.keySet();
        }
        SmartList result = new SmartList();
        block0: for (String prefix : map.keySet()) {
            for (Module module : map.get((Object)prefix)) {
                if (!scope.isSearchInModuleContent(module)) continue;
                result.add(prefix);
                continue block0;
            }
        }
        return result;
    }
}

