/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl;

import com.intellij.codeInsight.JavaExpressionTypeNullabilityPatcher;
import com.intellij.codeInsight.TypeNullability;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiType;
import com.siyeh.ig.callMatcher.CallMatcher;
import com.siyeh.ig.psiutils.ExpressionUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

final class StreamNullabilityPatcher
implements JavaExpressionTypeNullabilityPatcher {
    private static final CallMatcher STREAM_FILTER_TAKE_WHILE = CallMatcher.instanceCall("java.util.stream.Stream", "filter", "takeWhile").parameterCount(1);

    StreamNullabilityPatcher() {
    }

    @Nullable
    public PsiType tryPatchType(@NotNull PsiExpression expression, @NotNull PsiType type) {
        if (expression == null) {
            StreamNullabilityPatcher.$$$reportNull$$$0(0);
        }
        if (type == null) {
            StreamNullabilityPatcher.$$$reportNull$$$0(1);
        }
        if (type instanceof PsiClassType) {
            PsiType[] parameters;
            PsiClass psiClass;
            PsiMethodCallExpression call;
            PsiClassType classType = (PsiClassType)type;
            if (expression instanceof PsiMethodCallExpression && STREAM_FILTER_TAKE_WHILE.test(call = (PsiMethodCallExpression)expression) && ExpressionUtils.isNullFilteringFunction(call.getArgumentList().getExpressions()[0]) && (psiClass = classType.resolve()) != null && "java.util.stream.Stream".equals(psiClass.getQualifiedName()) && (parameters = classType.getParameters()).length == 1) {
                return JavaPsiFacade.getElementFactory((Project)expression.getProject()).createType(psiClass, parameters[0].withNullability(TypeNullability.NOT_NULL_KNOWN));
            }
        }
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "expression";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "type";
                break;
            }
        }
        objectArray[1] = "com/intellij/psi/impl/StreamNullabilityPatcher";
        objectArray[2] = "tryPatchType";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

