/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.file.impl;

import com.intellij.ide.highlighter.JavaClassFileType;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.FileTypeRegistry;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.impl.scopes.ModuleWithDependenciesScope;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.roots.PackageIndex;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.Predicates;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiJavaModule;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiNameHelper;
import com.intellij.psi.PsiPackage;
import com.intellij.psi.impl.PackagePrefixElementFinder;
import com.intellij.psi.impl.PsiImplUtil;
import com.intellij.psi.impl.PsiManagerEx;
import com.intellij.psi.impl.file.PsiPackageImpl;
import com.intellij.psi.impl.file.impl.JavaFileManager;
import com.intellij.psi.impl.java.stubs.index.JavaFullClassNameIndex;
import com.intellij.psi.search.DelegatingGlobalSearchScope;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.searches.JavaModuleSearch;
import com.intellij.psi.util.JavaMultiReleaseUtil;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.ListIterator;
import java.util.Objects;
import java.util.function.Predicate;
import java.util.stream.Stream;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class JavaFileManagerImpl
implements JavaFileManager,
Disposable {
    private static final Logger LOG = Logger.getInstance(JavaFileManagerImpl.class);
    private final PsiManagerEx myManager;
    private boolean myDisposed;

    public JavaFileManagerImpl(Project project) {
        this.myManager = PsiManagerEx.getInstanceEx((Project)project);
    }

    public void dispose() {
        this.myDisposed = true;
    }

    @Nullable
    public PsiPackage findPackage(@NotNull String packageName) {
        PackageIndex index;
        if (packageName == null) {
            JavaFileManagerImpl.$$$reportNull$$$0(0);
        }
        if ((index = PackageIndex.getInstance((Project)this.myManager.getProject())).getDirsByPackageName(packageName, true).findFirst() == null && index.getFilesByPackageName(packageName).findFirst() == null) {
            return null;
        }
        return new PsiPackageImpl((PsiManager)this.myManager, packageName);
    }

    public PsiClass @NotNull [] findClasses(@NotNull String qName, @NotNull GlobalSearchScope scope) {
        List<Pair<PsiClass, VirtualFile>> result;
        int count;
        if (qName == null) {
            JavaFileManagerImpl.$$$reportNull$$$0(1);
        }
        if (scope == null) {
            JavaFileManagerImpl.$$$reportNull$$$0(2);
        }
        if ((count = (result = this.doFindClasses(qName, scope)).size()) == 0) {
            if (PsiClass.EMPTY_ARRAY == null) {
                JavaFileManagerImpl.$$$reportNull$$$0(3);
            }
            return PsiClass.EMPTY_ARRAY;
        }
        if (count == 1) {
            PsiClass[] psiClassArray = new PsiClass[]{(PsiClass)result.getFirst().getFirst()};
            if (psiClassArray == null) {
                JavaFileManagerImpl.$$$reportNull$$$0(4);
            }
            return psiClassArray;
        }
        ContainerUtil.quickSort(result, (o1, o2) -> scope.compare((VirtualFile)o2.getSecond(), (VirtualFile)o1.getSecond()));
        PsiClass[] psiClassArray = (PsiClass[])result.stream().map(p -> (PsiClass)p.getFirst()).toArray(PsiClass[]::new);
        if (psiClassArray == null) {
            JavaFileManagerImpl.$$$reportNull$$$0(5);
        }
        return psiClassArray;
    }

    public boolean hasClass(@NotNull String qName, @NotNull GlobalSearchScope scope, @NotNull Predicate<PsiClass> filter) {
        if (qName == null) {
            JavaFileManagerImpl.$$$reportNull$$$0(6);
        }
        if (scope == null) {
            JavaFileManagerImpl.$$$reportNull$$$0(7);
        }
        if (filter == null) {
            JavaFileManagerImpl.$$$reportNull$$$0(8);
        }
        List<Pair<PsiClass, VirtualFile>> pairs = this.doFindClasses(qName, scope);
        if (filter == Predicates.alwaysTrue()) {
            return !pairs.isEmpty();
        }
        for (Pair<PsiClass, VirtualFile> pair : pairs) {
            if (!filter.test((PsiClass)pair.getFirst())) continue;
            return true;
        }
        return false;
    }

    @NotNull
    private List<Pair<PsiClass, VirtualFile>> doFindClasses(@NotNull String qName, @NotNull GlobalSearchScope scope) {
        Collection classes;
        if (qName == null) {
            JavaFileManagerImpl.$$$reportNull$$$0(9);
        }
        if (scope == null) {
            JavaFileManagerImpl.$$$reportNull$$$0(10);
        }
        if ((classes = JavaFullClassNameIndex.getInstance().getClasses((CharSequence)qName, this.myManager.getProject(), scope)).isEmpty()) {
            List<Pair<PsiClass, VirtualFile>> list = Collections.emptyList();
            if (list == null) {
                JavaFileManagerImpl.$$$reportNull$$$0(11);
            }
            return list;
        }
        ArrayList<Pair<PsiClass, VirtualFile>> result = new ArrayList<Pair<PsiClass, VirtualFile>>(classes.size());
        for (PsiClass aClass : classes) {
            PsiFile file = aClass.getContainingFile();
            if (file == null) {
                throw new AssertionError((Object)("No file for class: " + String.valueOf(aClass) + " of " + String.valueOf(aClass.getClass())));
            }
            VirtualFile vFile = file.getViewProvider().getVirtualFile();
            if (!this.hasAcceptablePackage(vFile)) continue;
            result.add((Pair<PsiClass, VirtualFile>)Pair.create((Object)aClass, (Object)vFile));
        }
        ArrayList<Pair<PsiClass, VirtualFile>> arrayList = result;
        if (arrayList == null) {
            JavaFileManagerImpl.$$$reportNull$$$0(12);
        }
        return arrayList;
    }

    @Nullable
    public PsiClass findClass(@NotNull String qName, @NotNull GlobalSearchScope scope) {
        if (qName == null) {
            JavaFileManagerImpl.$$$reportNull$$$0(13);
        }
        if (scope == null) {
            JavaFileManagerImpl.$$$reportNull$$$0(14);
        }
        LOG.assertTrue(!this.myDisposed);
        VirtualFile bestFile = null;
        PsiClass bestClass = null;
        List<Pair<PsiClass, VirtualFile>> result = this.doFindClasses(qName, scope);
        for (int i = 0; i < result.size(); ++i) {
            Pair<PsiClass, VirtualFile> pair = result.get(i);
            VirtualFile vFile = (VirtualFile)pair.getSecond();
            if (bestFile != null && scope.compare(vFile, bestFile) <= 0) continue;
            bestFile = vFile;
            bestClass = (PsiClass)pair.getFirst();
        }
        return bestClass;
    }

    private boolean hasAcceptablePackage(@NotNull VirtualFile vFile) {
        if (vFile == null) {
            JavaFileManagerImpl.$$$reportNull$$$0(15);
        }
        if (FileTypeRegistry.getInstance().isFileOfType(vFile, (FileType)JavaClassFileType.INSTANCE)) {
            ProjectFileIndex index = ProjectRootManager.getInstance((Project)this.myManager.getProject()).getFileIndex();
            boolean checkMultiRelease = index.isInLibrary(vFile);
            VirtualFile root = index.getClassRootForFile(vFile);
            PsiNameHelper nameHelper = PsiNameHelper.getInstance((Project)this.myManager.getProject());
            for (VirtualFile parent = vFile.getParent(); !(parent == null || Comparing.equal((Object)parent, (Object)root) || checkMultiRelease && JavaMultiReleaseUtil.getVersionForVersionRoot((VirtualFile)root, (VirtualFile)parent) != null); parent = parent.getParent()) {
                if (nameHelper.isIdentifier(parent.getName())) continue;
                return false;
            }
        }
        return true;
    }

    @NotNull
    public Collection<String> getNonTrivialPackagePrefixes() {
        Collection<String> collection = PackagePrefixElementFinder.getInstance(this.myManager.getProject()).getAllPackagePrefixes(GlobalSearchScope.projectScope((Project)this.myManager.getProject()));
        if (collection == null) {
            JavaFileManagerImpl.$$$reportNull$$$0(16);
        }
        return collection;
    }

    @NotNull
    public Collection<PsiJavaModule> findModules(@NotNull String moduleName, @NotNull GlobalSearchScope scope) {
        if (moduleName == null) {
            JavaFileManagerImpl.$$$reportNull$$$0(17);
        }
        if (scope == null) {
            JavaFileManagerImpl.$$$reportNull$$$0(18);
        }
        LibSrcExcludingScope excludingScope = new LibSrcExcludingScope(scope);
        Collection results = JavaModuleSearch.search((String)moduleName, (Project)this.myManager.getProject(), (GlobalSearchScope)excludingScope).findAll();
        Collection<PsiJavaModule> collection = JavaFileManagerImpl.upgradeModules(JavaFileManagerImpl.sortModules(results, scope), moduleName, scope);
        if (collection == null) {
            JavaFileManagerImpl.$$$reportNull$$$0(19);
        }
        return collection;
    }

    private static Collection<PsiJavaModule> sortModules(Collection<PsiJavaModule> modules, GlobalSearchScope scope) {
        if (modules.size() > 1) {
            ArrayList<PsiJavaModule> list = new ArrayList<PsiJavaModule>(modules);
            list.sort((m1, m2) -> scope.compare(PsiImplUtil.getModuleVirtualFile((PsiJavaModule)m2), PsiImplUtil.getModuleVirtualFile((PsiJavaModule)m1)));
            modules = list;
        }
        return modules;
    }

    private static Collection<PsiJavaModule> upgradeModules(Collection<PsiJavaModule> modules, String moduleName, GlobalSearchScope scope) {
        if (scope instanceof DelegatingGlobalSearchScope) {
            DelegatingGlobalSearchScope delegatingScope = (DelegatingGlobalSearchScope)scope;
            scope = delegatingScope.unwrap();
        }
        if (modules.size() > 1 && PsiJavaModule.UPGRADEABLE.contains(moduleName) && scope instanceof ModuleWithDependenciesScope) {
            ModuleWithDependenciesScope moduleScope = (ModuleWithDependenciesScope)scope;
            Module module = moduleScope.getModule();
            boolean isModular = Stream.of(ModuleRootManager.getInstance((Module)module).getSourceRoots(true)).filter(arg_0 -> ((GlobalSearchScope)scope).contains(arg_0)).anyMatch(root -> root.findChild("module-info.java") != null);
            if (isModular) {
                List<PsiJavaModule> list = new ArrayList<PsiJavaModule>(modules);
                ProjectFileIndex index = ProjectFileIndex.getInstance((Project)module.getProject());
                ListIterator i = list.listIterator();
                while (i.hasNext()) {
                    PsiJavaModule candidate = (PsiJavaModule)i.next();
                    if (index.findContainingSdks(PsiImplUtil.getModuleVirtualFile((PsiJavaModule)candidate)).isEmpty()) continue;
                    if (i.previousIndex() > 0) {
                        i.remove();
                        continue;
                    }
                    list = Collections.singletonList(candidate);
                    break;
                }
                if (list.size() != modules.size()) {
                    modules = list;
                }
            }
        }
        return modules;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 3, 4, 5, 11, 12, 16, 19 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "packageName";
                break;
            }
            case 1: 
            case 6: 
            case 9: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "qName";
                break;
            }
            case 2: 
            case 7: 
            case 10: 
            case 14: 
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "scope";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 11: 
            case 12: 
            case 16: 
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/psi/impl/file/impl/JavaFileManagerImpl";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "filter";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "vFile";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "moduleName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/psi/impl/file/impl/JavaFileManagerImpl";
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "findClasses";
                break;
            }
            case 11: 
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "doFindClasses";
                break;
            }
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "getNonTrivialPackagePrefixes";
                break;
            }
            case 19: {
                objectArray = objectArray2;
                objectArray2[1] = "findModules";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "findPackage";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "findClasses";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 11: 
            case 12: 
            case 16: 
            case 19: {
                break;
            }
            case 6: 
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "hasClass";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "doFindClasses";
                break;
            }
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "findClass";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "hasAcceptablePackage";
                break;
            }
            case 17: 
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "findModules";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 3, 4, 5, 11, 12, 16, 19 -> new IllegalStateException(string);
        };
    }

    private static class LibSrcExcludingScope
    extends DelegatingGlobalSearchScope {
        private final ProjectFileIndex myIndex;

        LibSrcExcludingScope(@NotNull GlobalSearchScope baseScope) {
            if (baseScope == null) {
                LibSrcExcludingScope.$$$reportNull$$$0(0);
            }
            super(baseScope);
            this.myIndex = ProjectFileIndex.getInstance((Project)Objects.requireNonNull(baseScope.getProject()));
        }

        public boolean contains(@NotNull VirtualFile file) {
            if (file == null) {
                LibSrcExcludingScope.$$$reportNull$$$0(1);
            }
            return super.contains(file) && (!this.myIndex.isInLibrarySource(file) || this.myIndex.isInLibraryClasses(file));
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "baseScope";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "file";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/psi/impl/file/impl/JavaFileManagerImpl$LibSrcExcludingScope";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "contains";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

