/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.util;

import com.intellij.codeInspection.bytecodeAnalysis.ProjectBytecodeAnalysis;
import com.intellij.lang.java.beans.PropertyKind;
import com.intellij.lang.jvm.JvmModifier;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaTokenType;
import com.intellij.psi.PsiAssignmentExpression;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionStatement;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiParameterList;
import com.intellij.psi.PsiQualifiedExpression;
import com.intellij.psi.PsiRecordComponent;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiResolveHelper;
import com.intellij.psi.PsiStatement;
import com.intellij.psi.PsiType;
import com.intellij.psi.impl.JavaSimplePropertyGistKt;
import com.intellij.psi.impl.compiled.ClsMethodImpl;
import com.intellij.psi.impl.light.LightRecordMethod;
import com.intellij.psi.impl.source.PsiMethodImpl;
import com.intellij.psi.util.InheritanceUtil;
import com.intellij.psi.util.JavaPsiRecordUtil;
import com.intellij.psi.util.PropertyUtilBase;
import com.intellij.psi.util.PsiUtil;
import java.util.function.Supplier;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;

public final class PropertyUtil
extends PropertyUtilBase {
    private PropertyUtil() {
    }

    @Nullable
    public static PsiField getFieldOfGetter(@NotNull PsiMethod method) {
        if (method == null) {
            PropertyUtil.$$$reportNull$$$0(0);
        }
        return PropertyUtil.getFieldOfGetter(method, true);
    }

    @Nullable
    private static PsiField getFieldOfGetter(@NotNull PsiMethod method, boolean useIndex) {
        if (method == null) {
            PropertyUtil.$$$reportNull$$$0(1);
        }
        return PropertyUtil.getFieldOfGetter(method, () -> PropertyUtil.getGetterReturnExpression((PsiMethod)method), useIndex);
    }

    @Nullable
    public static PsiField getFieldOfGetter(@NotNull PsiMethod method, Supplier<? extends PsiExpression> returnExprSupplier, boolean useIndex) {
        PsiField field;
        if (method == null) {
            PropertyUtil.$$$reportNull$$$0(2);
        }
        if ((field = PropertyUtil.getFieldImpl(method, returnExprSupplier, useIndex)) == null || !PropertyUtil.checkFieldLocation(method, field)) {
            return null;
        }
        PsiType returnType = method.getReturnType();
        return returnType != null && field.getType().equals(returnType) ? field : null;
    }

    @Nullable
    private static PsiField getFieldImpl(@NotNull PsiMethod method, @NotNull Supplier<? extends PsiExpression> returnExprSupplier, boolean useIndex) {
        if (method == null) {
            PropertyUtil.$$$reportNull$$$0(3);
        }
        if (returnExprSupplier == null) {
            PropertyUtil.$$$reportNull$$$0(4);
        }
        if (!method.getParameterList().isEmpty()) {
            return null;
        }
        if (method instanceof LightRecordMethod) {
            PsiRecordComponent component = JavaPsiRecordUtil.getRecordComponentForAccessor((PsiMethod)method);
            return component == null ? null : JavaPsiRecordUtil.getFieldForComponent((PsiRecordComponent)component);
        }
        if (useIndex) {
            PsiModifierListOwner psiModifierListOwner = PsiUtil.preferCompiledElement((PsiModifierListOwner)method);
            if (psiModifierListOwner instanceof ClsMethodImpl) {
                ClsMethodImpl compiledMethod = (ClsMethodImpl)psiModifierListOwner;
                return ProjectBytecodeAnalysis.getInstance(method.getProject()).findFieldForAccessor((PsiMethod)compiledMethod);
            }
            if (method instanceof PsiMethodImpl && method.isPhysical()) {
                return JavaSimplePropertyGistKt.getFieldOfGetter((PsiMethod)method);
            }
        }
        return PropertyUtil.getSimplyReturnedField((PsiExpression)returnExprSupplier.get());
    }

    public static boolean isSimpleGetter(@NotNull PsiMethod method) {
        if (method == null) {
            PropertyUtil.$$$reportNull$$$0(5);
        }
        return PropertyUtil.isSimpleGetter(method, true);
    }

    @TestOnly
    public static boolean isSimpleGetter(@NotNull PsiMethod method, boolean useIndex) {
        if (method == null) {
            PropertyUtil.$$$reportNull$$$0(6);
        }
        return PropertyUtil.getFieldOfGetter(method, useIndex) != null;
    }

    @Nullable
    public static PsiField getFieldOfSetter(@Nullable PsiMethod method) {
        return PropertyUtil.getFieldOfSetter(method, true);
    }

    @Nullable
    private static PsiField getFieldOfSetter(@Nullable PsiMethod method, boolean useIndex) {
        if (method == null) {
            return null;
        }
        PsiParameterList parameterList = method.getParameterList();
        if (parameterList.getParametersCount() != 1) {
            return null;
        }
        PsiField field = useIndex && method instanceof PsiMethodImpl && method.isPhysical() ? JavaSimplePropertyGistKt.getFieldOfSetter((PsiMethod)method) : (useIndex && method instanceof ClsMethodImpl ? ProjectBytecodeAnalysis.getInstance(method.getProject()).findFieldForAccessor(method) : PropertyUtil.getFieldFromSetterExplicit(method));
        if (field == null) {
            return null;
        }
        return field.getType().equals(parameterList.getParameters()[0].getType()) && PropertyUtil.checkFieldLocation(method, field) ? field : null;
    }

    @Nullable
    private static PsiField getFieldFromSetterExplicit(@NotNull PsiMethod method) {
        PsiReferenceExpression ref;
        boolean allowedQualifier;
        PsiStatement psiStatement;
        String name;
        if (method == null) {
            PropertyUtil.$$$reportNull$$$0(7);
        }
        if (!(name = method.getName()).startsWith(SET_PREFIX)) {
            return null;
        }
        PsiCodeBlock body = method.getBody();
        if (body == null) {
            return null;
        }
        PsiStatement[] statements = body.getStatements();
        if (statements.length != 1 || !((psiStatement = statements[0]) instanceof PsiExpressionStatement)) {
            return null;
        }
        PsiExpressionStatement possibleAssignmentStatement = (PsiExpressionStatement)psiStatement;
        PsiExpression possibleAssignment = possibleAssignmentStatement.getExpression();
        if (!(possibleAssignment instanceof PsiAssignmentExpression)) {
            return null;
        }
        PsiAssignmentExpression assignment = (PsiAssignmentExpression)possibleAssignment;
        if (!JavaTokenType.EQ.equals(assignment.getOperationTokenType())) {
            return null;
        }
        PsiExpression lhs = PsiUtil.skipParenthesizedExprDown((PsiExpression)assignment.getLExpression());
        if (!(lhs instanceof PsiReferenceExpression)) {
            return null;
        }
        PsiReferenceExpression reference = (PsiReferenceExpression)lhs;
        PsiExpression qualifier = PsiUtil.skipParenthesizedExprDown((PsiExpression)reference.getQualifierExpression());
        boolean bl = allowedQualifier = qualifier == null || qualifier instanceof PsiQualifiedExpression || qualifier instanceof PsiReferenceExpression && (ref = (PsiReferenceExpression)qualifier).resolve() instanceof PsiClass;
        if (!allowedQualifier) {
            return null;
        }
        PsiElement psiElement = reference.resolve();
        if (!(psiElement instanceof PsiField)) {
            return null;
        }
        PsiField field = (PsiField)psiElement;
        PsiExpression rhs = PsiUtil.skipParenthesizedExprDown((PsiExpression)assignment.getRExpression());
        if (!(rhs instanceof PsiReferenceExpression)) {
            return null;
        }
        PsiReferenceExpression rReference = (PsiReferenceExpression)rhs;
        if (rReference.getQualifierExpression() != null) {
            return null;
        }
        if (!(rReference.resolve() instanceof PsiParameter)) {
            return null;
        }
        return field;
    }

    public static boolean isSimpleSetter(@Nullable PsiMethod method) {
        return PropertyUtil.isSimpleSetter(method, true);
    }

    @TestOnly
    public static boolean isSimpleSetter(@Nullable PsiMethod method, boolean useIndex) {
        return PropertyUtil.getFieldOfSetter(method, useIndex) != null;
    }

    @Nullable
    public static PsiMethod getReversePropertyMethod(PsiMethod propertyMethod) {
        PsiField field;
        if (propertyMethod == null) {
            return null;
        }
        PsiClass aClass = propertyMethod.getContainingClass();
        if (aClass == null) {
            return null;
        }
        String methodName = propertyMethod.getName();
        PropertyKind kind = PropertyUtil.getPropertyKind((String)propertyMethod.getName());
        if (kind == null) {
            return null;
        }
        String name = methodName.substring(kind.prefix.length());
        PsiField psiField = field = kind == PropertyKind.SETTER ? PropertyUtil.getFieldOfSetter(propertyMethod) : PropertyUtil.getFieldOfGetter(propertyMethod);
        if (field == null) {
            return null;
        }
        if (kind == PropertyKind.SETTER) {
            PsiMethod result = PropertyUtil.findPropertyMethod(aClass, PropertyKind.GETTER, name, field);
            if (result != null) {
                return result;
            }
            return PropertyUtil.findPropertyMethod(aClass, PropertyKind.BOOLEAN_GETTER, name, field);
        }
        return PropertyUtil.findPropertyMethod(aClass, PropertyKind.SETTER, name, field);
    }

    private static PsiMethod findPropertyMethod(@NotNull PsiClass aClass, @NotNull PropertyKind kind, @NotNull String propertyName, @NotNull PsiField field1) {
        PsiMethod[] methods;
        if (aClass == null) {
            PropertyUtil.$$$reportNull$$$0(8);
        }
        if (kind == null) {
            PropertyUtil.$$$reportNull$$$0(9);
        }
        if (propertyName == null) {
            PropertyUtil.$$$reportNull$$$0(10);
        }
        if (field1 == null) {
            PropertyUtil.$$$reportNull$$$0(11);
        }
        for (PsiMethod method : methods = aClass.findMethodsByName(kind.prefix + propertyName, true)) {
            PsiField field2;
            PsiField psiField = field2 = kind == PropertyKind.SETTER ? PropertyUtil.getFieldOfSetter(method) : PropertyUtil.getFieldOfGetter(method);
            if (!field1.equals((Object)field2)) continue;
            return method;
        }
        return null;
    }

    private static boolean checkFieldLocation(PsiMethod method, PsiField field) {
        return PsiResolveHelper.getInstance((Project)method.getProject()).isAccessible((PsiMember)field, (PsiElement)method, null) && (!method.hasModifier(JvmModifier.STATIC) || field.hasModifier(JvmModifier.STATIC)) && InheritanceUtil.isInheritorOrSelf((PsiClass)method.getContainingClass(), (PsiClass)field.getContainingClass(), (boolean)true);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "method";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "returnExprSupplier";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "aClass";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "kind";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "propertyName";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "field1";
                break;
            }
        }
        objectArray2[1] = "com/intellij/psi/util/PropertyUtil";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "getFieldOfGetter";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "getFieldImpl";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[2] = "isSimpleGetter";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[2] = "getFieldFromSetterExplicit";
                break;
            }
            case 8: 
            case 9: 
            case 10: 
            case 11: {
                objectArray = objectArray2;
                objectArray2[2] = "findPropertyMethod";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

