/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.util;

import com.intellij.codeInsight.ExceptionUtil;
import com.intellij.codeInsight.Nullability;
import com.intellij.codeInsight.NullableNotNullManager;
import com.intellij.codeInsight.daemon.impl.analysis.JavaGenericsUtil;
import com.intellij.java.codeserver.core.JavaPsiSwitchUtil;
import com.intellij.java.codeserver.highlighting.JavaErrorCollector;
import com.intellij.java.codeserver.highlighting.errors.JavaCompilationError;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Comparing;
import com.intellij.pom.java.JavaFeature;
import com.intellij.psi.JavaElementVisitor;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.JavaRecursiveElementWalkingVisitor;
import com.intellij.psi.JavaResolveResult;
import com.intellij.psi.LambdaUtil;
import com.intellij.psi.PsiAnnotationMemberValue;
import com.intellij.psi.PsiAnonymousClass;
import com.intellij.psi.PsiArrayAccessExpression;
import com.intellij.psi.PsiArrayInitializerExpression;
import com.intellij.psi.PsiArrayType;
import com.intellij.psi.PsiAssertStatement;
import com.intellij.psi.PsiAssignmentExpression;
import com.intellij.psi.PsiBinaryExpression;
import com.intellij.psi.PsiCall;
import com.intellij.psi.PsiCallExpression;
import com.intellij.psi.PsiCaseLabelElementList;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiConditionalExpression;
import com.intellij.psi.PsiDefaultCaseLabelElement;
import com.intellij.psi.PsiDoWhileStatement;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiEnumConstant;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionList;
import com.intellij.psi.PsiExpressionStatement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiForeachStatement;
import com.intellij.psi.PsiFunctionalExpression;
import com.intellij.psi.PsiIfStatement;
import com.intellij.psi.PsiInstanceOfExpression;
import com.intellij.psi.PsiLambdaExpression;
import com.intellij.psi.PsiLocalVariable;
import com.intellij.psi.PsiLoopStatement;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiNameValuePair;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiParameterListOwner;
import com.intellij.psi.PsiParenthesizedExpression;
import com.intellij.psi.PsiPattern;
import com.intellij.psi.PsiPolyadicExpression;
import com.intellij.psi.PsiPrimitiveType;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiResourceExpression;
import com.intellij.psi.PsiReturnStatement;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.PsiSwitchBlock;
import com.intellij.psi.PsiSwitchExpression;
import com.intellij.psi.PsiSwitchLabelStatementBase;
import com.intellij.psi.PsiSwitchLabeledRuleStatement;
import com.intellij.psi.PsiSwitchStatement;
import com.intellij.psi.PsiSynchronizedStatement;
import com.intellij.psi.PsiThrowStatement;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeCastExpression;
import com.intellij.psi.PsiTypeElement;
import com.intellij.psi.PsiTypeParameterListOwner;
import com.intellij.psi.PsiTypes;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.PsiWhileStatement;
import com.intellij.psi.impl.RecaptureTypeMapper;
import com.intellij.psi.impl.source.resolve.graphInference.PsiPolyExpressionUtil;
import com.intellij.psi.infos.MethodCandidateInfo;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.InheritanceUtil;
import com.intellij.psi.util.MethodSignatureUtil;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiTypesUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.psi.util.TypeConversionUtil;
import com.intellij.util.CommonProcessors;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.Processor;
import com.intellij.util.containers.ContainerUtil;
import com.siyeh.ig.bugs.NullArgumentToVariableArgMethodInspection;
import com.siyeh.ig.psiutils.ExpectedTypeUtils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import one.util.streamex.StreamEx;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class RedundantCastUtil {
    private static final Logger LOG = Logger.getInstance(RedundantCastUtil.class);

    private RedundantCastUtil() {
    }

    @NotNull
    public static List<PsiTypeCastExpression> getRedundantCastsInside(@NotNull PsiElement where) {
        if (where == null) {
            RedundantCastUtil.$$$reportNull$$$0(0);
        }
        HashSet casts = new HashSet();
        final JavaElementVisitor visitor2 = RedundantCastUtil.createRedundantCastVisitor((Processor<? super PsiTypeCastExpression>)new CommonProcessors.CollectProcessor(casts));
        where.accept((PsiElementVisitor)new JavaRecursiveElementWalkingVisitor(){

            public void visitElement(@NotNull PsiElement element) {
                if (element == null) {
                    1.$$$reportNull$$$0(0);
                }
                super.visitElement(element);
                element.accept((PsiElementVisitor)visitor2);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/psi/util/RedundantCastUtil$1", "visitElement"));
            }
        });
        return new ArrayList<PsiTypeCastExpression>(casts);
    }

    public static boolean isCastRedundant(PsiTypeCastExpression typeCast) {
        PsiElement parent = typeCast.getParent();
        PsiExpression operand = typeCast.getOperand();
        if (operand != null && operand.getType() != null && operand.getType().equals(typeCast.getType())) {
            return true;
        }
        while (parent instanceof PsiParenthesizedExpression) {
            parent = parent.getParent();
        }
        if (parent instanceof PsiExpressionList) {
            parent = parent.getParent();
        }
        if (parent instanceof PsiReferenceExpression) {
            parent = parent.getParent();
        }
        if (parent instanceof PsiAnonymousClass) {
            parent = parent.getParent();
        }
        final HashSet casts = new HashSet();
        final JavaElementVisitor visitor2 = RedundantCastUtil.createRedundantCastVisitor((Processor<? super PsiTypeCastExpression>)new CommonProcessors.CollectProcessor(casts));
        parent.accept((PsiElementVisitor)new JavaRecursiveElementWalkingVisitor(){

            public void visitElement(@NotNull PsiElement element) {
                if (element == null) {
                    2.$$$reportNull$$$0(0);
                }
                super.visitElement(element);
                element.accept((PsiElementVisitor)visitor2);
                if (!casts.isEmpty()) {
                    this.stopWalking();
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/psi/util/RedundantCastUtil$2", "visitElement"));
            }
        });
        return casts.contains(typeCast);
    }

    public static JavaElementVisitor createRedundantCastVisitor(final Processor<? super PsiTypeCastExpression> processor) {
        return new RedundantCastVisitorBase(){

            @Override
            protected void registerCast(@NotNull PsiTypeCastExpression typeCast) {
                if (typeCast == null) {
                    3.$$$reportNull$$$0(0);
                }
                processor.process((Object)typeCast);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "typeCast", "com/intellij/psi/util/RedundantCastUtil$3", "registerCast"));
            }
        };
    }

    @Nullable
    private static PsiExpression deparenthesizeExpression(PsiExpression arg) {
        return PsiUtil.skipParenthesizedExprDown((PsiExpression)arg);
    }

    private static boolean isTypeCastSemantic(PsiTypeCastExpression typeCast) {
        PsiClassType opClassType;
        PsiClassType castClassType;
        PsiExpression operand = typeCast.getOperand();
        if (operand == null) {
            return false;
        }
        if (PsiUtil.isInSignaturePolymorphicCall((PsiTypeCastExpression)typeCast)) {
            return true;
        }
        PsiType opType = operand.getType();
        PsiTypeElement typeElement = typeCast.getCastType();
        if (typeElement == null) {
            return false;
        }
        PsiType castType = typeElement.getType();
        if (castType instanceof PsiPrimitiveType) {
            if (opType instanceof PsiPrimitiveType) {
                PsiElement parent = PsiUtil.skipParenthesizedExprUp((PsiElement)typeCast.getParent());
                if ((parent instanceof PsiReturnStatement || parent instanceof PsiExpressionList || parent instanceof PsiVariable || parent instanceof PsiAssignmentExpression || parent instanceof PsiArrayAccessExpression && PsiTreeUtil.isAncestor((PsiElement)((PsiArrayAccessExpression)parent).getIndexExpression(), (PsiElement)typeCast, (boolean)false)) && castType.equals(ExpectedTypeUtils.findExpectedType((PsiExpression)typeCast, false))) {
                    return !TypeConversionUtil.isSafeConversion((PsiType)castType, (PsiType)opType);
                }
                return !castType.equals(opType);
            }
            PsiPrimitiveType unboxedOpType = PsiPrimitiveType.getUnboxedType((PsiType)opType);
            if (unboxedOpType != null && !unboxedOpType.equals((Object)castType)) {
                return true;
            }
        } else if (castType instanceof PsiClassType && (castClassType = (PsiClassType)castType).hasParameters() && opType instanceof PsiClassType && (opClassType = (PsiClassType)opType).isRaw()) {
            return true;
        }
        PsiElement parent = PsiUtil.skipParenthesizedExprUp((PsiElement)typeCast.getParent());
        PsiExpression stripParenthesisOperand = PsiUtil.skipParenthesizedExprDown((PsiExpression)operand);
        if (stripParenthesisOperand instanceof PsiFunctionalExpression ? RedundantCastUtil.isCastToSerializable(castType) && !RedundantCastUtil.isCastToSerializable(PsiTypesUtil.getExpectedTypeByParent((PsiElement)typeCast)) : stripParenthesisOperand instanceof PsiConditionalExpression && (PsiUtil.skipParenthesizedExprDown((PsiExpression)((PsiConditionalExpression)stripParenthesisOperand).getThenExpression()) instanceof PsiFunctionalExpression || PsiUtil.skipParenthesizedExprDown((PsiExpression)((PsiConditionalExpression)stripParenthesisOperand).getElseExpression()) instanceof PsiFunctionalExpression)) {
            return true;
        }
        if (parent instanceof PsiBinaryExpression) {
            PsiBinaryExpression expression = (PsiBinaryExpression)parent;
            PsiExpression firstOperand = expression.getLOperand();
            PsiExpression otherOperand = expression.getROperand();
            if (PsiTreeUtil.isAncestor((PsiElement)otherOperand, (PsiElement)typeCast, (boolean)false)) {
                PsiExpression temp = otherOperand;
                otherOperand = firstOperand;
                firstOperand = temp;
            }
            if (otherOperand != null && RedundantCastUtil.wrapperCastChangeSemantics(firstOperand, otherOperand, operand)) {
                return true;
            }
        } else if (parent instanceof PsiConditionalExpression) {
            if (opType instanceof PsiPrimitiveType && !(((PsiConditionalExpression)parent).getType() instanceof PsiPrimitiveType) && PsiPrimitiveType.getUnboxedType((PsiType)PsiTypesUtil.getExpectedTypeByParent((PsiElement)parent)) != null) {
                return true;
            }
        } else if (parent instanceof PsiLocalVariable) {
            PsiLocalVariable localVar = (PsiLocalVariable)parent;
            return localVar.getTypeElement().isInferredType() && (!castType.equals(opType) || PsiPolyExpressionUtil.isPolyExpression((PsiExpression)operand));
        }
        return false;
    }

    private static boolean isCastToSerializable(PsiType castType) {
        return InheritanceUtil.isInheritor((PsiType)castType, (String)"java.io.Serializable");
    }

    private static boolean wrapperCastChangeSemantics(PsiExpression operand, PsiExpression otherOperand, PsiExpression toCast) {
        if (TypeConversionUtil.isPrimitiveAndNotNull((PsiType)otherOperand.getType())) {
            return TypeConversionUtil.isPrimitiveAndNotNullOrWrapper((PsiType)operand.getType()) != TypeConversionUtil.isPrimitiveAndNotNullOrWrapper((PsiType)toCast.getType());
        }
        return TypeConversionUtil.isPrimitiveAndNotNull((PsiType)operand.getType()) != TypeConversionUtil.isPrimitiveAndNotNull((PsiType)toCast.getType());
    }

    private static boolean areNullabilityCompatible(PsiMethod oldTargetMethod, PsiMethod newTargetMethod) {
        return NullableNotNullManager.getNullability((PsiModifierListOwner)oldTargetMethod) == NullableNotNullManager.getNullability((PsiModifierListOwner)newTargetMethod);
    }

    private static boolean areThrownExceptionsCompatible(PsiMethod targetMethod, PsiMethod newTargetMethod) {
        Set oldThrowsTypes = Stream.of(targetMethod.getThrowsList().getReferencedTypes()).filter(t -> !ExceptionUtil.isUncheckedException((PsiClassType)t)).collect(Collectors.toSet());
        List<PsiClassType> newThrowsTypes = Stream.of(newTargetMethod.getThrowsList().getReferencedTypes()).filter(t -> !ExceptionUtil.isUncheckedException((PsiClassType)t)).toList();
        return oldThrowsTypes.size() == newThrowsTypes.size() && oldThrowsTypes.containsAll(newThrowsTypes);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "where", "com/intellij/psi/util/RedundantCastUtil", "getRedundantCastsInside"));
    }

    @ApiStatus.Internal
    public static abstract class RedundantCastVisitorBase
    extends JavaElementVisitor {
        private void addToResults(@NotNull PsiTypeCastExpression typeCast) {
            if (typeCast == null) {
                RedundantCastVisitorBase.$$$reportNull$$$0(0);
            }
            if (!RedundantCastUtil.isTypeCastSemantic(typeCast)) {
                this.registerCast(typeCast);
            }
        }

        private void addIfNarrowing(PsiTypeCastExpression castExpression, @NotNull PsiType opType, PsiType expectedTypeByParent) {
            PsiTypeElement castElement;
            if (opType == null) {
                RedundantCastVisitorBase.$$$reportNull$$$0(1);
            }
            if ((castElement = castExpression.getCastType()) != null && TypeConversionUtil.isAssignable((PsiType)castElement.getType(), (PsiType)opType, (boolean)false) && (expectedTypeByParent == null || TypeConversionUtil.isAssignable((PsiType)expectedTypeByParent, (PsiType)opType, (boolean)false))) {
                this.addToResults(castExpression);
            }
        }

        private void addIfNarrowing(PsiExpression expression, PsiType expectedTypeByParent) {
            if ((expression = RedundantCastUtil.deparenthesizeExpression(expression)) instanceof PsiTypeCastExpression) {
                PsiType opType;
                PsiTypeCastExpression typeCastExpression = (PsiTypeCastExpression)expression;
                PsiExpression operand = RedundantCastVisitorBase.getInnerMostOperand(expression);
                if (operand != null && (opType = operand.getType()) != null) {
                    this.addIfNarrowing(typeCastExpression, opType, expectedTypeByParent);
                }
            }
        }

        protected abstract void registerCast(@NotNull PsiTypeCastExpression var1);

        public void visitAssignmentExpression(@NotNull PsiAssignmentExpression expression) {
            if (expression == null) {
                RedundantCastVisitorBase.$$$reportNull$$$0(2);
            }
            this.processTypeCastWithExpectedType(expression.getRExpression(), expression.getLExpression().getType());
            super.visitAssignmentExpression(expression);
        }

        public void visitArrayInitializerExpression(@NotNull PsiArrayInitializerExpression expression) {
            PsiType type;
            if (expression == null) {
                RedundantCastVisitorBase.$$$reportNull$$$0(3);
            }
            if ((type = expression.getType()) instanceof PsiArrayType) {
                PsiArrayType arrayType = (PsiArrayType)type;
                for (PsiExpression initializer : expression.getInitializers()) {
                    this.processTypeCastWithExpectedType(initializer, arrayType.getComponentType());
                }
            }
            super.visitArrayInitializerExpression(expression);
        }

        public void visitVariable(@NotNull PsiVariable variable) {
            PsiExpression initializer;
            if (variable == null) {
                RedundantCastVisitorBase.$$$reportNull$$$0(4);
            }
            if ((initializer = RedundantCastUtil.deparenthesizeExpression(variable.getInitializer())) instanceof PsiTypeCastExpression) {
                this.processTypeCastWithExpectedType(initializer, variable.getType());
            }
            super.visitVariable(variable);
        }

        public void visitReturnStatement(@NotNull PsiReturnStatement statement) {
            PsiMethod method;
            if (statement == null) {
                RedundantCastVisitorBase.$$$reportNull$$$0(5);
            }
            if ((method = (PsiMethod)PsiTreeUtil.getParentOfType((PsiElement)statement, PsiMethod.class, (boolean)true, (Class[])new Class[]{PsiLambdaExpression.class})) != null) {
                PsiType returnType = method.getReturnType();
                PsiExpression returnValue = statement.getReturnValue();
                if (returnValue != null) {
                    this.processTypeCastWithExpectedType(returnValue, returnType);
                }
            }
            super.visitReturnStatement(statement);
        }

        private void processTypeCastWithExpectedType(PsiExpression rExpr, @Nullable PsiType lType) {
            if ((rExpr = RedundantCastUtil.deparenthesizeExpression(rExpr)) instanceof PsiTypeCastExpression) {
                PsiTypeCastExpression typeCastExpression = (PsiTypeCastExpression)rExpr;
                PsiExpression castOperand = RedundantCastVisitorBase.getInnerMostOperand(rExpr);
                if (castOperand != null && lType != null) {
                    PsiType opType;
                    PsiExpression expected = RedundantCastVisitorBase.getOpWithExpectedType(castOperand, lType);
                    PsiType psiType = opType = expected != null ? expected.getType() : null;
                    if (opType != null) {
                        if (expected instanceof PsiConditionalExpression) {
                            if (!RedundantCastVisitorBase.isApplicableForConditionalBranch(opType, ((PsiConditionalExpression)expected).getThenExpression())) {
                                return;
                            }
                            if (!RedundantCastVisitorBase.isApplicableForConditionalBranch(opType, ((PsiConditionalExpression)expected).getElseExpression())) {
                                return;
                            }
                        }
                        if (expected instanceof PsiSwitchExpression) {
                            for (PsiExpression resultExpression : PsiUtil.getSwitchResultExpressions((PsiSwitchExpression)((PsiSwitchExpression)expected))) {
                                if (RedundantCastVisitorBase.isApplicableForConditionalBranch(opType, resultExpression)) continue;
                                return;
                            }
                        }
                        if (TypeConversionUtil.isAssignable((PsiType)lType, (PsiType)opType, (boolean)false)) {
                            if (!RedundantCastVisitorBase.isFunctionalExpressionTypePreserved(typeCastExpression, expected, lType)) {
                                return;
                            }
                            this.addToResults(typeCastExpression);
                        }
                    }
                }
            }
        }

        private static boolean isFunctionalExpressionTypePreserved(PsiTypeCastExpression typeCast, PsiExpression castOperand, @NotNull PsiType lType) {
            if (lType == null) {
                RedundantCastVisitorBase.$$$reportNull$$$0(6);
            }
            if (castOperand instanceof PsiFunctionalExpression) {
                PsiTypeElement typeElement = typeCast.getCastType();
                PsiType castType = typeElement != null ? typeElement.getType() : null;
                return lType.equals(castType);
            }
            return true;
        }

        public void visitPolyadicExpression(@NotNull PsiPolyadicExpression expression) {
            if (expression == null) {
                RedundantCastVisitorBase.$$$reportNull$$$0(7);
            }
            class Processor {
                Processor() {
                }

                @Nullable
                private PsiType processBinaryExpressionOperand(PsiExpression operand, PsiType otherType, IElementType binaryToken) {
                    PsiTypeCastExpression typeCast;
                    PsiExpression toCast;
                    if (operand instanceof PsiTypeCastExpression && (toCast = (typeCast = (PsiTypeCastExpression)operand).getOperand()) != null && otherType != null && TypeConversionUtil.isBinaryOperatorApplicable((IElementType)binaryToken, (PsiType)toCast.getType(), (PsiType)otherType, (boolean)false)) {
                        RedundantCastVisitorBase.this.addToResults(typeCast);
                        return toCast.getType();
                    }
                    return operand != null ? operand.getType() : null;
                }
            }
            Processor processor = new Processor();
            IElementType tokenType = expression.getOperationTokenType();
            PsiExpression[] operands = expression.getOperands();
            if (operands.length >= 2) {
                PsiType lType = processor.processBinaryExpressionOperand(RedundantCastUtil.deparenthesizeExpression(operands[0]), operands[1].getType(), tokenType);
                for (int i = 1; i < operands.length; ++i) {
                    PsiExpression operand = RedundantCastUtil.deparenthesizeExpression(operands[i]);
                    if (operand == null) continue;
                    PsiType rType = processor.processBinaryExpressionOperand(operand, lType, tokenType);
                    lType = TypeConversionUtil.calcTypeForBinaryExpression((PsiType)lType, (PsiType)rType, (IElementType)tokenType, (boolean)true);
                }
            }
            super.visitPolyadicExpression(expression);
        }

        public void visitCallExpression(@NotNull PsiCallExpression callExpression) {
            if (callExpression == null) {
                RedundantCastVisitorBase.$$$reportNull$$$0(8);
            }
            this.processCall((PsiCall)callExpression);
            super.visitCallExpression(callExpression);
        }

        public void visitEnumConstant(@NotNull PsiEnumConstant enumConstant) {
            if (enumConstant == null) {
                RedundantCastVisitorBase.$$$reportNull$$$0(9);
            }
            this.processCall((PsiCall)enumConstant);
            super.visitEnumConstant(enumConstant);
        }

        public void visitReferenceExpression(@NotNull PsiReferenceExpression expression) {
            PsiExpression qualifier;
            if (expression == null) {
                RedundantCastVisitorBase.$$$reportNull$$$0(10);
            }
            if ((qualifier = RedundantCastUtil.deparenthesizeExpression(expression.getQualifierExpression())) instanceof PsiTypeCastExpression) {
                PsiTypeCastExpression typeCast = (PsiTypeCastExpression)qualifier;
                PsiExpression operand = RedundantCastVisitorBase.getInnerMostOperand(typeCast.getOperand());
                if (operand == null) {
                    return;
                }
                PsiTypeElement typeElement = typeCast.getCastType();
                if (typeElement == null) {
                    return;
                }
                PsiType opType = operand.getType();
                if (opType == null) {
                    return;
                }
                if (!(operand instanceof PsiFunctionalExpression) && !(opType instanceof PsiPrimitiveType) && RedundantCastVisitorBase.isCastInReferenceQualifierRedundant(expression)) {
                    this.addToResults(typeCast);
                }
            }
            super.visitReferenceExpression(expression);
        }

        private static PsiExpression getInnerMostOperand(@Nullable PsiExpression castOperand) {
            castOperand = RedundantCastUtil.deparenthesizeExpression(castOperand);
            while (castOperand instanceof PsiTypeCastExpression) {
                PsiTypeCastExpression typeCastExpression = (PsiTypeCastExpression)castOperand;
                castOperand = RedundantCastUtil.deparenthesizeExpression(typeCastExpression.getOperand());
            }
            return castOperand;
        }

        private static boolean isCastInReferenceQualifierRedundant(PsiReferenceExpression refExpression) {
            JavaResolveResult resolveResult = refExpression.advancedResolve(false);
            PsiElement oldMember = resolveResult.getElement();
            if (oldMember == null) {
                return false;
            }
            try {
                PsiElement parent = PsiUtil.skipParenthesizedExprUp((PsiElement)refExpression.getParent());
                if (parent instanceof PsiMethodCallExpression) {
                    PsiMethodCallExpression methodCallExpression = (PsiMethodCallExpression)parent;
                    PsiMethod targetMethod = (PsiMethod)oldMember;
                    if (targetMethod.hasModifierProperty("static")) {
                        return false;
                    }
                    PsiMethodCallExpression newCall = (PsiMethodCallExpression)RedundantCastVisitorBase.copyCallExpression((PsiCall)methodCallExpression, PsiTypesUtil.getExpectedTypeByParent((PsiElement)parent));
                    if (newCall == null) {
                        return false;
                    }
                    PsiExpression newQualifier = RedundantCastUtil.deparenthesizeExpression(newCall.getMethodExpression().getQualifierExpression());
                    LOG.assertTrue(newQualifier != null);
                    PsiElement oldReference = (PsiElement)newQualifier.getCopyableUserData(RecaptureTypeMapper.SELF_REFERENCE);
                    PsiElement replace = RedundantCastVisitorBase.removeCastInQualifier(newQualifier);
                    replace.putCopyableUserData(RecaptureTypeMapper.SELF_REFERENCE, (Object)oldReference);
                    JavaResolveResult newResult = newCall.getMethodExpression().advancedResolve(false);
                    if (!newResult.isValidResult()) {
                        return false;
                    }
                    PsiMethod newTargetMethod = (PsiMethod)newResult.getElement();
                    LOG.assertTrue(newTargetMethod != null, (Object)"isValidResult() check above should find this");
                    PsiType newReturnType = newCall.getType();
                    PsiType oldReturnType = methodCallExpression.getType();
                    return !(!Comparing.equal(newReturnType == null ? null : new RecaptureTypeMapper().mapType(newReturnType), (Object)oldReturnType) || !Comparing.equal((Object)newTargetMethod, (Object)targetMethod) && (newTargetMethod.isDeprecated() && !targetMethod.isDeprecated() || !MethodSignatureUtil.isSuperMethod((PsiMethod)newTargetMethod, (PsiMethod)targetMethod) && !MethodSignatureUtil.isSuperMethod((PsiMethod)targetMethod, (PsiMethod)newTargetMethod) || !RedundantCastUtil.areThrownExceptionsCompatible(targetMethod, newTargetMethod) || !RedundantCastUtil.areNullabilityCompatible(targetMethod, newTargetMethod)));
                }
                PsiElementFactory elementFactory = JavaPsiFacade.getElementFactory((Project)refExpression.getProject());
                PsiReferenceExpression newExpression = (PsiReferenceExpression)elementFactory.createExpressionFromText(refExpression.getText(), (PsiElement)refExpression);
                PsiExpression newQualifier = newExpression.getQualifierExpression();
                LOG.assertTrue(newQualifier != null);
                RedundantCastVisitorBase.removeCastInQualifier(newQualifier);
                JavaResolveResult newResult = newExpression.advancedResolve(false);
                if (!newResult.isValidResult() || !oldMember.equals((Object)newResult.getElement())) {
                    return false;
                }
                PsiType expected = ExpectedTypeUtils.findExpectedType((PsiExpression)refExpression, false);
                PsiType actual = newExpression.getType();
                if (!(expected == null || actual != null && TypeConversionUtil.isAssignable((PsiType)expected, (PsiType)actual))) {
                    return false;
                }
                if (parent instanceof PsiReferenceExpression) {
                    PsiReferenceExpression parentRef = (PsiReferenceExpression)parent;
                    if (!newResult.getSubstitutor().equals((Object)resolveResult.getSubstitutor())) {
                        return RedundantCastVisitorBase.isCastInReferenceQualifierRedundant(parentRef);
                    }
                }
                return true;
            }
            catch (IncorrectOperationException ignore) {
                return false;
            }
        }

        private static PsiElement removeCastInQualifier(PsiExpression qualifier) {
            PsiReferenceExpression ref;
            PsiExpression refQualifier;
            if ((qualifier = RedundantCastUtil.deparenthesizeExpression(qualifier)) instanceof PsiTypeCastExpression) {
                PsiExpression operand;
                PsiTypeCastExpression typeCastExpression = (PsiTypeCastExpression)qualifier;
                while ((operand = RedundantCastUtil.deparenthesizeExpression(typeCastExpression.getOperand())) instanceof PsiTypeCastExpression) {
                    PsiTypeCastExpression nestedCast;
                    typeCastExpression = nestedCast = (PsiTypeCastExpression)operand;
                }
                return operand == null ? qualifier : qualifier.replace((PsiElement)operand);
            }
            if (qualifier instanceof PsiReferenceExpression && (refQualifier = (ref = (PsiReferenceExpression)qualifier).getQualifierExpression()) != null) {
                RedundantCastVisitorBase.removeCastInQualifier(refQualifier);
            }
            return qualifier;
        }

        private void processCall(PsiCall expression) {
            PsiExpressionList argumentList = expression.getArgumentList();
            if (argumentList == null) {
                return;
            }
            PsiExpression[] args = argumentList.getExpressions();
            if (args.length == 0) {
                return;
            }
            JavaResolveResult oldResult = expression.resolveMethodGenerics();
            PsiElement element = oldResult.getElement();
            if (!(element instanceof PsiMethod)) {
                return;
            }
            PsiMethod oldMethod = (PsiMethod)element;
            PsiParameter[] parameters = oldMethod.getParameterList().getParameters();
            PsiCall newCall = null;
            for (int i = 0; i < args.length; ++i) {
                PsiExpression arg = RedundantCastUtil.deparenthesizeExpression(args[i]);
                if (!(arg instanceof PsiTypeCastExpression) && !(arg instanceof PsiLambdaExpression) && !(arg instanceof PsiConditionalExpression)) continue;
                ProgressManager.checkCanceled();
                if (newCall == null) {
                    newCall = RedundantCastVisitorBase.copyCallExpression(expression, PsiTypesUtil.getExpectedTypeByParent((PsiElement)expression));
                }
                if (newCall == null) {
                    return;
                }
                PsiExpressionList argList = newCall.getArgumentList();
                LOG.assertTrue(argList != null);
                PsiExpression[] newArgs = argList.getExpressions();
                LOG.assertTrue(newArgs.length == args.length, (Object)("oldCall: " + expression.getText() + "; old length: " + args.length + "; newCall: " + newCall.getText() + "; new length: " + newArgs.length));
                if (arg instanceof PsiTypeCastExpression) {
                    PsiTypeCastExpression typeCastExpression = (PsiTypeCastExpression)arg;
                    this.checkTypeCastInCallArgument(i, typeCastExpression, newArgs, expression, newCall);
                    continue;
                }
                if (arg instanceof PsiLambdaExpression) {
                    PsiLambdaExpression lambdaExpression = (PsiLambdaExpression)arg;
                    this.checkLambdaReturnsInsideCall(i, lambdaExpression, newArgs, expression, newCall, parameters);
                    continue;
                }
                PsiType conditionalType = arg.getType();
                PsiExpression thenExpression = RedundantCastUtil.deparenthesizeExpression(((PsiConditionalExpression)arg).getThenExpression());
                PsiExpression elseExpression = RedundantCastUtil.deparenthesizeExpression(((PsiConditionalExpression)arg).getElseExpression());
                if (thenExpression instanceof PsiTypeCastExpression && !RedundantCastVisitorBase.castForBoxing(RedundantCastVisitorBase.getInnerMostOperand(thenExpression), elseExpression != null ? elseExpression.getType() : null, conditionalType)) {
                    PsiExpression newThenExpression = RedundantCastUtil.deparenthesizeExpression(((PsiConditionalExpression)Objects.requireNonNull(RedundantCastUtil.deparenthesizeExpression(newArgs[i]))).getThenExpression());
                    this.checkConditionalBranch(expression, newCall, thenExpression, newThenExpression);
                }
                if (!(elseExpression instanceof PsiTypeCastExpression) || RedundantCastVisitorBase.castForBoxing(RedundantCastVisitorBase.getInnerMostOperand(elseExpression), thenExpression != null ? thenExpression.getType() : null, conditionalType)) continue;
                PsiExpression newElseExpression = RedundantCastUtil.deparenthesizeExpression(((PsiConditionalExpression)Objects.requireNonNull(RedundantCastUtil.deparenthesizeExpression(newArgs[i]))).getElseExpression());
                this.checkConditionalBranch(expression, newCall, elseExpression, newElseExpression);
            }
        }

        private void checkConditionalBranch(PsiCall oldCall, PsiCall newCall, PsiExpression oldBranchExpression, PsiExpression newBranchExpression) {
            PsiExpression operand = ((PsiTypeCastExpression)newBranchExpression).getOperand();
            if (operand != null) {
                JavaResolveResult newResult;
                newBranchExpression = (PsiExpression)newBranchExpression.replace((PsiElement)operand);
                JavaResolveResult oldResult = oldCall.resolveMethodGenerics();
                if (RedundantCastVisitorBase.isSameResolveResult(oldResult, newResult = newCall.resolveMethodGenerics())) {
                    this.addToResults((PsiTypeCastExpression)oldBranchExpression);
                } else {
                    newBranchExpression.replace((PsiElement)oldBranchExpression);
                }
            }
        }

        private static boolean isSameResolveResult(JavaResolveResult oldResult, JavaResolveResult newResult) {
            MethodCandidateInfo methodCandidateInfo;
            PsiMethod oldMethod = (PsiMethod)oldResult.getElement();
            LOG.assertTrue(oldMethod != null);
            return oldMethod.equals((Object)newResult.getElement()) && newResult.isValidResult() && (!(newResult instanceof MethodCandidateInfo) || (methodCandidateInfo = (MethodCandidateInfo)newResult).getInferenceErrorMessage() == null) && new RecaptureTypeMapper().recapture(newResult.getSubstitutor()).equals((Object)oldResult.getSubstitutor());
        }

        private static boolean castForBoxing(PsiExpression operand, PsiType oppositeType, PsiType conditionalType) {
            return operand != null && TypeConversionUtil.isPrimitiveAndNotNull((PsiType)operand.getType()) && !(oppositeType instanceof PsiPrimitiveType) && !(conditionalType instanceof PsiPrimitiveType);
        }

        private void checkLambdaReturnsInsideCall(int i, PsiLambdaExpression arg, PsiExpression[] newArgs, PsiCall oldCall, PsiCall newCall, PsiParameter[] parameters) {
            PsiType interfaceType = arg.getFunctionalInterfaceType();
            if (interfaceType != null) {
                List expressions = LambdaUtil.getReturnExpressions((PsiLambdaExpression)arg);
                PsiLambdaExpression newLambdaExpression = (PsiLambdaExpression)RedundantCastUtil.deparenthesizeExpression(newArgs[i]);
                LOG.assertTrue(newLambdaExpression != null);
                List newReturnExpressions = LambdaUtil.getReturnExpressions((PsiLambdaExpression)newLambdaExpression);
                for (int returnExprIdx = 0; returnExprIdx < expressions.size(); ++returnExprIdx) {
                    ProgressManager.checkCanceled();
                    PsiExpression returnExpression = RedundantCastUtil.deparenthesizeExpression((PsiExpression)expressions.get(returnExprIdx));
                    PsiExpression newReturnExpression = RedundantCastUtil.deparenthesizeExpression((PsiExpression)newReturnExpressions.get(returnExprIdx));
                    if (newReturnExpression instanceof PsiTypeCastExpression) {
                        PsiTypeCastExpression typeCastExpression = (PsiTypeCastExpression)newReturnExpression;
                        this.checkLambdaReturn(i, (PsiTypeCastExpression)returnExpression, typeCastExpression, interfaceType, newLambdaExpression, oldCall, newCall, parameters);
                        continue;
                    }
                    if (!(returnExpression instanceof PsiConditionalExpression)) continue;
                    PsiConditionalExpression conditionalExpression = (PsiConditionalExpression)returnExpression;
                    LOG.assertTrue(newReturnExpression instanceof PsiConditionalExpression);
                    PsiConditionalExpression newConditionalExpression = (PsiConditionalExpression)newReturnExpression;
                    PsiExpression thenExpression = RedundantCastUtil.deparenthesizeExpression(conditionalExpression.getThenExpression());
                    PsiExpression newThenExpression = RedundantCastUtil.deparenthesizeExpression(newConditionalExpression.getThenExpression());
                    PsiExpression elseExpression = RedundantCastUtil.deparenthesizeExpression(conditionalExpression.getElseExpression());
                    PsiExpression newElseExpression = RedundantCastUtil.deparenthesizeExpression(newConditionalExpression.getElseExpression());
                    if (thenExpression instanceof PsiTypeCastExpression && !RedundantCastVisitorBase.castForBoxing(RedundantCastVisitorBase.getInnerMostOperand(thenExpression), elseExpression != null ? elseExpression.getType() : null, returnExpression.getType())) {
                        this.checkLambdaReturn(i, (PsiTypeCastExpression)thenExpression, (PsiTypeCastExpression)newThenExpression, interfaceType, newLambdaExpression, oldCall, newCall, parameters);
                    }
                    if (!(elseExpression instanceof PsiTypeCastExpression) || RedundantCastVisitorBase.castForBoxing(RedundantCastVisitorBase.getInnerMostOperand(elseExpression), thenExpression != null ? thenExpression.getType() : null, returnExpression.getType())) continue;
                    this.checkLambdaReturn(i, (PsiTypeCastExpression)elseExpression, (PsiTypeCastExpression)newElseExpression, interfaceType, newLambdaExpression, oldCall, newCall, parameters);
                }
            }
        }

        private void checkLambdaReturn(int i, PsiTypeCastExpression returnExpression, PsiTypeCastExpression newReturnExpression, PsiType originalFunctionalInterfaceType, PsiLambdaExpression newLambdaExpression, PsiCall oldCall, PsiCall newCall, PsiParameter[] parameters) {
            PsiTypeElement originalCastType;
            PsiType castExprType;
            PsiExpression castOperand = RedundantCastVisitorBase.getInnerMostOperand((PsiExpression)returnExpression);
            if (castOperand == null) {
                return;
            }
            PsiType interfaceReturnType = LambdaUtil.getFunctionalInterfaceReturnType((PsiType)originalFunctionalInterfaceType);
            if (interfaceReturnType == null || !RedundantCastVisitorBase.isFunctionalExpressionTypePreserved(returnExpression, castOperand, interfaceReturnType)) {
                return;
            }
            PsiExpression strippedCast = (PsiExpression)newReturnExpression.replace((PsiElement)castOperand);
            PsiType newArgType = RedundantCastVisitorBase.calculateNewArgType(i, newCall.resolveMethodGenerics(), parameters);
            PsiType functionalInterfaceType = newLambdaExpression.getGroundTargetType(newArgType);
            if (originalFunctionalInterfaceType.equals(functionalInterfaceType) && (castExprType = (PsiType)LambdaUtil.performWithTargetType((PsiElement)newLambdaExpression, (PsiType)functionalInterfaceType, () -> strippedCast.getType())) != null && interfaceReturnType.isAssignableFrom(castExprType) && (originalCastType = returnExpression.getCastType()) != null) {
                boolean explicitChangeOfNullability;
                Nullability returnTypeNullability = originalCastType.getType().getNullability().nullability();
                Nullability castExprNullability = castExprType.getNullability().nullability();
                boolean bl = explicitChangeOfNullability = !returnTypeNullability.equals((Object)Nullability.UNKNOWN) && !returnTypeNullability.equals((Object)castExprNullability);
                if (!explicitChangeOfNullability) {
                    this.addToResults(returnExpression);
                    return;
                }
            }
            strippedCast.replace((PsiElement)returnExpression);
        }

        private void checkTypeCastInCallArgument(int i, PsiTypeCastExpression arg, PsiExpression[] newArgs, PsiCall oldCall, PsiCall newCall) {
            PsiParameter[] parameters;
            JavaResolveResult newResult;
            JavaResolveResult oldResult;
            PsiType castType;
            block13: {
                block14: {
                    PsiTypeElement castTypeElement = arg.getCastType();
                    castType = castTypeElement != null ? castTypeElement.getType() : null;
                    PsiExpression castOperand = ((PsiTypeCastExpression)Objects.requireNonNull(RedundantCastUtil.deparenthesizeExpression(newArgs[i]))).getOperand();
                    if (castOperand == null) {
                        return;
                    }
                    newArgs[i] = (PsiExpression)newArgs[i].replace((PsiElement)castOperand);
                    if (!RedundantCastVisitorBase.errorsMatch((PsiElement)newCall, (PsiElement)oldCall)) {
                        newArgs[i].replace((PsiElement)arg);
                        return;
                    }
                    oldResult = oldCall.resolveMethodGenerics();
                    newResult = newCall.resolveMethodGenerics();
                    PsiMethod oldMethod = (PsiMethod)oldResult.getElement();
                    LOG.assertTrue(oldMethod != null);
                    parameters = oldMethod.getParameterList().getParameters();
                    if (i != newArgs.length - 1 || newArgs.length != parameters.length || !parameters[i].isVarArgs()) break block13;
                    if (NullArgumentToVariableArgMethodInspection.isSuspiciousVararg(newCall, newArgs[i].getType(), () -> (PsiMethod)newResult.getElement())) break block14;
                    if (!(oldResult instanceof MethodCandidateInfo)) break block13;
                    MethodCandidateInfo oldMethodCandidateInfo = (MethodCandidateInfo)oldResult;
                    if (!(newResult instanceof MethodCandidateInfo)) break block13;
                    MethodCandidateInfo newMethodCandidateInfo = (MethodCandidateInfo)newResult;
                    if (oldMethodCandidateInfo.getApplicabilityLevel() == newMethodCandidateInfo.getApplicabilityLevel()) break block13;
                }
                newArgs[i].replace((PsiElement)arg);
                return;
            }
            if (RedundantCastVisitorBase.isSameResolveResult(oldResult, newResult)) {
                PsiExpression newArg = PsiUtil.deparenthesizeExpression((PsiExpression)newArgs[i]);
                if (newArg instanceof PsiFunctionalExpression) {
                    PsiFunctionalExpression functionalExpression = (PsiFunctionalExpression)newArg;
                    PsiType newArgType = RedundantCastVisitorBase.calculateNewArgType(i, newResult, parameters);
                    if (Comparing.equal((Object)castType, (Object)functionalExpression.getGroundTargetType(newArgType))) {
                        this.addToResults(arg);
                        return;
                    }
                } else if (newArg instanceof PsiCallExpression) {
                    MethodCandidateInfo info;
                    PsiCallExpression callExpression = (PsiCallExpression)newArg;
                    JavaResolveResult result = callExpression.resolveMethodGenerics();
                    if (!(result instanceof MethodCandidateInfo) || (info = (MethodCandidateInfo)result).getInferenceErrorMessage() == null) {
                        this.addToResults(arg);
                        return;
                    }
                } else {
                    this.addToResults(arg);
                    return;
                }
            }
            newArgs[i].replace((PsiElement)arg);
        }

        private static boolean errorsMatch(PsiElement updated, PsiElement original) {
            while (!(updated instanceof PsiFile)) {
                JavaCompilationError originalError;
                JavaCompilationError updatedError = JavaErrorCollector.findSingleError((PsiElement)updated);
                if (updatedError == null != ((originalError = JavaErrorCollector.findSingleError((PsiElement)original)) == null)) {
                    return false;
                }
                if (updatedError != null && updatedError.kind() != originalError.kind()) {
                    return false;
                }
                updated = updated.getParent();
                original = original.getParent();
            }
            return true;
        }

        @Nullable
        private static PsiType calculateNewArgType(int i, JavaResolveResult newResult, PsiParameter[] parameters) {
            MethodCandidateInfo info;
            MethodCandidateInfo info2;
            boolean varargs = newResult instanceof MethodCandidateInfo && (info2 = (MethodCandidateInfo)newResult).isVarargs();
            PsiType parameterType = PsiTypesUtil.getParameterType((PsiParameter[])parameters, (int)i, (boolean)varargs);
            PsiType newArgType = newResult.getSubstitutor().substitute(parameterType);
            if (newResult instanceof MethodCandidateInfo && PsiUtil.isRawSubstitutor((PsiTypeParameterListOwner)(info = (MethodCandidateInfo)newResult).getElement(), (PsiSubstitutor)newResult.getSubstitutor())) {
                newArgType = TypeConversionUtil.erasure((PsiType)newArgType);
            }
            return newArgType;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Nullable
        private static PsiCall copyCallExpression(PsiCall expression, PsiType typeByParent) {
            PsiCall psiCall;
            block20: {
                PsiCall encoded;
                block16: {
                    PsiCall psiCall2;
                    block19: {
                        block17: {
                            PsiCall psiCall3;
                            block18: {
                                PsiCall psiCall4;
                                block12: {
                                    PsiCall psiCall5;
                                    block15: {
                                        PsiCall callCopy;
                                        Object marker;
                                        block13: {
                                            PsiCall psiCall6;
                                            block14: {
                                                block10: {
                                                    PsiCall psiCall7;
                                                    block11: {
                                                        encoded = null;
                                                        if (typeByParent == null || !PsiTypesUtil.isDenotableType((PsiType)typeByParent, (PsiElement)expression)) break block10;
                                                        encoded = expression;
                                                        RecaptureTypeMapper.encode((PsiElement)encoded);
                                                        psiCall7 = (PsiCall)LambdaUtil.copyWithExpectedType((PsiElement)expression, (PsiType)typeByParent);
                                                        if (encoded == null) break block11;
                                                        RecaptureTypeMapper.clean((PsiElement)encoded);
                                                    }
                                                    return psiCall7;
                                                }
                                                PsiCall call = LambdaUtil.treeWalkUp((PsiElement)expression);
                                                if (call == null) break block12;
                                                encoded = call;
                                                RecaptureTypeMapper.encode((PsiElement)encoded);
                                                marker = new Object();
                                                PsiTreeUtil.mark((PsiElement)expression, (Object)marker);
                                                callCopy = LambdaUtil.copyTopLevelCall((PsiCall)call);
                                                if (callCopy != null) break block13;
                                                psiCall6 = null;
                                                if (encoded == null) break block14;
                                                RecaptureTypeMapper.clean((PsiElement)encoded);
                                            }
                                            return psiCall6;
                                        }
                                        psiCall5 = (PsiCall)PsiTreeUtil.releaseMark((PsiElement)callCopy, (Object)marker);
                                        if (encoded == null) break block15;
                                        RecaptureTypeMapper.clean((PsiElement)encoded);
                                    }
                                    return psiCall5;
                                }
                                ParentPathContext contextParent = RedundantCastVisitorBase.getContextParent(expression);
                                if (contextParent == null || !contextParent.hasPath()) break block16;
                                encoded = contextParent.parent();
                                RecaptureTypeMapper.encode((PsiElement)encoded);
                                PsiElement copy = contextParent.getElementCopy();
                                if (!(copy instanceof PsiCall)) break block17;
                                psiCall3 = psiCall4 = (PsiCall)copy;
                                if (encoded == null) break block18;
                                RecaptureTypeMapper.clean((PsiElement)encoded);
                            }
                            return psiCall3;
                        }
                        psiCall2 = null;
                        if (encoded == null) break block19;
                        RecaptureTypeMapper.clean((PsiElement)encoded);
                    }
                    return psiCall2;
                }
                try {
                    encoded = expression;
                    RecaptureTypeMapper.encode((PsiElement)encoded);
                    psiCall = (PsiCall)expression.copy();
                    if (encoded == null) break block20;
                }
                catch (IllegalArgumentException e) {
                    PsiCall psiCall8;
                    block21: {
                        try {
                            psiCall8 = null;
                            if (encoded == null) break block21;
                        }
                        catch (Throwable throwable) {
                            if (encoded != null) {
                                RecaptureTypeMapper.clean(encoded);
                            }
                            throw throwable;
                        }
                        RecaptureTypeMapper.clean((PsiElement)encoded);
                    }
                    return psiCall8;
                }
                RecaptureTypeMapper.clean((PsiElement)encoded);
            }
            return psiCall;
        }

        @Nullable
        private static ParentPathContext getContextParent(@NotNull PsiCall expression) {
            if (expression == null) {
                RedundantCastVisitorBase.$$$reportNull$$$0(11);
            }
            PsiElement parent = expression.getParent();
            ArrayList<Integer> indexes = new ArrayList<Integer>();
            PsiCall currentChild = expression;
            while (parent instanceof PsiIfStatement || parent instanceof PsiConditionalExpression || parent instanceof PsiLoopStatement) {
                PsiElement[] children = parent.getChildren();
                PsiCall finalCurrentChild = currentChild;
                int index = ContainerUtil.indexOf(Arrays.asList(children), arg_0 -> RedundantCastVisitorBase.lambda$getContextParent$2((PsiElement)finalCurrentChild, arg_0));
                if (index == -1) {
                    return null;
                }
                indexes.add(index);
                currentChild = parent;
                parent = parent.getParent();
            }
            return new ParentPathContext((PsiElement)currentChild, indexes);
        }

        public void visitTypeCastExpression(@NotNull PsiTypeCastExpression typeCast) {
            PsiExpression operand;
            if (typeCast == null) {
                RedundantCastVisitorBase.$$$reportNull$$$0(12);
            }
            if ((operand = typeCast.getOperand()) == null) {
                return;
            }
            PsiExpression expr = RedundantCastUtil.deparenthesizeExpression(operand);
            PsiType topCastType = typeCast.getType();
            if (expr instanceof PsiTypeCastExpression) {
                PsiType operandType;
                PsiTypeCastExpression innerCast = (PsiTypeCastExpression)expr;
                PsiTypeElement typeElement = innerCast.getCastType();
                if (typeElement == null) {
                    return;
                }
                PsiType castType = typeElement.getType();
                PsiExpression innerOperand = innerCast.getOperand();
                PsiType psiType = operandType = innerOperand != null ? innerOperand.getType() : null;
                if (!(castType instanceof PsiPrimitiveType) && !(topCastType instanceof PsiPrimitiveType)) {
                    if (operandType != null && topCastType != null && TypeConversionUtil.areTypesConvertible((PsiType)operandType, (PsiType)topCastType)) {
                        this.addToResults(innerCast);
                    }
                } else if (Comparing.equal((Object)PsiPrimitiveType.getUnboxedType((PsiType)operandType), (Object)topCastType)) {
                    this.addToResults(innerCast);
                } else if (operandType != null && operandType.equals(castType)) {
                    this.addToResults(innerCast);
                }
            }
            super.visitTypeCastExpression(typeCast);
        }

        public void visitForeachStatement(@NotNull PsiForeachStatement statement) {
            PsiType collectionItemType;
            PsiTypeCastExpression typeCastExpression;
            PsiExpression operand;
            PsiExpression iteratedValue;
            if (statement == null) {
                RedundantCastVisitorBase.$$$reportNull$$$0(13);
            }
            if ((iteratedValue = RedundantCastUtil.deparenthesizeExpression(statement.getIteratedValue())) instanceof PsiTypeCastExpression && (operand = (typeCastExpression = (PsiTypeCastExpression)iteratedValue).getOperand()) != null && (collectionItemType = JavaGenericsUtil.getCollectionItemType((PsiType)operand.getType(), (GlobalSearchScope)statement.getResolveScope())) != null && TypeConversionUtil.isAssignable((PsiType)statement.getIterationParameter().getType(), (PsiType)collectionItemType)) {
                this.addToResults((PsiTypeCastExpression)iteratedValue);
            }
            super.visitForeachStatement(statement);
        }

        public void visitInstanceOfExpression(@NotNull PsiInstanceOfExpression expression) {
            PsiType opType;
            PsiTypeCastExpression typeCastExpression;
            PsiExpression operand;
            PsiTypeElement checkTypeElement;
            if (expression == null) {
                RedundantCastVisitorBase.$$$reportNull$$$0(14);
            }
            if ((checkTypeElement = expression.getCheckType()) == null) {
                return;
            }
            PsiExpression typeCast = RedundantCastUtil.deparenthesizeExpression(expression.getOperand());
            if (typeCast instanceof PsiTypeCastExpression && (operand = RedundantCastVisitorBase.getInnerMostOperand((typeCastExpression = (PsiTypeCastExpression)typeCast).getOperand())) != null && (opType = operand.getType()) != null && !(opType instanceof PsiPrimitiveType) && TypeConversionUtil.areTypesConvertible((PsiType)opType, (PsiType)checkTypeElement.getType())) {
                this.addToResults((PsiTypeCastExpression)typeCast);
            }
            super.visitInstanceOfExpression(expression);
        }

        public void visitThrowStatement(@NotNull PsiThrowStatement statement) {
            PsiTypeCastExpression typeCastExpression;
            PsiExpression operand;
            PsiExpression typeCast;
            if (statement == null) {
                RedundantCastVisitorBase.$$$reportNull$$$0(15);
            }
            if ((typeCast = RedundantCastUtil.deparenthesizeExpression(statement.getException())) instanceof PsiTypeCastExpression && (operand = RedundantCastVisitorBase.getInnerMostOperand((typeCastExpression = (PsiTypeCastExpression)typeCast).getOperand())) != null) {
                PsiType opType = operand.getType();
                PsiClass thrownClass = PsiUtil.resolveClassInType((PsiType)opType);
                if (InheritanceUtil.isInheritor((PsiClass)thrownClass, (boolean)false, (String)"java.lang.RuntimeException")) {
                    this.addToResults((PsiTypeCastExpression)typeCast);
                }
                if (InheritanceUtil.isInheritor((PsiClass)thrownClass, (boolean)false, (String)"java.lang.Throwable")) {
                    PsiParameterListOwner listOwner = (PsiParameterListOwner)PsiTreeUtil.getParentOfType((PsiElement)statement, (Class[])new Class[]{PsiMethod.class, PsiLambdaExpression.class});
                    if (listOwner instanceof PsiMethod) {
                        PsiMethod method = (PsiMethod)listOwner;
                        this.processThrowsList(method, PsiSubstitutor.EMPTY, (PsiTypeCastExpression)typeCast, opType);
                    } else if (listOwner instanceof PsiLambdaExpression) {
                        PsiLambdaExpression lambdaExpression = (PsiLambdaExpression)listOwner;
                        PsiType functionalInterfaceType = lambdaExpression.getFunctionalInterfaceType();
                        PsiClassType.ClassResolveResult functionalInterfaceResolveResult = PsiUtil.resolveGenericsClassInType((PsiType)functionalInterfaceType);
                        PsiMethod interfaceMethod = LambdaUtil.getFunctionalInterfaceMethod((PsiType)functionalInterfaceType);
                        if (interfaceMethod != null) {
                            this.processThrowsList(interfaceMethod, LambdaUtil.getSubstitutor((PsiMethod)interfaceMethod, (PsiClassType.ClassResolveResult)functionalInterfaceResolveResult), (PsiTypeCastExpression)typeCast, opType);
                        }
                    }
                }
            }
            super.visitThrowStatement(statement);
        }

        private void processThrowsList(PsiMethod interfaceMethod, PsiSubstitutor psiSubstitutor, PsiTypeCastExpression typeCast, PsiType opType) {
            for (PsiClassType thrownType : interfaceMethod.getThrowsList().getReferencedTypes()) {
                PsiType left = psiSubstitutor.substitute((PsiType)thrownType);
                if (left == null || !TypeConversionUtil.isAssignable((PsiType)left, (PsiType)opType, (boolean)false)) continue;
                this.addToResults(typeCast);
            }
        }

        public void visitSynchronizedStatement(@NotNull PsiSynchronizedStatement statement) {
            PsiTypeCastExpression typeCastExpression;
            PsiExpression operand;
            PsiExpression lockExpression;
            if (statement == null) {
                RedundantCastVisitorBase.$$$reportNull$$$0(16);
            }
            if ((lockExpression = RedundantCastUtil.deparenthesizeExpression(statement.getLockExpression())) instanceof PsiTypeCastExpression && (operand = RedundantCastVisitorBase.getInnerMostOperand((typeCastExpression = (PsiTypeCastExpression)lockExpression).getOperand())) != null) {
                PsiType opType = operand.getType();
                if (!(operand instanceof PsiFunctionalExpression) && !(opType instanceof PsiPrimitiveType) && opType != null) {
                    this.addIfNarrowing(typeCastExpression, opType, null);
                }
            }
            super.visitSynchronizedStatement(statement);
        }

        public void visitSwitchStatement(@NotNull PsiSwitchStatement statement) {
            if (statement == null) {
                RedundantCastVisitorBase.$$$reportNull$$$0(17);
            }
            this.visitSwitchBlockSelector((PsiSwitchBlock)statement);
            super.visitSwitchStatement(statement);
        }

        public void visitSwitchExpression(@NotNull PsiSwitchExpression expression) {
            if (expression == null) {
                RedundantCastVisitorBase.$$$reportNull$$$0(18);
            }
            this.visitSwitchBlockSelector((PsiSwitchBlock)expression);
            PsiType expectedTypeByParent = PsiTypesUtil.getExpectedTypeByParent((PsiElement)expression);
            if (expectedTypeByParent != null) {
                for (PsiExpression resultExpression : PsiUtil.getSwitchResultExpressions((PsiSwitchExpression)expression)) {
                    this.addIfNarrowing(resultExpression, expectedTypeByParent);
                }
            }
            super.visitSwitchExpression(expression);
        }

        private void visitSwitchBlockSelector(PsiSwitchBlock switchBlock) {
            PsiTypeCastExpression cast;
            PsiExpression operand;
            PsiExpression selector = RedundantCastUtil.deparenthesizeExpression(switchBlock.getExpression());
            if (selector instanceof PsiTypeCastExpression && (operand = (cast = (PsiTypeCastExpression)selector).getOperand()) != null) {
                Object aClass;
                PsiType opType = operand.getType();
                if (opType instanceof PsiClassType && PsiPrimitiveType.getUnboxedType((PsiType)opType) == null && !opType.equalsToText("java.lang.String") && (aClass = ((PsiClassType)opType).resolve()) != null && !aClass.isEnum()) {
                    return;
                }
                if (opType instanceof PsiPrimitiveType) {
                    if (PsiUtil.isAvailable((JavaFeature)JavaFeature.PATTERN_GUARDS_AND_RECORD_PATTERNS, (PsiElement)switchBlock)) {
                        for (PsiElement branch : JavaPsiSwitchUtil.getSwitchBranches((PsiSwitchBlock)switchBlock)) {
                            PsiExpression expression;
                            if (branch instanceof PsiExpression && TypeConversionUtil.isNullType((PsiType)(expression = (PsiExpression)branch).getType())) {
                                return;
                            }
                            if (!(branch instanceof PsiPattern)) continue;
                            return;
                        }
                    } else if (PsiUtil.isAvailable((JavaFeature)JavaFeature.PATTERNS_IN_SWITCH, (PsiElement)switchBlock)) {
                        boolean needToCheckCompleteness = switchBlock instanceof PsiSwitchExpression;
                        boolean hasDefault = false;
                        for (PsiElement branch : JavaPsiSwitchUtil.getSwitchBranches((PsiSwitchBlock)switchBlock)) {
                            PsiSwitchLabelStatementBase label;
                            PsiExpression expression;
                            if (branch instanceof PsiExpression && TypeConversionUtil.isNullType((PsiType)(expression = (PsiExpression)branch).getType())) {
                                return;
                            }
                            needToCheckCompleteness |= branch instanceof PsiPattern;
                            hasDefault |= branch instanceof PsiDefaultCaseLabelElement || branch instanceof PsiSwitchLabelStatementBase && (label = (PsiSwitchLabelStatementBase)branch).isDefaultCase();
                        }
                        if (needToCheckCompleteness && !hasDefault) {
                            return;
                        }
                    }
                }
                if (opType != null) {
                    PsiCodeBlock body = switchBlock.getBody();
                    boolean hasInconvertibleLabel = false;
                    if (body != null) {
                        hasInconvertibleLabel = StreamEx.of((Object[])body.getStatements()).select(PsiSwitchLabelStatementBase.class).map(PsiSwitchLabelStatementBase::getCaseLabelElementList).nonNull().flatArray(PsiCaseLabelElementList::getElements).select(PsiExpression.class).map(PsiExpression::getType).nonNull().anyMatch(t -> !t.isConvertibleFrom(opType));
                    }
                    if (!hasInconvertibleLabel) {
                        this.addIfNarrowing(cast, opType, null);
                    }
                }
            }
        }

        public void visitAssertStatement(@NotNull PsiAssertStatement statement) {
            if (statement == null) {
                RedundantCastVisitorBase.$$$reportNull$$$0(19);
            }
            this.addIfNarrowing(statement.getAssertCondition(), (PsiType)PsiTypes.booleanType());
            this.addIfNarrowing(statement.getAssertDescription(), (PsiType)PsiType.getJavaLangString((PsiManager)statement.getManager(), (GlobalSearchScope)statement.getResolveScope()));
            super.visitAssertStatement(statement);
        }

        public void visitDoWhileStatement(@NotNull PsiDoWhileStatement statement) {
            if (statement == null) {
                RedundantCastVisitorBase.$$$reportNull$$$0(20);
            }
            this.addIfNarrowing(statement.getCondition(), (PsiType)PsiTypes.booleanType());
            super.visitDoWhileStatement(statement);
        }

        public void visitIfStatement(@NotNull PsiIfStatement statement) {
            if (statement == null) {
                RedundantCastVisitorBase.$$$reportNull$$$0(21);
            }
            this.addIfNarrowing(statement.getCondition(), (PsiType)PsiTypes.booleanType());
            super.visitIfStatement(statement);
        }

        public void visitWhileStatement(@NotNull PsiWhileStatement statement) {
            if (statement == null) {
                RedundantCastVisitorBase.$$$reportNull$$$0(22);
            }
            this.addIfNarrowing(statement.getCondition(), (PsiType)PsiTypes.booleanType());
            super.visitWhileStatement(statement);
        }

        public void visitResourceExpression(@NotNull PsiResourceExpression expression) {
            if (expression == null) {
                RedundantCastVisitorBase.$$$reportNull$$$0(23);
            }
            this.addIfNarrowing(expression.getExpression(), null);
            super.visitResourceExpression(expression);
        }

        public void visitExpressionStatement(@NotNull PsiExpressionStatement statement) {
            if (statement == null) {
                RedundantCastVisitorBase.$$$reportNull$$$0(24);
            }
            if (!(statement.getParent() instanceof PsiSwitchLabeledRuleStatement)) {
                this.addIfNarrowing(statement.getExpression(), null);
            }
            super.visitExpressionStatement(statement);
        }

        public void visitNameValuePair(@NotNull PsiNameValuePair pair) {
            PsiAnnotationMemberValue value;
            if (pair == null) {
                RedundantCastVisitorBase.$$$reportNull$$$0(25);
            }
            if ((value = pair.getValue()) instanceof PsiExpression) {
                this.addIfNarrowing((PsiExpression)value, null);
            }
            super.visitNameValuePair(pair);
        }

        public void visitLambdaExpression(@NotNull PsiLambdaExpression expression) {
            PsiType returnType;
            PsiMethod method;
            if (expression == null) {
                RedundantCastVisitorBase.$$$reportNull$$$0(26);
            }
            if (!(PsiUtil.skipParenthesizedExprUp((PsiElement)expression.getParent()) instanceof PsiExpressionList) && (method = LambdaUtil.getFunctionalInterfaceMethod((PsiElement)expression)) != null && (returnType = method.getReturnType()) != null) {
                List returns = LambdaUtil.getReturnExpressions((PsiLambdaExpression)expression);
                for (PsiExpression aReturn : returns) {
                    PsiExpression operand;
                    PsiExpression returnInLambda = RedundantCastUtil.deparenthesizeExpression(aReturn);
                    if (!(returnInLambda instanceof PsiTypeCastExpression) || (operand = RedundantCastVisitorBase.getInnerMostOperand(returnInLambda)) == null || !returnType.equals(operand.getType())) continue;
                    this.addToResults((PsiTypeCastExpression)returnInLambda);
                }
            }
            super.visitLambdaExpression(expression);
        }

        public void visitConditionalExpression(@NotNull PsiConditionalExpression conditionalExpression) {
            PsiElement gParent;
            if (conditionalExpression == null) {
                RedundantCastVisitorBase.$$$reportNull$$$0(27);
            }
            if ((gParent = PsiUtil.skipParenthesizedExprUp((PsiElement)conditionalExpression.getParent())) instanceof PsiLambdaExpression) {
                return;
            }
            if (gParent instanceof PsiReturnStatement && PsiTreeUtil.getParentOfType((PsiElement)gParent, (Class[])new Class[]{PsiMethod.class, PsiLambdaExpression.class}) instanceof PsiLambdaExpression) {
                return;
            }
            if (!(gParent instanceof PsiExpressionList)) {
                PsiExpression thenExpression = RedundantCastUtil.deparenthesizeExpression(conditionalExpression.getThenExpression());
                PsiExpression elseExpression = RedundantCastUtil.deparenthesizeExpression(conditionalExpression.getElseExpression());
                if (thenExpression instanceof PsiTypeCastExpression) {
                    this.visitConditional((PsiTypeCastExpression)thenExpression, conditionalExpression, RedundantCastVisitorBase.getInnerMostOperand(elseExpression));
                }
                if (elseExpression instanceof PsiTypeCastExpression) {
                    this.visitConditional((PsiTypeCastExpression)elseExpression, conditionalExpression, RedundantCastVisitorBase.getInnerMostOperand(RedundantCastUtil.deparenthesizeExpression(conditionalExpression.getThenExpression())));
                }
            }
            this.addIfNarrowing(conditionalExpression.getCondition(), (PsiType)PsiTypes.booleanType());
            super.visitConditionalExpression(conditionalExpression);
        }

        private void visitConditional(PsiTypeCastExpression typeCast, @NotNull PsiConditionalExpression parent, @Nullable PsiExpression oppositeOperand) {
            PsiExpression operand;
            if (parent == null) {
                RedundantCastVisitorBase.$$$reportNull$$$0(28);
            }
            if ((operand = RedundantCastVisitorBase.getInnerMostOperand(typeCast.getOperand())) == null) {
                return;
            }
            PsiType castTo = typeCast.getType();
            if (castTo == null) {
                return;
            }
            PsiType expectedTypeByParent = PsiTypesUtil.getExpectedTypeByParent((PsiElement)parent);
            if (operand instanceof PsiFunctionalExpression && !castTo.equals(expectedTypeByParent)) {
                return;
            }
            PsiType opType = operand.getType();
            if (opType == null) {
                return;
            }
            if (castTo instanceof PsiClassType && TypeConversionUtil.isPrimitiveAndNotNull((PsiType)opType) && oppositeOperand != null && !(oppositeOperand.getType() instanceof PsiPrimitiveType) && !(expectedTypeByParent instanceof PsiPrimitiveType)) {
                return;
            }
            PsiType conditionalType = parent.getType();
            if (!Comparing.equal((Object)opType, (Object)conditionalType)) {
                if (!PsiUtil.isLanguageLevel5OrHigher((PsiElement)typeCast)) {
                    return;
                }
                if (!(PsiPolyExpressionUtil.isInAssignmentOrInvocationContext((PsiExpression)parent) && !PsiPolyExpressionUtil.sameBooleanOrNumeric((PsiExpression)operand, (PsiExpression)oppositeOperand) || oppositeOperand != null && Comparing.equal((Object)conditionalType, (Object)oppositeOperand.getType()))) {
                    return;
                }
            }
            this.addIfNarrowing(typeCast, opType, expectedTypeByParent);
        }

        private static PsiExpression getOpWithExpectedType(PsiExpression operand, PsiType expectedTypeByParent) {
            if (expectedTypeByParent != null && !(operand instanceof PsiFunctionalExpression)) {
                try {
                    JavaResolveResult newResult;
                    PsiExpression initializer = (PsiExpression)LambdaUtil.copyWithExpectedType((PsiElement)operand, (PsiType)expectedTypeByParent);
                    if (initializer instanceof PsiMethodCallExpression && (newResult = ((PsiMethodCallExpression)initializer).resolveMethodGenerics()) instanceof MethodCandidateInfo && ((MethodCandidateInfo)newResult).getInferenceErrorMessage() != null) {
                        return null;
                    }
                    return initializer;
                }
                catch (IncorrectOperationException incorrectOperationException) {
                    // empty catch block
                }
            }
            return operand;
        }

        private static boolean isApplicableForConditionalBranch(PsiType opType, PsiExpression thenExpression) {
            PsiType thenType;
            return thenExpression == null || (thenType = thenExpression.getType()) == null || TypeConversionUtil.isAssignable((PsiType)opType, (PsiType)thenType);
        }

        public void visitArrayAccessExpression(@NotNull PsiArrayAccessExpression expression) {
            PsiType opType;
            PsiExpression indexExpression;
            PsiExpression operand;
            PsiExpression arrayExpression;
            if (expression == null) {
                RedundantCastVisitorBase.$$$reportNull$$$0(29);
            }
            if ((arrayExpression = RedundantCastUtil.deparenthesizeExpression(expression.getArrayExpression())) instanceof PsiTypeCastExpression) {
                PsiTypeElement castTypeElement = ((PsiTypeCastExpression)arrayExpression).getCastType();
                operand = ((PsiTypeCastExpression)arrayExpression).getOperand();
                if (castTypeElement != null && operand != null && PsiUtil.isAccessedForWriting((PsiExpression)expression)) {
                    PsiType castTo = castTypeElement.getType();
                    PsiType opType2 = operand.getType();
                    if (opType2 != null && TypeConversionUtil.isAssignable((PsiType)opType2, (PsiType)castTo, (boolean)false) && opType2.getArrayDimensions() == castTo.getArrayDimensions()) {
                        this.addToResults((PsiTypeCastExpression)arrayExpression);
                    }
                }
            }
            if ((indexExpression = RedundantCastUtil.deparenthesizeExpression(expression.getIndexExpression())) instanceof PsiTypeCastExpression && (operand = ((PsiTypeCastExpression)indexExpression).getOperand()) != null && (opType = operand.getType()) != null) {
                this.addIfNarrowing((PsiTypeCastExpression)indexExpression, opType, null);
            }
            super.visitArrayAccessExpression(expression);
        }

        private static /* synthetic */ boolean lambda$getContextParent$2(PsiElement finalCurrentChild, PsiElement child) {
            return child == finalCurrentChild;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "typeCast";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "opType";
                    break;
                }
                case 2: 
                case 3: 
                case 7: 
                case 10: 
                case 11: 
                case 14: 
                case 18: 
                case 23: 
                case 26: 
                case 29: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "expression";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "variable";
                    break;
                }
                case 5: 
                case 13: 
                case 15: 
                case 16: 
                case 17: 
                case 19: 
                case 20: 
                case 21: 
                case 22: 
                case 24: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "statement";
                    break;
                }
                case 6: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "lType";
                    break;
                }
                case 8: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "callExpression";
                    break;
                }
                case 9: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "enumConstant";
                    break;
                }
                case 25: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "pair";
                    break;
                }
                case 27: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "conditionalExpression";
                    break;
                }
                case 28: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "parent";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/psi/util/RedundantCastUtil$RedundantCastVisitorBase";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "addToResults";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "addIfNarrowing";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "visitAssignmentExpression";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[2] = "visitArrayInitializerExpression";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[2] = "visitVariable";
                    break;
                }
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[2] = "visitReturnStatement";
                    break;
                }
                case 6: {
                    objectArray = objectArray2;
                    objectArray2[2] = "isFunctionalExpressionTypePreserved";
                    break;
                }
                case 7: {
                    objectArray = objectArray2;
                    objectArray2[2] = "visitPolyadicExpression";
                    break;
                }
                case 8: {
                    objectArray = objectArray2;
                    objectArray2[2] = "visitCallExpression";
                    break;
                }
                case 9: {
                    objectArray = objectArray2;
                    objectArray2[2] = "visitEnumConstant";
                    break;
                }
                case 10: {
                    objectArray = objectArray2;
                    objectArray2[2] = "visitReferenceExpression";
                    break;
                }
                case 11: {
                    objectArray = objectArray2;
                    objectArray2[2] = "getContextParent";
                    break;
                }
                case 12: {
                    objectArray = objectArray2;
                    objectArray2[2] = "visitTypeCastExpression";
                    break;
                }
                case 13: {
                    objectArray = objectArray2;
                    objectArray2[2] = "visitForeachStatement";
                    break;
                }
                case 14: {
                    objectArray = objectArray2;
                    objectArray2[2] = "visitInstanceOfExpression";
                    break;
                }
                case 15: {
                    objectArray = objectArray2;
                    objectArray2[2] = "visitThrowStatement";
                    break;
                }
                case 16: {
                    objectArray = objectArray2;
                    objectArray2[2] = "visitSynchronizedStatement";
                    break;
                }
                case 17: {
                    objectArray = objectArray2;
                    objectArray2[2] = "visitSwitchStatement";
                    break;
                }
                case 18: {
                    objectArray = objectArray2;
                    objectArray2[2] = "visitSwitchExpression";
                    break;
                }
                case 19: {
                    objectArray = objectArray2;
                    objectArray2[2] = "visitAssertStatement";
                    break;
                }
                case 20: {
                    objectArray = objectArray2;
                    objectArray2[2] = "visitDoWhileStatement";
                    break;
                }
                case 21: {
                    objectArray = objectArray2;
                    objectArray2[2] = "visitIfStatement";
                    break;
                }
                case 22: {
                    objectArray = objectArray2;
                    objectArray2[2] = "visitWhileStatement";
                    break;
                }
                case 23: {
                    objectArray = objectArray2;
                    objectArray2[2] = "visitResourceExpression";
                    break;
                }
                case 24: {
                    objectArray = objectArray2;
                    objectArray2[2] = "visitExpressionStatement";
                    break;
                }
                case 25: {
                    objectArray = objectArray2;
                    objectArray2[2] = "visitNameValuePair";
                    break;
                }
                case 26: {
                    objectArray = objectArray2;
                    objectArray2[2] = "visitLambdaExpression";
                    break;
                }
                case 27: {
                    objectArray = objectArray2;
                    objectArray2[2] = "visitConditionalExpression";
                    break;
                }
                case 28: {
                    objectArray = objectArray2;
                    objectArray2[2] = "visitConditional";
                    break;
                }
                case 29: {
                    objectArray = objectArray2;
                    objectArray2[2] = "visitArrayAccessExpression";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }

        private record ParentPathContext(PsiElement parent, List<Integer> childrenIndexes) {
            public PsiElement getElementCopy() {
                PsiElement result = this.parent.copy();
                for (Integer nextIndex : this.childrenIndexes) {
                    if (result != null && result.getChildren().length > nextIndex) {
                        result = result.getChildren()[nextIndex];
                        continue;
                    }
                    return null;
                }
                return result;
            }

            public boolean hasPath() {
                return !this.childrenIndexes.isEmpty();
            }
        }
    }
}

