/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.refactoring.util.duplicates;

import com.intellij.psi.JavaTokenType;
import com.intellij.psi.PsiArrayAccessExpression;
import com.intellij.psi.PsiAssignmentExpression;
import com.intellij.psi.PsiBinaryExpression;
import com.intellij.psi.PsiConditionalExpression;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiLiteralExpression;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiQualifiedExpression;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiSuperExpression;
import com.intellij.psi.PsiUnaryExpression;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiUtil;
import com.intellij.refactoring.util.duplicates.DuplicatesFinder;
import com.intellij.util.containers.ObjectIntHashMap;
import com.intellij.util.containers.ObjectIntMap;
import java.util.List;

class ComplexityHolder {
    static final int MAX_ACCEPTABLE = 12;
    static final int TOO_COMPLEX = 100;
    private final ObjectIntMap<PsiExpression> myCache = new ObjectIntHashMap();
    private final List<PsiElement> myScope;

    ComplexityHolder(List<PsiElement> scope) {
        this.myScope = scope;
    }

    boolean isAcceptableExpression(PsiExpression expression) {
        return this.getComplexity(expression) <= 12;
    }

    private int getComplexity(PsiExpression expression) {
        if (expression == null) {
            return 100;
        }
        int complexity = this.myCache.get((Object)expression);
        if (complexity < 0) {
            complexity = this.computeComplexity(expression);
            this.myCache.put((Object)expression, complexity);
        }
        return complexity;
    }

    private int computeComplexity(PsiExpression expression) {
        if ((expression = PsiUtil.skipParenthesizedExprDown((PsiExpression)expression)) instanceof PsiAssignmentExpression || expression instanceof PsiSuperExpression) {
            return 100;
        }
        if (expression instanceof PsiLiteralExpression || expression instanceof PsiQualifiedExpression) {
            return 1;
        }
        if (expression instanceof PsiUnaryExpression) {
            IElementType tokenType = ((PsiUnaryExpression)expression).getOperationTokenType();
            if (JavaTokenType.PLUSPLUS.equals(tokenType) || JavaTokenType.MINUSMINUS.equals(tokenType)) {
                return 100;
            }
            return 1 + this.getComplexity(((PsiUnaryExpression)expression).getOperand());
        }
        if (expression instanceof PsiBinaryExpression) {
            int complexity = 1 + this.getComplexity(((PsiBinaryExpression)expression).getLOperand());
            if (complexity > 12) {
                return complexity;
            }
            return complexity + this.getComplexity(((PsiBinaryExpression)expression).getROperand());
        }
        if (expression instanceof PsiConditionalExpression) {
            int complexity = 1 + this.getComplexity(((PsiConditionalExpression)expression).getCondition());
            if (complexity > 12) {
                return complexity;
            }
            if ((complexity += this.getComplexity(((PsiConditionalExpression)expression).getThenExpression())) > 12) {
                return complexity;
            }
            return complexity + this.getComplexity(((PsiConditionalExpression)expression).getElseExpression());
        }
        if (expression instanceof PsiArrayAccessExpression) {
            int complexity = 3 + this.getComplexity(((PsiArrayAccessExpression)expression).getArrayExpression());
            if (complexity > 12) {
                return complexity;
            }
            return complexity + this.getComplexity(((PsiArrayAccessExpression)expression).getIndexExpression());
        }
        if (expression instanceof PsiReferenceExpression) {
            PsiElement resolved = ((PsiReferenceExpression)expression).resolve();
            if (resolved == null || this.isWithinScope(resolved)) {
                return 100;
            }
            if (resolved instanceof PsiVariable && ((PsiVariable)resolved).hasModifierProperty("static") && ((PsiVariable)resolved).hasModifierProperty("final")) {
                return 1;
            }
            PsiExpression qualifier = ((PsiReferenceExpression)expression).getQualifierExpression();
            if (qualifier == null) {
                return 2;
            }
            return 2 + this.getComplexity(qualifier);
        }
        if (expression instanceof PsiMethodCallExpression) {
            PsiExpression[] arguments;
            PsiReferenceExpression methodExpression = ((PsiMethodCallExpression)expression).getMethodExpression();
            PsiElement resolved = methodExpression.resolve();
            if (resolved == null || this.isWithinScope(resolved)) {
                return 100;
            }
            int complexity = 3;
            PsiExpression qualifier = methodExpression.getQualifierExpression();
            if (qualifier != null && (complexity += this.getComplexity(qualifier)) > 12) {
                return complexity;
            }
            for (PsiExpression argument : arguments = ((PsiMethodCallExpression)expression).getArgumentList().getExpressions()) {
                if ((complexity += this.getComplexity(argument)) <= 12) continue;
                return complexity;
            }
            return complexity;
        }
        return 100;
    }

    private boolean isWithinScope(PsiElement resolved) {
        return DuplicatesFinder.isUnder(resolved, this.myScope);
    }

    public List<PsiElement> getScope() {
        return this.myScope;
    }
}

