/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.refactoring.util.duplicates;

import com.intellij.psi.GenericsUtil;
import com.intellij.psi.JavaRecursiveElementWalkingVisitor;
import com.intellij.psi.JavaTokenType;
import com.intellij.psi.PsiAssignmentExpression;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiPostfixExpression;
import com.intellij.psi.PsiPrefixExpression;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiUtil;
import com.intellij.refactoring.util.duplicates.ExtractableExpressionPart;
import com.intellij.refactoring.util.duplicates.Match;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import one.util.streamex.StreamEx;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Unmodifiable;

public class ExtractedParameter {
    @NotNull
    public final PsiType myType;
    @NotNull
    public final ExtractableExpressionPart myPattern;
    @NotNull
    public final ExtractableExpressionPart myCandidate;
    @NotNull
    public final Set<PsiExpression> myPatternUsages;

    public ExtractedParameter(@NotNull ExtractableExpressionPart patternPart, @NotNull ExtractableExpressionPart candidatePart, @NotNull PsiType type) {
        if (patternPart == null) {
            ExtractedParameter.$$$reportNull$$$0(0);
        }
        if (candidatePart == null) {
            ExtractedParameter.$$$reportNull$$$0(1);
        }
        if (type == null) {
            ExtractedParameter.$$$reportNull$$$0(2);
        }
        this.myPatternUsages = new HashSet<PsiExpression>();
        this.myType = type;
        this.myPattern = patternPart;
        this.myCandidate = candidatePart;
        this.addUsages(patternPart);
    }

    public static boolean match(@NotNull ExtractableExpressionPart patternPart, @NotNull ExtractableExpressionPart candidatePart, @NotNull List<? super ExtractedParameter> parameters) {
        PsiType type;
        if (patternPart == null) {
            ExtractedParameter.$$$reportNull$$$0(3);
        }
        if (candidatePart == null) {
            ExtractedParameter.$$$reportNull$$$0(4);
        }
        if (parameters == null) {
            ExtractedParameter.$$$reportNull$$$0(5);
        }
        if ((type = ExtractableExpressionPart.commonType(patternPart, candidatePart)) == null) {
            return false;
        }
        parameters.add(new ExtractedParameter(patternPart, candidatePart, type));
        return true;
    }

    @NotNull
    public ExtractedParameter copyWithCandidateUsage(@NotNull PsiExpression candidateUsage) {
        if (candidateUsage == null) {
            ExtractedParameter.$$$reportNull$$$0(6);
        }
        ExtractedParameter result = new ExtractedParameter(this.myPattern, ExtractableExpressionPart.fromUsage(candidateUsage, this.myType), this.myType);
        result.myPatternUsages.addAll(this.myPatternUsages);
        ExtractedParameter extractedParameter = result;
        if (extractedParameter == null) {
            ExtractedParameter.$$$reportNull$$$0(7);
        }
        return extractedParameter;
    }

    @NotNull
    public String getLocalVariableTypeText() {
        PsiType type = GenericsUtil.getVariableTypeByExpressionType((PsiType)this.myType);
        String string = type.getCanonicalText();
        if (string == null) {
            ExtractedParameter.$$$reportNull$$$0(8);
        }
        return string;
    }

    public void addUsages(@NotNull ExtractableExpressionPart patternPart) {
        if (patternPart == null) {
            ExtractedParameter.$$$reportNull$$$0(9);
        }
        this.myPatternUsages.add(patternPart.getUsage());
    }

    public static List<Match> getCompatibleMatches(@NotNull List<Match> matches, PsiElement @NotNull [] pattern, @NotNull List<PsiElement[]> candidates) {
        if (matches == null) {
            ExtractedParameter.$$$reportNull$$$0(10);
        }
        if (candidates == null) {
            ExtractedParameter.$$$reportNull$$$0(11);
        }
        if (pattern == null) {
            ExtractedParameter.$$$reportNull$$$0(12);
        }
        ArrayList<Match> result = new ArrayList<Match>();
        Set firstUsages = null;
        for (Match match : matches) {
            List<ExtractedParameter> parameters = match.getExtractedParameters();
            PsiElement[] candidateElements = (PsiElement[])ContainerUtil.find(candidates, elements -> ((PsiElement[])elements).length != 0 && match.getMatchStart() == elements[0]);
            Set candidateVariables = ContainerUtil.map2SetNotNull(parameters, parameter -> parameter.myCandidate.myVariable);
            if (candidateElements == null || ExtractedParameter.containsModifiedField(candidateElements, candidateVariables)) continue;
            Set patternUsages = StreamEx.of(parameters).map(p -> p.myPattern.getUsage()).toSet();
            if (firstUsages == null) {
                Set patternVariables = ContainerUtil.map2SetNotNull(parameters, parameter -> parameter.myPattern.myVariable);
                if (ExtractedParameter.containsModifiedField(pattern, patternVariables)) {
                    return Collections.emptyList();
                }
                firstUsages = patternUsages;
                result.add(match);
                continue;
            }
            if (!firstUsages.equals(patternUsages)) continue;
            result.add(match);
        }
        return result;
    }

    private static boolean containsModifiedField(PsiElement @NotNull [] elements, @NotNull @Unmodifiable Set<PsiVariable> variables) {
        Set fields;
        if (variables == null) {
            ExtractedParameter.$$$reportNull$$$0(13);
        }
        if (elements == null) {
            ExtractedParameter.$$$reportNull$$$0(14);
        }
        if (!(fields = ((StreamEx)StreamEx.of(variables).select(PsiField.class).filter(field -> !field.hasModifierProperty("final"))).toSet()).isEmpty()) {
            FieldModificationVisitor visitor2 = new FieldModificationVisitor(fields);
            for (PsiElement element : elements) {
                element.accept((PsiElementVisitor)visitor2);
                if (!visitor2.myModified) continue;
                return true;
            }
        }
        return false;
    }

    public String toString() {
        return String.valueOf(this.myPattern) + " -> " + String.valueOf(this.myCandidate) + " [" + this.myPatternUsages.size() + "] : " + this.myType.getPresentableText();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 7, 8 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "patternPart";
                break;
            }
            case 1: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "candidatePart";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parameters";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "candidateUsage";
                break;
            }
            case 7: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/refactoring/util/duplicates/ExtractedParameter";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "matches";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "candidates";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pattern";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "variables";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "elements";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/refactoring/util/duplicates/ExtractedParameter";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "copyWithCandidateUsage";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getLocalVariableTypeText";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "match";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "copyWithCandidateUsage";
                break;
            }
            case 7: 
            case 8: {
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "addUsages";
                break;
            }
            case 10: 
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "getCompatibleMatches";
                break;
            }
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "containsModifiedField";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 7, 8 -> new IllegalStateException(string);
        };
    }

    private static class FieldModificationVisitor
    extends JavaRecursiveElementWalkingVisitor {
        private final Set<PsiField> myFields;
        private boolean myModified;

        FieldModificationVisitor(Set<PsiField> fields) {
            this.myFields = fields;
        }

        public void visitAssignmentExpression(@NotNull PsiAssignmentExpression expression) {
            if (expression == null) {
                FieldModificationVisitor.$$$reportNull$$$0(0);
            }
            super.visitAssignmentExpression(expression);
            this.visitModifiedExpression(expression.getLExpression());
        }

        public void visitPrefixExpression(@NotNull PsiPrefixExpression expression) {
            if (expression == null) {
                FieldModificationVisitor.$$$reportNull$$$0(1);
            }
            super.visitPrefixExpression(expression);
            IElementType op = expression.getOperationTokenType();
            if (op == JavaTokenType.PLUSPLUS || op == JavaTokenType.MINUSMINUS) {
                this.visitModifiedExpression(expression.getOperand());
            }
        }

        public void visitPostfixExpression(@NotNull PsiPostfixExpression expression) {
            if (expression == null) {
                FieldModificationVisitor.$$$reportNull$$$0(2);
            }
            super.visitPostfixExpression(expression);
            IElementType op = expression.getOperationTokenType();
            if (op == JavaTokenType.PLUSPLUS || op == JavaTokenType.MINUSMINUS) {
                this.visitModifiedExpression(expression.getOperand());
            }
        }

        private void visitModifiedExpression(PsiExpression modifiedExpression) {
            PsiField field;
            PsiExpression expression = PsiUtil.skipParenthesizedExprDown((PsiExpression)modifiedExpression);
            if (expression instanceof PsiReferenceExpression && (field = (PsiField)ObjectUtils.tryCast((Object)((PsiReferenceExpression)expression).resolve(), PsiField.class)) != null && this.myFields.contains(field)) {
                this.myModified = true;
                this.stopWalking();
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            objectArray2[0] = "expression";
            objectArray2[1] = "com/intellij/refactoring/util/duplicates/ExtractedParameter$FieldModificationVisitor";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "visitAssignmentExpression";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "visitPrefixExpression";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "visitPostfixExpression";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

