/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig;

import com.intellij.codeInspection.AbstractBaseJavaLocalInspectionTool;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.codeInspection.util.InspectionMessage;
import com.intellij.openapi.util.DefaultJDOMExternalizer;
import com.intellij.openapi.util.WriteExternalException;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import com.intellij.util.ArrayUtil;
import com.intellij.util.ReflectionUtil;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.GroupDisplayNameUtil;
import java.util.List;
import org.jdom.Element;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class BaseInspection
extends AbstractBaseJavaLocalInspectionTool {
    private String m_shortName = null;

    @NotNull
    public String getShortName() {
        if (this.m_shortName == null) {
            Class<?> aClass = ((Object)((Object)this)).getClass();
            String name = aClass.getSimpleName();
            this.m_shortName = BaseInspection.getShortName((String)name);
            if (this.m_shortName.equals(name)) {
                throw new AssertionError((Object)("class name must end with 'Inspection' to correctly calculate the short name: " + name));
            }
        }
        String string = this.m_shortName;
        if (string == null) {
            BaseInspection.$$$reportNull$$$0(0);
        }
        return string;
    }

    @Nls
    @NotNull
    public final String getGroupDisplayName() {
        String string = GroupDisplayNameUtil.getGroupDisplayName(((Object)((Object)this)).getClass());
        if (string == null) {
            BaseInspection.$$$reportNull$$$0(1);
        }
        return string;
    }

    @NotNull
    @InspectionMessage
    protected abstract String buildErrorString(Object ... var1);

    protected boolean buildQuickFixesOnlyForOnTheFlyErrors() {
        return false;
    }

    @Nullable
    protected LocalQuickFix buildFix(Object ... infos) {
        return null;
    }

    @NotNull
    protected @NotNull LocalQuickFix @NotNull [] buildFixes(Object ... infos) {
        if (LocalQuickFix.EMPTY_ARRAY == null) {
            BaseInspection.$$$reportNull$$$0(2);
        }
        return LocalQuickFix.EMPTY_ARRAY;
    }

    protected void writeBooleanOption(@NotNull Element node, @NotNull @NonNls String property, boolean defaultValueToIgnore) {
        if (node == null) {
            BaseInspection.$$$reportNull$$$0(3);
        }
        if (property == null) {
            BaseInspection.$$$reportNull$$$0(4);
        }
        Boolean value = (Boolean)ReflectionUtil.getField(((Object)((Object)this)).getClass(), (Object)((Object)this), Boolean.TYPE, (String)property);
        assert (value != null);
        if (defaultValueToIgnore == value) {
            return;
        }
        node.addContent(new Element("option").setAttribute("name", property).setAttribute("value", value.toString()));
    }

    protected void writeOption(@NotNull Element node, @NotNull @NonNls String property) {
        if (node == null) {
            BaseInspection.$$$reportNull$$$0(5);
        }
        if (property == null) {
            BaseInspection.$$$reportNull$$$0(6);
        }
        Object value = ReflectionUtil.getField(((Object)((Object)this)).getClass(), (Object)((Object)this), null, (String)property);
        assert (value != null) : "field " + property + " not found";
        node.addContent(new Element("option").setAttribute("name", property).setAttribute("value", value.toString()));
    }

    protected void defaultWriteSettings(@NotNull Element node, String ... excludedProperties) throws WriteExternalException {
        if (node == null) {
            BaseInspection.$$$reportNull$$$0(7);
        }
        DefaultJDOMExternalizer.write((Object)((Object)this), (Element)node, field -> {
            String name = field.getName();
            return !ArrayUtil.contains((String)name, (String[])excludedProperties);
        });
    }

    @NotNull
    public abstract BaseInspectionVisitor buildVisitor();

    @NotNull
    public final PsiElementVisitor buildVisitor(@NotNull ProblemsHolder holder, boolean isOnTheFly) {
        if (holder == null) {
            BaseInspection.$$$reportNull$$$0(8);
        }
        PsiFile file = holder.getFile();
        assert (file.isPhysical());
        if (!this.shouldInspect(file)) {
            PsiElementVisitor psiElementVisitor = PsiElementVisitor.EMPTY_VISITOR;
            if (psiElementVisitor == null) {
                BaseInspection.$$$reportNull$$$0(9);
            }
            return psiElementVisitor;
        }
        BaseInspectionVisitor visitor2 = this.buildVisitor();
        visitor2.setProblemsHolder(holder);
        visitor2.setOnTheFly(isOnTheFly);
        visitor2.setInspection(this);
        BaseInspectionVisitor baseInspectionVisitor = visitor2;
        if (baseInspectionVisitor == null) {
            BaseInspection.$$$reportNull$$$0(10);
        }
        return baseInspectionVisitor;
    }

    @Deprecated
    @ApiStatus.Internal
    public boolean shouldInspect(@NotNull PsiFile file) {
        if (file == null) {
            BaseInspection.$$$reportNull$$$0(11);
        }
        return true;
    }

    @SafeVarargs
    public static void parseString(String string, List<String> ... outs) {
        List strings = StringUtil.split((String)string, (String)",");
        for (List<String> out : outs) {
            out.clear();
        }
        int iMax = strings.size();
        for (int i = 0; i < iMax; i += outs.length) {
            for (int j = 0; j < outs.length; ++j) {
                List<String> out;
                out = outs[j];
                if (i + j >= iMax) {
                    out.add("");
                    continue;
                }
                out.add((String)strings.get(i + j));
            }
        }
    }

    @SafeVarargs
    public static String formatString(List<String> ... strings) {
        StringBuilder buffer = new StringBuilder();
        int size = strings[0].size();
        if (size > 0) {
            BaseInspection.formatString(strings, 0, buffer);
            for (int i = 1; i < size; ++i) {
                buffer.append(',');
                BaseInspection.formatString(strings, i, buffer);
            }
        }
        return buffer.toString();
    }

    private static void formatString(List<String>[] strings, int index, StringBuilder out) {
        out.append(strings[0].get(index));
        for (int i = 1; i < strings.length; ++i) {
            out.append(',');
            List<String> list = strings[i];
            out.append(list.size() > index ? list.get(index) : "");
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 3, 4, 5, 6, 7, 8, 11 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/siyeh/ig/BaseInspection";
                break;
            }
            case 3: 
            case 5: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "node";
                break;
            }
            case 4: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "property";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "holder";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getShortName";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getGroupDisplayName";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "buildFixes";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "com/siyeh/ig/BaseInspection";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "buildVisitor";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "writeBooleanOption";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "writeOption";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "defaultWriteSettings";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "buildVisitor";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "shouldInspect";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 3, 4, 5, 6, 7, 8, 11 -> new IllegalArgumentException(string);
        };
    }
}

