/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.abstraction;

import com.intellij.codeInspection.options.OptPane;
import com.intellij.codeInspection.options.OptRegularComponent;
import com.intellij.psi.PsiCatchSection;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassObjectAccessExpression;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiInstanceOfExpression;
import com.intellij.psi.PsiLambdaExpression;
import com.intellij.psi.PsiLocalVariable;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiPatternVariable;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeCastExpression;
import com.intellij.psi.PsiTypeElement;
import com.intellij.psi.PsiTypeParameter;
import com.intellij.psi.PsiTypeTestPattern;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtil;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.callMatcher.CallMatcher;
import com.siyeh.ig.psiutils.CloneUtils;
import com.siyeh.ig.psiutils.ExpressionUtils;
import com.siyeh.ig.psiutils.LibraryUtil;
import com.siyeh.ig.psiutils.MethodUtils;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class UseOfConcreteClassInspection
extends BaseInspection {
    private static final CallMatcher OBJECT_GET_CLASS = CallMatcher.exactInstanceCall("java.lang.Object", "getClass").parameterCount(0);
    private static final CallMatcher CLASS_CAST = CallMatcher.exactInstanceCall("java.lang.Class", "cast").parameterCount(1);
    public boolean ignoreAbstractClasses = false;
    public boolean ignoreRecords = true;
    public boolean reportMethodReturns = true;
    public boolean reportMethodParameters = true;
    public boolean reportLocalVariables = true;
    public boolean reportStaticFields = true;
    public boolean reportInstanceFields = true;
    public boolean reportInstanceOf = true;
    public boolean reportCast = true;

    @Override
    @NotNull
    protected String buildErrorString(Object ... infos) {
        String string = (String)infos[0];
        if (string == null) {
            UseOfConcreteClassInspection.$$$reportNull$$$0(0);
        }
        return string;
    }

    @NotNull
    public OptPane getOptionsPane() {
        OptPane optPane = OptPane.pane((OptRegularComponent[])new OptRegularComponent[]{OptPane.checkbox((String)"ignoreAbstractClasses", (String)InspectionGadgetsBundle.message("use.of.concrete.class.option.ignore.abstract", new Object[0]), (OptRegularComponent[])new OptRegularComponent[0]), OptPane.checkbox((String)"ignoreRecords", (String)InspectionGadgetsBundle.message("use.of.concrete.class.option.ignore.records", new Object[0]), (OptRegularComponent[])new OptRegularComponent[0]), OptPane.checkbox((String)"reportMethodReturns", (String)InspectionGadgetsBundle.message("use.of.concrete.class.option.report.method.returns", new Object[0]), (OptRegularComponent[])new OptRegularComponent[0]), OptPane.checkbox((String)"reportMethodParameters", (String)InspectionGadgetsBundle.message("use.of.concrete.class.option.report.parameter", new Object[0]), (OptRegularComponent[])new OptRegularComponent[0]), OptPane.checkbox((String)"reportLocalVariables", (String)InspectionGadgetsBundle.message("use.of.concrete.class.option.report.local.variable", new Object[0]), (OptRegularComponent[])new OptRegularComponent[0]), OptPane.checkbox((String)"reportStaticFields", (String)InspectionGadgetsBundle.message("use.of.concrete.class.option.report.static.fields", new Object[0]), (OptRegularComponent[])new OptRegularComponent[0]), OptPane.checkbox((String)"reportInstanceFields", (String)InspectionGadgetsBundle.message("use.of.concrete.class.option.report.instance.fields", new Object[0]), (OptRegularComponent[])new OptRegularComponent[0]), OptPane.checkbox((String)"reportInstanceOf", (String)InspectionGadgetsBundle.message("use.of.concrete.class.option.report.instanceof", new Object[0]), (OptRegularComponent[])new OptRegularComponent[0]), OptPane.checkbox((String)"reportCast", (String)InspectionGadgetsBundle.message("use.of.concrete.class.option.report.cast", new Object[0]), (OptRegularComponent[])new OptRegularComponent[0])});
        if (optPane == null) {
            UseOfConcreteClassInspection.$$$reportNull$$$0(1);
        }
        return optPane;
    }

    @Override
    @NotNull
    public BaseInspectionVisitor buildVisitor() {
        return new MethodReturnOfConcreteClassVisitor();
    }

    @Contract(value="null -> false")
    private boolean typeIsConcreteClass(@Nullable PsiTypeElement typeElement) {
        if (typeElement == null || typeElement.isInferredType()) {
            return false;
        }
        PsiType type = typeElement.getType();
        return this.typeIsConcreteClass(type);
    }

    @Contract(value="null -> false")
    private boolean typeIsConcreteClass(@Nullable PsiType type) {
        if (type == null) {
            return false;
        }
        PsiType baseType = type.getDeepComponentType();
        PsiClass aClass = PsiUtil.resolveClassInClassTypeOnly((PsiType)baseType);
        if (aClass == null) {
            return false;
        }
        if (this.ignoreAbstractClasses && aClass.hasModifierProperty("abstract")) {
            return false;
        }
        if (this.ignoreRecords && aClass.isRecord()) {
            return false;
        }
        if (aClass.isInterface() || aClass.isEnum() || aClass.isAnnotationType()) {
            return false;
        }
        if (aClass instanceof PsiTypeParameter) {
            return false;
        }
        return !LibraryUtil.classIsInLibrary(aClass);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[2];
        objectArray2[0] = "com/siyeh/ig/abstraction/UseOfConcreteClassInspection";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "buildErrorString";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getOptionsPane";
                break;
            }
        }
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
    }

    private class MethodReturnOfConcreteClassVisitor
    extends BaseInspectionVisitor {
        private MethodReturnOfConcreteClassVisitor() {
        }

        public void visitMethod(@NotNull PsiMethod method) {
            if (method == null) {
                MethodReturnOfConcreteClassVisitor.$$$reportNull$$$0(0);
            }
            if (!UseOfConcreteClassInspection.this.reportMethodReturns) {
                return;
            }
            if (method.isConstructor()) {
                return;
            }
            PsiTypeElement typeElement = method.getReturnTypeElement();
            if (!UseOfConcreteClassInspection.this.typeIsConcreteClass(typeElement)) {
                return;
            }
            this.registerError((PsiElement)typeElement, InspectionGadgetsBundle.message("method.return.concrete.class.problem.descriptor", new Object[0]));
        }

        public void visitParameter(@NotNull PsiParameter parameter) {
            boolean report;
            if (parameter == null) {
                MethodReturnOfConcreteClassVisitor.$$$reportNull$$$0(1);
            }
            PsiElement scope = parameter.getDeclarationScope();
            boolean methodParameter = scope instanceof PsiMethod;
            boolean catchParameter = scope instanceof PsiCatchSection;
            boolean bl = report = methodParameter && UseOfConcreteClassInspection.this.reportMethodParameters || !methodParameter && !catchParameter && UseOfConcreteClassInspection.this.reportLocalVariables;
            if (!report) {
                return;
            }
            if (parameter instanceof PsiPatternVariable) {
                return;
            }
            PsiTypeElement typeElement = parameter.getTypeElement();
            if (!UseOfConcreteClassInspection.this.typeIsConcreteClass(typeElement)) {
                return;
            }
            String variableName = parameter.getName();
            this.registerError((PsiElement)typeElement, InspectionGadgetsBundle.message(methodParameter ? "concrete.class.method.parameter.problem.descriptor" : "local.variable.of.concrete.class.problem.descriptor", variableName));
        }

        public void visitLocalVariable(@NotNull PsiLocalVariable variable) {
            if (variable == null) {
                MethodReturnOfConcreteClassVisitor.$$$reportNull$$$0(2);
            }
            if (!UseOfConcreteClassInspection.this.reportLocalVariables) {
                return;
            }
            PsiTypeElement typeElement = variable.getTypeElement();
            if (!UseOfConcreteClassInspection.this.typeIsConcreteClass(typeElement)) {
                return;
            }
            PsiMethod method = (PsiMethod)PsiTreeUtil.getParentOfType((PsiElement)typeElement, PsiMethod.class, (boolean)true, (Class[])new Class[]{PsiClass.class, PsiLambdaExpression.class});
            if (MethodUtils.isEquals(method)) {
                return;
            }
            this.registerError((PsiElement)typeElement, InspectionGadgetsBundle.message("local.variable.of.concrete.class.problem.descriptor", variable.getName()));
        }

        public void visitField(@NotNull PsiField field) {
            boolean isStatic;
            boolean report;
            if (field == null) {
                MethodReturnOfConcreteClassVisitor.$$$reportNull$$$0(3);
            }
            boolean bl = report = (isStatic = field.hasModifierProperty("static")) && UseOfConcreteClassInspection.this.reportStaticFields || !isStatic && UseOfConcreteClassInspection.this.reportInstanceFields;
            if (!report) {
                return;
            }
            PsiTypeElement typeElement = field.getTypeElement();
            if (!UseOfConcreteClassInspection.this.typeIsConcreteClass(typeElement)) {
                return;
            }
            String variableName = field.getName();
            this.registerError((PsiElement)typeElement, InspectionGadgetsBundle.message(isStatic ? "static.variable.of.concrete.class.problem.descriptor" : "instance.variable.of.concrete.class.problem.descriptor", variableName));
        }

        public void visitMethodCallExpression(@NotNull PsiMethodCallExpression call) {
            PsiExpression qualifier;
            if (call == null) {
                MethodReturnOfConcreteClassVisitor.$$$reportNull$$$0(4);
            }
            if (UseOfConcreteClassInspection.this.reportInstanceOf && OBJECT_GET_CLASS.test(call)) {
                PsiMethod method;
                PsiTypeElement typeElement;
                PsiExpression other = ExpressionUtils.getExpressionComparedTo((PsiExpression)call);
                if (other instanceof PsiClassObjectAccessExpression && UseOfConcreteClassInspection.this.typeIsConcreteClass(typeElement = ((PsiClassObjectAccessExpression)other).getOperand()) && !MethodUtils.isEquals(method = (PsiMethod)PsiTreeUtil.getParentOfType((PsiElement)call, PsiMethod.class, (boolean)true, (Class[])new Class[]{PsiClass.class, PsiLambdaExpression.class}))) {
                    this.registerError((PsiElement)typeElement, InspectionGadgetsBundle.message("instanceof.concrete.class.equality.problem.descriptor", new Object[0]));
                }
            } else if (UseOfConcreteClassInspection.this.reportCast && CLASS_CAST.test(call) && (qualifier = call.getMethodExpression().getQualifierExpression()) != null) {
                PsiType qualifierType = qualifier.getType();
                PsiType targetClass = PsiUtil.substituteTypeParameter((PsiType)qualifierType, (String)"java.lang.Class", (int)0, (boolean)false);
                if (!UseOfConcreteClassInspection.this.typeIsConcreteClass(targetClass)) {
                    return;
                }
                PsiMethod method = (PsiMethod)PsiTreeUtil.getParentOfType((PsiElement)call, PsiMethod.class, (boolean)true, (Class[])new Class[]{PsiClass.class, PsiLambdaExpression.class});
                if (!MethodUtils.isEquals(method) && !CloneUtils.isClone(method)) {
                    this.registerMethodCallError(call, InspectionGadgetsBundle.message("cast.to.concrete.class.problem.descriptor", targetClass.getPresentableText()));
                }
            }
        }

        public void visitTypeTestPattern(@NotNull PsiTypeTestPattern pattern) {
            if (pattern == null) {
                MethodReturnOfConcreteClassVisitor.$$$reportNull$$$0(5);
            }
            PsiTypeElement typeElement = pattern.getCheckType();
            this.processInstanceOfCheck(typeElement, InspectionGadgetsBundle.message("instanceof.concrete.class.pattern.problem.descriptor", new Object[0]));
        }

        public void visitInstanceOfExpression(@NotNull PsiInstanceOfExpression expression) {
            if (expression == null) {
                MethodReturnOfConcreteClassVisitor.$$$reportNull$$$0(6);
            }
            super.visitInstanceOfExpression(expression);
            if (expression.getPattern() == null) {
                this.processInstanceOfCheck(expression.getCheckType(), InspectionGadgetsBundle.message("instanceof.concrete.class.problem.descriptor", new Object[0]));
            }
        }

        private void processInstanceOfCheck(@Nullable PsiTypeElement typeElement, @NotNull @Nls String message) {
            if (message == null) {
                MethodReturnOfConcreteClassVisitor.$$$reportNull$$$0(7);
            }
            if (!UseOfConcreteClassInspection.this.reportInstanceOf) {
                return;
            }
            if (!UseOfConcreteClassInspection.this.typeIsConcreteClass(typeElement)) {
                return;
            }
            PsiMethod method = (PsiMethod)PsiTreeUtil.getParentOfType((PsiElement)typeElement, PsiMethod.class, (boolean)true, (Class[])new Class[]{PsiClass.class, PsiLambdaExpression.class});
            if (MethodUtils.isEquals(method)) {
                return;
            }
            this.registerError((PsiElement)typeElement, message);
        }

        public void visitTypeCastExpression(@NotNull PsiTypeCastExpression expression) {
            if (expression == null) {
                MethodReturnOfConcreteClassVisitor.$$$reportNull$$$0(8);
            }
            if (!UseOfConcreteClassInspection.this.reportCast) {
                return;
            }
            PsiTypeElement typeElement = expression.getCastType();
            if (!UseOfConcreteClassInspection.this.typeIsConcreteClass(typeElement)) {
                return;
            }
            PsiMethod method = (PsiMethod)PsiTreeUtil.getParentOfType((PsiElement)expression, PsiMethod.class, (boolean)true, (Class[])new Class[]{PsiClass.class, PsiLambdaExpression.class});
            if (MethodUtils.isEquals(method) || CloneUtils.isClone(method)) {
                return;
            }
            this.registerError((PsiElement)typeElement, InspectionGadgetsBundle.message("cast.to.concrete.class.problem.descriptor", typeElement.getType().getPresentableText()));
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "method";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "parameter";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "variable";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "field";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "call";
                    break;
                }
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "pattern";
                    break;
                }
                case 6: 
                case 8: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "expression";
                    break;
                }
                case 7: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "message";
                    break;
                }
            }
            objectArray2[1] = "com/siyeh/ig/abstraction/UseOfConcreteClassInspection$MethodReturnOfConcreteClassVisitor";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "visitMethod";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "visitParameter";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "visitLocalVariable";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[2] = "visitField";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[2] = "visitMethodCallExpression";
                    break;
                }
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[2] = "visitTypeTestPattern";
                    break;
                }
                case 6: {
                    objectArray = objectArray2;
                    objectArray2[2] = "visitInstanceOfExpression";
                    break;
                }
                case 7: {
                    objectArray = objectArray2;
                    objectArray2[2] = "processInstanceOfCheck";
                    break;
                }
                case 8: {
                    objectArray = objectArray2;
                    objectArray2[2] = "visitTypeCastExpression";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

