/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.assignment;

import com.intellij.codeInspection.CleanupLocalInspectionTool;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.modcommand.ModPsiUpdater;
import com.intellij.modcommand.PsiUpdateModCommandQuickFix;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.JavaTokenType;
import com.intellij.psi.PsiBlockStatement;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiForStatement;
import com.intellij.psi.PsiLoopStatement;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiPostfixExpression;
import com.intellij.psi.PsiPrefixExpression;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiReturnStatement;
import com.intellij.psi.PsiStatement;
import com.intellij.psi.PsiThrowStatement;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiUnaryExpression;
import com.intellij.psi.PsiYieldStatement;
import com.intellij.psi.codeStyle.VariableKind;
import com.intellij.psi.search.LocalSearchScope;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiTreeUtil;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.PsiReplacementUtil;
import com.siyeh.ig.psiutils.CodeBlockSurrounder;
import com.siyeh.ig.psiutils.ExpressionUtils;
import com.siyeh.ig.psiutils.VariableNameGenerator;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class IncrementDecrementUsedAsExpressionInspection
extends BaseInspection
implements CleanupLocalInspectionTool {
    @NotNull
    public String getID() {
        return "ValueOfIncrementOrDecrementUsed";
    }

    @Override
    @NotNull
    public String buildErrorString(Object ... infos) {
        Object info = infos[0];
        if (info instanceof PsiPostfixExpression) {
            PsiPostfixExpression postfixExpression = (PsiPostfixExpression)info;
            IElementType tokenType = postfixExpression.getOperationTokenType();
            if (tokenType.equals(JavaTokenType.PLUSPLUS)) {
                String string = InspectionGadgetsBundle.message("value.of.post.increment.problem.descriptor", new Object[0]);
                if (string == null) {
                    IncrementDecrementUsedAsExpressionInspection.$$$reportNull$$$0(0);
                }
                return string;
            }
            String string = InspectionGadgetsBundle.message("value.of.post.decrement.problem.descriptor", new Object[0]);
            if (string == null) {
                IncrementDecrementUsedAsExpressionInspection.$$$reportNull$$$0(1);
            }
            return string;
        }
        PsiPrefixExpression prefixExpression = (PsiPrefixExpression)info;
        IElementType tokenType = prefixExpression.getOperationTokenType();
        if (tokenType.equals(JavaTokenType.PLUSPLUS)) {
            String string = InspectionGadgetsBundle.message("value.of.pre.increment.problem.descriptor", new Object[0]);
            if (string == null) {
                IncrementDecrementUsedAsExpressionInspection.$$$reportNull$$$0(2);
            }
            return string;
        }
        String string = InspectionGadgetsBundle.message("value.of.pre.decrement.problem.descriptor", new Object[0]);
        if (string == null) {
            IncrementDecrementUsedAsExpressionInspection.$$$reportNull$$$0(3);
        }
        return string;
    }

    @Override
    @Nullable
    protected LocalQuickFix buildFix(Object ... infos) {
        PsiExpression expression = (PsiExpression)infos[0];
        if (PsiTreeUtil.getParentOfType((PsiElement)expression, PsiCodeBlock.class, (boolean)true, (Class[])new Class[]{PsiMember.class}) == null) {
            return null;
        }
        return new IncrementDecrementUsedAsExpressionFix(expression.getText());
    }

    public static PsiExpression getSurroundPrefixPostfixExpression(@NotNull PsiUnaryExpression element) {
        PsiStatement statement;
        if (element == null) {
            IncrementDecrementUsedAsExpressionInspection.$$$reportNull$$$0(4);
        }
        if ((statement = (PsiStatement)PsiTreeUtil.getParentOfType((PsiElement)element, PsiStatement.class)) == null) {
            return null;
        }
        if (statement instanceof PsiLoopStatement) {
            return element;
        }
        CodeBlockSurrounder surrounder = CodeBlockSurrounder.forExpression((PsiExpression)element);
        if (surrounder == null) {
            return null;
        }
        CodeBlockSurrounder.SurroundResult result = surrounder.surround();
        return result.getExpression();
    }

    public static void extractPrefixPostfixExpressionToSeparateStatement(PsiElement element) {
        SearchScope useScope;
        PsiReferenceExpression referenceExpression;
        PsiElement target;
        if (!(element instanceof PsiUnaryExpression)) {
            assert (false);
            return;
        }
        PsiExpression operand = ((PsiUnaryExpression)element).getOperand();
        element = IncrementDecrementUsedAsExpressionInspection.getSurroundPrefixPostfixExpression((PsiUnaryExpression)element);
        if (operand == null) {
            return;
        }
        PsiStatement statement = (PsiStatement)PsiTreeUtil.getParentOfType((PsiElement)element, PsiStatement.class);
        if (statement == null) {
            return;
        }
        PsiElement parent = statement.getParent();
        if (parent == null) {
            return;
        }
        Project project = element.getProject();
        PsiElementFactory factory = JavaPsiFacade.getInstance((Project)project).getElementFactory();
        String newStatementText = element.getText() + ";";
        String operandText = operand.getText();
        PsiStatement newStatement = factory.createStatementFromText(newStatementText, element);
        if (statement instanceof PsiReturnStatement || statement instanceof PsiYieldStatement || statement instanceof PsiThrowStatement) {
            if (element instanceof PsiPostfixExpression) {
                String[] stringArray;
                PsiExpression expression = statement instanceof PsiReturnStatement ? ((PsiReturnStatement)statement).getReturnValue() : (statement instanceof PsiYieldStatement ? ((PsiYieldStatement)statement).getExpression() : ((PsiThrowStatement)statement).getException());
                if (expression == null) {
                    return;
                }
                PsiType type = expression.getType();
                if (type == null) {
                    return;
                }
                if (statement instanceof PsiThrowStatement) {
                    String[] stringArray2 = new String[3];
                    stringArray2[0] = "e";
                    stringArray2[1] = "ex";
                    stringArray = stringArray2;
                    stringArray2[2] = "exc";
                } else {
                    String[] stringArray3 = new String[1];
                    stringArray = stringArray3;
                    stringArray3[0] = "result";
                }
                String[] names = stringArray;
                VariableNameGenerator generator = new VariableNameGenerator((PsiElement)expression, VariableKind.LOCAL_VARIABLE);
                if (statement instanceof PsiReturnStatement || statement instanceof PsiYieldStatement) {
                    generator = generator.byType(type).byExpression(expression);
                }
                String variableName = generator.byName(names).generate(true);
                String newReturnValueText = PsiReplacementUtil.getElementText((PsiElement)expression, element, operandText);
                String declarationStatementText = type.getCanonicalText() + " " + variableName + "=" + newReturnValueText + ";";
                PsiStatement declarationStatement = factory.createStatementFromText(declarationStatementText, (PsiElement)statement);
                parent.addBefore((PsiElement)declarationStatement, (PsiElement)statement);
                parent.addBefore((PsiElement)newStatement, (PsiElement)statement);
                String keyword = statement instanceof PsiReturnStatement ? "return" : (statement instanceof PsiYieldStatement ? "yield" : "throw");
                PsiStatement newReturnStatement = factory.createStatementFromText(keyword + " " + variableName + ";", (PsiElement)statement);
                statement.replace((PsiElement)newReturnStatement);
                return;
            }
            parent.addBefore((PsiElement)newStatement, (PsiElement)statement);
        } else if (!(statement instanceof PsiForStatement)) {
            if (element instanceof PsiPostfixExpression) {
                parent.addAfter((PsiElement)newStatement, (PsiElement)statement);
            } else {
                parent.addBefore((PsiElement)newStatement, (PsiElement)statement);
            }
        } else if (operand instanceof PsiReferenceExpression && (target = (referenceExpression = (PsiReferenceExpression)operand).resolve()) != null && !new LocalSearchScope((PsiElement)statement).equals((Object)(useScope = target.getUseScope()))) {
            if (element instanceof PsiPostfixExpression) {
                parent.addAfter((PsiElement)newStatement, (PsiElement)statement);
            } else {
                parent.addBefore((PsiElement)newStatement, (PsiElement)statement);
            }
        }
        if (statement instanceof PsiLoopStatement) {
            PsiLoopStatement loopStatement = (PsiLoopStatement)statement;
            PsiStatement body = loopStatement.getBody();
            if (body instanceof PsiBlockStatement) {
                PsiBlockStatement blockStatement = (PsiBlockStatement)body;
                PsiCodeBlock codeBlock = blockStatement.getCodeBlock();
                if (element instanceof PsiPostfixExpression) {
                    PsiElement firstElement = codeBlock.getFirstBodyElement();
                    codeBlock.addBefore((PsiElement)newStatement, firstElement);
                } else {
                    codeBlock.add((PsiElement)newStatement);
                }
            } else {
                StringBuilder blockText = new StringBuilder();
                blockText.append('{');
                if (element instanceof PsiPostfixExpression) {
                    blockText.append(newStatementText);
                    if (body != null) {
                        blockText.append(body.getText());
                    }
                } else {
                    if (body != null) {
                        blockText.append(body.getText());
                    }
                    blockText.append(newStatementText);
                }
                blockText.append('}');
                PsiStatement blockStatement = factory.createStatementFromText(blockText.toString(), (PsiElement)statement);
                if (body == null) {
                    loopStatement.add((PsiElement)blockStatement);
                } else {
                    body.replace((PsiElement)blockStatement);
                }
            }
        }
        PsiReplacementUtil.replaceExpression((PsiExpression)element, operandText);
    }

    public static boolean isSuitableForReplacement(@NotNull PsiUnaryExpression expression) {
        if (expression == null) {
            IncrementDecrementUsedAsExpressionInspection.$$$reportNull$$$0(5);
        }
        if (ExpressionUtils.isVoidContext((PsiExpression)expression)) {
            return false;
        }
        IElementType tokenType = expression.getOperationTokenType();
        if (!tokenType.equals(JavaTokenType.PLUSPLUS) && !tokenType.equals(JavaTokenType.MINUSMINUS)) {
            return false;
        }
        PsiStatement statement = (PsiStatement)PsiTreeUtil.getParentOfType((PsiElement)expression, PsiStatement.class);
        PsiForStatement forStatement = (PsiForStatement)PsiTreeUtil.getParentOfType((PsiElement)expression, PsiForStatement.class);
        if (forStatement != null && PsiTreeUtil.isAncestor((PsiElement)forStatement.getInitialization(), (PsiElement)expression, (boolean)false)) {
            return false;
        }
        return statement != null && (CodeBlockSurrounder.canSurround((PsiExpression)expression) || statement instanceof PsiLoopStatement);
    }

    @Override
    @NotNull
    public BaseInspectionVisitor buildVisitor() {
        return new IncrementDecrementUsedAsExpressionVisitor();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 4, 5 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/siyeh/ig/assignment/IncrementDecrementUsedAsExpressionInspection";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expression";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "buildErrorString";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "com/siyeh/ig/assignment/IncrementDecrementUsedAsExpressionInspection";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getSurroundPrefixPostfixExpression";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "isSuitableForReplacement";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 4, 5 -> new IllegalArgumentException(string);
        };
    }

    private static class IncrementDecrementUsedAsExpressionFix
    extends PsiUpdateModCommandQuickFix {
        private final String elementText;

        IncrementDecrementUsedAsExpressionFix(String elementText) {
            this.elementText = elementText;
        }

        @NotNull
        public String getName() {
            String string = InspectionGadgetsBundle.message("increment.decrement.used.as.expression.quickfix", this.elementText);
            if (string == null) {
                IncrementDecrementUsedAsExpressionFix.$$$reportNull$$$0(0);
            }
            return string;
        }

        @NotNull
        public String getFamilyName() {
            String string = InspectionGadgetsBundle.message("increment.decrement.used.as.expression.fix.family.name", new Object[0]);
            if (string == null) {
                IncrementDecrementUsedAsExpressionFix.$$$reportNull$$$0(1);
            }
            return string;
        }

        protected void applyFix(@NotNull Project project, @NotNull PsiElement startElement, @NotNull ModPsiUpdater updater) {
            if (project == null) {
                IncrementDecrementUsedAsExpressionFix.$$$reportNull$$$0(2);
            }
            if (startElement == null) {
                IncrementDecrementUsedAsExpressionFix.$$$reportNull$$$0(3);
            }
            if (updater == null) {
                IncrementDecrementUsedAsExpressionFix.$$$reportNull$$$0(4);
            }
            IncrementDecrementUsedAsExpressionInspection.extractPrefixPostfixExpressionToSeparateStatement(startElement);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 2;
                case 2, 3, 4 -> 3;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/siyeh/ig/assignment/IncrementDecrementUsedAsExpressionInspection$IncrementDecrementUsedAsExpressionFix";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "startElement";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "updater";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getName";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFamilyName";
                    break;
                }
                case 2: 
                case 3: 
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/siyeh/ig/assignment/IncrementDecrementUsedAsExpressionInspection$IncrementDecrementUsedAsExpressionFix";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 2: 
                case 3: 
                case 4: {
                    objectArray = objectArray;
                    objectArray[2] = "applyFix";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalStateException(string);
                case 2, 3, 4 -> new IllegalArgumentException(string);
            };
        }
    }

    private static class IncrementDecrementUsedAsExpressionVisitor
    extends BaseInspectionVisitor {
        private IncrementDecrementUsedAsExpressionVisitor() {
        }

        public void visitUnaryExpression(@NotNull PsiUnaryExpression expression) {
            if (expression == null) {
                IncrementDecrementUsedAsExpressionVisitor.$$$reportNull$$$0(0);
            }
            super.visitUnaryExpression(expression);
            if (IncrementDecrementUsedAsExpressionInspection.isSuitableForReplacement(expression)) {
                this.registerError((PsiElement)expression, expression);
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "com/siyeh/ig/assignment/IncrementDecrementUsedAsExpressionInspection$IncrementDecrementUsedAsExpressionVisitor", "visitUnaryExpression"));
        }
    }
}

