/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.bitwise;

import com.intellij.psi.JavaTokenType;
import com.intellij.psi.PsiBinaryExpression;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypes;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.ConstantExpressionUtil;
import com.intellij.psi.util.PsiUtil;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.psiutils.ComparisonUtils;
import org.jetbrains.annotations.NotNull;

public final class IncompatibleMaskInspection
extends BaseInspection {
    @NotNull
    public String getID() {
        return "IncompatibleBitwiseMaskOperation";
    }

    @Override
    @NotNull
    public String buildErrorString(Object ... infos) {
        PsiBinaryExpression binaryExpression = (PsiBinaryExpression)infos[0];
        IElementType tokenType = binaryExpression.getOperationTokenType();
        if (tokenType.equals(JavaTokenType.EQEQ)) {
            String string = InspectionGadgetsBundle.message("incompatible.mask.operation.problem.descriptor.always.false", new Object[0]);
            if (string == null) {
                IncompatibleMaskInspection.$$$reportNull$$$0(0);
            }
            return string;
        }
        String string = InspectionGadgetsBundle.message("incompatible.mask.operation.problem.descriptor.always.true", new Object[0]);
        if (string == null) {
            IncompatibleMaskInspection.$$$reportNull$$$0(1);
        }
        return string;
    }

    public boolean isEnabledByDefault() {
        return true;
    }

    @Override
    @NotNull
    public BaseInspectionVisitor buildVisitor() {
        return new IncompatibleMaskVisitor();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/bitwise/IncompatibleMaskInspection", "buildErrorString"));
    }

    private static class IncompatibleMaskVisitor
    extends BaseInspectionVisitor {
        private IncompatibleMaskVisitor() {
        }

        public void visitBinaryExpression(@NotNull PsiBinaryExpression expression) {
            if (expression == null) {
                IncompatibleMaskVisitor.$$$reportNull$$$0(0);
            }
            super.visitBinaryExpression(expression);
            PsiExpression rhs = expression.getROperand();
            if (!ComparisonUtils.isEqualityComparison((PsiExpression)expression)) {
                return;
            }
            PsiType expressionType = expression.getType();
            if (expressionType == null) {
                return;
            }
            PsiExpression strippedRhs = PsiUtil.skipParenthesizedExprDown((PsiExpression)rhs);
            if (strippedRhs == null) {
                return;
            }
            PsiExpression lhs = expression.getLOperand();
            PsiExpression strippedLhs = PsiUtil.skipParenthesizedExprDown((PsiExpression)lhs);
            if (strippedLhs == null) {
                return;
            }
            if (IncompatibleMaskVisitor.isConstantMask(strippedLhs) && PsiUtil.isConstantExpression((PsiExpression)strippedRhs)) {
                if (IncompatibleMaskVisitor.isIncompatibleMask((PsiBinaryExpression)strippedLhs, strippedRhs)) {
                    this.registerError((PsiElement)expression, expression);
                }
            } else if (IncompatibleMaskVisitor.isConstantMask(strippedRhs) && PsiUtil.isConstantExpression((PsiExpression)strippedLhs) && IncompatibleMaskVisitor.isIncompatibleMask((PsiBinaryExpression)strippedRhs, strippedLhs)) {
                this.registerError((PsiElement)expression, expression);
            }
        }

        private static boolean isIncompatibleMask(PsiBinaryExpression maskExpression, PsiExpression constantExpression) {
            long constantMaskValue;
            IElementType tokenType = maskExpression.getOperationTokenType();
            Object constantValue = ConstantExpressionUtil.computeCastTo((PsiExpression)constantExpression, (PsiType)PsiTypes.longType());
            if (constantValue == null) {
                return false;
            }
            long constantLongValue = (Long)constantValue;
            PsiExpression maskRhs = maskExpression.getROperand();
            PsiExpression maskLhs = maskExpression.getLOperand();
            if (PsiUtil.isConstantExpression((PsiExpression)maskRhs)) {
                Object rhsValue = ConstantExpressionUtil.computeCastTo((PsiExpression)maskRhs, (PsiType)PsiTypes.longType());
                if (rhsValue == null) {
                    return false;
                }
                constantMaskValue = (Long)rhsValue;
            } else {
                Object lhsValue = ConstantExpressionUtil.computeCastTo((PsiExpression)maskLhs, (PsiType)PsiTypes.longType());
                if (lhsValue == null) {
                    return false;
                }
                constantMaskValue = (Long)lhsValue;
            }
            if (tokenType.equals(JavaTokenType.OR) && (constantMaskValue | constantLongValue) != constantLongValue) {
                return true;
            }
            return tokenType.equals(JavaTokenType.AND) && (constantMaskValue | constantLongValue) != constantMaskValue;
        }

        private static boolean isConstantMask(PsiExpression expression) {
            if (expression == null) {
                return false;
            }
            if (!(expression instanceof PsiBinaryExpression)) {
                return false;
            }
            PsiBinaryExpression binaryExpression = (PsiBinaryExpression)expression;
            IElementType tokenType = binaryExpression.getOperationTokenType();
            if (!tokenType.equals(JavaTokenType.OR) && !tokenType.equals(JavaTokenType.AND)) {
                return false;
            }
            PsiExpression rhs = binaryExpression.getROperand();
            if (PsiUtil.isConstantExpression((PsiExpression)rhs)) {
                return true;
            }
            PsiExpression lhs = binaryExpression.getLOperand();
            return PsiUtil.isConstantExpression((PsiExpression)lhs);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "com/siyeh/ig/bitwise/IncompatibleMaskInspection$IncompatibleMaskVisitor", "visitBinaryExpression"));
        }
    }
}

