/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.bitwise;

import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.options.OptPane;
import com.intellij.codeInspection.options.OptRegularComponent;
import com.intellij.modcommand.ModPsiUpdater;
import com.intellij.modcommand.PsiUpdateModCommandQuickFix;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaTokenType;
import com.intellij.psi.PsiBinaryExpression;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiJavaToken;
import com.intellij.psi.PsiLiteralExpression;
import com.intellij.psi.PsiPolyadicExpression;
import com.intellij.psi.PsiPrefixExpression;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypes;
import com.intellij.psi.impl.source.tree.ElementType;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.TokenSet;
import com.intellij.psi.util.ConstantExpressionUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.psi.util.PsiUtilCore;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.psiutils.CommentTracker;
import com.siyeh.ig.psiutils.EquivalenceChecker;
import com.siyeh.ig.psiutils.ExpressionUtils;
import com.siyeh.ig.psiutils.JavaPsiMathUtil;
import com.siyeh.ig.psiutils.SideEffectChecker;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public final class PointlessBitwiseExpressionInspection
extends BaseInspection {
    public boolean m_ignoreExpressionsContainingConstants = true;
    @NotNull
    static final TokenSet bitwiseTokens = TokenSet.create((IElementType[])new IElementType[]{JavaTokenType.AND, JavaTokenType.OR, JavaTokenType.XOR, JavaTokenType.LTLT, JavaTokenType.GTGT, JavaTokenType.GTGTGT});

    @Override
    @NotNull
    public String buildErrorString(Object ... infos) {
        PsiExpression expression = (PsiExpression)infos[0];
        String replacementExpression = this.calculateReplacementExpression(expression, new CommentTracker());
        String string = InspectionGadgetsBundle.message("expression.can.be.replaced.problem.descriptor", replacementExpression);
        if (string == null) {
            PointlessBitwiseExpressionInspection.$$$reportNull$$$0(0);
        }
        return string;
    }

    public boolean isEnabledByDefault() {
        return true;
    }

    @NotNull
    public OptPane getOptionsPane() {
        OptPane optPane = OptPane.pane((OptRegularComponent[])new OptRegularComponent[]{OptPane.checkbox((String)"m_ignoreExpressionsContainingConstants", (String)InspectionGadgetsBundle.message("pointless.boolean.expression.ignore.option", new Object[0]), (OptRegularComponent[])new OptRegularComponent[0])});
        if (optPane == null) {
            PointlessBitwiseExpressionInspection.$$$reportNull$$$0(1);
        }
        return optPane;
    }

    String calculateReplacementExpression(PsiExpression expression, CommentTracker ct) {
        if (expression instanceof PsiPolyadicExpression) {
            return this.calculateReplacementExpression((PsiPolyadicExpression)expression, ct);
        }
        PsiExpression complemented = PointlessBitwiseExpressionInspection.unwrapComplement(expression);
        if (complemented != null) {
            PsiExpression decremented = PointlessBitwiseExpressionInspection.extractDecrementedValue(complemented);
            if (decremented != null) {
                return "-" + ct.text(decremented, 3);
            }
            PsiExpression twiceComplemented = PointlessBitwiseExpressionInspection.unwrapComplement(complemented);
            if (twiceComplemented != null) {
                return ct.text((PsiElement)twiceComplemented);
            }
        }
        return "";
    }

    @NonNls
    String calculateReplacementExpression(PsiPolyadicExpression expression, CommentTracker ct) {
        IElementType tokenType = expression.getOperationTokenType();
        PsiExpression[] operands = expression.getOperands();
        PsiExpression previousOperand = null;
        int length = operands.length;
        for (int i = 0; i < length; ++i) {
            PsiExpression operand = operands[i];
            if (this.isZero(operand)) {
                if (tokenType.equals(JavaTokenType.AND) || ElementType.SHIFT_OPS.contains(tokenType) && previousOperand == null) {
                    return PointlessBitwiseExpressionInspection.getText(expression, (PsiElement)operands[0], (PsiElement)operands[length - 1], PsiTypes.longType().equals((Object)expression.getType()) ? "0L" : "0", ct);
                }
                if (tokenType.equals(JavaTokenType.OR) || tokenType.equals(JavaTokenType.XOR) || ElementType.SHIFT_OPS.contains(tokenType) && previousOperand != null) {
                    return PointlessBitwiseExpressionInspection.getText(expression, (PsiElement)(i == length - 1 ? expression.getTokenBeforeOperand(operand) : operand), ct);
                }
            } else if (this.isAllOnes(operand)) {
                if (tokenType.equals(JavaTokenType.AND)) {
                    return PointlessBitwiseExpressionInspection.getText(expression, (PsiElement)(i == length - 1 ? expression.getTokenBeforeOperand(operand) : operand), ct);
                }
                if (tokenType.equals(JavaTokenType.OR)) {
                    return ct.text((PsiElement)operand);
                }
                if (tokenType.equals(JavaTokenType.XOR)) {
                    if (previousOperand != null) {
                        return PointlessBitwiseExpressionInspection.getText(expression, (PsiElement)previousOperand, (PsiElement)operand, PointlessBitwiseExpressionInspection.getTildeReplacement(previousOperand, ct), ct);
                    }
                    PsiExpression nextOperand = operands[i + 1];
                    return PointlessBitwiseExpressionInspection.getText(expression, (PsiElement)operand, (PsiElement)nextOperand, PointlessBitwiseExpressionInspection.getTildeReplacement(nextOperand, ct), ct);
                }
            } else if (EquivalenceChecker.getCanonicalPsiEquivalence().expressionsAreEquivalent(previousOperand, operand)) {
                if (tokenType.equals(JavaTokenType.OR) || tokenType.equals(JavaTokenType.AND)) {
                    return PointlessBitwiseExpressionInspection.getText(expression, (PsiElement)previousOperand, (PsiElement)operand, ct.text((PsiElement)operand), ct);
                }
                if (tokenType.equals(JavaTokenType.XOR)) {
                    return PointlessBitwiseExpressionInspection.getText(expression, (PsiElement)previousOperand, (PsiElement)operand, PsiTypes.longType().equals((Object)expression.getType()) ? "0L" : "0", ct);
                }
            } else {
                PsiExpression left = PointlessBitwiseExpressionInspection.optionallyUnwrapComplement(previousOperand);
                PsiExpression right = PointlessBitwiseExpressionInspection.optionallyUnwrapComplement(operand);
                if (EquivalenceChecker.getCanonicalPsiEquivalence().expressionsAreEquivalent(left, right)) {
                    if (tokenType.equals(JavaTokenType.AND)) {
                        return PointlessBitwiseExpressionInspection.getText(expression, (PsiElement)previousOperand, (PsiElement)operand, PsiTypes.longType().equals((Object)expression.getType()) ? "0L" : "0", ct);
                    }
                    if (tokenType.equals(JavaTokenType.OR) || tokenType.equals(JavaTokenType.XOR)) {
                        return PointlessBitwiseExpressionInspection.getText(expression, (PsiElement)previousOperand, (PsiElement)operand, PsiTypes.longType().equals((Object)expression.getType()) ? "-1L" : "-1", ct);
                    }
                }
            }
            previousOperand = operand;
        }
        return "";
    }

    private static String getTildeReplacement(PsiExpression operand, CommentTracker ct) {
        PsiExpression decrementedValue = PointlessBitwiseExpressionInspection.extractDecrementedValue(operand);
        if (decrementedValue != null) {
            return "-" + ct.text(decrementedValue, 3);
        }
        return "~" + ct.text(operand, 3);
    }

    private static PsiExpression extractDecrementedValue(PsiExpression expression) {
        Number right;
        PsiBinaryExpression binOp;
        if ((expression = PsiUtil.skipParenthesizedExprDown((PsiExpression)expression)) instanceof PsiBinaryExpression && (binOp = (PsiBinaryExpression)expression).getOperationTokenType().equals(JavaTokenType.MINUS) && ((right = JavaPsiMathUtil.getNumberFromLiteral(binOp.getROperand())) instanceof Integer || right instanceof Long) && right.longValue() == 1L) {
            return binOp.getLOperand();
        }
        return null;
    }

    private static String getText(PsiPolyadicExpression expression, PsiElement fromTarget, PsiElement untilTarget, @NotNull @NonNls String replacement, CommentTracker ct) {
        if (replacement == null) {
            PointlessBitwiseExpressionInspection.$$$reportNull$$$0(2);
        }
        StringBuilder result = new StringBuilder();
        boolean stop = false;
        for (PsiElement child = expression.getFirstChild(); child != null; child = child.getNextSibling()) {
            if (child == fromTarget) {
                stop = true;
                result.append(replacement);
                continue;
            }
            if (child == untilTarget) {
                stop = false;
                continue;
            }
            if (child instanceof PsiComment && !result.isEmpty() || !stop) {
                result.append(ct.text(child));
                continue;
            }
            if (!(child instanceof PsiJavaToken) || untilTarget != null) continue;
            stop = false;
        }
        return result.toString();
    }

    private static String getText(PsiPolyadicExpression expression, PsiElement exclude, CommentTracker ct) {
        return PointlessBitwiseExpressionInspection.getText(expression, exclude, null, "", ct).trim();
    }

    @Override
    @NotNull
    public BaseInspectionVisitor buildVisitor() {
        return new PointlessBitwiseVisitor();
    }

    @Override
    public LocalQuickFix buildFix(Object ... infos) {
        return new PointlessBitwiseFix();
    }

    private static PsiExpression optionallyUnwrapComplement(PsiExpression op) {
        PsiExpression unwrapped = PointlessBitwiseExpressionInspection.unwrapComplement(op);
        return unwrapped == null ? op : unwrapped;
    }

    private static PsiExpression unwrapComplement(PsiExpression op) {
        if ((op = PsiUtil.skipParenthesizedExprDown((PsiExpression)op)) instanceof PsiPrefixExpression && ((PsiPrefixExpression)op).getOperationTokenType().equals(JavaTokenType.TILDE)) {
            return ((PsiPrefixExpression)op).getOperand();
        }
        return null;
    }

    private boolean isZero(PsiExpression expression) {
        if (this.m_ignoreExpressionsContainingConstants && !(expression instanceof PsiLiteralExpression)) {
            return false;
        }
        return ExpressionUtils.isZero(expression);
    }

    private boolean isAllOnes(PsiExpression expression) {
        PsiType expressionType = expression.getType();
        Object value = this.m_ignoreExpressionsContainingConstants ? JavaPsiMathUtil.getNumberFromLiteral(expression) : ConstantExpressionUtil.computeCastTo((PsiExpression)expression, (PsiType)expressionType);
        return (value instanceof Integer || value instanceof Short || value instanceof Byte) && ((Number)value).intValue() == -1 || value instanceof Long && (Long)value == -1L;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 2 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/siyeh/ig/bitwise/PointlessBitwiseExpressionInspection";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "replacement";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "buildErrorString";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getOptionsPane";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "com/siyeh/ig/bitwise/PointlessBitwiseExpressionInspection";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getText";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 2 -> new IllegalArgumentException(string);
        };
    }

    private class PointlessBitwiseVisitor
    extends BaseInspectionVisitor {
        private PointlessBitwiseVisitor() {
        }

        public void visitPrefixExpression(@NotNull PsiPrefixExpression expression) {
            if (expression == null) {
                PointlessBitwiseVisitor.$$$reportNull$$$0(0);
            }
            super.visitPrefixExpression(expression);
            PsiExpression complemented = PointlessBitwiseExpressionInspection.unwrapComplement((PsiExpression)expression);
            if (complemented == null) {
                return;
            }
            if (PointlessBitwiseExpressionInspection.extractDecrementedValue(complemented) != null) {
                this.registerError((PsiElement)expression, expression);
            } else {
                PsiExpression twiceComplemented = PointlessBitwiseExpressionInspection.unwrapComplement(complemented);
                if (twiceComplemented != null && PointlessBitwiseExpressionInspection.unwrapComplement(twiceComplemented) == null) {
                    this.registerError((PsiElement)expression, expression);
                }
            }
        }

        public void visitPolyadicExpression(@NotNull PsiPolyadicExpression expression) {
            PsiExpression[] operands;
            if (expression == null) {
                PointlessBitwiseVisitor.$$$reportNull$$$0(1);
            }
            super.visitPolyadicExpression(expression);
            IElementType sign = expression.getOperationTokenType();
            if (!bitwiseTokens.contains(sign)) {
                return;
            }
            if (PsiUtilCore.hasErrorElementChild((PsiElement)expression)) {
                return;
            }
            for (PsiExpression operand : operands = expression.getOperands()) {
                if (operand == null) {
                    return;
                }
                PsiType type = operand.getType();
                if (type != null && !type.equals(PsiTypes.booleanType()) && !type.equalsToText("java.lang.Boolean")) continue;
                return;
            }
            boolean isPointless = sign.equals(JavaTokenType.AND) || sign.equals(JavaTokenType.OR) || sign.equals(JavaTokenType.XOR) ? this.booleanExpressionIsPointless(operands) : (ElementType.SHIFT_OPS.contains(sign) ? this.shiftExpressionIsPointless(operands) : false);
            if (!isPointless) {
                return;
            }
            this.registerError((PsiElement)expression, expression);
        }

        private boolean booleanExpressionIsPointless(PsiExpression[] operands) {
            PsiExpression previousExpression = null;
            for (PsiExpression operand : operands) {
                if (PointlessBitwiseExpressionInspection.this.isZero(operand) || PointlessBitwiseExpressionInspection.this.isAllOnes(operand) || PointlessBitwiseVisitor.areEquivalentModuloComplement(previousExpression, operand) && !SideEffectChecker.mayHaveSideEffects(operand)) {
                    return true;
                }
                previousExpression = operand;
            }
            return false;
        }

        private static boolean areEquivalentModuloComplement(PsiExpression op1, PsiExpression op2) {
            return EquivalenceChecker.getCanonicalPsiEquivalence().expressionsAreEquivalent(PointlessBitwiseExpressionInspection.optionallyUnwrapComplement(op1), PointlessBitwiseExpressionInspection.optionallyUnwrapComplement(op2));
        }

        private boolean shiftExpressionIsPointless(PsiExpression[] operands) {
            for (PsiExpression operand : operands) {
                if (!PointlessBitwiseExpressionInspection.this.isZero(operand)) continue;
                return true;
            }
            return false;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            objectArray2[0] = "expression";
            objectArray2[1] = "com/siyeh/ig/bitwise/PointlessBitwiseExpressionInspection$PointlessBitwiseVisitor";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "visitPrefixExpression";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "visitPolyadicExpression";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private class PointlessBitwiseFix
    extends PsiUpdateModCommandQuickFix {
        private PointlessBitwiseFix() {
        }

        @NotNull
        public String getFamilyName() {
            String string = InspectionGadgetsBundle.message("pointless.bitwise.expression.simplify.quickfix", new Object[0]);
            if (string == null) {
                PointlessBitwiseFix.$$$reportNull$$$0(0);
            }
            return string;
        }

        protected void applyFix(@NotNull Project project, @NotNull PsiElement startElement, @NotNull ModPsiUpdater updater) {
            CommentTracker ct;
            PsiExpression expression;
            String newExpression;
            if (project == null) {
                PointlessBitwiseFix.$$$reportNull$$$0(1);
            }
            if (startElement == null) {
                PointlessBitwiseFix.$$$reportNull$$$0(2);
            }
            if (updater == null) {
                PointlessBitwiseFix.$$$reportNull$$$0(3);
            }
            if (!(newExpression = PointlessBitwiseExpressionInspection.this.calculateReplacementExpression(expression = (PsiExpression)startElement, ct = new CommentTracker())).isEmpty()) {
                ct.replaceAndRestoreComments((PsiElement)expression, newExpression);
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 2;
                case 1, 2, 3 -> 3;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/siyeh/ig/bitwise/PointlessBitwiseExpressionInspection$PointlessBitwiseFix";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "startElement";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "updater";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFamilyName";
                    break;
                }
                case 1: 
                case 2: 
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/siyeh/ig/bitwise/PointlessBitwiseExpressionInspection$PointlessBitwiseFix";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 1: 
                case 2: 
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "applyFix";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalStateException(string);
                case 1, 2, 3 -> new IllegalArgumentException(string);
            };
        }
    }
}

