/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.bugs;

import com.intellij.codeInspection.CommonQuickFixBundle;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.modcommand.ModPsiUpdater;
import com.intellij.modcommand.PsiUpdateModCommandQuickFix;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaTokenType;
import com.intellij.psi.PsiArrayType;
import com.intellij.psi.PsiBinaryExpression;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiType;
import com.intellij.psi.tree.IElementType;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.PsiReplacementUtil;
import com.siyeh.ig.psiutils.CommentTracker;
import com.siyeh.ig.psiutils.ComparisonUtils;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public final class ArrayEqualityInspection
extends BaseInspection {
    @Override
    @NotNull
    public String buildErrorString(Object ... infos) {
        String string = InspectionGadgetsBundle.message("array.comparison.problem.descriptor", new Object[0]);
        if (string == null) {
            ArrayEqualityInspection.$$$reportNull$$$0(0);
        }
        return string;
    }

    @Override
    public LocalQuickFix buildFix(Object ... infos) {
        PsiArrayType type = (PsiArrayType)infos[0];
        PsiType componentType = type.getComponentType();
        if (componentType instanceof PsiArrayType) {
            return new ArrayEqualityFix(true);
        }
        return new ArrayEqualityFix(false);
    }

    @Override
    @NotNull
    public BaseInspectionVisitor buildVisitor() {
        return new ArrayEqualityVisitor();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/bugs/ArrayEqualityInspection", "buildErrorString"));
    }

    private static class ArrayEqualityFix
    extends PsiUpdateModCommandQuickFix {
        private final boolean deepEquals;

        ArrayEqualityFix(boolean deepEquals) {
            this.deepEquals = deepEquals;
        }

        @NotNull
        public String getName() {
            String string = CommonQuickFixBundle.message((String)"fix.replace.with.x", (Object[])new Object[]{this.deepEquals ? "Arrays.deepEquals()" : "Arrays.equals()"});
            if (string == null) {
                ArrayEqualityFix.$$$reportNull$$$0(0);
            }
            return string;
        }

        @NotNull
        public String getFamilyName() {
            String string = CommonQuickFixBundle.message((String)"fix.replace.with.x", (Object[])new Object[]{"Arrays.equals()"});
            if (string == null) {
                ArrayEqualityFix.$$$reportNull$$$0(1);
            }
            return string;
        }

        protected void applyFix(@NotNull Project project, @NotNull PsiElement element, @NotNull ModPsiUpdater updater) {
            PsiElement parent;
            if (project == null) {
                ArrayEqualityFix.$$$reportNull$$$0(2);
            }
            if (element == null) {
                ArrayEqualityFix.$$$reportNull$$$0(3);
            }
            if (updater == null) {
                ArrayEqualityFix.$$$reportNull$$$0(4);
            }
            if (!((parent = element.getParent()) instanceof PsiBinaryExpression)) {
                return;
            }
            PsiBinaryExpression binaryExpression = (PsiBinaryExpression)parent;
            CommentTracker commentTracker = new CommentTracker();
            IElementType tokenType = binaryExpression.getOperationTokenType();
            @NonNls StringBuilder newExpressionText = new StringBuilder();
            if (JavaTokenType.NE.equals(tokenType)) {
                newExpressionText.append('!');
            } else if (!JavaTokenType.EQEQ.equals(tokenType)) {
                return;
            }
            if (this.deepEquals) {
                newExpressionText.append("java.util.Arrays.deepEquals(");
            } else {
                newExpressionText.append("java.util.Arrays.equals(");
            }
            newExpressionText.append(commentTracker.text((PsiElement)binaryExpression.getLOperand()));
            newExpressionText.append(',');
            PsiExpression rhs = binaryExpression.getROperand();
            if (rhs == null) {
                return;
            }
            newExpressionText.append(commentTracker.text((PsiElement)rhs));
            newExpressionText.append(')');
            PsiReplacementUtil.replaceExpressionAndShorten((PsiExpression)binaryExpression, newExpressionText.toString(), commentTracker);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 2;
                case 2, 3, 4 -> 3;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/siyeh/ig/bugs/ArrayEqualityInspection$ArrayEqualityFix";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "element";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "updater";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getName";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFamilyName";
                    break;
                }
                case 2: 
                case 3: 
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/siyeh/ig/bugs/ArrayEqualityInspection$ArrayEqualityFix";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 2: 
                case 3: 
                case 4: {
                    objectArray = objectArray;
                    objectArray[2] = "applyFix";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalStateException(string);
                case 2, 3, 4 -> new IllegalArgumentException(string);
            };
        }
    }

    private static class ArrayEqualityVisitor
    extends BaseInspectionVisitor {
        private ArrayEqualityVisitor() {
        }

        public void visitBinaryExpression(@NotNull PsiBinaryExpression expression) {
            if (expression == null) {
                ArrayEqualityVisitor.$$$reportNull$$$0(0);
            }
            super.visitBinaryExpression(expression);
            PsiExpression rhs = expression.getROperand();
            if (rhs == null || !ComparisonUtils.isEqualityComparison((PsiExpression)expression)) {
                return;
            }
            PsiExpression lhs = expression.getLOperand();
            PsiType lhsType = lhs.getType();
            if (!(lhsType instanceof PsiArrayType) || !(rhs.getType() instanceof PsiArrayType)) {
                return;
            }
            this.registerError((PsiElement)expression.getOperationSign(), lhsType);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "com/siyeh/ig/bugs/ArrayEqualityInspection$ArrayEqualityVisitor", "visitBinaryExpression"));
        }
    }
}

