/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.bugs;

import com.intellij.codeInspection.CommonQuickFixBundle;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.modcommand.ModPsiUpdater;
import com.intellij.modcommand.PsiUpdateModCommandQuickFix;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiArrayType;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionList;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiType;
import com.intellij.psi.codeStyle.JavaCodeStyleManager;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.PsiReplacementUtil;
import com.siyeh.ig.psiutils.CommentTracker;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public final class ArrayHashCodeInspection
extends BaseInspection {
    @Override
    @NotNull
    protected String buildErrorString(Object ... infos) {
        String string = switch (((Kind)((Object)infos[1])).ordinal()) {
            default -> throw new MatchException(null, null);
            case 0 -> InspectionGadgetsBundle.message("array.hash.code.problem.descriptor", new Object[0]);
            case 1 -> InspectionGadgetsBundle.message("objects.hash.problem.descriptor", new Object[0]);
        };
        if (string == null) {
            ArrayHashCodeInspection.$$$reportNull$$$0(0);
        }
        return string;
    }

    public boolean isEnabledByDefault() {
        return true;
    }

    @Override
    protected LocalQuickFix buildFix(Object ... infos) {
        PsiArrayType type = (PsiArrayType)infos[0];
        boolean deepHashCode = type.getComponentType() instanceof PsiArrayType;
        return switch (((Kind)((Object)infos[1])).ordinal()) {
            default -> throw new MatchException(null, null);
            case 0 -> new ArrayHashCodeFix(deepHashCode);
            case 1 -> new ObjectsHashFix(deepHashCode);
        };
    }

    @Override
    @NotNull
    public BaseInspectionVisitor buildVisitor() {
        return new ArrayHashCodeVisitor();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/bugs/ArrayHashCodeInspection", "buildErrorString"));
    }

    static enum Kind {
        ARRAY_HASH_CODE,
        OBJECTS_HASH;

    }

    private static class ArrayHashCodeFix
    extends PsiUpdateModCommandQuickFix {
        private final boolean deepHashCode;

        ArrayHashCodeFix(boolean deepHashCode) {
            this.deepHashCode = deepHashCode;
        }

        @NotNull
        public String getName() {
            String string = CommonQuickFixBundle.message((String)"fix.replace.with.x.call", (Object[])new Object[]{this.deepHashCode ? "Arrays.deepHashCode()" : "Arrays.hashCode()"});
            if (string == null) {
                ArrayHashCodeFix.$$$reportNull$$$0(0);
            }
            return string;
        }

        @NotNull
        public String getFamilyName() {
            String string = InspectionGadgetsBundle.message("array.hash.code.fix.family.name", new Object[0]);
            if (string == null) {
                ArrayHashCodeFix.$$$reportNull$$$0(1);
            }
            return string;
        }

        protected void applyFix(@NotNull Project project, @NotNull PsiElement element, @NotNull ModPsiUpdater updater) {
            PsiElement parent;
            PsiElement grandParent;
            if (project == null) {
                ArrayHashCodeFix.$$$reportNull$$$0(2);
            }
            if (element == null) {
                ArrayHashCodeFix.$$$reportNull$$$0(3);
            }
            if (updater == null) {
                ArrayHashCodeFix.$$$reportNull$$$0(4);
            }
            if (!((grandParent = (parent = element.getParent()).getParent()) instanceof PsiMethodCallExpression)) {
                return;
            }
            PsiMethodCallExpression methodCallExpression = (PsiMethodCallExpression)grandParent;
            PsiReferenceExpression methodExpression = methodCallExpression.getMethodExpression();
            PsiExpression qualifier = methodExpression.getQualifierExpression();
            if (qualifier == null) {
                return;
            }
            @NonNls StringBuilder newExpressionText = new StringBuilder();
            if (this.deepHashCode) {
                newExpressionText.append("java.util.Arrays.deepHashCode(");
            } else {
                newExpressionText.append("java.util.Arrays.hashCode(");
            }
            CommentTracker commentTracker = new CommentTracker();
            newExpressionText.append(commentTracker.text((PsiElement)qualifier));
            newExpressionText.append(')');
            PsiReplacementUtil.replaceExpressionAndShorten((PsiExpression)methodCallExpression, newExpressionText.toString(), commentTracker);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 2;
                case 2, 3, 4 -> 3;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/siyeh/ig/bugs/ArrayHashCodeInspection$ArrayHashCodeFix";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "element";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "updater";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getName";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFamilyName";
                    break;
                }
                case 2: 
                case 3: 
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/siyeh/ig/bugs/ArrayHashCodeInspection$ArrayHashCodeFix";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 2: 
                case 3: 
                case 4: {
                    objectArray = objectArray;
                    objectArray[2] = "applyFix";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalStateException(string);
                case 2, 3, 4 -> new IllegalArgumentException(string);
            };
        }
    }

    private static class ObjectsHashFix
    extends PsiUpdateModCommandQuickFix {
        private final boolean deepHashCode;

        ObjectsHashFix(boolean deepHashCode) {
            this.deepHashCode = deepHashCode;
        }

        @NotNull
        public String getName() {
            String string = InspectionGadgetsBundle.message("wrap.with.arrays.hash.code.quickfix", this.deepHashCode ? "Arrays.deepHashCode()" : "Arrays.hashCode()");
            if (string == null) {
                ObjectsHashFix.$$$reportNull$$$0(0);
            }
            return string;
        }

        @NotNull
        public String getFamilyName() {
            String string = InspectionGadgetsBundle.message("objects.hash.fix.family.name", new Object[0]);
            if (string == null) {
                ObjectsHashFix.$$$reportNull$$$0(1);
            }
            return string;
        }

        protected void applyFix(@NotNull Project project, @NotNull PsiElement element, @NotNull ModPsiUpdater updater) {
            if (project == null) {
                ObjectsHashFix.$$$reportNull$$$0(2);
            }
            if (element == null) {
                ObjectsHashFix.$$$reportNull$$$0(3);
            }
            if (updater == null) {
                ObjectsHashFix.$$$reportNull$$$0(4);
            }
            CommentTracker tracker = new CommentTracker();
            String text = (this.deepHashCode ? "java.util.Arrays.deepHashCode(" : "java.util.Arrays.hashCode(") + tracker.text(element) + ")";
            PsiElement result = tracker.replaceAndRestoreComments(element, text);
            JavaCodeStyleManager.getInstance((Project)result.getProject()).shortenClassReferences(result);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 2;
                case 2, 3, 4 -> 3;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/siyeh/ig/bugs/ArrayHashCodeInspection$ObjectsHashFix";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "element";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "updater";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getName";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFamilyName";
                    break;
                }
                case 2: 
                case 3: 
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/siyeh/ig/bugs/ArrayHashCodeInspection$ObjectsHashFix";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 2: 
                case 3: 
                case 4: {
                    objectArray = objectArray;
                    objectArray[2] = "applyFix";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalStateException(string);
                case 2, 3, 4 -> new IllegalArgumentException(string);
            };
        }
    }

    private static class ArrayHashCodeVisitor
    extends BaseInspectionVisitor {
        private ArrayHashCodeVisitor() {
        }

        public void visitMethodCallExpression(@NotNull PsiMethodCallExpression expression) {
            if (expression == null) {
                ArrayHashCodeVisitor.$$$reportNull$$$0(0);
            }
            super.visitMethodCallExpression(expression);
            PsiReferenceExpression methodExpression = expression.getMethodExpression();
            String methodName = methodExpression.getReferenceName();
            PsiExpressionList argumentList = expression.getArgumentList();
            if ("hashCode".equals(methodName)) {
                if (!argumentList.isEmpty()) {
                    return;
                }
                PsiExpression qualifier = methodExpression.getQualifierExpression();
                if (qualifier == null) {
                    return;
                }
                PsiType type = qualifier.getType();
                if (!(type instanceof PsiArrayType)) {
                    return;
                }
                this.registerMethodCallError(expression, new Object[]{type, Kind.ARRAY_HASH_CODE});
            } else if ("hash".equals(methodName)) {
                PsiExpression[] expressions;
                if (argumentList.getExpressionCount() == 1) {
                    return;
                }
                PsiMethod method = expression.resolveMethod();
                if (method == null) {
                    return;
                }
                PsiClass containingClass = method.getContainingClass();
                if (containingClass == null || !"java.util.Objects".equals(containingClass.getQualifiedName())) {
                    return;
                }
                for (PsiExpression arg : expressions = argumentList.getExpressions()) {
                    PsiType type = arg.getType();
                    if (!(type instanceof PsiArrayType)) continue;
                    this.registerError((PsiElement)arg, new Object[]{type, Kind.OBJECTS_HASH});
                }
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "com/siyeh/ig/bugs/ArrayHashCodeInspection$ArrayHashCodeVisitor", "visitMethodCallExpression"));
        }
    }
}

