/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.bugs;

import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.modcommand.ModPsiUpdater;
import com.intellij.modcommand.PsiUpdateModCommandQuickFix;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.pom.java.JavaFeature;
import com.intellij.psi.JavaDocTokenType;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiAnonymousClass;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.codeStyle.CodeStyleManager;
import com.intellij.psi.javadoc.PsiDocComment;
import com.intellij.psi.javadoc.PsiDocToken;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.MethodSignatureUtil;
import com.intellij.psi.util.PsiUtil;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.psiutils.ClassUtils;
import java.util.Arrays;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public final class ComparableImplementedButEqualsNotOverriddenInspection
extends BaseInspection {
    @Override
    @NotNull
    protected String buildErrorString(Object ... infos) {
        String string = InspectionGadgetsBundle.message("comparable.implemented.but.equals.not.overridden.problem.descriptor", new Object[0]);
        if (string == null) {
            ComparableImplementedButEqualsNotOverriddenInspection.$$$reportNull$$$0(0);
        }
        return string;
    }

    @Override
    protected LocalQuickFix @NotNull [] buildFixes(Object ... infos) {
        if (infos[0] instanceof PsiAnonymousClass) {
            LocalQuickFix[] localQuickFixArray = new LocalQuickFix[]{new GenerateEqualsMethodFix()};
            if (localQuickFixArray == null) {
                ComparableImplementedButEqualsNotOverriddenInspection.$$$reportNull$$$0(1);
            }
            return localQuickFixArray;
        }
        LocalQuickFix[] localQuickFixArray = new LocalQuickFix[]{new GenerateEqualsMethodFix(), new AddNoteFix()};
        if (localQuickFixArray == null) {
            ComparableImplementedButEqualsNotOverriddenInspection.$$$reportNull$$$0(2);
        }
        return localQuickFixArray;
    }

    @Override
    @NotNull
    public BaseInspectionVisitor buildVisitor() {
        return new CompareToAndEqualsNotPairedVisitor();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[2];
        objectArray2[0] = "com/siyeh/ig/bugs/ComparableImplementedButEqualsNotOverriddenInspection";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "buildErrorString";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "buildFixes";
                break;
            }
        }
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
    }

    private static class GenerateEqualsMethodFix
    extends PsiUpdateModCommandQuickFix {
        private GenerateEqualsMethodFix() {
        }

        @Nls
        @NotNull
        public String getFamilyName() {
            String string = InspectionGadgetsBundle.message("comparable.implemented.but.equals.not.overridden.fix.generate.equals.name", new Object[0]);
            if (string == null) {
                GenerateEqualsMethodFix.$$$reportNull$$$0(0);
            }
            return string;
        }

        protected void applyFix(@NotNull Project project, @NotNull PsiElement startElement, @NotNull ModPsiUpdater updater) {
            if (project == null) {
                GenerateEqualsMethodFix.$$$reportNull$$$0(1);
            }
            if (startElement == null) {
                GenerateEqualsMethodFix.$$$reportNull$$$0(2);
            }
            if (updater == null) {
                GenerateEqualsMethodFix.$$$reportNull$$$0(3);
            }
            PsiClass aClass = (PsiClass)startElement.getParent();
            @NonNls StringBuilder methodText = new StringBuilder();
            if (PsiUtil.isAvailable((JavaFeature)JavaFeature.ANNOTATIONS, (PsiElement)aClass)) {
                methodText.append("@java.lang.Override ");
            }
            methodText.append("public ");
            methodText.append("boolean equals(Object o) {\n");
            methodText.append("return o instanceof ").append(aClass.getName());
            methodText.append("&& compareTo((").append(aClass.getName()).append(")o) == 0;\n");
            methodText.append("}");
            PsiMethod method = JavaPsiFacade.getElementFactory((Project)project).createMethodFromText(methodText.toString(), (PsiElement)aClass, PsiUtil.getLanguageLevel((PsiElement)aClass));
            PsiElement newMethod = aClass.add((PsiElement)method);
            CodeStyleManager.getInstance((Project)project).reformat(newMethod);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 2;
                case 1, 2, 3 -> 3;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/siyeh/ig/bugs/ComparableImplementedButEqualsNotOverriddenInspection$GenerateEqualsMethodFix";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "startElement";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "updater";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFamilyName";
                    break;
                }
                case 1: 
                case 2: 
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/siyeh/ig/bugs/ComparableImplementedButEqualsNotOverriddenInspection$GenerateEqualsMethodFix";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 1: 
                case 2: 
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "applyFix";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalStateException(string);
                case 1, 2, 3 -> new IllegalArgumentException(string);
            };
        }
    }

    private static class AddNoteFix
    extends PsiUpdateModCommandQuickFix {
        private static final Pattern PARAM_PATTERN = Pattern.compile("\\*[ \t]+@");
        @NonNls
        private static final String NOTE = " * Note: this class has a natural ordering that is inconsistent with equals.\n";

        private AddNoteFix() {
        }

        @Nls
        @NotNull
        public String getFamilyName() {
            String string = InspectionGadgetsBundle.message("comparable.implemented.but.equals.not.overridden.fix.add.note.name", new Object[0]);
            if (string == null) {
                AddNoteFix.$$$reportNull$$$0(0);
            }
            return string;
        }

        protected void applyFix(@NotNull Project project, @NotNull PsiElement startElement, @NotNull ModPsiUpdater updater) {
            PsiClass aClass;
            PsiDocComment comment;
            if (project == null) {
                AddNoteFix.$$$reportNull$$$0(1);
            }
            if (startElement == null) {
                AddNoteFix.$$$reportNull$$$0(2);
            }
            if (updater == null) {
                AddNoteFix.$$$reportNull$$$0(3);
            }
            if ((comment = (aClass = (PsiClass)startElement.getParent()).getDocComment()) == null) {
                PsiDocComment newComment = JavaPsiFacade.getElementFactory((Project)project).createDocCommentFromText("/**\n * Note: this class has a natural ordering that is inconsistent with equals.\n*/", (PsiElement)aClass);
                aClass.addBefore((PsiElement)newComment, aClass.getFirstChild());
            } else {
                String text = comment.getText();
                Matcher matcher = PARAM_PATTERN.matcher(text);
                String newCommentText = matcher.find() ? text.substring(0, matcher.start()) + NOTE + text.substring(matcher.start()) : text.substring(0, text.length() - 2) + " * Note: this class has a natural ordering that is inconsistent with equals.\n*/";
                PsiDocComment newComment = JavaPsiFacade.getElementFactory((Project)project).createDocCommentFromText(newCommentText);
                comment.replace((PsiElement)newComment);
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 2;
                case 1, 2, 3 -> 3;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/siyeh/ig/bugs/ComparableImplementedButEqualsNotOverriddenInspection$AddNoteFix";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "startElement";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "updater";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFamilyName";
                    break;
                }
                case 1: 
                case 2: 
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/siyeh/ig/bugs/ComparableImplementedButEqualsNotOverriddenInspection$AddNoteFix";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 1: 
                case 2: 
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "applyFix";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalStateException(string);
                case 1, 2, 3 -> new IllegalArgumentException(string);
            };
        }
    }

    private static class CompareToAndEqualsNotPairedVisitor
    extends BaseInspectionVisitor {
        private CompareToAndEqualsNotPairedVisitor() {
        }

        public void visitClass(@NotNull PsiClass aClass) {
            if (aClass == null) {
                CompareToAndEqualsNotPairedVisitor.$$$reportNull$$$0(0);
            }
            super.visitClass(aClass);
            if (aClass.isInterface() || aClass.isRecord() || aClass.isEnum()) {
                return;
            }
            PsiClass comparableClass = JavaPsiFacade.getInstance((Project)aClass.getProject()).findClass("java.lang.Comparable", aClass.getResolveScope());
            if (comparableClass == null || !aClass.isInheritor(comparableClass, true)) {
                return;
            }
            PsiMethod[] comparableMethods = comparableClass.findMethodsByName("compareTo", false);
            if (comparableMethods.length == 0) {
                return;
            }
            PsiMethod comparableMethod = MethodSignatureUtil.findMethodBySuperMethod((PsiClass)aClass, (PsiMethod)comparableMethods[0], (boolean)false);
            if (comparableMethod == null || comparableMethod.hasModifierProperty("abstract") || comparableMethod.getBody() == null) {
                return;
            }
            PsiClass objectClass = ClassUtils.findObjectClass((PsiElement)aClass);
            if (objectClass == null) {
                return;
            }
            PsiMethod[] equalsMethods = objectClass.findMethodsByName("equals", false);
            if (equalsMethods.length != 1) {
                return;
            }
            PsiMethod equalsMethod = MethodSignatureUtil.findMethodBySuperMethod((PsiClass)aClass, (PsiMethod)equalsMethods[0], (boolean)false);
            if (equalsMethod != null && !equalsMethod.hasModifierProperty("abstract")) {
                return;
            }
            String docCommentText = StringUtil.collapseWhiteSpace((CharSequence)CompareToAndEqualsNotPairedVisitor.getActualCommentText(aClass.getDocComment()));
            if (StringUtil.containsIgnoreCase((String)docCommentText, (String)"this class has a natural ordering that is inconsistent with equals")) {
                return;
            }
            this.registerClassError(aClass, aClass);
        }

        private static String getActualCommentText(PsiDocComment comment) {
            if (comment == null) {
                return "";
            }
            return Arrays.stream(comment.getChildren()).filter(e -> PsiDocToken.isDocToken((PsiElement)e, (IElementType)JavaDocTokenType.DOC_COMMENT_DATA)).map(PsiElement::getText).collect(Collectors.joining());
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "aClass", "com/siyeh/ig/bugs/ComparableImplementedButEqualsNotOverriddenInspection$CompareToAndEqualsNotPairedVisitor", "visitClass"));
        }
    }
}

