/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.bugs;

import com.intellij.pom.java.JavaFeature;
import com.intellij.psi.PsiAssertStatement;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.util.PsiUtil;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.psiutils.BoolUtils;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

public final class ConstantAssertConditionInspection
extends BaseInspection {
    @Override
    @NotNull
    protected String buildErrorString(Object ... infos) {
        String string = InspectionGadgetsBundle.message("constant.assert.condition.problem.descriptor", new Object[0]);
        if (string == null) {
            ConstantAssertConditionInspection.$$$reportNull$$$0(0);
        }
        return string;
    }

    @NotNull
    public @NotNull Set<@NotNull JavaFeature> requiredFeatures() {
        Set<JavaFeature> set = Set.of(JavaFeature.ASSERTIONS);
        if (set == null) {
            ConstantAssertConditionInspection.$$$reportNull$$$0(1);
        }
        return set;
    }

    @Override
    @NotNull
    public BaseInspectionVisitor buildVisitor() {
        return new ConstantAssertConditionVisitor();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[2];
        objectArray2[0] = "com/siyeh/ig/bugs/ConstantAssertConditionInspection";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "buildErrorString";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "requiredFeatures";
                break;
            }
        }
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
    }

    private static class ConstantAssertConditionVisitor
    extends BaseInspectionVisitor {
        private ConstantAssertConditionVisitor() {
        }

        public void visitAssertStatement(@NotNull PsiAssertStatement statement) {
            if (statement == null) {
                ConstantAssertConditionVisitor.$$$reportNull$$$0(0);
            }
            super.visitAssertStatement(statement);
            PsiExpression assertCondition = statement.getAssertCondition();
            PsiExpression expression = PsiUtil.skipParenthesizedExprDown((PsiExpression)assertCondition);
            if (expression == null) {
                return;
            }
            if (BoolUtils.isFalse(expression)) {
                return;
            }
            if (!PsiUtil.isConstantExpression((PsiExpression)expression)) {
                return;
            }
            this.registerError((PsiElement)expression, new Object[0]);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "statement", "com/siyeh/ig/bugs/ConstantAssertConditionInspection$ConstantAssertConditionVisitor", "visitAssertStatement"));
        }
    }
}

