/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.bugs;

import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.modcommand.ModPsiUpdater;
import com.intellij.modcommand.PsiUpdateModCommandQuickFix;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiClassInitializer;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiElement;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.psiutils.ControlFlowUtils;
import org.jetbrains.annotations.NotNull;

public final class EmptyInitializerInspection
extends BaseInspection {
    @NotNull
    public String getID() {
        return "EmptyClassInitializer";
    }

    @Override
    @NotNull
    public String buildErrorString(Object ... infos) {
        String string = InspectionGadgetsBundle.message("empty.class.initializer.problem.descriptor", new Object[0]);
        if (string == null) {
            EmptyInitializerInspection.$$$reportNull$$$0(0);
        }
        return string;
    }

    @Override
    protected LocalQuickFix buildFix(Object ... infos) {
        return new EmptyInitializerFix();
    }

    @Override
    @NotNull
    public BaseInspectionVisitor buildVisitor() {
        return new EmptyInitializerVisitor();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/bugs/EmptyInitializerInspection", "buildErrorString"));
    }

    private static class EmptyInitializerFix
    extends PsiUpdateModCommandQuickFix {
        private EmptyInitializerFix() {
        }

        @NotNull
        public String getFamilyName() {
            String string = InspectionGadgetsBundle.message("empty.class.initializer.delete.quickfix", new Object[0]);
            if (string == null) {
                EmptyInitializerFix.$$$reportNull$$$0(0);
            }
            return string;
        }

        protected void applyFix(@NotNull Project project, @NotNull PsiElement element, @NotNull ModPsiUpdater updater) {
            PsiElement codeBlock;
            if (project == null) {
                EmptyInitializerFix.$$$reportNull$$$0(1);
            }
            if (element == null) {
                EmptyInitializerFix.$$$reportNull$$$0(2);
            }
            if (updater == null) {
                EmptyInitializerFix.$$$reportNull$$$0(3);
            }
            if (!((codeBlock = element.getParent()) instanceof PsiCodeBlock)) {
                return;
            }
            PsiElement classInitializer = codeBlock.getParent();
            if (!(classInitializer instanceof PsiClassInitializer)) {
                return;
            }
            classInitializer.delete();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 2;
                case 1, 2, 3 -> 3;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/siyeh/ig/bugs/EmptyInitializerInspection$EmptyInitializerFix";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "element";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "updater";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFamilyName";
                    break;
                }
                case 1: 
                case 2: 
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/siyeh/ig/bugs/EmptyInitializerInspection$EmptyInitializerFix";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 1: 
                case 2: 
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "applyFix";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalStateException(string);
                case 1, 2, 3 -> new IllegalArgumentException(string);
            };
        }
    }

    private static class EmptyInitializerVisitor
    extends BaseInspectionVisitor {
        private EmptyInitializerVisitor() {
        }

        public void visitClassInitializer(@NotNull PsiClassInitializer initializer) {
            if (initializer == null) {
                EmptyInitializerVisitor.$$$reportNull$$$0(0);
            }
            super.visitClassInitializer(initializer);
            PsiCodeBlock body = initializer.getBody();
            if (!ControlFlowUtils.isEmptyCodeBlock(body)) {
                return;
            }
            this.registerClassInitializerError(initializer, new Object[0]);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "initializer", "com/siyeh/ig/bugs/EmptyInitializerInspection$EmptyInitializerVisitor", "visitClassInitializer"));
        }
    }
}

