/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.bugs;

import com.intellij.codeInsight.Nullability;
import com.intellij.codeInsight.NullableNotNullManager;
import com.intellij.codeInsight.intention.FileModifier;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.dataFlow.NullabilityUtil;
import com.intellij.modcommand.ModPsiUpdater;
import com.intellij.modcommand.PsiUpdateModCommandQuickFix;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.pom.java.LanguageLevel;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiType;
import com.intellij.psi.codeStyle.CodeStyleManager;
import com.intellij.psi.util.PsiUtil;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.bugs.BaseEqualsVisitor;
import com.siyeh.ig.psiutils.CommentTracker;
import com.siyeh.ig.psiutils.ParenthesesUtils;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class EqualsOnSuspiciousObjectInspection
extends BaseInspection {
    private final Map<String, ReplaceInfo> myClasses = Map.ofEntries(Map.entry("java.lang.StringBuilder", ReplaceInfo.stringBuilders()), Map.entry("java.lang.StringBuffer", ReplaceInfo.stringBuilders()), Map.entry("java.util.concurrent.atomic.AtomicBoolean", ReplaceInfo.available(false, "get")), Map.entry("java.util.concurrent.atomic.AtomicInteger", ReplaceInfo.available(false, "get")), Map.entry("java.util.concurrent.atomic.AtomicIntegerArray", ReplaceInfo.notAvailable()), Map.entry("java.util.concurrent.atomic.AtomicLong", ReplaceInfo.available(false, "get")), Map.entry("java.util.concurrent.atomic.AtomicLongArray", ReplaceInfo.notAvailable()), Map.entry("java.util.concurrent.atomic.AtomicReference", ReplaceInfo.notAvailable()), Map.entry("java.util.concurrent.atomic.DoubleAccumulator", ReplaceInfo.notAvailable()), Map.entry("java.util.concurrent.atomic.DoubleAdder", ReplaceInfo.notAvailable()), Map.entry("java.util.concurrent.atomic.LongAccumulator", ReplaceInfo.notAvailable()), Map.entry("java.util.concurrent.atomic.LongAdder", ReplaceInfo.notAvailable()));

    @Override
    @NotNull
    protected String buildErrorString(Object ... infos) {
        String typeName = (String)infos[0];
        String string = InspectionGadgetsBundle.message("equals.called.on.suspicious.object.problem.descriptor", StringUtil.getShortName((String)typeName));
        if (string == null) {
            EqualsOnSuspiciousObjectInspection.$$$reportNull$$$0(0);
        }
        return string;
    }

    @Override
    @Nullable
    protected LocalQuickFix buildFix(Object ... infos) {
        PsiReferenceExpression expression = (PsiReferenceExpression)infos[1];
        PsiExpression qualifierExpression = expression.getQualifierExpression();
        if (qualifierExpression == null) {
            return null;
        }
        PsiType qualifierType = qualifierExpression.getType();
        PsiElement parent = expression.getParent();
        if (!(parent instanceof PsiMethodCallExpression)) {
            return null;
        }
        PsiMethodCallExpression callExpression = (PsiMethodCallExpression)parent;
        if (!BaseEqualsVisitor.OBJECT_EQUALS.matches((PsiExpression)callExpression)) {
            return null;
        }
        PsiExpression[] arguments = callExpression.getArgumentList().getExpressions();
        if (arguments.length != 1) {
            return null;
        }
        PsiExpression argument = arguments[0];
        if (argument == null) {
            return null;
        }
        PsiType argumentType = argument.getType();
        if (argumentType == null || !argumentType.equals(qualifierType)) {
            return null;
        }
        PsiClass psiClass = PsiUtil.resolveClassInClassTypeOnly((PsiType)argumentType);
        if (psiClass == null) {
            return null;
        }
        String qualifiedName = psiClass.getQualifiedName();
        if (qualifiedName == null) {
            return null;
        }
        ReplaceInfo info = this.myClasses.get(qualifiedName);
        if (info == null || info instanceof ReplaceInfo.NotAvailableReplaceInfo) {
            return null;
        }
        return new EqualsOnSuspiciousObjectFix(info);
    }

    @Override
    @NotNull
    public BaseInspectionVisitor buildVisitor() {
        return new BaseEqualsVisitor(){

            @Override
            boolean checkTypes(@NotNull PsiReferenceExpression expression, @NotNull PsiType type1, @NotNull PsiType type2) {
                if (expression == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (type1 == null) {
                    1.$$$reportNull$$$0(1);
                }
                if (type2 == null) {
                    1.$$$reportNull$$$0(2);
                }
                if (this.checkType(expression, type1)) {
                    return true;
                }
                return this.checkType(expression, type2);
            }

            private boolean checkType(PsiReferenceExpression expression, PsiType type) {
                String qualifiedName;
                PsiClass psiClass = PsiUtil.resolveClassInClassTypeOnly((PsiType)type);
                if (psiClass != null && (qualifiedName = psiClass.getQualifiedName()) != null && EqualsOnSuspiciousObjectInspection.this.myClasses.containsKey(qualifiedName)) {
                    PsiElement name = expression.getReferenceNameElement();
                    this.registerError((PsiElement)(name == null ? expression : name), qualifiedName, expression);
                    return true;
                }
                return false;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[0] = "expression";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[0] = "type1";
                        break;
                    }
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[0] = "type2";
                        break;
                    }
                }
                objectArray[1] = "com/siyeh/ig/bugs/EqualsOnSuspiciousObjectInspection$1";
                objectArray[2] = "checkTypes";
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        };
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/bugs/EqualsOnSuspiciousObjectInspection", "buildErrorString"));
    }

    private static sealed interface ReplaceInfo {
        public static final ReplaceInfo NOT_AVAILABLE = new NotAvailableReplaceInfo();

        public String valueMethod();

        private static ReplaceInfo notAvailable() {
            return NOT_AVAILABLE;
        }

        private static SimpleReplaceInfo available(boolean isObjects, @NotNull String valueMethod) {
            if (valueMethod == null) {
                ReplaceInfo.$$$reportNull$$$0(0);
            }
            return new SimpleReplaceInfo(isObjects, valueMethod);
        }

        public static ReplaceInfo stringBuilders() {
            return new ComplexReplaceInfo(){
                private static final String COMPARE_TO = "compareTo";
                private static final SimpleReplaceInfo fallback = ReplaceInfo.available(true, "toString");

                @Override
                public String valueMethod() {
                    return fallback.valueMethod();
                }

                private static boolean isApplicable(PsiElement psiElement) {
                    return PsiUtil.getLanguageLevel((PsiElement)psiElement).isAtLeast(LanguageLevel.JDK_11);
                }

                @Override
                public void fill(@NotNull PsiExpression argument, @NotNull PsiExpression qualifier, @NotNull StringBuilder builder, @NotNull CommentTracker ct) {
                    if (argument == null) {
                        1.$$$reportNull$$$0(0);
                    }
                    if (qualifier == null) {
                        1.$$$reportNull$$$0(1);
                    }
                    if (builder == null) {
                        1.$$$reportNull$$$0(2);
                    }
                    if (ct == null) {
                        1.$$$reportNull$$$0(3);
                    }
                    if (!1.isApplicable((PsiElement)argument)) {
                        EqualsOnSuspiciousObjectFix.fillSimple(fallback, argument, qualifier, builder, ct);
                        return;
                    }
                    builder.append(ct.text(qualifier, 1)).append(".").append(COMPARE_TO).append("(").append(ct.text((PsiElement)argument)).append(")").append(" == 0");
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    Object[] objectArray;
                    Object[] objectArray2 = new Object[3];
                    switch (n) {
                        default: {
                            objectArray = objectArray2;
                            objectArray2[0] = "argument";
                            break;
                        }
                        case 1: {
                            objectArray = objectArray2;
                            objectArray2[0] = "qualifier";
                            break;
                        }
                        case 2: {
                            objectArray = objectArray2;
                            objectArray2[0] = "builder";
                            break;
                        }
                        case 3: {
                            objectArray = objectArray2;
                            objectArray2[0] = "ct";
                            break;
                        }
                    }
                    objectArray[1] = "com/siyeh/ig/bugs/EqualsOnSuspiciousObjectInspection$ReplaceInfo$1";
                    objectArray[2] = "fill";
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
                }
            };
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "valueMethod", "com/siyeh/ig/bugs/EqualsOnSuspiciousObjectInspection$ReplaceInfo", "available"));
        }

        public record SimpleReplaceInfo(boolean isObjects, @NotNull String valueMethod) implements ReplaceInfo
        {
            @NotNull
            private final String valueMethod;

            public SimpleReplaceInfo(boolean isObjects, @NotNull String valueMethod) {
                if (valueMethod == null) {
                    SimpleReplaceInfo.$$$reportNull$$$0(0);
                }
            }

            @Override
            @NotNull
            public String valueMethod() {
                String string = this.valueMethod;
                if (string == null) {
                    SimpleReplaceInfo.$$$reportNull$$$0(1);
                }
                return string;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[switch (n) {
                    default -> 3;
                    case 1 -> 2;
                }];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "valueMethod";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "com/siyeh/ig/bugs/EqualsOnSuspiciousObjectInspection$ReplaceInfo$SimpleReplaceInfo";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "com/siyeh/ig/bugs/EqualsOnSuspiciousObjectInspection$ReplaceInfo$SimpleReplaceInfo";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[1] = "valueMethod";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray;
                        objectArray[2] = "<init>";
                        break;
                    }
                    case 1: {
                        break;
                    }
                }
                String string = String.format(v0, objectArray);
                throw switch (n) {
                    default -> new IllegalArgumentException(string);
                    case 1 -> new IllegalStateException(string);
                };
            }
        }

        public static final class NotAvailableReplaceInfo
        implements ReplaceInfo {
            @Override
            public String valueMethod() {
                return "";
            }
        }

        public static non-sealed interface ComplexReplaceInfo
        extends ReplaceInfo {
            public void fill(@NotNull PsiExpression var1, @NotNull PsiExpression var2, @NotNull StringBuilder var3, @NotNull CommentTracker var4);
        }
    }

    private static class EqualsOnSuspiciousObjectFix
    extends PsiUpdateModCommandQuickFix {
        @FileModifier.SafeFieldForPreview
        private final ReplaceInfo myInfo;

        private EqualsOnSuspiciousObjectFix(ReplaceInfo info) {
            this.myInfo = info;
        }

        @NotNull
        public String getName() {
            String string = InspectionGadgetsBundle.message("equals.called.on.suspicious.object.fix.name", this.myInfo.valueMethod());
            if (string == null) {
                EqualsOnSuspiciousObjectFix.$$$reportNull$$$0(0);
            }
            return string;
        }

        @NotNull
        public String getFamilyName() {
            String string = InspectionGadgetsBundle.message("equals.called.on.suspicious.object.fix.family.name", new Object[0]);
            if (string == null) {
                EqualsOnSuspiciousObjectFix.$$$reportNull$$$0(1);
            }
            return string;
        }

        protected void applyFix(@NotNull Project project, @NotNull PsiElement psiElement, @NotNull ModPsiUpdater updater) {
            if (project == null) {
                EqualsOnSuspiciousObjectFix.$$$reportNull$$$0(2);
            }
            if (psiElement == null) {
                EqualsOnSuspiciousObjectFix.$$$reportNull$$$0(3);
            }
            if (updater == null) {
                EqualsOnSuspiciousObjectFix.$$$reportNull$$$0(4);
            }
            if (this.myInfo instanceof ReplaceInfo.NotAvailableReplaceInfo) {
                return;
            }
            PsiElement psiElement2 = psiElement.getParent();
            if (!(psiElement2 instanceof PsiReferenceExpression)) {
                return;
            }
            PsiReferenceExpression referenceExpression = (PsiReferenceExpression)psiElement2;
            PsiElement parent = referenceExpression.getParent();
            if (!(parent instanceof PsiMethodCallExpression)) {
                return;
            }
            PsiMethodCallExpression callExpression = (PsiMethodCallExpression)parent;
            PsiExpression qualifierExpression = referenceExpression.getQualifierExpression();
            if (qualifierExpression == null) {
                return;
            }
            PsiExpression[] expressions = callExpression.getArgumentList().getExpressions();
            if (expressions.length != 1) {
                return;
            }
            PsiExpression argument = expressions[0];
            if (argument == null) {
                return;
            }
            StringBuilder builder = new StringBuilder();
            CommentTracker ct = new CommentTracker();
            ReplaceInfo replaceInfo = this.myInfo;
            if (replaceInfo instanceof ReplaceInfo.SimpleReplaceInfo) {
                ReplaceInfo.SimpleReplaceInfo simpleReplaceInfo = (ReplaceInfo.SimpleReplaceInfo)replaceInfo;
                EqualsOnSuspiciousObjectFix.fillSimple(simpleReplaceInfo, argument, qualifierExpression, builder, ct);
            }
            if ((replaceInfo = this.myInfo) instanceof ReplaceInfo.ComplexReplaceInfo) {
                ReplaceInfo.ComplexReplaceInfo complexReplaceInfo = (ReplaceInfo.ComplexReplaceInfo)replaceInfo;
                complexReplaceInfo.fill(argument, qualifierExpression, builder, ct);
            }
            if (builder.isEmpty()) {
                return;
            }
            PsiElementFactory factory = JavaPsiFacade.getElementFactory((Project)project);
            PsiExpression newExpression = factory.createExpressionFromText(builder.toString(), (PsiElement)callExpression);
            PsiElement callParent = callExpression.getParent();
            if (callParent instanceof PsiExpression && ParenthesesUtils.areParenthesesNeeded(newExpression, (PsiExpression)callParent, true)) {
                newExpression = factory.createExpressionFromText("(" + newExpression.getText() + ")", (PsiElement)callExpression);
            }
            PsiElement replaced = ct.replaceAndRestoreComments((PsiElement)callExpression, (PsiElement)newExpression);
            CodeStyleManager styleManager = CodeStyleManager.getInstance((Project)project);
            styleManager.reformat(replaced);
        }

        private static void fillSimple(@NotNull ReplaceInfo.SimpleReplaceInfo replaceInfo, @NotNull PsiExpression argument, @NotNull PsiExpression qualifierExpression, @NotNull StringBuilder builder, @NotNull CommentTracker ct) {
            boolean argumentIsNullable;
            if (replaceInfo == null) {
                EqualsOnSuspiciousObjectFix.$$$reportNull$$$0(5);
            }
            if (argument == null) {
                EqualsOnSuspiciousObjectFix.$$$reportNull$$$0(6);
            }
            if (qualifierExpression == null) {
                EqualsOnSuspiciousObjectFix.$$$reportNull$$$0(7);
            }
            if (builder == null) {
                EqualsOnSuspiciousObjectFix.$$$reportNull$$$0(8);
            }
            if (ct == null) {
                EqualsOnSuspiciousObjectFix.$$$reportNull$$$0(9);
            }
            if (argumentIsNullable = EqualsOnSuspiciousObjectFix.isNullable(argument)) {
                builder.append(ct.text(argument, 9)).append("!=null &&");
            }
            String qualifierText = ct.text(qualifierExpression, 1) + "." + replaceInfo.valueMethod + "()";
            String argumentText = ct.text(argument, 1) + "." + replaceInfo.valueMethod + "()";
            if (replaceInfo.isObjects) {
                builder.append(qualifierText).append(".equals(").append(argumentText).append(")");
            } else {
                builder.append(qualifierText).append("==").append(argumentText);
            }
        }

        private static boolean isNullable(@NotNull PsiExpression argument) {
            PsiReferenceExpression referenceExpression;
            PsiElement target;
            Nullability nullability;
            if (argument == null) {
                EqualsOnSuspiciousObjectFix.$$$reportNull$$$0(10);
            }
            if ((nullability = NullabilityUtil.getExpressionNullability(argument, true)) == Nullability.NULLABLE) {
                return true;
            }
            return argument instanceof PsiReferenceExpression && (target = (referenceExpression = (PsiReferenceExpression)argument).resolve()) instanceof PsiModifierListOwner && NullableNotNullManager.isNullable((PsiModifierListOwner)((PsiModifierListOwner)target));
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 2;
                case 2, 3, 4, 5, 6, 7, 8, 9, 10 -> 3;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/siyeh/ig/bugs/EqualsOnSuspiciousObjectInspection$EqualsOnSuspiciousObjectFix";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "psiElement";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "updater";
                    break;
                }
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "replaceInfo";
                    break;
                }
                case 6: 
                case 10: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "argument";
                    break;
                }
                case 7: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "qualifierExpression";
                    break;
                }
                case 8: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "builder";
                    break;
                }
                case 9: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "ct";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getName";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFamilyName";
                    break;
                }
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: 
                case 8: 
                case 9: 
                case 10: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/siyeh/ig/bugs/EqualsOnSuspiciousObjectInspection$EqualsOnSuspiciousObjectFix";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 2: 
                case 3: 
                case 4: {
                    objectArray = objectArray;
                    objectArray[2] = "applyFix";
                    break;
                }
                case 5: 
                case 6: 
                case 7: 
                case 8: 
                case 9: {
                    objectArray = objectArray;
                    objectArray[2] = "fillSimple";
                    break;
                }
                case 10: {
                    objectArray = objectArray;
                    objectArray[2] = "isNullable";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalStateException(string);
                case 2, 3, 4, 5, 6, 7, 8, 9, 10 -> new IllegalArgumentException(string);
            };
        }
    }
}

