/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.bugs;

import com.intellij.codeInspection.InspectionProfileEntry;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.UpdateInspectionOptionFix;
import com.intellij.codeInspection.options.OptPane;
import com.intellij.codeInspection.options.OptRegularComponent;
import com.intellij.modcommand.ModCommandAction;
import com.intellij.openapi.util.text.HtmlChunk;
import com.intellij.psi.PsiArrayType;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionList;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiType;
import com.intellij.psi.util.PsiUtil;
import com.intellij.psi.util.TypeConversionUtil;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.callMatcher.CallMatcher;
import com.siyeh.ig.psiutils.EquivalenceChecker;
import com.siyeh.ig.psiutils.ExpressionUtils;
import com.siyeh.ig.psiutils.LibraryUtil;
import com.siyeh.ig.psiutils.SideEffectChecker;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class EqualsWithItselfInspection
extends BaseInspection {
    private static final CallMatcher.Simple COMPARATOR_COMPARE = CallMatcher.instanceCall("java.util.Comparator", "compare");
    private static final CallMatcher TWO_ARGUMENT_COMPARISON = CallMatcher.anyOf(CallMatcher.staticCall("java.util.Objects", "equals", "deepEquals"), COMPARATOR_COMPARE, CallMatcher.staticCall("java.util.Arrays", "equals", "deepEquals"), CallMatcher.staticCall("java.lang.Integer", "compare", "compareUnsigned"), CallMatcher.staticCall("java.lang.Long", "compare", "compareUnsigned"), CallMatcher.staticCall("java.lang.Short", "compare", "compareUnsigned"), CallMatcher.staticCall("java.lang.Byte", "compare", "compareUnsigned"), CallMatcher.staticCall("java.lang.Boolean", "compare"), CallMatcher.staticCall("java.lang.Character", "compare"), CallMatcher.staticCall("java.lang.Float", "compare"), CallMatcher.staticCall("java.lang.Double", "compare"));
    private static final CallMatcher ASSERT_ARGUMENT_COMPARISON = CallMatcher.anyOf(CallMatcher.staticCall("org.junit.Assert", "assertEquals", "assertArrayEquals", "assertIterableEquals", "assertLinesMatch", "assertNotEquals"), CallMatcher.staticCall("org.junit.jupiter.api.Assertions", "assertEquals", "assertArrayEquals", "assertIterableEquals", "assertLinesMatch", "assertNotEquals"), CallMatcher.staticCall("org.testng.Assert", "assertEquals", "assertEqualsDeep", "assertEqualsNoOrder", "assertNotEquals", "assertNotEqualsDeep"), CallMatcher.staticCall("org.testng.AssertJUnit", "assertEquals"), CallMatcher.staticCall("org.testng.internal.junit.ArrayAsserts", "assertArrayEquals"));
    private static final CallMatcher ASSERT_ARGUMENTS_THE_SAME = CallMatcher.anyOf(CallMatcher.staticCall("org.junit.Assert", "assertSame", "assertNotSame"), CallMatcher.staticCall("org.junit.jupiter.api.Assertions", "assertSame", "assertNotSame"), CallMatcher.staticCall("org.testng.Assert", "assertSame", "assertNotSame"), CallMatcher.staticCall("org.testng.AssertJUnit", "assertSame", "assertNotSame"));
    private static final CallMatcher ONE_ARGUMENT_COMPARISON = CallMatcher.anyOf(CallMatcher.instanceCall("java.lang.Object", "equals"), CallMatcher.instanceCall("java.lang.String", "equalsIgnoreCase", "compareToIgnoreCase"), CallMatcher.instanceCall("java.lang.Comparable", "compareTo"));
    private static final CallMatcher ASSERTJ_COMPARISON = CallMatcher.instanceCall("org.assertj.core.api.AbstractAssert", "isEqualTo", "isNotEqualTo").parameterCount(1);
    private static final CallMatcher ASSERTJ_THE_SAME = CallMatcher.instanceCall("org.assertj.core.api.AbstractAssert", "isSameAs", "isNotSameAs").parameterCount(1);
    private static final CallMatcher ASSERTJ_ASSERT_THAT = CallMatcher.staticCall("org.assertj.core.api.Assertions", "assertThat").parameterCount(1);
    private static final CallMatcher POSSIBLE_TO_SKIP_TEST_ASSERTIONS = CallMatcher.anyOf(ASSERT_ARGUMENT_COMPARISON, ASSERTJ_COMPARISON);
    public boolean ignoreNonFinalClassesInTest = false;

    @NotNull
    public OptPane getOptionsPane() {
        OptPane optPane = OptPane.pane((OptRegularComponent[])new OptRegularComponent[]{OptPane.checkbox((String)"ignoreNonFinalClassesInTest", (String)InspectionGadgetsBundle.message("equals.with.itself.option", new Object[0]), (OptRegularComponent[])new OptRegularComponent[0]).description(HtmlChunk.raw((String)InspectionGadgetsBundle.message("equals.with.itself.option.description", new Object[0])))});
        if (optPane == null) {
            EqualsWithItselfInspection.$$$reportNull$$$0(0);
        }
        return optPane;
    }

    @Override
    @NotNull
    protected String buildErrorString(Object ... infos) {
        String string = InspectionGadgetsBundle.message("equals.with.itself.problem.descriptor", new Object[0]);
        if (string == null) {
            EqualsWithItselfInspection.$$$reportNull$$$0(1);
        }
        return string;
    }

    @Override
    @NotNull
    public BaseInspectionVisitor buildVisitor() {
        return new EqualsWithItselfVisitor();
    }

    @Override
    @Nullable
    protected LocalQuickFix buildFix(Object ... infos) {
        Boolean canEnableOption = (Boolean)infos[0];
        return canEnableOption != false ? LocalQuickFix.from((ModCommandAction)new UpdateInspectionOptionFix((InspectionProfileEntry)this, "ignoreNonFinalClassesInTest", InspectionGadgetsBundle.message("equals.with.itself.option", new Object[0]), true)) : null;
    }

    public static boolean isEqualsWithItself(PsiMethodCallExpression expression) {
        PsiReferenceExpression methodExpression = expression.getMethodExpression();
        PsiExpressionList argumentList = expression.getArgumentList();
        int count = argumentList.getExpressionCount();
        if (count == 1) {
            PsiExpression qualifier = ExpressionUtils.getEffectiveQualifier(methodExpression);
            PsiExpression[] arguments = argumentList.getExpressions();
            if (arguments.length != 1) {
                return false;
            }
            PsiExpression argument = PsiUtil.skipParenthesizedExprDown((PsiExpression)arguments[0]);
            if (ONE_ARGUMENT_COMPARISON.test(expression)) {
                return EqualsWithItselfInspection.isItself(qualifier, argument);
            }
            if (ASSERTJ_COMPARISON.test(expression)) {
                return EqualsWithItselfInspection.isItself(EqualsWithItselfInspection.getAssertThatArgument((PsiExpression)expression), argument);
            }
            if (ASSERTJ_THE_SAME.test(expression)) {
                return EqualsWithItselfInspection.isTheSame(EqualsWithItselfInspection.getAssertThatArgument((PsiExpression)expression), argument);
            }
        } else if (count == 2 || count == 3) {
            PsiExpression[] arguments = argumentList.getExpressions();
            PsiExpression firstArgument = PsiUtil.skipParenthesizedExprDown((PsiExpression)arguments[0]);
            PsiExpression secondArgument = PsiUtil.skipParenthesizedExprDown((PsiExpression)arguments[1]);
            if (TWO_ARGUMENT_COMPARISON.test(expression) || ASSERT_ARGUMENT_COMPARISON.test(expression)) {
                return EqualsWithItselfInspection.isItself(firstArgument, secondArgument);
            }
            if (ASSERT_ARGUMENTS_THE_SAME.test(expression)) {
                return EqualsWithItselfInspection.isTheSame(firstArgument, secondArgument);
            }
        }
        return false;
    }

    @Nullable
    private static PsiExpression getAssertThatArgument(@Nullable PsiExpression expression) {
        while (expression instanceof PsiMethodCallExpression) {
            PsiMethodCallExpression callExpression = (PsiMethodCallExpression)expression;
            if (ASSERTJ_ASSERT_THAT.test(callExpression)) {
                return callExpression.getArgumentList().getExpressions()[0];
            }
            PsiReferenceExpression reference = callExpression.getMethodExpression();
            expression = reference.getQualifierExpression();
            expression = PsiUtil.skipParenthesizedExprDown((PsiExpression)expression);
        }
        return null;
    }

    private static boolean isTheSame(@Nullable PsiExpression left, @Nullable PsiExpression right) {
        return EqualsWithItselfInspection.isItself(left, right) && !ExpressionUtils.isNewObject(left);
    }

    private static boolean isItself(@Nullable PsiExpression left, @Nullable PsiExpression right) {
        return left != null && right != null && EquivalenceChecker.getCanonicalPsiEquivalence().expressionsAreEquivalent(left, right) && !SideEffectChecker.mayHaveSideEffects(left);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[2];
        objectArray2[0] = "com/siyeh/ig/bugs/EqualsWithItselfInspection";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getOptionsPane";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "buildErrorString";
                break;
            }
        }
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
    }

    private class EqualsWithItselfVisitor
    extends BaseInspectionVisitor {
        private EqualsWithItselfVisitor() {
        }

        public void visitMethodCallExpression(@NotNull PsiMethodCallExpression expression) {
            if (expression == null) {
                EqualsWithItselfVisitor.$$$reportNull$$$0(0);
            }
            super.visitMethodCallExpression(expression);
            if (EqualsWithItselfInspection.this.ignoreNonFinalClassesInTest && EqualsWithItselfVisitor.mayTestContract(expression)) {
                return;
            }
            if (EqualsWithItselfInspection.isEqualsWithItself(expression)) {
                this.registerMethodCallError(expression, !EqualsWithItselfInspection.this.ignoreNonFinalClassesInTest && EqualsWithItselfVisitor.mayTestContract(expression));
            }
        }

        private static boolean mayTestContract(@NotNull PsiMethodCallExpression expression) {
            PsiMethodCallExpression parent;
            PsiExpressionList list;
            PsiElement psiElement;
            if (expression == null) {
                EqualsWithItselfVisitor.$$$reportNull$$$0(1);
            }
            if (POSSIBLE_TO_SKIP_TEST_ASSERTIONS.test(expression) && !EqualsWithItselfVisitor.isFinalLibraryClassOrPrimitives(expression)) {
                return true;
            }
            return COMPARATOR_COMPARE.test(expression) && (psiElement = PsiUtil.skipParenthesizedExprUp((PsiElement)expression.getParent())) instanceof PsiExpressionList && (psiElement = (list = (PsiExpressionList)psiElement).getParent()) instanceof PsiMethodCallExpression && POSSIBLE_TO_SKIP_TEST_ASSERTIONS.test(parent = (PsiMethodCallExpression)psiElement);
        }

        private static boolean isFinalLibraryClassOrPrimitives(PsiMethodCallExpression expression) {
            PsiExpressionList argumentList = expression.getArgumentList();
            if (argumentList.getExpressionCount() < 1) {
                return false;
            }
            PsiType type = argumentList.getExpressions()[0].getType();
            if (type == null) {
                return false;
            }
            if (TypeConversionUtil.isPrimitiveAndNotNull((PsiType)type)) {
                return true;
            }
            if (type instanceof PsiArrayType) {
                return true;
            }
            PsiClass aClass = PsiUtil.resolveClassInClassTypeOnly((PsiType)type);
            if (aClass == null) {
                return false;
            }
            if (!aClass.hasModifierProperty("final")) {
                return false;
            }
            return LibraryUtil.classIsInLibrary(aClass);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            objectArray2[0] = "expression";
            objectArray2[1] = "com/siyeh/ig/bugs/EqualsWithItselfInspection$EqualsWithItselfVisitor";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "visitMethodCallExpression";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "mayTestContract";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

