/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.bugs;

import com.intellij.codeInsight.daemon.impl.UnusedSymbolUtil;
import com.intellij.psi.JavaRecursiveElementWalkingVisitor;
import com.intellij.psi.JavaTokenType;
import com.intellij.psi.LambdaUtil;
import com.intellij.psi.PsiArrayInitializerExpression;
import com.intellij.psi.PsiAssignmentExpression;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiConditionalExpression;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionList;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiFunctionalExpression;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.PsiLambdaExpression;
import com.intellij.psi.PsiLocalVariable;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiMethodReferenceExpression;
import com.intellij.psi.PsiNewExpression;
import com.intellij.psi.PsiParenthesizedExpression;
import com.intellij.psi.PsiPolyadicExpression;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiReturnStatement;
import com.intellij.psi.PsiStatement;
import com.intellij.psi.PsiTemplate;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeCastExpression;
import com.intellij.psi.PsiTypes;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.InheritanceUtil;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtil;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.psiutils.ConstructionUtils;
import com.siyeh.ig.psiutils.ExpressionUtils;
import com.siyeh.ig.psiutils.ParenthesesUtils;
import com.siyeh.ig.psiutils.SideEffectChecker;
import com.siyeh.ig.psiutils.TypeUtils;
import com.siyeh.ig.psiutils.VariableAccessUtils;
import java.util.Map;
import java.util.Set;
import org.intellij.lang.annotations.Pattern;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class MismatchedStringBuilderQueryUpdateInspection
extends BaseInspection {
    @NonNls
    static final Map<BuilderType, Set<String>> returnSelfNames = Map.of(BuilderType.ABSTRACT_STRING_BUILDER, Set.of("append", "appendCodePoint", "delete", "deleteCharAt", "insert", "replace", "reverse", "repeat"), BuilderType.STRING_JOINER, Set.of("add", "merge", "setEmptyValue"));
    private static final String STRING_JOINER = "java.util.StringJoiner";

    @Pattern(value="[a-zA-Z_0-9.-]+")
    @NotNull
    public String getID() {
        return "MismatchedQueryAndUpdateOfStringBuilder";
    }

    @Override
    @NotNull
    protected String buildErrorString(Object ... infos) {
        boolean updated = (Boolean)infos[0];
        PsiType type = (PsiType)infos[1];
        if (updated) {
            String string = InspectionGadgetsBundle.message("mismatched.string.builder.updated.problem.descriptor", type.getPresentableText());
            if (string == null) {
                MismatchedStringBuilderQueryUpdateInspection.$$$reportNull$$$0(0);
            }
            return string;
        }
        String string = InspectionGadgetsBundle.message("mismatched.string.builder.queried.problem.descriptor", type.getPresentableText());
        if (string == null) {
            MismatchedStringBuilderQueryUpdateInspection.$$$reportNull$$$0(1);
        }
        return string;
    }

    public boolean isEnabledByDefault() {
        return true;
    }

    public boolean runForWholeFile() {
        return true;
    }

    @Override
    @NotNull
    public BaseInspectionVisitor buildVisitor() {
        return new MismatchedQueryAndUpdateOfStringBuilderVisitor();
    }

    @Nullable
    private static BuilderType getType(@NotNull PsiVariable variable) {
        if (variable == null) {
            MismatchedStringBuilderQueryUpdateInspection.$$$reportNull$$$0(2);
        }
        if (TypeUtils.variableHasTypeOrSubtype(variable, "java.lang.AbstractStringBuilder")) {
            return BuilderType.ABSTRACT_STRING_BUILDER;
        }
        if (TypeUtils.typeEquals(STRING_JOINER, variable.getType())) {
            return BuilderType.STRING_JOINER;
        }
        return null;
    }

    static boolean hasReferenceToVariable(@NotNull PsiVariable variable, @Nullable PsiElement element, @NotNull BuilderType type) {
        if (variable == null) {
            MismatchedStringBuilderQueryUpdateInspection.$$$reportNull$$$0(3);
        }
        if (type == null) {
            MismatchedStringBuilderQueryUpdateInspection.$$$reportNull$$$0(4);
        }
        if (element instanceof PsiReferenceExpression) {
            PsiReferenceExpression referenceExpression = (PsiReferenceExpression)element;
            return referenceExpression.isReferenceTo((PsiElement)variable);
        }
        if (element instanceof PsiParenthesizedExpression) {
            PsiParenthesizedExpression parenthesizedExpression = (PsiParenthesizedExpression)element;
            PsiExpression expression = parenthesizedExpression.getExpression();
            return MismatchedStringBuilderQueryUpdateInspection.hasReferenceToVariable(variable, (PsiElement)expression, type);
        }
        if (element instanceof PsiMethodCallExpression) {
            PsiMethodCallExpression methodCallExpression = (PsiMethodCallExpression)element;
            PsiReferenceExpression methodExpression = methodCallExpression.getMethodExpression();
            String name = methodExpression.getReferenceName();
            if (name != null && returnSelfNames.get((Object)type).contains(name)) {
                return MismatchedStringBuilderQueryUpdateInspection.hasReferenceToVariable(variable, (PsiElement)methodExpression.getQualifierExpression(), type);
            }
        } else if (element instanceof PsiConditionalExpression) {
            PsiConditionalExpression conditionalExpression = (PsiConditionalExpression)element;
            PsiExpression thenExpression = conditionalExpression.getThenExpression();
            if (MismatchedStringBuilderQueryUpdateInspection.hasReferenceToVariable(variable, (PsiElement)thenExpression, type)) {
                return true;
            }
            PsiExpression elseExpression = conditionalExpression.getElseExpression();
            return MismatchedStringBuilderQueryUpdateInspection.hasReferenceToVariable(variable, (PsiElement)elseExpression, type);
        }
        return false;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 2, 3, 4 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/siyeh/ig/bugs/MismatchedStringBuilderQueryUpdateInspection";
                break;
            }
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "variable";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "buildErrorString";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "com/siyeh/ig/bugs/MismatchedStringBuilderQueryUpdateInspection";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getType";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "hasReferenceToVariable";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 2, 3, 4 -> new IllegalArgumentException(string);
        };
    }

    private static class MismatchedQueryAndUpdateOfStringBuilderVisitor
    extends BaseInspectionVisitor {
        private MismatchedQueryAndUpdateOfStringBuilderVisitor() {
        }

        public void visitField(@NotNull PsiField field) {
            boolean updated;
            if (field == null) {
                MismatchedQueryAndUpdateOfStringBuilderVisitor.$$$reportNull$$$0(0);
            }
            super.visitField(field);
            if (!field.hasModifierProperty("private")) {
                return;
            }
            BuilderType type = MismatchedStringBuilderQueryUpdateInspection.getType((PsiVariable)field);
            if (type == null) {
                return;
            }
            PsiClass containingClass = PsiUtil.getTopLevelClass((PsiElement)field);
            PsiExpression firstQualifier = MismatchedQueryAndUpdateOfStringBuilderVisitor.getFirstQualifier(field.getInitializer(), type);
            if (!MismatchedQueryAndUpdateOfStringBuilderVisitor.checkVariable((PsiVariable)field, firstQualifier, (PsiElement)containingClass)) {
                return;
            }
            boolean queried = MismatchedQueryAndUpdateOfStringBuilderVisitor.isStringBuilderQueried((PsiVariable)field, (PsiElement)containingClass, type);
            if (queried == (updated = MismatchedQueryAndUpdateOfStringBuilderVisitor.isStringBuilderUpdated((PsiVariable)field, firstQualifier, (PsiElement)containingClass, type)) || UnusedSymbolUtil.isImplicitWrite((PsiVariable)field)) {
                return;
            }
            this.registerFieldError(field, updated, field.getType());
        }

        public void visitLocalVariable(@NotNull PsiLocalVariable variable) {
            boolean updated;
            if (variable == null) {
                MismatchedQueryAndUpdateOfStringBuilderVisitor.$$$reportNull$$$0(1);
            }
            super.visitLocalVariable(variable);
            PsiCodeBlock codeBlock = (PsiCodeBlock)PsiTreeUtil.getParentOfType((PsiElement)variable, PsiCodeBlock.class);
            BuilderType type = MismatchedStringBuilderQueryUpdateInspection.getType((PsiVariable)variable);
            if (type == null) {
                return;
            }
            PsiExpression firstQualifier = MismatchedQueryAndUpdateOfStringBuilderVisitor.getFirstQualifier(variable.getInitializer(), type);
            if (!MismatchedQueryAndUpdateOfStringBuilderVisitor.checkVariable((PsiVariable)variable, firstQualifier, (PsiElement)codeBlock)) {
                return;
            }
            boolean queried = MismatchedQueryAndUpdateOfStringBuilderVisitor.isStringBuilderQueried((PsiVariable)variable, (PsiElement)codeBlock, type);
            if (queried == (updated = MismatchedQueryAndUpdateOfStringBuilderVisitor.isStringBuilderUpdated((PsiVariable)variable, firstQualifier, (PsiElement)codeBlock, type))) {
                return;
            }
            this.registerVariableError((PsiVariable)variable, updated, variable.getType());
        }

        private static boolean checkVariable(@NotNull PsiVariable variable, @Nullable PsiExpression firstQualifier, @Nullable PsiElement context) {
            if (variable == null) {
                MismatchedQueryAndUpdateOfStringBuilderVisitor.$$$reportNull$$$0(2);
            }
            if (context == null) {
                return false;
            }
            if (!(PsiUtil.skipParenthesizedExprDown((PsiExpression)firstQualifier) instanceof PsiNewExpression)) {
                return false;
            }
            if (VariableAccessUtils.variableIsAssigned(variable, context)) {
                return false;
            }
            if (VariableAccessUtils.variableIsAssignedFrom(variable, context)) {
                return false;
            }
            if (VariableAccessUtils.variableIsReturned(variable, context)) {
                return false;
            }
            if (VariableAccessUtils.variableIsPassedAsMethodArgument(variable, context)) {
                return false;
            }
            return !VariableAccessUtils.variableIsUsedInArrayInitializer(variable, context);
        }

        @Nullable
        private static PsiExpression getFirstQualifier(@Nullable PsiExpression expression, @NotNull BuilderType type) {
            PsiMethodCallExpression methodCallExpression;
            PsiReferenceExpression methodExpression;
            String name;
            if (type == null) {
                MismatchedQueryAndUpdateOfStringBuilderVisitor.$$$reportNull$$$0(3);
            }
            if (expression instanceof PsiParenthesizedExpression) {
                PsiParenthesizedExpression parenthesizedExpression = (PsiParenthesizedExpression)expression;
                PsiExpression next = parenthesizedExpression.getExpression();
                return MismatchedQueryAndUpdateOfStringBuilderVisitor.getFirstQualifier(next, type);
            }
            if (expression instanceof PsiMethodCallExpression && (name = (methodExpression = (methodCallExpression = (PsiMethodCallExpression)expression).getMethodExpression()).getReferenceName()) != null && returnSelfNames.get((Object)type).contains(name)) {
                return MismatchedQueryAndUpdateOfStringBuilderVisitor.getFirstQualifier(methodExpression.getQualifierExpression(), type);
            }
            return expression;
        }

        private static boolean isStringBuilderUpdated(@NotNull PsiVariable variable, @Nullable PsiExpression firstQualifiedInitializer, @NotNull PsiElement context, @NotNull BuilderType type) {
            if (variable == null) {
                MismatchedQueryAndUpdateOfStringBuilderVisitor.$$$reportNull$$$0(4);
            }
            if (context == null) {
                MismatchedQueryAndUpdateOfStringBuilderVisitor.$$$reportNull$$$0(5);
            }
            if (type == null) {
                MismatchedQueryAndUpdateOfStringBuilderVisitor.$$$reportNull$$$0(6);
            }
            if (firstQualifiedInitializer != null && !ConstructionUtils.isEmptyStringBuilderInitializer(firstQualifiedInitializer) && !MismatchedQueryAndUpdateOfStringBuilderVisitor.isOnlyDelimiterStringJoinerInitializer(firstQualifiedInitializer)) {
                return true;
            }
            if (firstQualifiedInitializer != variable.getInitializer() && MismatchedQueryAndUpdateOfStringBuilderVisitor.isChainUpdated(variable.getInitializer(), type)) {
                return true;
            }
            StringBuilderUpdateCalledVisitor visitor2 = new StringBuilderUpdateCalledVisitor(variable, type);
            context.accept((PsiElementVisitor)visitor2);
            return visitor2.isUpdated();
        }

        private static boolean isChainUpdated(@Nullable PsiExpression expression, @NotNull BuilderType type) {
            if (type == null) {
                MismatchedQueryAndUpdateOfStringBuilderVisitor.$$$reportNull$$$0(7);
            }
            if (expression instanceof PsiParenthesizedExpression) {
                PsiParenthesizedExpression parenthesizedExpression = (PsiParenthesizedExpression)expression;
                PsiExpression next = parenthesizedExpression.getExpression();
                return MismatchedQueryAndUpdateOfStringBuilderVisitor.isChainUpdated(next, type);
            }
            if (expression instanceof PsiMethodCallExpression) {
                PsiMethodCallExpression methodCallExpression = (PsiMethodCallExpression)expression;
                PsiReferenceExpression methodExpression = methodCallExpression.getMethodExpression();
                String name = methodExpression.getReferenceName();
                if (name != null && StringBuilderUpdateCalledVisitor.updateNames.get((Object)type).contains(name)) {
                    return true;
                }
                if (name != null && returnSelfNames.get((Object)type).contains(name)) {
                    return MismatchedQueryAndUpdateOfStringBuilderVisitor.isChainUpdated(methodExpression.getQualifierExpression(), type);
                }
            }
            return false;
        }

        private static boolean isOnlyDelimiterStringJoinerInitializer(@NotNull PsiExpression construction) {
            if (construction == null) {
                MismatchedQueryAndUpdateOfStringBuilderVisitor.$$$reportNull$$$0(8);
            }
            if (!((construction = PsiUtil.skipParenthesizedExprDown((PsiExpression)construction)) instanceof PsiNewExpression)) {
                return false;
            }
            PsiNewExpression newExpression = (PsiNewExpression)construction;
            PsiJavaCodeReferenceElement classReference = newExpression.getClassReference();
            if (!ConstructionUtils.isReferenceTo(classReference, MismatchedStringBuilderQueryUpdateInspection.STRING_JOINER)) {
                return false;
            }
            PsiExpressionList argumentList = newExpression.getArgumentList();
            if (argumentList == null) {
                return false;
            }
            PsiExpression[] arguments = argumentList.getExpressions();
            if (arguments.length != 1) {
                return false;
            }
            PsiExpression argument = arguments[0];
            PsiType argumentType = argument.getType();
            return InheritanceUtil.isInheritor((PsiType)argumentType, (String)"java.lang.CharSequence");
        }

        private static boolean isStringBuilderQueried(@NotNull PsiVariable variable, @NotNull PsiElement context, @NotNull BuilderType type) {
            if (variable == null) {
                MismatchedQueryAndUpdateOfStringBuilderVisitor.$$$reportNull$$$0(9);
            }
            if (context == null) {
                MismatchedQueryAndUpdateOfStringBuilderVisitor.$$$reportNull$$$0(10);
            }
            if (type == null) {
                MismatchedQueryAndUpdateOfStringBuilderVisitor.$$$reportNull$$$0(11);
            }
            StringBuilderQueryCalledVisitor visitor2 = new StringBuilderQueryCalledVisitor(variable, type);
            context.accept((PsiElementVisitor)visitor2);
            return visitor2.isQueried();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "field";
                    break;
                }
                case 1: 
                case 2: 
                case 4: 
                case 9: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "variable";
                    break;
                }
                case 3: 
                case 6: 
                case 7: 
                case 11: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "type";
                    break;
                }
                case 5: 
                case 10: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "context";
                    break;
                }
                case 8: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "construction";
                    break;
                }
            }
            objectArray2[1] = "com/siyeh/ig/bugs/MismatchedStringBuilderQueryUpdateInspection$MismatchedQueryAndUpdateOfStringBuilderVisitor";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "visitField";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "visitLocalVariable";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "checkVariable";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[2] = "getFirstQualifier";
                    break;
                }
                case 4: 
                case 5: 
                case 6: {
                    objectArray = objectArray2;
                    objectArray2[2] = "isStringBuilderUpdated";
                    break;
                }
                case 7: {
                    objectArray = objectArray2;
                    objectArray2[2] = "isChainUpdated";
                    break;
                }
                case 8: {
                    objectArray = objectArray2;
                    objectArray2[2] = "isOnlyDelimiterStringJoinerInitializer";
                    break;
                }
                case 9: 
                case 10: 
                case 11: {
                    objectArray = objectArray2;
                    objectArray2[2] = "isStringBuilderQueried";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static enum BuilderType {
        ABSTRACT_STRING_BUILDER,
        STRING_JOINER;

    }

    private static class StringBuilderQueryCalledVisitor
    extends JavaRecursiveElementWalkingVisitor {
        @NonNls
        private static final Map<BuilderType, Set<String>> queryNames = Map.of(BuilderType.ABSTRACT_STRING_BUILDER, Set.of("capacity", "charAt", "chars", "codePointAt", "codePointBefore", "codePointCount", "codePoints", "compareTo", "equals", "getChars", "hashCode", "indexOf", "lastIndexOf", "length", "offsetByCodePoints", "subSequence", "substring", "toString"), BuilderType.STRING_JOINER, Set.of("length", "toString"));
        @NotNull
        private final PsiVariable variable;
        private boolean queried;
        @NotNull
        private final BuilderType builderType;

        StringBuilderQueryCalledVisitor(@NotNull PsiVariable variable, @NotNull BuilderType type) {
            if (variable == null) {
                StringBuilderQueryCalledVisitor.$$$reportNull$$$0(0);
            }
            if (type == null) {
                StringBuilderQueryCalledVisitor.$$$reportNull$$$0(1);
            }
            this.variable = variable;
            this.builderType = type;
        }

        public boolean isQueried() {
            return this.queried;
        }

        public void visitElement(@NotNull PsiElement element) {
            if (element == null) {
                StringBuilderQueryCalledVisitor.$$$reportNull$$$0(2);
            }
            if (this.queried) {
                return;
            }
            super.visitElement(element);
        }

        public void visitReferenceExpression(@NotNull PsiReferenceExpression expression) {
            PsiPolyadicExpression polyadicExpression;
            IElementType tokenType;
            if (expression == null) {
                StringBuilderQueryCalledVisitor.$$$reportNull$$$0(3);
            }
            if (this.queried) {
                return;
            }
            super.visitReferenceExpression(expression);
            PsiElement parent = ParenthesesUtils.getParentSkipParentheses((PsiElement)expression);
            if (parent instanceof PsiPolyadicExpression ? !JavaTokenType.PLUS.equals(tokenType = (polyadicExpression = (PsiPolyadicExpression)parent).getOperationTokenType()) || !ExpressionUtils.hasStringType((PsiExpression)polyadicExpression) : !(parent instanceof PsiTemplate)) {
                return;
            }
            PsiElement target = expression.resolve();
            if (!this.variable.equals((Object)target)) {
                return;
            }
            this.queried = true;
        }

        public void visitMethodReferenceExpression(@NotNull PsiMethodReferenceExpression expression) {
            if (expression == null) {
                StringBuilderQueryCalledVisitor.$$$reportNull$$$0(4);
            }
            if (this.queried) {
                return;
            }
            super.visitMethodReferenceExpression(expression);
            String name = expression.getReferenceName();
            if (name == null) {
                return;
            }
            if (!queryNames.get((Object)this.builderType).contains(name) && !returnSelfNames.get((Object)this.builderType).contains(name)) {
                return;
            }
            if (PsiTypes.voidType().equals((Object)LambdaUtil.getFunctionalInterfaceReturnType((PsiFunctionalExpression)expression))) {
                return;
            }
            PsiExpression qualifierExpression = expression.getQualifierExpression();
            if (MismatchedStringBuilderQueryUpdateInspection.hasReferenceToVariable(this.variable, (PsiElement)qualifierExpression, this.builderType)) {
                this.queried = true;
            }
        }

        public void visitMethodCallExpression(@NotNull PsiMethodCallExpression expression) {
            if (expression == null) {
                StringBuilderQueryCalledVisitor.$$$reportNull$$$0(5);
            }
            if (this.queried) {
                return;
            }
            super.visitMethodCallExpression(expression);
            PsiReferenceExpression methodExpression = expression.getMethodExpression();
            String name = methodExpression.getReferenceName();
            if (name == null) {
                return;
            }
            PsiExpression qualifierExpression = methodExpression.getQualifierExpression();
            if (!queryNames.get((Object)this.builderType).contains(name)) {
                if (returnSelfNames.get((Object)this.builderType).contains(name) && MismatchedStringBuilderQueryUpdateInspection.hasReferenceToVariable(this.variable, (PsiElement)qualifierExpression, this.builderType) && StringBuilderQueryCalledVisitor.isVariableValueUsed((PsiExpression)expression)) {
                    this.queried = true;
                }
                return;
            }
            if (MismatchedStringBuilderQueryUpdateInspection.hasReferenceToVariable(this.variable, (PsiElement)qualifierExpression, this.builderType)) {
                PsiElement parent = PsiTreeUtil.getParentOfType((PsiElement)expression, (Class[])new Class[]{PsiStatement.class, PsiLambdaExpression.class});
                if (parent instanceof PsiStatement && !SideEffectChecker.mayHaveSideEffects(parent, e -> e instanceof PsiMethodCallExpression && this.isSideEffectFreeBuilderMethodCall((PsiMethodCallExpression)e))) {
                    return;
                }
                this.queried = true;
            }
        }

        private boolean isSideEffectFreeBuilderMethodCall(PsiMethodCallExpression call) {
            PsiReferenceExpression methodExpression = call.getMethodExpression();
            return !"getChars".equals(methodExpression.getReferenceName()) && ExpressionUtils.isReferenceTo(methodExpression.getQualifierExpression(), this.variable);
        }

        private static boolean isVariableValueUsed(PsiExpression expression) {
            PsiElement parent = expression.getParent();
            if (parent instanceof PsiParenthesizedExpression) {
                PsiParenthesizedExpression parenthesizedExpression = (PsiParenthesizedExpression)parent;
                return StringBuilderQueryCalledVisitor.isVariableValueUsed((PsiExpression)parenthesizedExpression);
            }
            if (parent instanceof PsiPolyadicExpression) {
                PsiPolyadicExpression polyadicExpression = (PsiPolyadicExpression)parent;
                return StringBuilderQueryCalledVisitor.isVariableValueUsed((PsiExpression)polyadicExpression);
            }
            if (parent instanceof PsiTypeCastExpression) {
                PsiTypeCastExpression typeCastExpression = (PsiTypeCastExpression)parent;
                return StringBuilderQueryCalledVisitor.isVariableValueUsed((PsiExpression)typeCastExpression);
            }
            if (parent instanceof PsiReturnStatement) {
                return true;
            }
            if (parent instanceof PsiExpressionList) {
                PsiElement grandParent = parent.getParent();
                if (grandParent instanceof PsiMethodCallExpression) {
                    return true;
                }
            } else {
                if (parent instanceof PsiArrayInitializerExpression) {
                    return true;
                }
                if (parent instanceof PsiAssignmentExpression) {
                    PsiAssignmentExpression assignmentExpression = (PsiAssignmentExpression)parent;
                    PsiExpression rhs = assignmentExpression.getRExpression();
                    return expression.equals((Object)rhs);
                }
                if (parent instanceof PsiVariable) {
                    PsiVariable variable = (PsiVariable)parent;
                    PsiExpression initializer = variable.getInitializer();
                    return expression.equals((Object)initializer);
                }
            }
            return false;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "variable";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "type";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "element";
                    break;
                }
                case 3: 
                case 4: 
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "expression";
                    break;
                }
            }
            objectArray2[1] = "com/siyeh/ig/bugs/MismatchedStringBuilderQueryUpdateInspection$StringBuilderQueryCalledVisitor";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "visitElement";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[2] = "visitReferenceExpression";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[2] = "visitMethodReferenceExpression";
                    break;
                }
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[2] = "visitMethodCallExpression";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static class StringBuilderUpdateCalledVisitor
    extends JavaRecursiveElementWalkingVisitor {
        @NonNls
        private static final Map<BuilderType, Set<String>> updateNames = Map.of(BuilderType.ABSTRACT_STRING_BUILDER, Set.of("append", "appendCodePoint", "delete", "deleteCharAt", "insert", "replace", "reverse", "setCharAt", "setLength", "repeat"), BuilderType.STRING_JOINER, Set.of("add", "merge", "setEmptyValue"));
        @NotNull
        private final PsiVariable variable;
        private boolean updated;
        @NotNull
        private final BuilderType builderType;

        StringBuilderUpdateCalledVisitor(@NotNull PsiVariable variable, @NotNull BuilderType builderType) {
            if (variable == null) {
                StringBuilderUpdateCalledVisitor.$$$reportNull$$$0(0);
            }
            if (builderType == null) {
                StringBuilderUpdateCalledVisitor.$$$reportNull$$$0(1);
            }
            this.variable = variable;
            this.builderType = builderType;
        }

        public boolean isUpdated() {
            return this.updated;
        }

        public void visitMethodCallExpression(@NotNull PsiMethodCallExpression expression) {
            if (expression == null) {
                StringBuilderUpdateCalledVisitor.$$$reportNull$$$0(2);
            }
            if (this.updated) {
                return;
            }
            super.visitMethodCallExpression(expression);
            this.checkReferenceExpression(expression.getMethodExpression());
        }

        public void visitMethodReferenceExpression(@NotNull PsiMethodReferenceExpression expression) {
            if (expression == null) {
                StringBuilderUpdateCalledVisitor.$$$reportNull$$$0(3);
            }
            if (this.updated) {
                return;
            }
            super.visitMethodReferenceExpression(expression);
            this.checkReferenceExpression((PsiReferenceExpression)expression);
        }

        private void checkReferenceExpression(PsiReferenceExpression methodExpression) {
            String name = methodExpression.getReferenceName();
            if (name == null || !updateNames.get((Object)this.builderType).contains(name)) {
                return;
            }
            PsiExpression qualifierExpression = methodExpression.getQualifierExpression();
            if (MismatchedStringBuilderQueryUpdateInspection.hasReferenceToVariable(this.variable, (PsiElement)qualifierExpression, this.builderType)) {
                this.updated = true;
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "variable";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "builderType";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "expression";
                    break;
                }
            }
            objectArray2[1] = "com/siyeh/ig/bugs/MismatchedStringBuilderQueryUpdateInspection$StringBuilderUpdateCalledVisitor";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "visitMethodCallExpression";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[2] = "visitMethodReferenceExpression";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

