/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.bugs;

import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.dataFlow.ContractReturnValue;
import com.intellij.codeInspection.dataFlow.JavaMethodContractUtil;
import com.intellij.codeInspection.dataFlow.MethodContract;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiBinaryExpression;
import com.intellij.psi.PsiCallExpression;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiLambdaExpression;
import com.intellij.psi.PsiLocalVariable;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiNewExpression;
import com.intellij.psi.PsiPrimitiveType;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.controlFlow.AnalysisCanceledException;
import com.intellij.psi.controlFlow.ControlFlow;
import com.intellij.psi.controlFlow.ControlFlowFactory;
import com.intellij.psi.controlFlow.ControlFlowPolicy;
import com.intellij.psi.controlFlow.ControlFlowUtil;
import com.intellij.psi.controlFlow.LocalsControlFlowPolicy;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.util.ObjectUtils;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.fixes.EqualityToEqualsFix;
import com.siyeh.ig.psiutils.ComparisonUtils;
import com.siyeh.ig.psiutils.ControlFlowUtils;
import com.siyeh.ig.psiutils.VariableAccessUtils;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;

public final class NewObjectEqualityInspection
extends BaseInspection {
    @Override
    @NotNull
    public String buildErrorString(Object ... infos) {
        Object sign = infos[1];
        String string = InspectionGadgetsBundle.message("inspection.new.object.equality.message", sign);
        if (string == null) {
            NewObjectEqualityInspection.$$$reportNull$$$0(0);
        }
        return string;
    }

    @Override
    @NotNull
    public BaseInspectionVisitor buildVisitor() {
        return new NumberEqualityVisitor();
    }

    @Override
    protected LocalQuickFix @NotNull [] buildFixes(Object ... infos) {
        LocalQuickFix[] localQuickFixArray = EqualityToEqualsFix.buildEqualityFixes((PsiBinaryExpression)infos[0]);
        if (localQuickFixArray == null) {
            NewObjectEqualityInspection.$$$reportNull$$$0(1);
        }
        return localQuickFixArray;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[2];
        objectArray2[0] = "com/siyeh/ig/bugs/NewObjectEqualityInspection";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "buildErrorString";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "buildFixes";
                break;
            }
        }
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
    }

    private static class NumberEqualityVisitor
    extends BaseInspectionVisitor {
        private NumberEqualityVisitor() {
        }

        public void visitBinaryExpression(@NotNull PsiBinaryExpression expression) {
            if (expression == null) {
                NumberEqualityVisitor.$$$reportNull$$$0(0);
            }
            super.visitBinaryExpression(expression);
            if (!ComparisonUtils.isEqualityComparison((PsiExpression)expression)) {
                return;
            }
            PsiExpression rhs = expression.getROperand();
            if (rhs == null) {
                return;
            }
            PsiExpression lhs = expression.getLOperand();
            if (NumberEqualityVisitor.isNewObject(rhs) && !(lhs.getType() instanceof PsiPrimitiveType)) {
                this.registerError((PsiElement)rhs, expression, expression.getOperationSign().getText());
            } else if (NumberEqualityVisitor.isNewObject(lhs) && !(rhs.getType() instanceof PsiPrimitiveType)) {
                this.registerError((PsiElement)lhs, expression, expression.getOperationSign().getText());
            }
        }

        @Contract(value="null -> false")
        private static boolean isNewObject(PsiExpression expression) {
            if ((expression = NumberEqualityVisitor.resolveExpression(expression)) instanceof PsiNewExpression) {
                return true;
            }
            if (expression instanceof PsiMethodCallExpression) {
                List<? extends MethodContract> contracts = JavaMethodContractUtil.getMethodCallContracts((PsiCallExpression)expression);
                return ContractReturnValue.returnNew().equals(JavaMethodContractUtil.getNonFailingReturnValue(contracts));
            }
            return false;
        }

        private static PsiExpression resolveExpression(PsiExpression expression) {
            ControlFlow flow;
            PsiElement parent = expression.getParent();
            if (!((expression = PsiUtil.skipParenthesizedExprDown((PsiExpression)expression)) instanceof PsiReferenceExpression)) {
                return expression;
            }
            PsiReferenceExpression reference = (PsiReferenceExpression)expression;
            PsiLocalVariable variable = (PsiLocalVariable)ObjectUtils.tryCast((Object)reference.resolve(), PsiLocalVariable.class);
            if (variable == null) {
                return expression;
            }
            PsiExpression initializer = variable.getInitializer();
            if (initializer == null) {
                return expression;
            }
            if (parent instanceof PsiBinaryExpression && VariableAccessUtils.getVariableReferences((PsiVariable)variable, parent).size() != 1) {
                return expression;
            }
            PsiElement block = ControlFlowUtil.findCodeFragment((PsiElement)variable);
            PsiElement expressionContext = PsiTreeUtil.getParentOfType((PsiElement)expression, (Class[])new Class[]{PsiMember.class, PsiLambdaExpression.class});
            if (expressionContext == null || PsiTreeUtil.isAncestor((PsiElement)block, (PsiElement)expressionContext, (boolean)true)) {
                return expression;
            }
            if (!ControlFlowUtil.isEffectivelyFinal((PsiVariable)variable, (PsiElement)block)) {
                return expression;
            }
            try {
                flow = ControlFlowFactory.getInstance((Project)block.getProject()).getControlFlow(block, (ControlFlowPolicy)new LocalsControlFlowPolicy(block), false);
            }
            catch (AnalysisCanceledException e) {
                return expression;
            }
            int initializerEnd = flow.getEndOffset((PsiElement)initializer);
            int start = initializerEnd + 1;
            if (ControlFlowUtils.isVariableReferencedBeforeStatementEntry(flow, start, (PsiElement)expression, (PsiVariable)variable, Set.of(Integer.valueOf(initializerEnd)))) {
                return expression;
            }
            return initializer;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "com/siyeh/ig/bugs/NewObjectEqualityInspection$NumberEqualityVisitor", "visitBinaryExpression"));
        }
    }
}

