/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.bugs;

import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.modcommand.ModPsiUpdater;
import com.intellij.modcommand.PsiUpdateModCommandQuickFix;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionList;
import com.intellij.psi.PsiLiteralExpression;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiNewExpression;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypes;
import com.intellij.psi.util.InheritanceUtil;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.PsiReplacementUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class NewStringBufferWithCharArgumentInspection
extends BaseInspection {
    @Override
    @NotNull
    protected String buildErrorString(Object ... infos) {
        String string = InspectionGadgetsBundle.message("new.string.buffer.with.char.argument.problem.descriptor", new Object[0]);
        if (string == null) {
            NewStringBufferWithCharArgumentInspection.$$$reportNull$$$0(0);
        }
        return string;
    }

    public boolean isEnabledByDefault() {
        return true;
    }

    @Override
    @Nullable
    protected LocalQuickFix buildFix(Object ... infos) {
        PsiExpression argument = (PsiExpression)infos[0];
        if (!(argument instanceof PsiLiteralExpression)) {
            return null;
        }
        return new NewStringBufferWithCharArgumentFix();
    }

    @Override
    @NotNull
    public BaseInspectionVisitor buildVisitor() {
        return new StringBufferWithCharArgumentVisitor();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/bugs/NewStringBufferWithCharArgumentInspection", "buildErrorString"));
    }

    private static class NewStringBufferWithCharArgumentFix
    extends PsiUpdateModCommandQuickFix {
        private NewStringBufferWithCharArgumentFix() {
        }

        @NotNull
        public String getFamilyName() {
            String string = InspectionGadgetsBundle.message("new.string.buffer.with.char.argument.quickfix", new Object[0]);
            if (string == null) {
                NewStringBufferWithCharArgumentFix.$$$reportNull$$$0(0);
            }
            return string;
        }

        protected void applyFix(@NotNull Project project, @NotNull PsiElement element, @NotNull ModPsiUpdater updater) {
            PsiNewExpression newExpression;
            PsiExpressionList argumentList;
            if (project == null) {
                NewStringBufferWithCharArgumentFix.$$$reportNull$$$0(1);
            }
            if (element == null) {
                NewStringBufferWithCharArgumentFix.$$$reportNull$$$0(2);
            }
            if (updater == null) {
                NewStringBufferWithCharArgumentFix.$$$reportNull$$$0(3);
            }
            if ((argumentList = (newExpression = (PsiNewExpression)element.getParent()).getArgumentList()) == null) {
                return;
            }
            PsiExpression[] arguments = argumentList.getExpressions();
            if (arguments.length != 1) {
                return;
            }
            PsiExpression argument = arguments[0];
            String text = argument.getText();
            String newArgument = "\"" + StringUtil.escapeStringCharacters((String)StringUtil.stripQuotesAroundValue((String)text)) + "\"";
            PsiReplacementUtil.replaceExpression(argument, newArgument);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 2;
                case 1, 2, 3 -> 3;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/siyeh/ig/bugs/NewStringBufferWithCharArgumentInspection$NewStringBufferWithCharArgumentFix";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "element";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "updater";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFamilyName";
                    break;
                }
                case 1: 
                case 2: 
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/siyeh/ig/bugs/NewStringBufferWithCharArgumentInspection$NewStringBufferWithCharArgumentFix";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 1: 
                case 2: 
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "applyFix";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalStateException(string);
                case 1, 2, 3 -> new IllegalArgumentException(string);
            };
        }
    }

    private static class StringBufferWithCharArgumentVisitor
    extends BaseInspectionVisitor {
        private StringBufferWithCharArgumentVisitor() {
        }

        public void visitNewExpression(@NotNull PsiNewExpression expression) {
            if (expression == null) {
                StringBufferWithCharArgumentVisitor.$$$reportNull$$$0(0);
            }
            super.visitNewExpression(expression);
            PsiExpressionList argumentList = expression.getArgumentList();
            if (argumentList == null) {
                return;
            }
            PsiExpression[] arguments = argumentList.getExpressions();
            if (arguments.length != 1) {
                return;
            }
            PsiExpression argument = arguments[0];
            PsiType type = argument.getType();
            if (!PsiTypes.charType().equals((Object)type)) {
                return;
            }
            PsiMethod constructor = expression.resolveConstructor();
            if (constructor == null) {
                return;
            }
            PsiClass aClass = constructor.getContainingClass();
            if (!InheritanceUtil.isInheritor((PsiClass)aClass, (String)"java.lang.AbstractStringBuilder")) {
                return;
            }
            this.registerNewExpressionError(expression, argument);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "com/siyeh/ig/bugs/NewStringBufferWithCharArgumentInspection$StringBufferWithCharArgumentVisitor", "visitNewExpression"));
        }
    }
}

