/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.bugs;

import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.modcommand.ModPsiUpdater;
import com.intellij.modcommand.PsiUpdateModCommandQuickFix;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaTokenType;
import com.intellij.psi.PsiAssignmentExpression;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiPolyadicExpression;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypes;
import com.intellij.psi.tree.IElementType;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.PsiReplacementUtil;
import com.siyeh.ig.psiutils.CommentTracker;
import org.jetbrains.annotations.NotNull;

public final class NonShortCircuitBooleanInspection
extends BaseInspection {
    @NotNull
    public String getID() {
        return "NonShortCircuitBooleanExpression";
    }

    @Override
    @NotNull
    public String buildErrorString(Object ... infos) {
        String string = InspectionGadgetsBundle.message("non.short.circuit.boolean.expression.problem.descriptor", new Object[0]);
        if (string == null) {
            NonShortCircuitBooleanInspection.$$$reportNull$$$0(0);
        }
        return string;
    }

    @Override
    public LocalQuickFix buildFix(Object ... infos) {
        return new NonShortCircuitBooleanFix();
    }

    @Override
    @NotNull
    public BaseInspectionVisitor buildVisitor() {
        return new NonShortCircuitBooleanVisitor();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/bugs/NonShortCircuitBooleanInspection", "buildErrorString"));
    }

    private static class NonShortCircuitBooleanFix
    extends PsiUpdateModCommandQuickFix {
        private NonShortCircuitBooleanFix() {
        }

        @NotNull
        public String getFamilyName() {
            String string = InspectionGadgetsBundle.message("non.short.circuit.boolean.expression.replace.quickfix", new Object[0]);
            if (string == null) {
                NonShortCircuitBooleanFix.$$$reportNull$$$0(0);
            }
            return string;
        }

        protected void applyFix(@NotNull Project project, @NotNull PsiElement element, @NotNull ModPsiUpdater updater) {
            PsiAssignmentExpression assignment;
            PsiAssignmentExpression replaced;
            PsiExpression expression;
            if (project == null) {
                NonShortCircuitBooleanFix.$$$reportNull$$$0(1);
            }
            if (element == null) {
                NonShortCircuitBooleanFix.$$$reportNull$$$0(2);
            }
            if (updater == null) {
                NonShortCircuitBooleanFix.$$$reportNull$$$0(3);
            }
            if (element instanceof PsiPolyadicExpression) {
                PsiPolyadicExpression polyadic = (PsiPolyadicExpression)element;
                NonShortCircuitBooleanFix.doReplacePolyadicExpression(polyadic);
            } else if (element instanceof PsiAssignmentExpression && (expression = (replaced = PsiReplacementUtil.replaceOperatorAssignmentWithAssignmentExpression(assignment = (PsiAssignmentExpression)element)).getRExpression()) instanceof PsiPolyadicExpression) {
                PsiPolyadicExpression polyadic = (PsiPolyadicExpression)expression;
                NonShortCircuitBooleanFix.doReplacePolyadicExpression(polyadic);
            }
        }

        private static void doReplacePolyadicExpression(PsiPolyadicExpression expression) {
            IElementType tokenType = expression.getOperationTokenType();
            String operandText = NonShortCircuitBooleanFix.getShortCircuitOperand(tokenType);
            PsiExpression[] operands = expression.getOperands();
            StringBuilder newExpression = new StringBuilder();
            CommentTracker commentTracker = new CommentTracker();
            for (PsiExpression operand : operands) {
                if (!newExpression.isEmpty()) {
                    newExpression.append(operandText);
                }
                newExpression.append(commentTracker.text((PsiElement)operand));
            }
            PsiReplacementUtil.replaceExpression((PsiExpression)expression, newExpression.toString(), commentTracker);
        }

        private static String getShortCircuitOperand(IElementType tokenType) {
            if (tokenType.equals(JavaTokenType.AND)) {
                return "&&";
            }
            return "||";
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 2;
                case 1, 2, 3 -> 3;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/siyeh/ig/bugs/NonShortCircuitBooleanInspection$NonShortCircuitBooleanFix";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "element";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "updater";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFamilyName";
                    break;
                }
                case 1: 
                case 2: 
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/siyeh/ig/bugs/NonShortCircuitBooleanInspection$NonShortCircuitBooleanFix";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 1: 
                case 2: 
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "applyFix";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalStateException(string);
                case 1, 2, 3 -> new IllegalArgumentException(string);
            };
        }
    }

    private static class NonShortCircuitBooleanVisitor
    extends BaseInspectionVisitor {
        private NonShortCircuitBooleanVisitor() {
        }

        public void visitPolyadicExpression(@NotNull PsiPolyadicExpression expression) {
            if (expression == null) {
                NonShortCircuitBooleanVisitor.$$$reportNull$$$0(0);
            }
            super.visitPolyadicExpression(expression);
            IElementType tokenType = expression.getOperationTokenType();
            if (!tokenType.equals(JavaTokenType.AND) && !tokenType.equals(JavaTokenType.OR)) {
                return;
            }
            this.doCheck((PsiExpression)expression);
        }

        public void visitAssignmentExpression(@NotNull PsiAssignmentExpression expression) {
            if (expression == null) {
                NonShortCircuitBooleanVisitor.$$$reportNull$$$0(1);
            }
            super.visitAssignmentExpression(expression);
            IElementType tokenType = expression.getOperationTokenType();
            if (!tokenType.equals(JavaTokenType.ANDEQ) && !tokenType.equals(JavaTokenType.OREQ)) {
                return;
            }
            this.doCheck((PsiExpression)expression);
        }

        private void doCheck(PsiExpression expression) {
            PsiType type = expression.getType();
            if (type == null) {
                return;
            }
            if (!type.equals(PsiTypes.booleanType())) {
                return;
            }
            this.registerError((PsiElement)expression, new Object[0]);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            objectArray2[0] = "expression";
            objectArray2[1] = "com/siyeh/ig/bugs/NonShortCircuitBooleanInspection$NonShortCircuitBooleanVisitor";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "visitPolyadicExpression";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "visitAssignmentExpression";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

