/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.bugs;

import com.intellij.codeInsight.daemon.impl.quickfix.AddTypeCastFix;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.modcommand.ModCommandAction;
import com.intellij.pom.java.JavaFeature;
import com.intellij.psi.JavaResolveResult;
import com.intellij.psi.PsiArrayType;
import com.intellij.psi.PsiCall;
import com.intellij.psi.PsiCallExpression;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiEllipsisType;
import com.intellij.psi.PsiEnumConstant;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionList;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiParameterList;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypes;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.psiutils.TypeUtils;
import java.util.Set;
import java.util.function.Supplier;
import org.jetbrains.annotations.NotNull;

public final class NullArgumentToVariableArgMethodInspection
extends BaseInspection {
    @NotNull
    public String getID() {
        return "ConfusingArgumentToVarargsMethod";
    }

    @NotNull
    public String getAlternativeID() {
        return "NullArgumentToVariableArgMethod";
    }

    @Override
    @NotNull
    public String buildErrorString(Object ... infos) {
        String string = InspectionGadgetsBundle.message("null.argument.to.var.arg.method.problem.descriptor", new Object[0]);
        if (string == null) {
            NullArgumentToVariableArgMethodInspection.$$$reportNull$$$0(0);
        }
        return string;
    }

    @Override
    protected LocalQuickFix @NotNull [] buildFixes(Object ... infos) {
        PsiExpression argument = (PsiExpression)infos[0];
        PsiType type1 = (PsiType)infos[1];
        PsiType type2 = (PsiType)infos[2];
        LocalQuickFix[] localQuickFixArray = new LocalQuickFix[]{LocalQuickFix.from((ModCommandAction)new AddTypeCastFix(type1, argument)), LocalQuickFix.from((ModCommandAction)new AddTypeCastFix(type2, argument))};
        if (localQuickFixArray == null) {
            NullArgumentToVariableArgMethodInspection.$$$reportNull$$$0(1);
        }
        return localQuickFixArray;
    }

    public boolean isEnabledByDefault() {
        return true;
    }

    @NotNull
    public @NotNull Set<@NotNull JavaFeature> requiredFeatures() {
        Set<JavaFeature> set = Set.of(JavaFeature.VARARGS);
        if (set == null) {
            NullArgumentToVariableArgMethodInspection.$$$reportNull$$$0(2);
        }
        return set;
    }

    @Override
    @NotNull
    public BaseInspectionVisitor buildVisitor() {
        return new NullArgumentToVariableArgVisitor();
    }

    public static boolean isSuspiciousVararg(PsiCall call, PsiType lastArgumentType, Supplier<? extends PsiMethod> methodSupplier) {
        return NullArgumentToVariableArgVisitor.getSuspiciousVarargType(call, lastArgumentType, methodSupplier) != null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[2];
        objectArray2[0] = "com/siyeh/ig/bugs/NullArgumentToVariableArgMethodInspection";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "buildErrorString";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "buildFixes";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "requiredFeatures";
                break;
            }
        }
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
    }

    private static class NullArgumentToVariableArgVisitor
    extends BaseInspectionVisitor {
        private NullArgumentToVariableArgVisitor() {
        }

        public void visitEnumConstant(@NotNull PsiEnumConstant enumConstant) {
            if (enumConstant == null) {
                NullArgumentToVariableArgVisitor.$$$reportNull$$$0(0);
            }
            super.visitEnumConstant(enumConstant);
            this.visitCall((PsiCall)enumConstant);
        }

        public void visitCallExpression(@NotNull PsiCallExpression call) {
            if (call == null) {
                NullArgumentToVariableArgVisitor.$$$reportNull$$$0(1);
            }
            super.visitCallExpression(call);
            this.visitCall((PsiCall)call);
        }

        private static PsiArrayType getSuspiciousVarargType(PsiCall call, PsiType type, Supplier<? extends PsiMethod> resolver) {
            boolean checkArray;
            if (PsiTypes.nullType().equals(type)) {
                checkArray = false;
            } else if (type instanceof PsiArrayType) {
                checkArray = true;
            } else {
                return null;
            }
            PsiMethod method = resolver.get();
            if (method == null) {
                return null;
            }
            PsiParameterList parameterList = method.getParameterList();
            PsiExpressionList argumentList = call.getArgumentList();
            if (argumentList == null || parameterList.getParametersCount() != argumentList.getExpressionCount()) {
                return null;
            }
            PsiParameter[] parameters = parameterList.getParameters();
            PsiParameter lastParameter = parameters[parameters.length - 1];
            if (!lastParameter.isVarArgs()) {
                return null;
            }
            PsiType type1 = lastParameter.getType();
            if (!(type1 instanceof PsiEllipsisType)) {
                return null;
            }
            PsiEllipsisType ellipsisType = (PsiEllipsisType)type1;
            PsiArrayType arrayType = (PsiArrayType)ellipsisType.toArrayType();
            PsiType componentType = arrayType.getComponentType();
            if (checkArray) {
                if (!componentType.equals(TypeUtils.getObjectType((PsiElement)call))) {
                    return null;
                }
                if (type.isAssignableFrom((PsiType)arrayType) || !arrayType.isAssignableFrom(type)) {
                    return null;
                }
            }
            return arrayType;
        }

        private void visitCall(PsiCall call) {
            JavaResolveResult resolveResult;
            PsiExpressionList argumentList = call.getArgumentList();
            if (argumentList == null) {
                return;
            }
            PsiExpression[] arguments = argumentList.getExpressions();
            if (arguments.length == 0) {
                return;
            }
            PsiExpression lastArgument = arguments[arguments.length - 1];
            PsiType type = lastArgument.getType();
            PsiArrayType arrayType = NullArgumentToVariableArgVisitor.getSuspiciousVarargType(call, type, () -> NullArgumentToVariableArgVisitor.lambda$visitCall$0(resolveResult = call.resolveMethodGenerics()));
            if (arrayType == null) {
                return;
            }
            PsiSubstitutor substitutor = resolveResult.getSubstitutor();
            PsiType componentType = substitutor.substitute(arrayType.getComponentType());
            PsiType substitutedArrayType = substitutor.substitute((PsiType)arrayType);
            this.registerError((PsiElement)lastArgument, lastArgument, componentType, substitutedArrayType);
        }

        private static /* synthetic */ PsiMethod lambda$visitCall$0(JavaResolveResult resolveResult) {
            return (PsiMethod)resolveResult.getElement();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "enumConstant";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "call";
                    break;
                }
            }
            objectArray2[1] = "com/siyeh/ig/bugs/NullArgumentToVariableArgMethodInspection$NullArgumentToVariableArgVisitor";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "visitEnumConstant";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "visitCallExpression";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

