/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.bugs;

import com.intellij.codeInsight.AnnotationUtil;
import com.intellij.codeInsight.daemon.impl.quickfix.AddTypeCastFix;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.modcommand.ModCommandAction;
import com.intellij.openapi.project.Project;
import com.intellij.pom.java.JavaFeature;
import com.intellij.psi.JavaResolveResult;
import com.intellij.psi.PsiArrayType;
import com.intellij.psi.PsiCall;
import com.intellij.psi.PsiCallExpression;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiEllipsisType;
import com.intellij.psi.PsiEnumConstant;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionList;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiParameterList;
import com.intellij.psi.PsiType;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.util.TypeConversionUtil;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.psiutils.TypeUtils;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

public final class PrimitiveArrayArgumentToVariableArgMethodInspection
extends BaseInspection {
    @NotNull
    public String getID() {
        return "PrimitiveArrayArgumentToVarargsMethod";
    }

    @NotNull
    public String getAlternativeID() {
        return "PrimitiveArrayArgumentToVariableArgMethod";
    }

    @Override
    @NotNull
    public String buildErrorString(Object ... infos) {
        String string = InspectionGadgetsBundle.message("primitive.array.argument.to.var.arg.method.problem.descriptor", new Object[0]);
        if (string == null) {
            PrimitiveArrayArgumentToVariableArgMethodInspection.$$$reportNull$$$0(0);
        }
        return string;
    }

    public boolean isEnabledByDefault() {
        return true;
    }

    @NotNull
    public @NotNull Set<@NotNull JavaFeature> requiredFeatures() {
        Set<JavaFeature> set = Set.of(JavaFeature.VARARGS);
        if (set == null) {
            PrimitiveArrayArgumentToVariableArgMethodInspection.$$$reportNull$$$0(1);
        }
        return set;
    }

    @Override
    @NotNull
    protected LocalQuickFix buildFix(Object ... infos) {
        PsiExpression argument = (PsiExpression)infos[0];
        Project project = argument.getProject();
        PsiClassType type = PsiType.getJavaLangObject((PsiManager)PsiManager.getInstance((Project)project), (GlobalSearchScope)GlobalSearchScope.allScope((Project)project));
        LocalQuickFix localQuickFix = LocalQuickFix.from((ModCommandAction)new AddTypeCastFix((PsiType)type, argument));
        if (localQuickFix == null) {
            PrimitiveArrayArgumentToVariableArgMethodInspection.$$$reportNull$$$0(2);
        }
        return localQuickFix;
    }

    @Override
    @NotNull
    public BaseInspectionVisitor buildVisitor() {
        return new PrimitiveArrayArgumentToVariableArgVisitor();
    }

    public static boolean isConfusingArgument(@NotNull PsiCall call, PsiExpression argument, PsiExpression[] arguments) {
        if (call == null) {
            PrimitiveArrayArgumentToVariableArgMethodInspection.$$$reportNull$$$0(3);
        }
        if (!PrimitiveArrayArgumentToVariableArgMethodInspection.isPrimitiveArrayType(argument.getType())) {
            return false;
        }
        JavaResolveResult result = call.resolveMethodGenerics();
        PsiMethod method = (PsiMethod)result.getElement();
        if (method == null || !method.isVarArgs() || AnnotationUtil.isAnnotated((PsiModifierListOwner)method, (String)"java.lang.invoke.MethodHandle.PolymorphicSignature", (int)0)) {
            return false;
        }
        PsiParameterList parameterList = method.getParameterList();
        int count = parameterList.getParametersCount();
        if (count != arguments.length) {
            return false;
        }
        PsiParameter lastParameter = parameterList.getParameter(count - 1);
        if (lastParameter == null || !lastParameter.isVarArgs()) {
            return false;
        }
        PsiEllipsisType parameterType = (PsiEllipsisType)lastParameter.getType();
        PsiType componentType = parameterType.getComponentType();
        return TypeUtils.isJavaLangObject(result.getSubstitutor().substitute(componentType));
    }

    private static boolean isPrimitiveArrayType(PsiType type) {
        PsiArrayType arrayType;
        return type instanceof PsiArrayType && TypeConversionUtil.isPrimitiveAndNotNull((PsiType)(arrayType = (PsiArrayType)type).getComponentType());
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 3 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/siyeh/ig/bugs/PrimitiveArrayArgumentToVariableArgMethodInspection";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "call";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "buildErrorString";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "requiredFeatures";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "buildFix";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "com/siyeh/ig/bugs/PrimitiveArrayArgumentToVariableArgMethodInspection";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "isConfusingArgument";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 3 -> new IllegalArgumentException(string);
        };
    }

    private static class PrimitiveArrayArgumentToVariableArgVisitor
    extends BaseInspectionVisitor {
        private PrimitiveArrayArgumentToVariableArgVisitor() {
        }

        public void visitEnumConstant(@NotNull PsiEnumConstant enumConstant) {
            if (enumConstant == null) {
                PrimitiveArrayArgumentToVariableArgVisitor.$$$reportNull$$$0(0);
            }
            super.visitEnumConstant(enumConstant);
            this.visitCall((PsiCall)enumConstant);
        }

        public void visitCallExpression(@NotNull PsiCallExpression callExpression) {
            if (callExpression == null) {
                PrimitiveArrayArgumentToVariableArgVisitor.$$$reportNull$$$0(1);
            }
            super.visitCallExpression(callExpression);
            this.visitCall((PsiCall)callExpression);
        }

        private void visitCall(@NotNull PsiCall call) {
            PsiExpressionList argumentList;
            if (call == null) {
                PrimitiveArrayArgumentToVariableArgVisitor.$$$reportNull$$$0(2);
            }
            if ((argumentList = call.getArgumentList()) == null) {
                return;
            }
            PsiExpression[] arguments = argumentList.getExpressions();
            if (arguments.length == 0) {
                return;
            }
            PsiExpression lastArgument = arguments[arguments.length - 1];
            if (!PrimitiveArrayArgumentToVariableArgMethodInspection.isConfusingArgument(call, lastArgument, arguments)) {
                return;
            }
            this.registerError((PsiElement)lastArgument, lastArgument);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "enumConstant";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "callExpression";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "call";
                    break;
                }
            }
            objectArray2[1] = "com/siyeh/ig/bugs/PrimitiveArrayArgumentToVariableArgMethodInspection$PrimitiveArrayArgumentToVariableArgVisitor";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "visitEnumConstant";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "visitCallExpression";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "visitCall";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

