/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.bugs;

import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.modcommand.ModPsiUpdater;
import com.intellij.modcommand.PsiUpdateModCommandQuickFix;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiLiteralExpression;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.util.PsiUtil;
import com.intellij.util.ArrayUtil;
import com.intellij.util.PatternUtil;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.PsiReplacementUtil;
import com.siyeh.ig.callMatcher.CallMatcher;
import com.siyeh.ig.psiutils.ExpressionUtils;
import org.intellij.lang.annotations.Pattern;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class ReplaceAllDotInspection
extends BaseInspection {
    @Override
    @NotNull
    public String buildErrorString(Object ... infos) {
        PsiMethodCallExpression methodCallExpression = (PsiMethodCallExpression)infos[0];
        PsiExpression expression = (PsiExpression)infos[1];
        String methodName = methodCallExpression.getMethodExpression().getReferenceName();
        if (ReplaceAllDotInspection.isFileSeparator(expression)) {
            String string = InspectionGadgetsBundle.message("replace.all.file.separator.problem.descriptor", new Object[0]);
            if (string == null) {
                ReplaceAllDotInspection.$$$reportNull$$$0(0);
            }
            return string;
        }
        String string = InspectionGadgetsBundle.message("replace.all.dot.problem.descriptor", methodName);
        if (string == null) {
            ReplaceAllDotInspection.$$$reportNull$$$0(1);
        }
        return string;
    }

    public boolean isEnabledByDefault() {
        return true;
    }

    @Pattern(value="[a-zA-Z_0-9.-]+")
    @NotNull
    public String getID() {
        return "SuspiciousRegexArgument";
    }

    @Nullable
    public String getAlternativeID() {
        return "ReplaceAllDot";
    }

    @Override
    @Nullable
    protected LocalQuickFix buildFix(Object ... infos) {
        PsiExpression expression = (PsiExpression)infos[1];
        if (!(expression instanceof PsiLiteralExpression)) {
            return null;
        }
        return new EscapeCharacterFix();
    }

    @Override
    @NotNull
    public BaseInspectionVisitor buildVisitor() {
        return new ReplaceAllDotVisitor();
    }

    private static boolean isFileSeparator(PsiExpression argument) {
        PsiElement psiElement;
        PsiReferenceExpression ref;
        if (argument instanceof PsiReferenceExpression && "separator".equals((ref = (PsiReferenceExpression)argument).getReferenceName()) && (psiElement = ref.resolve()) instanceof PsiField) {
            PsiField field = (PsiField)psiElement;
            PsiClass cls = field.getContainingClass();
            return cls != null && "java.io.File".equals(cls.getQualifiedName());
        }
        return false;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/bugs/ReplaceAllDotInspection", "buildErrorString"));
    }

    private static class EscapeCharacterFix
    extends PsiUpdateModCommandQuickFix {
        private EscapeCharacterFix() {
        }

        @Nls(capitalization=Nls.Capitalization.Sentence)
        @NotNull
        public String getFamilyName() {
            String string = InspectionGadgetsBundle.message("replace.all.dot.quickfix", new Object[0]);
            if (string == null) {
                EscapeCharacterFix.$$$reportNull$$$0(0);
            }
            return string;
        }

        protected void applyFix(@NotNull Project project, @NotNull PsiElement element, @NotNull ModPsiUpdater updater) {
            if (project == null) {
                EscapeCharacterFix.$$$reportNull$$$0(1);
            }
            if (element == null) {
                EscapeCharacterFix.$$$reportNull$$$0(2);
            }
            if (updater == null) {
                EscapeCharacterFix.$$$reportNull$$$0(3);
            }
            if (!(element instanceof PsiLiteralExpression)) {
                return;
            }
            PsiLiteralExpression expression = (PsiLiteralExpression)element;
            String text = expression.getText();
            StringBuilder newExpression = new StringBuilder();
            int length = text.length();
            for (int i = 0; i < length; ++i) {
                char c = text.charAt(i);
                if (PatternUtil.containsMetaChar((String)String.valueOf(c))) {
                    newExpression.append("\\\\");
                }
                newExpression.append(c);
            }
            PsiReplacementUtil.replaceExpression((PsiExpression)expression, newExpression.toString());
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 2;
                case 1, 2, 3 -> 3;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/siyeh/ig/bugs/ReplaceAllDotInspection$EscapeCharacterFix";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "element";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "updater";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFamilyName";
                    break;
                }
                case 1: 
                case 2: 
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/siyeh/ig/bugs/ReplaceAllDotInspection$EscapeCharacterFix";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 1: 
                case 2: 
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "applyFix";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalStateException(string);
                case 1, 2, 3 -> new IllegalArgumentException(string);
            };
        }
    }

    private static class ReplaceAllDotVisitor
    extends BaseInspectionVisitor {
        private static final CallMatcher.Simple MATCHER = CallMatcher.instanceCall("java.lang.String", "replaceAll", "split");

        private ReplaceAllDotVisitor() {
        }

        public void visitMethodCallExpression(@NotNull PsiMethodCallExpression expression) {
            if (expression == null) {
                ReplaceAllDotVisitor.$$$reportNull$$$0(0);
            }
            super.visitMethodCallExpression(expression);
            if (!MATCHER.test(expression)) {
                return;
            }
            PsiExpression arg = (PsiExpression)ArrayUtil.getFirstElement((Object[])expression.getArgumentList().getExpressions());
            if (arg == null) {
                return;
            }
            ExpressionUtils.nonStructuralChildren(arg).forEach(argument -> {
                String value;
                if (PsiUtil.isConstantExpression((PsiExpression)argument) && ExpressionUtils.hasStringType(argument) && ReplaceAllDotVisitor.isRegexMetaChar(value = (String)ExpressionUtils.computeConstantExpression(argument), !this.isOnTheFly())) {
                    this.registerError((PsiElement)argument, expression, argument);
                }
                if (ReplaceAllDotInspection.isFileSeparator(argument)) {
                    this.registerError((PsiElement)argument, expression, argument);
                }
            });
        }

        private static boolean isRegexMetaChar(String s, boolean includeErrors) {
            return s != null && s.length() == 1 && (includeErrors ? PatternUtil.containsMetaChar((String)s) : ".$|^".contains(s));
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "com/siyeh/ig/bugs/ReplaceAllDotInspection$ReplaceAllDotVisitor", "visitMethodCallExpression"));
        }
    }
}

