/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.bugs;

import com.intellij.psi.PsiArrayAccessExpression;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionList;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiPolyadicExpression;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.util.PsiUtil;
import com.intellij.util.containers.ContainerUtil;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.psiutils.ExpressionUtils;
import com.siyeh.ig.psiutils.FormatUtils;
import org.jetbrains.annotations.NotNull;

public final class StringConcatenationInFormatCallInspection
extends BaseInspection {
    @Override
    @NotNull
    protected String buildErrorString(Object ... infos) {
        String string = InspectionGadgetsBundle.message("string.concatenation.in.format.call.problem.descriptor", infos[0]);
        if (string == null) {
            StringConcatenationInFormatCallInspection.$$$reportNull$$$0(0);
        }
        return string;
    }

    @Override
    @NotNull
    public BaseInspectionVisitor buildVisitor() {
        return new StringConcatenationInFormatCallVisitor();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/bugs/StringConcatenationInFormatCallInspection", "buildErrorString"));
    }

    private static class StringConcatenationInFormatCallVisitor
    extends BaseInspectionVisitor {
        private StringConcatenationInFormatCallVisitor() {
        }

        public void visitMethodCallExpression(@NotNull PsiMethodCallExpression call) {
            if (call == null) {
                StringConcatenationInFormatCallVisitor.$$$reportNull$$$0(0);
            }
            if (FormatUtils.isFormatCall(call)) {
                PsiExpressionList argumentList = call.getArgumentList();
                PsiExpression formatArgument = FormatUtils.getFormatArgument(argumentList);
                this.checkFormatString(call, formatArgument);
            }
            if (FormatUtils.STRING_FORMATTED.test(call)) {
                this.checkFormatString(call, call.getMethodExpression().getQualifierExpression());
            }
        }

        private void checkFormatString(PsiMethodCallExpression call, PsiExpression formatString) {
            if (!((formatString = PsiUtil.skipParenthesizedExprDown((PsiExpression)formatString)) instanceof PsiPolyadicExpression)) {
                return;
            }
            PsiPolyadicExpression polyadicExpression = (PsiPolyadicExpression)formatString;
            if (!ExpressionUtils.hasStringType(formatString)) {
                return;
            }
            if (PsiUtil.isConstantExpression((PsiExpression)formatString)) {
                return;
            }
            Object[] operands = polyadicExpression.getOperands();
            if (!ContainerUtil.exists((Object[])operands, o -> ExpressionUtils.nonStructuralChildren(o).anyMatch(c -> c instanceof PsiReferenceExpression || c instanceof PsiMethodCallExpression || c instanceof PsiArrayAccessExpression))) {
                return;
            }
            this.registerError((PsiElement)formatString, call.getMethodExpression().getReferenceName());
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "call", "com/siyeh/ig/bugs/StringConcatenationInFormatCallInspection$StringConcatenationInFormatCallVisitor", "visitMethodCallExpression"));
        }
    }
}

