/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.bugs;

import com.intellij.codeInspection.dataFlow.CommonDataflow;
import com.intellij.codeInspection.dataFlow.JavaMethodContractUtil;
import com.intellij.codeInspection.dataFlow.MethodContract;
import com.intellij.codeInspection.dataFlow.interpreter.RunnerResult;
import com.intellij.codeInspection.dataFlow.interpreter.StandardDataFlowInterpreter;
import com.intellij.codeInspection.dataFlow.java.ControlFlowAnalyzer;
import com.intellij.codeInspection.dataFlow.java.JavaDfaListener;
import com.intellij.codeInspection.dataFlow.jvm.JvmDfaMemoryStateImpl;
import com.intellij.codeInspection.dataFlow.jvm.descriptors.PlainDescriptor;
import com.intellij.codeInspection.dataFlow.jvm.descriptors.ThisDescriptor;
import com.intellij.codeInspection.dataFlow.lang.DfaListener;
import com.intellij.codeInspection.dataFlow.lang.ir.ControlFlow;
import com.intellij.codeInspection.dataFlow.memory.DfaMemoryState;
import com.intellij.codeInspection.dataFlow.rangeSet.LongRangeSet;
import com.intellij.codeInspection.dataFlow.types.DfIntType;
import com.intellij.codeInspection.dataFlow.types.DfLongType;
import com.intellij.codeInspection.dataFlow.value.DfaValue;
import com.intellij.codeInspection.dataFlow.value.DfaValueFactory;
import com.intellij.codeInspection.dataFlow.value.DfaVariableValue;
import com.intellij.psi.JavaRecursiveElementWalkingVisitor;
import com.intellij.psi.LambdaUtil;
import com.intellij.psi.PsiCallExpression;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiFunctionalExpression;
import com.intellij.psi.PsiLambdaExpression;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiParameterList;
import com.intellij.psi.PsiParameterListOwner;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiReturnStatement;
import com.intellij.psi.PsiStatement;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.psiutils.ControlFlowUtils;
import com.siyeh.ig.psiutils.ExpressionUtils;
import com.siyeh.ig.psiutils.MethodUtils;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import one.util.streamex.StreamEx;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class SuspiciousComparatorCompareInspection
extends BaseInspection {
    @Override
    @NotNull
    public String getShortName() {
        return "ComparatorMethodParameterNotUsed";
    }

    @Override
    @NotNull
    protected String buildErrorString(Object ... infos) {
        String string = (String)infos[0];
        if (string == null) {
            SuspiciousComparatorCompareInspection.$$$reportNull$$$0(0);
        }
        return string;
    }

    public boolean isEnabledByDefault() {
        return true;
    }

    @Override
    @NotNull
    public BaseInspectionVisitor buildVisitor() {
        return new SuspiciousComparatorCompareVisitor();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/bugs/SuspiciousComparatorCompareInspection", "buildErrorString"));
    }

    private static class SuspiciousComparatorCompareVisitor
    extends BaseInspectionVisitor {
        private SuspiciousComparatorCompareVisitor() {
        }

        public void visitMethod(@NotNull PsiMethod method) {
            if (method == null) {
                SuspiciousComparatorCompareVisitor.$$$reportNull$$$0(0);
            }
            super.visitMethod(method);
            if (MethodUtils.isComparatorCompare(method) && !ControlFlowUtils.methodAlwaysThrowsException(method)) {
                this.check((PsiParameterListOwner)method, false);
            }
            if (MethodUtils.isCompareTo(method) && !ControlFlowUtils.methodAlwaysThrowsException(method)) {
                this.check((PsiParameterListOwner)method, true);
            }
        }

        public void visitLambdaExpression(@NotNull PsiLambdaExpression lambda) {
            if (lambda == null) {
                SuspiciousComparatorCompareVisitor.$$$reportNull$$$0(1);
            }
            super.visitLambdaExpression(lambda);
            PsiClass functionalInterface = LambdaUtil.resolveFunctionalInterfaceClass((PsiFunctionalExpression)lambda);
            if (functionalInterface == null || !"java.util.Comparator".equals(functionalInterface.getQualifiedName()) || ControlFlowUtils.lambdaExpressionAlwaysThrowsException(lambda)) {
                return;
            }
            this.check((PsiParameterListOwner)lambda, false);
        }

        private void check(PsiParameterListOwner owner, boolean compareTo) {
            PsiParameterList psiParameterList;
            MethodContract contract;
            PsiStatement statement;
            int expectedParameters;
            PsiParameterList parameterList = owner.getParameterList();
            PsiElement body = owner.getBody();
            int n = expectedParameters = compareTo ? 1 : 2;
            if (body == null || parameterList.getParametersCount() != expectedParameters) {
                return;
            }
            if (body instanceof PsiExpression && ExpressionUtils.isZero((PsiExpression)body)) {
                return;
            }
            if (body instanceof PsiCodeBlock && (statement = ControlFlowUtils.getOnlyStatementInBlock((PsiCodeBlock)body)) instanceof PsiReturnStatement && ExpressionUtils.isZero(((PsiReturnStatement)statement).getReturnValue())) {
                return;
            }
            PsiMethodCallExpression soleCall = (PsiMethodCallExpression)ObjectUtils.tryCast((Object)LambdaUtil.extractSingleExpressionFromBody((PsiElement)body), PsiMethodCallExpression.class);
            if (soleCall != null && (contract = (MethodContract)ContainerUtil.getOnlyItem(JavaMethodContractUtil.getMethodCallContracts((PsiCallExpression)soleCall))) != null && contract.isTrivial() && contract.getReturnValue().isFail()) {
                return;
            }
            PsiParameter[] parameters = parameterList.getParameters();
            this.checkParameterList(parameters, body, compareTo ? "compareTo" : "compare");
            if (owner instanceof PsiMethod) {
                PsiMethod method = (PsiMethod)owner;
                psiParameterList = method.getNameIdentifier();
            } else {
                psiParameterList = parameterList;
            }
            this.checkReturnValueSanity((PsiElement)psiParameterList, body);
            this.checkReflexivity(owner, parameters, body);
            this.checkReturnMinValue(body);
        }

        private void checkReturnMinValue(PsiElement body) {
            StreamEx stream;
            if (body instanceof PsiExpression) {
                PsiExpression expression = (PsiExpression)body;
                stream = StreamEx.of((Object)expression);
            } else if (body instanceof PsiCodeBlock) {
                PsiCodeBlock block = (PsiCodeBlock)body;
                stream = StreamEx.of((Object[])PsiUtil.findReturnStatements((PsiCodeBlock)block)).map(PsiReturnStatement::getReturnValue).nonNull();
            } else {
                return;
            }
            stream.flatMap(ExpressionUtils::nonStructuralChildren).forEach(expr -> {
                Integer i;
                Object patt0$temp = ExpressionUtils.computeConstantExpression(expr);
                if (patt0$temp instanceof Integer && (i = (Integer)patt0$temp) == Integer.MIN_VALUE) {
                    this.registerError((PsiElement)expr, InspectionGadgetsBundle.message("suspicious.comparator.compare.descriptor.min.value", new Object[0]));
                }
            });
        }

        private void checkReturnValueSanity(PsiElement anchor, PsiElement body) {
            LongRangeSet range;
            if (body instanceof PsiExpression) {
                PsiExpression expression = (PsiExpression)body;
                range = DfLongType.extractRange(CommonDataflow.getDfType(expression));
            } else if (body instanceof PsiCodeBlock) {
                PsiCodeBlock block = (PsiCodeBlock)body;
                range = (LongRangeSet)StreamEx.of((Object[])PsiUtil.findReturnStatements((PsiCodeBlock)block)).map(PsiReturnStatement::getReturnValue).nonNull().map(CommonDataflow::getDfType).map(DfLongType::extractRange).reduce((Object)LongRangeSet.empty(), LongRangeSet::join);
            } else {
                return;
            }
            if (range.isEmpty() || range.equals(LongRangeSet.point((long)0L))) {
                return;
            }
            if (range.min() >= 0L) {
                this.registerError(anchor, InspectionGadgetsBundle.message("suspicious.comparator.compare.descriptor.non.negative", new Object[0]));
            } else if (range.max() <= 0L) {
                this.registerError(anchor, InspectionGadgetsBundle.message("suspicious.comparator.compare.descriptor.non.positive", new Object[0]));
            }
        }

        private void checkParameterList(PsiParameter[] parameters, PsiElement context, String methodName) {
            ParameterAccessVisitor visitor2 = new ParameterAccessVisitor(parameters);
            context.accept((PsiElementVisitor)visitor2);
            for (PsiParameter unusedParameter : visitor2.getUnusedParameters()) {
                this.registerVariableError((PsiVariable)unusedParameter, InspectionGadgetsBundle.message("suspicious.comparator.compare.descriptor.parameter.not.used", methodName));
            }
        }

        private void checkReflexivity(PsiParameterListOwner owner, PsiParameter[] parameters, PsiElement body) {
            DfaVariableValue var2;
            DfaValueFactory factory = new DfaValueFactory(owner.getProject());
            ControlFlow flow = ControlFlowAnalyzer.buildFlow(body, factory, true);
            if (flow == null) {
                return;
            }
            JvmDfaMemoryStateImpl state = new JvmDfaMemoryStateImpl(factory);
            DfaVariableValue var1 = PlainDescriptor.createVariableValue(factory, (PsiVariable)parameters[0]);
            if (parameters.length == 2) {
                var2 = PlainDescriptor.createVariableValue(factory, (PsiVariable)parameters[1]);
            } else {
                assert (owner instanceof PsiMethod);
                var2 = ThisDescriptor.createThisValue(factory, ((PsiMethod)owner).getContainingClass());
            }
            state.applyCondition(var1.eq((DfaValue)var2));
            ComparatorListener interceptor = new ComparatorListener(owner);
            if (new StandardDataFlowInterpreter(flow, (DfaListener)interceptor).interpret((DfaMemoryState)state) != RunnerResult.OK) {
                return;
            }
            if (interceptor.myRange.contains(0L) || interceptor.myContexts.isEmpty()) {
                return;
            }
            PsiElement context = null;
            if (interceptor.myContexts.size() == 1) {
                context = interceptor.myContexts.iterator().next();
            } else {
                PsiElement commonParent = PsiTreeUtil.findCommonParent((PsiElement[])interceptor.myContexts.toArray(PsiElement.EMPTY_ARRAY));
                if (commonParent instanceof PsiExpression) {
                    context = commonParent;
                } else {
                    PsiParameterListOwner parent = (PsiParameterListOwner)PsiTreeUtil.getParentOfType((PsiElement)body, (Class[])new Class[]{PsiMethod.class, PsiLambdaExpression.class});
                    if (parent instanceof PsiMethod) {
                        context = ((PsiMethod)parent).getNameIdentifier();
                    } else if (parent instanceof PsiLambdaExpression) {
                        context = parent.getParameterList();
                    }
                }
            }
            this.registerError(context != null ? context : body, InspectionGadgetsBundle.message("suspicious.comparator.compare.descriptor.non.reflexive", new Object[0]));
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "method";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "lambda";
                    break;
                }
            }
            objectArray2[1] = "com/siyeh/ig/bugs/SuspiciousComparatorCompareInspection$SuspiciousComparatorCompareVisitor";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "visitMethod";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "visitLambdaExpression";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }

        private static final class ParameterAccessVisitor
        extends JavaRecursiveElementWalkingVisitor {
            private final Set<PsiParameter> parameters;

            private ParameterAccessVisitor(PsiParameter @NotNull [] parameters) {
                if (parameters == null) {
                    ParameterAccessVisitor.$$$reportNull$$$0(0);
                }
                this.parameters = ContainerUtil.newHashSet((Object[])parameters);
            }

            public void visitReferenceExpression(@NotNull PsiReferenceExpression expression) {
                if (expression == null) {
                    ParameterAccessVisitor.$$$reportNull$$$0(1);
                }
                super.visitReferenceExpression(expression);
                if (expression.getQualifierExpression() != null) {
                    return;
                }
                PsiElement target = expression.resolve();
                if (!(target instanceof PsiParameter)) {
                    return;
                }
                PsiParameter parameter = (PsiParameter)target;
                this.parameters.remove(parameter);
                if (this.parameters.isEmpty()) {
                    this.stopWalking();
                }
            }

            private Collection<PsiParameter> getUnusedParameters() {
                return Collections.unmodifiableSet(this.parameters);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[3];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "parameters";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "expression";
                        break;
                    }
                }
                objectArray2[1] = "com/siyeh/ig/bugs/SuspiciousComparatorCompareInspection$SuspiciousComparatorCompareVisitor$ParameterAccessVisitor";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "<init>";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[2] = "visitReferenceExpression";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        }

        private static final class ComparatorListener
        implements JavaDfaListener {
            private final PsiParameterListOwner myOwner;
            private final Set<PsiElement> myContexts = new HashSet<PsiElement>();
            LongRangeSet myRange = LongRangeSet.empty();

            private ComparatorListener(PsiParameterListOwner owner) {
                this.myOwner = owner;
            }

            @Override
            public void beforeValueReturn(@NotNull DfaValue value, @Nullable PsiExpression expression, @NotNull PsiElement owner, @NotNull DfaMemoryState state) {
                if (value == null) {
                    ComparatorListener.$$$reportNull$$$0(0);
                }
                if (owner == null) {
                    ComparatorListener.$$$reportNull$$$0(1);
                }
                if (state == null) {
                    ComparatorListener.$$$reportNull$$$0(2);
                }
                if (owner != this.myOwner || expression == null) {
                    return;
                }
                this.myContexts.add((PsiElement)expression);
                this.myRange = this.myRange.join(DfIntType.extractRange(state.getDfType(value)));
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[0] = "value";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[0] = "owner";
                        break;
                    }
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[0] = "state";
                        break;
                    }
                }
                objectArray[1] = "com/siyeh/ig/bugs/SuspiciousComparatorCompareInspection$SuspiciousComparatorCompareVisitor$ComparatorListener";
                objectArray[2] = "beforeValueReturn";
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        }
    }
}

