/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.bugs;

import com.intellij.codeInsight.daemon.impl.analysis.JavaGenericsUtil;
import com.intellij.codeInspection.CommonQuickFixBundle;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.modcommand.ModPsiUpdater;
import com.intellij.modcommand.PsiUpdateModCommandQuickFix;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.GenericsUtil;
import com.intellij.psi.LambdaUtil;
import com.intellij.psi.PsiArrayType;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassObjectAccessExpression;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionList;
import com.intellij.psi.PsiInstanceOfExpression;
import com.intellij.psi.PsiLambdaExpression;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiMethodReferenceExpression;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiReferenceList;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeElement;
import com.intellij.psi.PsiTypeParameter;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.util.InheritanceUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.util.ObjectUtils;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.callMatcher.CallMatcher;
import com.siyeh.ig.psiutils.CommentTracker;
import com.siyeh.ig.psiutils.ExpressionUtils;
import com.siyeh.ig.psiutils.FunctionalExpressionUtils;
import com.siyeh.ig.psiutils.MethodCallUtils;
import com.siyeh.ig.psiutils.StreamApiUtil;
import com.siyeh.ig.psiutils.TypeUtils;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class SuspiciousToArrayCallInspection
extends BaseInspection {
    @Override
    @NotNull
    protected String buildErrorString(Object ... infos) {
        PsiType type = (PsiType)infos[0];
        PsiType foundType = (PsiType)infos[1];
        String string = InspectionGadgetsBundle.message("suspicious.to.array.call.problem.descriptor", type.getCanonicalText(), foundType.getCanonicalText());
        if (string == null) {
            SuspiciousToArrayCallInspection.$$$reportNull$$$0(0);
        }
        return string;
    }

    @Override
    @Nullable
    protected LocalQuickFix buildFix(Object ... infos) {
        return new SuspiciousToArrayCallFix((PsiType)infos[0], (Boolean)infos[2]);
    }

    public boolean isEnabledByDefault() {
        return true;
    }

    @Override
    @NotNull
    public BaseInspectionVisitor buildVisitor() {
        return new SuspiciousToArrayCallVisitor();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/bugs/SuspiciousToArrayCallInspection", "buildErrorString"));
    }

    private static class SuspiciousToArrayCallFix
    extends PsiUpdateModCommandQuickFix {
        @NonNls
        private final String myReplacement;
        @NonNls
        private final String myPresented;

        SuspiciousToArrayCallFix(PsiType wantedType, boolean isFunction) {
            if (wantedType instanceof PsiClassType) {
                wantedType = ((PsiClassType)wantedType).rawType();
            }
            if (isFunction) {
                this.myReplacement = wantedType.getCanonicalText() + "[]::new";
                this.myPresented = wantedType.getPresentableText() + "[]::new";
            } else {
                String index = StringUtil.repeat((String)"[0]", (int)(wantedType.getArrayDimensions() + 1));
                PsiType componentType = wantedType.getDeepComponentType();
                this.myReplacement = "new " + componentType.getCanonicalText() + index;
                this.myPresented = "new " + componentType.getPresentableText() + index;
            }
        }

        protected void applyFix(@NotNull Project project, @NotNull PsiElement startElement, @NotNull ModPsiUpdater updater) {
            PsiExpression expression;
            if (project == null) {
                SuspiciousToArrayCallFix.$$$reportNull$$$0(0);
            }
            if (startElement == null) {
                SuspiciousToArrayCallFix.$$$reportNull$$$0(1);
            }
            if (updater == null) {
                SuspiciousToArrayCallFix.$$$reportNull$$$0(2);
            }
            if ((expression = (PsiExpression)ObjectUtils.tryCast((Object)startElement, PsiExpression.class)) == null) {
                return;
            }
            new CommentTracker().replaceAndRestoreComments((PsiElement)expression, this.myReplacement);
        }

        @Nls(capitalization=Nls.Capitalization.Sentence)
        @NotNull
        public String getName() {
            String string = CommonQuickFixBundle.message((String)"fix.replace.with.x", (Object[])new Object[]{this.myPresented});
            if (string == null) {
                SuspiciousToArrayCallFix.$$$reportNull$$$0(3);
            }
            return string;
        }

        @Nls(capitalization=Nls.Capitalization.Sentence)
        @NotNull
        public String getFamilyName() {
            String string = InspectionGadgetsBundle.message("suspicious.to.array.call.fix.family.name", new Object[0]);
            if (string == null) {
                SuspiciousToArrayCallFix.$$$reportNull$$$0(4);
            }
            return string;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 3, 4 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "startElement";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "updater";
                    break;
                }
                case 3: 
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/siyeh/ig/bugs/SuspiciousToArrayCallInspection$SuspiciousToArrayCallFix";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/siyeh/ig/bugs/SuspiciousToArrayCallInspection$SuspiciousToArrayCallFix";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getName";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFamilyName";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "applyFix";
                    break;
                }
                case 3: 
                case 4: {
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 3, 4 -> new IllegalStateException(string);
            };
        }
    }

    private static class SuspiciousToArrayCallVisitor
    extends BaseInspectionVisitor {
        private static final CallMatcher STREAM_FILTER = CallMatcher.instanceCall("java.util.stream.Stream", "filter").parameterTypes("java.util.function.Predicate");
        private static final CallMatcher CLASS_INSTANCEOF = CallMatcher.instanceCall("java.lang.Class", "isInstance").parameterCount(1);

        private SuspiciousToArrayCallVisitor() {
        }

        public void visitMethodCallExpression(@NotNull PsiMethodCallExpression expression) {
            PsiType argumentType;
            if (expression == null) {
                SuspiciousToArrayCallVisitor.$$$reportNull$$$0(0);
            }
            super.visitMethodCallExpression(expression);
            PsiReferenceExpression methodExpression = expression.getMethodExpression();
            @NonNls String methodName = methodExpression.getReferenceName();
            if (!"toArray".equals(methodName)) {
                return;
            }
            PsiExpression qualifierExpression = methodExpression.getQualifierExpression();
            if (qualifierExpression == null) {
                return;
            }
            PsiClassType classType = (PsiClassType)ObjectUtils.tryCast((Object)qualifierExpression.getType(), PsiClassType.class);
            if (classType == null || classType.isRaw()) {
                return;
            }
            PsiExpressionList argumentList = expression.getArgumentList();
            PsiExpression[] arguments = argumentList.getExpressions();
            if (arguments.length != 1) {
                return;
            }
            PsiExpression argument = PsiUtil.skipParenthesizedExprDown((PsiExpression)arguments[0]);
            if (argument == null) {
                return;
            }
            PsiClass aClass = classType.resolve();
            if (aClass == null) {
                return;
            }
            if (InheritanceUtil.isInheritor((PsiClass)aClass, (String)"java.util.Collection")) {
                PsiType itemType = JavaGenericsUtil.getCollectionItemType((PsiType)classType, (GlobalSearchScope)expression.getResolveScope());
                PsiType argumentType2 = argument.getType();
                if (!(argumentType2 instanceof PsiArrayType)) {
                    argumentType2 = SuspiciousToArrayCallVisitor.getIntFunctionParameterType(argument);
                }
                this.checkArrayTypes(argument, expression, argumentType2, itemType);
            } else if (InheritanceUtil.isInheritor((PsiClass)aClass, (String)"java.util.stream.Stream") && (argumentType = SuspiciousToArrayCallVisitor.getIntFunctionParameterType(argument)) != null) {
                this.checkArrayTypes(argument, expression, argumentType, SuspiciousToArrayCallVisitor.getStreamElementType(qualifierExpression));
            }
        }

        @Nullable
        private static PsiType getStreamElementType(PsiExpression expression) {
            PsiMethodCallExpression call = (PsiMethodCallExpression)ObjectUtils.tryCast((Object)PsiUtil.skipParenthesizedExprDown((PsiExpression)expression), PsiMethodCallExpression.class);
            while (STREAM_FILTER.test(call)) {
                PsiTypeElement checkType;
                PsiExpression lambdaBody;
                PsiParameter[] parameters;
                PsiExpression predicate = PsiUtil.skipParenthesizedExprDown((PsiExpression)call.getArgumentList().getExpressions()[0]);
                if (predicate instanceof PsiMethodReferenceExpression) {
                    PsiExpression qualifier;
                    if (CLASS_INSTANCEOF.methodReferenceMatches((PsiMethodReferenceExpression)predicate) && (qualifier = PsiUtil.skipParenthesizedExprDown((PsiExpression)((PsiMethodReferenceExpression)predicate).getQualifierExpression())) instanceof PsiClassObjectAccessExpression) {
                        return ((PsiClassObjectAccessExpression)qualifier).getOperand().getType();
                    }
                } else if (predicate instanceof PsiLambdaExpression && (parameters = ((PsiLambdaExpression)predicate).getParameterList().getParameters()).length == 1 && (lambdaBody = PsiUtil.skipParenthesizedExprDown((PsiExpression)LambdaUtil.extractSingleExpressionFromBody((PsiElement)((PsiLambdaExpression)predicate).getBody()))) instanceof PsiInstanceOfExpression && ExpressionUtils.isReferenceTo(((PsiInstanceOfExpression)lambdaBody).getOperand(), (PsiVariable)parameters[0]) && (checkType = ((PsiInstanceOfExpression)lambdaBody).getCheckType()) != null) {
                    return checkType.getType();
                }
                call = MethodCallUtils.getQualifierMethodCall(call);
            }
            return StreamApiUtil.getStreamElementType(expression.getType(), false);
        }

        private static PsiType getIntFunctionParameterType(PsiExpression argument) {
            PsiType argumentType = FunctionalExpressionUtils.getFunctionalExpressionType(argument);
            return PsiUtil.substituteTypeParameter((PsiType)argumentType, (String)"java.util.function.IntFunction", (int)0, (boolean)false);
        }

        private void checkArrayTypes(@NotNull PsiExpression argument, @NotNull PsiMethodCallExpression expression, PsiType argumentType, PsiType itemType) {
            if (argument == null) {
                SuspiciousToArrayCallVisitor.$$$reportNull$$$0(1);
            }
            if (expression == null) {
                SuspiciousToArrayCallVisitor.$$$reportNull$$$0(2);
            }
            if (!(argumentType instanceof PsiArrayType)) {
                return;
            }
            PsiArrayType arrayType = (PsiArrayType)argumentType;
            PsiType componentType = arrayType.getComponentType();
            PsiType actualType = SuspiciousToArrayCallVisitor.getActualItemTypeIfMismatch(arrayType, expression, itemType);
            if (actualType != null) {
                this.registerError((PsiElement)argument, actualType, componentType, !(argument.getType() instanceof PsiArrayType));
            }
        }

        @Nullable
        private static PsiType getActualItemTypeIfMismatch(@NotNull PsiArrayType arrayType, @NotNull PsiMethodCallExpression expression, PsiType itemType) {
            PsiClass aClass;
            PsiReferenceList extendsList;
            PsiClassType[] types;
            if (arrayType == null) {
                SuspiciousToArrayCallVisitor.$$$reportNull$$$0(3);
            }
            if (expression == null) {
                SuspiciousToArrayCallVisitor.$$$reportNull$$$0(4);
            }
            itemType = GenericsUtil.getVariableTypeByExpressionType((PsiType)itemType);
            PsiType componentType = arrayType.getComponentType();
            if (itemType == null || componentType.isAssignableFrom(itemType)) {
                return null;
            }
            PsiClass componentClass = PsiUtil.resolveClassInClassTypeOnly((PsiType)componentType);
            if (componentClass instanceof PsiTypeParameter && ((types = (extendsList = ((PsiTypeParameter)componentClass).getExtendsList()).getReferencedTypes()).length == 0 || types.length == 1 && types[0].isAssignableFrom(itemType))) {
                return null;
            }
            if (itemType instanceof PsiClassType && (aClass = ((PsiClassType)itemType).resolve()) instanceof PsiTypeParameter) {
                PsiReferenceList extendsList2 = ((PsiTypeParameter)aClass).getExtendsList();
                PsiClassType[] types2 = extendsList2.getReferencedTypes();
                if (types2.length == 0) {
                    return TypeUtils.getObjectType((PsiElement)expression);
                }
                if (types2.length == 1) {
                    return types2[0];
                }
                return null;
            }
            return itemType;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "expression";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "argument";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "arrayType";
                    break;
                }
            }
            objectArray2[1] = "com/siyeh/ig/bugs/SuspiciousToArrayCallInspection$SuspiciousToArrayCallVisitor";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "visitMethodCallExpression";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "checkArrayTypes";
                    break;
                }
                case 3: 
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[2] = "getActualItemTypeIfMismatch";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

