/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.bugs;

import com.intellij.codeInspection.AbstractBaseJavaLocalInspectionTool;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.codeInspection.dataFlow.CommonDataflow;
import com.intellij.codeInspection.util.ChronoUtil;
import com.intellij.psi.JavaElementVisitor;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiEnumConstant;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.callMatcher.CallMatcher;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.StringJoiner;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class UnsupportedChronoFieldUnitCallInspection
extends AbstractBaseJavaLocalInspectionTool {
    private final CallMatcher myMatcher = CallMatcher.anyOf(ChronoUtil.CHRONO_ALL_GET_MATCHERS, ChronoUtil.CHRONO_PLUS_MINUS_MATCHERS, ChronoUtil.CHRONO_WITH_MATCHERS);

    @NotNull
    public PsiElementVisitor buildVisitor(final @NotNull ProblemsHolder holder, boolean isOnTheFly) {
        if (holder == null) {
            UnsupportedChronoFieldUnitCallInspection.$$$reportNull$$$0(0);
        }
        return new JavaElementVisitor(){

            public void visitMethodCallExpression(@NotNull PsiMethodCallExpression call) {
                PsiExpression[] expressions;
                String methodName;
                if (call == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (!("get".equals(methodName = call.getMethodExpression().getReferenceName()) || "getLong".equals(methodName) || "with".equals(methodName) || "plus".equals(methodName) || "minus".equals(methodName))) {
                    return;
                }
                if (!UnsupportedChronoFieldUnitCallInspection.this.myMatcher.test(call)) {
                    return;
                }
                PsiMethod method = call.resolveMethod();
                if (method == null) {
                    return;
                }
                int fieldArgumentIndex = 1;
                if ("get".equals(methodName) || "getLong".equals(methodName) || "with".equals(methodName)) {
                    fieldArgumentIndex = 0;
                }
                if ((expressions = call.getArgumentList().getExpressions()).length < fieldArgumentIndex + 1) {
                    return;
                }
                PsiExpression fieldExpression = expressions[fieldArgumentIndex];
                if (fieldExpression == null) {
                    return;
                }
                CommonDataflow.DataflowResult dataflowResult = CommonDataflow.getDataflowResult((PsiElement)fieldExpression);
                if (dataflowResult == null) {
                    return;
                }
                Set<Object> values = dataflowResult.getExpressionValues(fieldExpression);
                HashSet<PsiEnumConstant> enumConstants = new HashSet<PsiEnumConstant>();
                for (Object value : values) {
                    if (value instanceof PsiEnumConstant) {
                        PsiEnumConstant enumConstant = (PsiEnumConstant)value;
                        enumConstants.add(enumConstant);
                        continue;
                    }
                    return;
                }
                List<PsiEnumConstant> unsupportedEnums = 1.getUnsupportedEnums(enumConstants, method);
                if (unsupportedEnums == null) {
                    return;
                }
                if (!unsupportedEnums.isEmpty()) {
                    1.registerProblems(unsupportedEnums, fieldExpression, holder);
                }
            }

            private static void registerProblems(@NotNull List<PsiEnumConstant> enums, @NotNull PsiExpression expression, @NotNull ProblemsHolder holder2) {
                if (enums == null) {
                    1.$$$reportNull$$$0(1);
                }
                if (expression == null) {
                    1.$$$reportNull$$$0(2);
                }
                if (holder2 == null) {
                    1.$$$reportNull$$$0(3);
                }
                StringJoiner joiner = new StringJoiner(", ");
                enums.forEach(enumName -> joiner.add("'" + enumName.getName() + "'"));
                String description = enums.size() == 1 ? InspectionGadgetsBundle.message("inspection.unsupported.chrono.value.message", joiner.toString()) : InspectionGadgetsBundle.message("inspection.unsupported.chrono.values.message", joiner.toString());
                holder2.registerProblem((PsiElement)expression, description, new LocalQuickFix[0]);
            }

            @Nullable
            private static List<PsiEnumConstant> getUnsupportedEnums(Set<PsiEnumConstant> constants, PsiMethod method) {
                String methodName = method.getName();
                ArrayList<PsiEnumConstant> result = new ArrayList<PsiEnumConstant>();
                for (PsiEnumConstant enumConstant : constants) {
                    PsiClass containingClass = enumConstant.getContainingClass();
                    if (containingClass == null || !containingClass.isEnum()) {
                        return null;
                    }
                    String classQualifiedName = containingClass.getQualifiedName();
                    if (!("java.time.temporal.ChronoField".equals(classQualifiedName) && (methodName.equals("get") || methodName.equals("getLong") || methodName.equals("with")) || "java.time.temporal.ChronoUnit".equals(classQualifiedName) || !methodName.equals("plus") && !methodName.equals("minus"))) {
                        return null;
                    }
                    String enumConstantName = enumConstant.getName();
                    switch (methodName) {
                        case "get": 
                        case "getLong": {
                            if (ChronoUtil.isAnyGetSupported(method, ChronoUtil.getChronoField(enumConstantName))) break;
                            result.add(enumConstant);
                            break;
                        }
                        case "with": {
                            if (ChronoUtil.isWithSupported(method, ChronoUtil.getChronoField(enumConstantName))) break;
                            result.add(enumConstant);
                            break;
                        }
                        case "plus": 
                        case "minus": {
                            if (ChronoUtil.isPlusMinusSupported(method, ChronoUtil.getChronoUnit(enumConstantName))) break;
                            result.add(enumConstant);
                        }
                    }
                }
                return result;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[3];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "call";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "enums";
                        break;
                    }
                    case 2: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "expression";
                        break;
                    }
                    case 3: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "holder";
                        break;
                    }
                }
                objectArray2[1] = "com/siyeh/ig/bugs/UnsupportedChronoFieldUnitCallInspection$1";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "visitMethodCallExpression";
                        break;
                    }
                    case 1: 
                    case 2: 
                    case 3: {
                        objectArray = objectArray2;
                        objectArray2[2] = "registerProblems";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        };
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "holder", "com/siyeh/ig/bugs/UnsupportedChronoFieldUnitCallInspection", "buildVisitor"));
    }
}

