/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.callMatcher;

import com.intellij.openapi.util.text.StringUtil;
import com.intellij.pom.java.LanguageLevel;
import com.intellij.psi.PsiCall;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionList;
import com.intellij.psi.PsiImportList;
import com.intellij.psi.PsiImportStatementBase;
import com.intellij.psi.PsiImportStaticStatement;
import com.intellij.psi.PsiJavaFile;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiMethodReferenceExpression;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiParameterList;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiType;
import com.intellij.psi.util.ImportsUtil;
import com.intellij.psi.util.InheritanceUtil;
import com.intellij.psi.util.PsiTypesUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.util.ArrayUtilRt;
import com.intellij.util.ObjectUtils;
import com.siyeh.ig.psiutils.MethodCallUtils;
import java.lang.invoke.LambdaMetafactory;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import one.util.streamex.StreamEx;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.uast.UCallExpression;
import org.jetbrains.uast.UCallableReferenceExpression;

public interface CallMatcher
extends Predicate<PsiMethodCallExpression> {
    public Stream<String> names();

    @Contract(value="null -> false", pure=true)
    public boolean methodReferenceMatches(PsiMethodReferenceExpression var1);

    @Override
    @Contract(value="null -> false", pure=true)
    public boolean test(@Nullable PsiMethodCallExpression var1);

    @Contract(value="null -> false", pure=true)
    public boolean methodMatches(@Nullable PsiMethod var1);

    @Contract(value="null -> false", pure=true)
    public boolean uCallMatches(@Nullable UCallExpression var1);

    @Contract(value="null -> false", pure=true)
    public boolean uCallableReferenceMatches(@Nullable UCallableReferenceExpression var1);

    @Contract(value="null -> false", pure=true)
    default public boolean matches(@Nullable PsiExpression expression) {
        return (expression = PsiUtil.skipParenthesizedExprDown((PsiExpression)expression)) instanceof PsiMethodCallExpression && this.test((PsiMethodCallExpression)expression);
    }

    public static CallMatcher none() {
        return new CallMatcher(){

            @Override
            public Stream<String> names() {
                return Stream.empty();
            }

            @Override
            public boolean methodReferenceMatches(PsiMethodReferenceExpression methodRef) {
                return false;
            }

            @Override
            public boolean test(@Nullable PsiMethodCallExpression call) {
                return false;
            }

            @Override
            public boolean methodMatches(@Nullable PsiMethod method) {
                return false;
            }

            @Override
            public boolean uCallMatches(@Nullable UCallExpression call) {
                return false;
            }

            @Override
            public boolean uCallableReferenceMatches(@Nullable UCallableReferenceExpression reference) {
                return false;
            }
        };
    }

    public static CallMatcher anyOf(final CallMatcher ... matchers) {
        if (matchers.length == 0) {
            return CallMatcher.none();
        }
        if (matchers.length == 1) {
            return matchers[0];
        }
        return new CallMatcher(){

            @Override
            public Stream<String> names() {
                return Stream.of(matchers).flatMap(CallMatcher::names).distinct();
            }

            @Override
            public boolean methodReferenceMatches(PsiMethodReferenceExpression methodRef) {
                for (CallMatcher m : matchers) {
                    if (!m.methodReferenceMatches(methodRef)) continue;
                    return true;
                }
                return false;
            }

            @Override
            public boolean methodMatches(PsiMethod method) {
                for (CallMatcher m : matchers) {
                    if (!m.methodMatches(method)) continue;
                    return true;
                }
                return false;
            }

            @Override
            public boolean uCallMatches(@Nullable UCallExpression call) {
                for (CallMatcher m : matchers) {
                    if (!m.uCallMatches(call)) continue;
                    return true;
                }
                return false;
            }

            @Override
            public boolean uCallableReferenceMatches(@Nullable UCallableReferenceExpression reference) {
                for (CallMatcher m : matchers) {
                    if (!m.uCallableReferenceMatches(reference)) continue;
                    return true;
                }
                return false;
            }

            @Override
            public boolean test(PsiMethodCallExpression call) {
                for (CallMatcher m : matchers) {
                    if (!m.test(call)) continue;
                    return true;
                }
                return false;
            }

            public String toString() {
                return Stream.of(matchers).map((Function<CallMatcher, String>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, toString(), (Lcom/siyeh/ig/callMatcher/CallMatcher;)Ljava/lang/String;)()).collect(Collectors.joining(" or ", "{", "}"));
            }
        };
    }

    @Contract(pure=true)
    public static Simple instanceCall(@NotNull @NonNls String className, String ... methodNames) {
        if (className == null) {
            CallMatcher.$$$reportNull$$$0(0);
        }
        return new Simple(className, Set.of(methodNames), null, CallType.INSTANCE);
    }

    @Contract(pure=true)
    public static Simple exactInstanceCall(@NotNull @NonNls String className, String ... methodNames) {
        if (className == null) {
            CallMatcher.$$$reportNull$$$0(1);
        }
        return new Simple(className, Set.of(methodNames), null, CallType.EXACT_INSTANCE);
    }

    @Contract(pure=true)
    public static Simple staticCall(@NotNull @NonNls String className, String ... methodNames) {
        if (className == null) {
            CallMatcher.$$$reportNull$$$0(2);
        }
        return new Simple(className, Set.of(methodNames), null, CallType.STATIC);
    }

    public static Simple enumValues() {
        return Simple.ENUM_VALUES;
    }

    public static Simple enumValueOf() {
        return Simple.ENUM_VALUE_OF;
    }

    @Contract(pure=true)
    @Nullable
    default public PsiReferenceExpression getReferenceIfMatched(PsiExpression expression) {
        if (expression instanceof PsiMethodReferenceExpression && this.methodReferenceMatches((PsiMethodReferenceExpression)expression)) {
            return (PsiReferenceExpression)expression;
        }
        if (expression instanceof PsiMethodCallExpression && this.test((PsiMethodCallExpression)expression)) {
            return ((PsiMethodCallExpression)expression).getMethodExpression();
        }
        return null;
    }

    @Contract(pure=true)
    default public CallMatcher withContextFilter(final @NotNull Predicate<? super PsiElement> filter) {
        if (filter == null) {
            CallMatcher.$$$reportNull$$$0(3);
        }
        return new CallMatcher(){

            @Override
            public Stream<String> names() {
                return CallMatcher.this.names();
            }

            @Override
            public boolean methodReferenceMatches(PsiMethodReferenceExpression methodRef) {
                if (methodRef == null || !filter.test(methodRef)) {
                    return false;
                }
                return CallMatcher.this.methodReferenceMatches(methodRef);
            }

            @Override
            public boolean test(@Nullable PsiMethodCallExpression call) {
                if (call == null || !filter.test(call)) {
                    return false;
                }
                return CallMatcher.this.test(call);
            }

            @Override
            public boolean methodMatches(@Nullable PsiMethod method) {
                if (method == null || !filter.test(method)) {
                    return false;
                }
                return CallMatcher.this.methodMatches(method);
            }

            @Override
            public boolean uCallMatches(@Nullable UCallExpression call) {
                if (call == null || !filter.test(call.getSourcePsi())) {
                    return false;
                }
                return CallMatcher.this.uCallMatches(call);
            }

            @Override
            public boolean uCallableReferenceMatches(@Nullable UCallableReferenceExpression reference) {
                if (reference == null || !filter.test(reference.getSourcePsi())) {
                    return false;
                }
                return CallMatcher.this.uCallableReferenceMatches(reference);
            }

            public String toString() {
                return CallMatcher.this.toString();
            }
        };
    }

    @Contract(pure=true)
    default public CallMatcher withLanguageLevelAtLeast(@NotNull LanguageLevel level) {
        if (level == null) {
            CallMatcher.$$$reportNull$$$0(4);
        }
        return this.withContextFilter(element -> PsiUtil.getLanguageLevel((PsiElement)element).isAtLeast(level));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "className";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "filter";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "level";
                break;
            }
        }
        objectArray2[1] = "com/siyeh/ig/callMatcher/CallMatcher";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "instanceCall";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "exactInstanceCall";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "staticCall";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "withContextFilter";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "withLanguageLevelAtLeast";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    public static final class Simple
    implements CallMatcher {
        static final Simple ENUM_VALUES = new Simple("", Collections.singleton("values"), ArrayUtilRt.EMPTY_STRING_ARRAY, CallType.ENUM_STATIC);
        static final Simple ENUM_VALUE_OF = new Simple("", Collections.singleton("valueOf"), new String[]{"java.lang.String"}, CallType.ENUM_STATIC);
        @NotNull
        private final String myClassName;
        @NotNull
        private final Set<String> myNames;
        private final String @Nullable [] myParameters;
        private final CallType myCallType;

        private Simple(@NotNull String className, @NotNull Set<String> names, String @Nullable [] parameters, CallType callType) {
            if (className == null) {
                Simple.$$$reportNull$$$0(0);
            }
            if (names == null) {
                Simple.$$$reportNull$$$0(1);
            }
            this.myClassName = className;
            this.myNames = names;
            this.myParameters = parameters;
            this.myCallType = callType;
        }

        public CallMatcher allowStaticUnresolved() {
            return new UnresolvedStaticCallMatcher();
        }

        @Override
        public Stream<String> names() {
            return this.myNames.stream();
        }

        @Contract(pure=true)
        public Simple parameterCount(int count) {
            if (this.myParameters != null) {
                throw new IllegalStateException("Parameter count is already set to " + count);
            }
            return new Simple(this.myClassName, this.myNames, count == 0 ? ArrayUtilRt.EMPTY_STRING_ARRAY : new String[count], this.myCallType);
        }

        @Contract(pure=true)
        public Simple parameterTypes(String ... types) {
            if (types == null) {
                Simple.$$$reportNull$$$0(2);
            }
            if (this.myParameters != null) {
                throw new IllegalStateException("Parameters are already registered");
            }
            return new Simple(this.myClassName, this.myNames, types.length == 0 ? ArrayUtilRt.EMPTY_STRING_ARRAY : (String[])types.clone(), this.myCallType);
        }

        private static boolean parameterTypeMatches(String type, PsiParameter parameter) {
            if (type == null) {
                return true;
            }
            PsiType psiType = parameter.getType();
            return psiType.equalsToText(type) || PsiTypesUtil.classNameEquals((PsiType)psiType, (String)type);
        }

        private static boolean expressionTypeMatches(@Nullable String type, @NotNull PsiExpression argument) {
            PsiType psiType;
            if (argument == null) {
                Simple.$$$reportNull$$$0(3);
            }
            if (type == null) {
                return true;
            }
            if (type.endsWith("...")) {
                type = type.substring(0, type.length() - 3);
            }
            if ((psiType = argument.getType()) == null) {
                return false;
            }
            return psiType.equalsToText(type) || PsiTypesUtil.classNameEquals((PsiType)psiType, (String)type) || "java.lang.Object".equals(type) || !"java.lang.String".equals(type) && InheritanceUtil.isInheritor((PsiType)psiType, (String)type);
        }

        @Override
        @Contract(pure=true)
        public boolean methodReferenceMatches(PsiMethodReferenceExpression methodRef) {
            if (methodRef == null) {
                return false;
            }
            String name = methodRef.getReferenceName();
            if (name == null || !this.myNames.contains(name)) {
                return false;
            }
            PsiMethod method = (PsiMethod)ObjectUtils.tryCast((Object)methodRef.resolve(), PsiMethod.class);
            return this.methodMatches(method);
        }

        @Override
        @Contract(value="null -> false", pure=true)
        public boolean test(PsiMethodCallExpression call) {
            if (call == null) {
                return false;
            }
            String name = call.getMethodExpression().getReferenceName();
            if (name == null || !this.myNames.contains(name)) {
                return false;
            }
            PsiExpression[] args = call.getArgumentList().getExpressions();
            if (this.myParameters != null && this.myParameters.length > 0 && args.length < this.myParameters.length - 1) {
                return false;
            }
            PsiMethod method = call.resolveMethod();
            if (method == null) {
                return false;
            }
            PsiParameterList parameterList = method.getParameterList();
            int count = parameterList.getParametersCount();
            if (count > args.length + 1 || !MethodCallUtils.isVarArgCall((PsiCall)call) && count != args.length) {
                return false;
            }
            return this.methodMatches(method);
        }

        private boolean parametersMatch(@NotNull PsiParameterList parameterList) {
            if (parameterList == null) {
                Simple.$$$reportNull$$$0(4);
            }
            if (this.myParameters == null) {
                return true;
            }
            if (this.myParameters.length != parameterList.getParametersCount()) {
                return false;
            }
            return StreamEx.zip((Object[])this.myParameters, (Object[])parameterList.getParameters(), Simple::parameterTypeMatches).allMatch(Boolean.TRUE::equals);
        }

        private boolean unresolvedArgumentListMatch(@NotNull PsiExpressionList expressionList) {
            String lastParameter;
            if (expressionList == null) {
                Simple.$$$reportNull$$$0(5);
            }
            if (this.myParameters == null) {
                return true;
            }
            PsiExpression[] args = expressionList.getExpressions();
            if (this.myParameters.length == 0 && args.length != 0) {
                return false;
            }
            if (this.myParameters.length > 0 && ((lastParameter = this.myParameters[this.myParameters.length - 1]) != null && lastParameter.endsWith("...") ? args.length < this.myParameters.length - 1 : args.length != this.myParameters.length)) {
                return false;
            }
            for (int i = 0; i < args.length; ++i) {
                PsiExpression arg;
                String parameter = i < this.myParameters.length ? this.myParameters[i] : this.myParameters[this.myParameters.length - 1];
                if (Simple.expressionTypeMatches(parameter, arg = args[i]) || this.myParameters.length - 1 == i && args.length == this.myParameters.length && parameter.endsWith("...") && Simple.expressionTypeMatches(parameter.substring(0, parameter.length() - 3) + "[]", arg)) continue;
                return false;
            }
            return true;
        }

        @Override
        @Contract(value="null -> false", pure=true)
        public boolean methodMatches(@Nullable PsiMethod method) {
            if (method == null) {
                return false;
            }
            if (!this.myNames.contains(method.getName())) {
                return false;
            }
            PsiClass aClass = method.getContainingClass();
            if (aClass == null) {
                return false;
            }
            return this.myCallType.matches(aClass, this.myClassName, method.hasModifierProperty("static")) && this.parametersMatch(method.getParameterList());
        }

        @Override
        @Contract(value="null -> false", pure=true)
        public boolean uCallMatches(@Nullable UCallExpression call) {
            if (call == null) {
                return false;
            }
            if (!call.isMethodNameOneOf(this.myNames)) {
                return false;
            }
            return this.methodMatches(call.resolve());
        }

        @Override
        @Contract(value="null -> false", pure=true)
        public boolean uCallableReferenceMatches(@Nullable UCallableReferenceExpression reference) {
            if (reference == null) {
                return false;
            }
            String name = reference.getCallableName();
            if (!this.myNames.contains(name)) {
                return false;
            }
            PsiMethod method = (PsiMethod)ObjectUtils.tryCast((Object)reference.resolve(), PsiMethod.class);
            return this.methodMatches(method);
        }

        public String toString() {
            return this.myClassName + "." + String.join((CharSequence)"|", this.myNames);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "className";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "names";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "types";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "argument";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "parameterList";
                    break;
                }
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "expressionList";
                    break;
                }
            }
            objectArray2[1] = "com/siyeh/ig/callMatcher/CallMatcher$Simple";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "parameterTypes";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[2] = "expressionTypeMatches";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[2] = "parametersMatch";
                    break;
                }
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[2] = "unresolvedArgumentListMatch";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }

        private class UnresolvedStaticCallMatcher
        implements CallMatcher {
            private UnresolvedStaticCallMatcher() {
            }

            @Override
            public Stream<String> names() {
                return Simple.this.names();
            }

            @Override
            public boolean methodReferenceMatches(PsiMethodReferenceExpression methodRef) {
                throw new UnsupportedOperationException("PsiMethodReferenceExpression is not supported");
            }

            @Override
            public boolean test(@Nullable PsiMethodCallExpression call) {
                if (Simple.this.test(call)) {
                    return true;
                }
                if (call == null) {
                    return false;
                }
                String name = call.getMethodExpression().getReferenceName();
                if (name == null || !Simple.this.myNames.contains(name)) {
                    return false;
                }
                if (!Simple.this.unresolvedArgumentListMatch(call.getArgumentList())) {
                    return false;
                }
                PsiMethod method = call.resolveMethod();
                if (method != null) {
                    return false;
                }
                return this.qualifierMatch(call.getMethodExpression().getQualifierExpression(), call);
            }

            private boolean qualifierMatch(@Nullable PsiExpression expression, @NotNull PsiMethodCallExpression call) {
                PsiReferenceExpression currentQualifier;
                if (call == null) {
                    UnresolvedStaticCallMatcher.$$$reportNull$$$0(0);
                }
                StringBuilder referenceName = new StringBuilder();
                if (expression instanceof PsiReferenceExpression) {
                    String nextReferenceName;
                    PsiReferenceExpression qualifierRefExpression;
                    currentQualifier = qualifierRefExpression = (PsiReferenceExpression)expression;
                    while ((nextReferenceName = currentQualifier.getReferenceName()) != null) {
                        PsiReferenceExpression referenceExpression;
                        if (referenceName.isEmpty()) {
                            referenceName = new StringBuilder(nextReferenceName);
                        } else {
                            referenceName.insert(0, nextReferenceName + ".");
                        }
                        PsiExpression psiExpression = currentQualifier.getQualifierExpression();
                        if (!(psiExpression instanceof PsiReferenceExpression)) break;
                        currentQualifier = referenceExpression = (PsiReferenceExpression)psiExpression;
                    }
                }
                if (Simple.this.myClassName.contentEquals(referenceName)) {
                    return true;
                }
                if (Simple.this.myClassName.equals("java.lang." + String.valueOf(referenceName))) {
                    return true;
                }
                currentQualifier = call.getContainingFile();
                if (!(currentQualifier instanceof PsiJavaFile)) {
                    return false;
                }
                PsiJavaFile javaFile = (PsiJavaFile)currentQualifier;
                if (javaFile.getPackageStatement() != null && Simple.this.myClassName.equals(javaFile.getPackageStatement().getPackageName() + "." + String.valueOf(referenceName))) {
                    return true;
                }
                ArrayList<PsiImportStatementBase> importStatements = new ArrayList<PsiImportStatementBase>(ImportsUtil.getAllImplicitImports((PsiJavaFile)javaFile));
                PsiImportList importList = javaFile.getImportList();
                if (importList != null) {
                    importStatements.addAll(List.of(importList.getAllImportStatements()));
                }
                for (PsiImportStatementBase statement : importStatements) {
                    String staticReference;
                    String shortName;
                    if (!(statement instanceof PsiImportStaticStatement)) continue;
                    PsiImportStaticStatement staticStatement = (PsiImportStaticStatement)statement;
                    if (staticStatement.isOnDemand() && staticStatement.getImportReference() != null) {
                        if (Simple.this.myClassName.equals(staticStatement.getImportReference().getQualifiedName() + "." + String.valueOf(referenceName))) {
                            return true;
                        }
                        if (referenceName.isEmpty() && Simple.this.myClassName.equals(staticStatement.getImportReference().getQualifiedName())) {
                            return true;
                        }
                    }
                    if (staticStatement.isOnDemand() || staticStatement.getImportReference() == null || !(shortName = StringUtil.getShortName((String)(staticReference = staticStatement.getImportReference().getQualifiedName()))).contentEquals(referenceName) && !referenceName.toString().startsWith(shortName + ".") || !Simple.this.myClassName.equals(StringUtil.getPackageName((String)staticReference) + "." + String.valueOf(referenceName))) continue;
                    return true;
                }
                return false;
            }

            @Override
            public boolean methodMatches(@Nullable PsiMethod method) {
                throw new UnsupportedOperationException("PsiMethod is not supported");
            }

            @Override
            public boolean uCallMatches(@Nullable UCallExpression call) {
                throw new UnsupportedOperationException("UCallExpression is not supported");
            }

            @Override
            public boolean uCallableReferenceMatches(@Nullable UCallableReferenceExpression reference) {
                throw new UnsupportedOperationException("UCallableReferenceExpression is not supported");
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "call", "com/siyeh/ig/callMatcher/CallMatcher$Simple$UnresolvedStaticCallMatcher", "qualifierMatch"));
            }
        }
    }

    public static enum CallType {
        STATIC{

            @Override
            boolean matches(PsiClass aClass, String className, boolean isStatic) {
                return isStatic && className.equals(aClass.getQualifiedName());
            }
        }
        ,
        ENUM_STATIC{

            @Override
            boolean matches(PsiClass aClass, String className, boolean isStatic) {
                return isStatic && aClass.isEnum();
            }
        }
        ,
        INSTANCE{

            @Override
            boolean matches(PsiClass aClass, String className, boolean isStatic) {
                return !isStatic && InheritanceUtil.isInheritor((PsiClass)aClass, (String)className);
            }
        }
        ,
        EXACT_INSTANCE{

            @Override
            boolean matches(PsiClass aClass, String className, boolean isStatic) {
                return !isStatic && className.equals(aClass.getQualifiedName());
            }
        };


        abstract boolean matches(PsiClass var1, String var2, boolean var3);
    }
}

