/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.classlayout;

import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiModifierListOwner;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.fixes.RemoveModifierFix;
import com.siyeh.ig.psiutils.SealedUtils;
import org.jetbrains.annotations.NotNull;

public final class FinalClassInspection
extends BaseInspection {
    @Override
    @NotNull
    protected String buildErrorString(Object ... infos) {
        PsiClass aClass = (PsiClass)infos[1];
        String string = InspectionGadgetsBundle.message("final.class.problem.descriptor", aClass.getName());
        if (string == null) {
            FinalClassInspection.$$$reportNull$$$0(0);
        }
        return string;
    }

    @Override
    @NotNull
    public BaseInspectionVisitor buildVisitor() {
        return new FinalClassVisitor();
    }

    @Override
    public LocalQuickFix buildFix(Object ... infos) {
        return new RemoveModifierFix((String)infos[0]);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/classlayout/FinalClassInspection", "buildErrorString"));
    }

    private static class FinalClassVisitor
    extends BaseInspectionVisitor {
        private FinalClassVisitor() {
        }

        public void visitClass(@NotNull PsiClass aClass) {
            if (aClass == null) {
                FinalClassVisitor.$$$reportNull$$$0(0);
            }
            if (!aClass.hasModifierProperty("final")) {
                return;
            }
            if (SealedUtils.hasSealedParent(aClass)) {
                return;
            }
            this.registerModifierError("final", (PsiModifierListOwner)aClass, "final", aClass);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "aClass", "com/siyeh/ig/classlayout/FinalClassInspection$FinalClassVisitor", "visitClass"));
        }
    }
}

