/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.classlayout;

import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.modcommand.ModPsiUpdater;
import com.intellij.modcommand.PsiUpdateModCommandQuickFix;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiModifierList;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiParameterList;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.fixes.RemoveModifierFix;
import com.siyeh.ig.psiutils.SerializationUtils;
import java.util.ArrayList;
import org.jetbrains.annotations.NotNull;

public final class PublicConstructorInNonPublicClassInspection
extends BaseInspection {
    @Override
    @NotNull
    public String buildErrorString(Object ... infos) {
        PsiMethod method = (PsiMethod)infos[0];
        String string = InspectionGadgetsBundle.message("public.constructor.in.non.public.class.problem.descriptor", method.getName());
        if (string == null) {
            PublicConstructorInNonPublicClassInspection.$$$reportNull$$$0(0);
        }
        return string;
    }

    @Override
    @NotNull
    public BaseInspectionVisitor buildVisitor() {
        return new PublicConstructorInNonPublicClassVisitor();
    }

    @Override
    public LocalQuickFix @NotNull [] buildFixes(Object ... infos) {
        ArrayList<PsiUpdateModCommandQuickFix> fixes = new ArrayList<PsiUpdateModCommandQuickFix>();
        PsiMethod constructor = (PsiMethod)infos[0];
        PsiClass aClass = constructor.getContainingClass();
        if (aClass != null && aClass.hasModifierProperty("private")) {
            fixes.add(new MakeConstructorPrivateFix());
        }
        fixes.add(new RemoveModifierFix("public"));
        LocalQuickFix[] localQuickFixArray = fixes.toArray(LocalQuickFix.EMPTY_ARRAY);
        if (localQuickFixArray == null) {
            PublicConstructorInNonPublicClassInspection.$$$reportNull$$$0(1);
        }
        return localQuickFixArray;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[2];
        objectArray2[0] = "com/siyeh/ig/classlayout/PublicConstructorInNonPublicClassInspection";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "buildErrorString";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "buildFixes";
                break;
            }
        }
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
    }

    private static class PublicConstructorInNonPublicClassVisitor
    extends BaseInspectionVisitor {
        private PublicConstructorInNonPublicClassVisitor() {
        }

        public void visitMethod(@NotNull PsiMethod method) {
            PsiParameterList parameterList;
            if (method == null) {
                PublicConstructorInNonPublicClassVisitor.$$$reportNull$$$0(0);
            }
            if (!method.isConstructor()) {
                return;
            }
            if (!method.hasModifierProperty("public")) {
                return;
            }
            PsiClass containingClass = method.getContainingClass();
            if (containingClass == null) {
                return;
            }
            if (containingClass.hasModifierProperty("public") || containingClass.hasModifierProperty("protected")) {
                return;
            }
            if (SerializationUtils.isExternalizable(containingClass) && (parameterList = method.getParameterList()).isEmpty()) {
                return;
            }
            this.registerModifierError("public", (PsiModifierListOwner)method, method);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "method", "com/siyeh/ig/classlayout/PublicConstructorInNonPublicClassInspection$PublicConstructorInNonPublicClassVisitor", "visitMethod"));
        }
    }

    private static class MakeConstructorPrivateFix
    extends PsiUpdateModCommandQuickFix {
        private MakeConstructorPrivateFix() {
        }

        @NotNull
        public String getFamilyName() {
            String string = InspectionGadgetsBundle.message("public.constructor.in.non.public.class.quickfix", new Object[0]);
            if (string == null) {
                MakeConstructorPrivateFix.$$$reportNull$$$0(0);
            }
            return string;
        }

        protected void applyFix(@NotNull Project project, @NotNull PsiElement element, @NotNull ModPsiUpdater updater) {
            if (project == null) {
                MakeConstructorPrivateFix.$$$reportNull$$$0(1);
            }
            if (element == null) {
                MakeConstructorPrivateFix.$$$reportNull$$$0(2);
            }
            if (updater == null) {
                MakeConstructorPrivateFix.$$$reportNull$$$0(3);
            }
            ((PsiModifierList)element.getParent()).setModifierProperty("private", true);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 2;
                case 1, 2, 3 -> 3;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/siyeh/ig/classlayout/PublicConstructorInNonPublicClassInspection$MakeConstructorPrivateFix";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "element";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "updater";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFamilyName";
                    break;
                }
                case 1: 
                case 2: 
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/siyeh/ig/classlayout/PublicConstructorInNonPublicClassInspection$MakeConstructorPrivateFix";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 1: 
                case 2: 
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "applyFix";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalStateException(string);
                case 1, 2, 3 -> new IllegalArgumentException(string);
            };
        }
    }
}

