/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.classlayout;

import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.options.OptPane;
import com.intellij.codeInspection.options.OptRegularComponent;
import com.intellij.psi.PsiField;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.fixes.MakeFieldFinalFix;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class StaticNonFinalFieldInspection
extends BaseInspection {
    public boolean ignoreNonPublicFields = true;

    @Override
    @NotNull
    protected String buildErrorString(Object ... infos) {
        String string = InspectionGadgetsBundle.message("static.non.final.field.problem.descriptor", new Object[0]);
        if (string == null) {
            StaticNonFinalFieldInspection.$$$reportNull$$$0(0);
        }
        return string;
    }

    @Override
    @Nullable
    protected LocalQuickFix buildFix(Object ... infos) {
        PsiField field = (PsiField)infos[0];
        return MakeFieldFinalFix.buildFix(field);
    }

    @NotNull
    public OptPane getOptionsPane() {
        OptPane optPane = OptPane.pane((OptRegularComponent[])new OptRegularComponent[]{OptPane.checkbox((String)"ignoreNonPublicFields", (String)InspectionGadgetsBundle.message("static.non.final.field.option", new Object[0]), (OptRegularComponent[])new OptRegularComponent[0])});
        if (optPane == null) {
            StaticNonFinalFieldInspection.$$$reportNull$$$0(1);
        }
        return optPane;
    }

    @Override
    @NotNull
    public BaseInspectionVisitor buildVisitor() {
        return new StaticNonFinalFieldVisitor();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[2];
        objectArray2[0] = "com/siyeh/ig/classlayout/StaticNonFinalFieldInspection";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "buildErrorString";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getOptionsPane";
                break;
            }
        }
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
    }

    private class StaticNonFinalFieldVisitor
    extends BaseInspectionVisitor {
        private StaticNonFinalFieldVisitor() {
        }

        public void visitField(@NotNull PsiField field) {
            if (field == null) {
                StaticNonFinalFieldVisitor.$$$reportNull$$$0(0);
            }
            if (StaticNonFinalFieldInspection.this.ignoreNonPublicFields && !field.hasModifierProperty("public")) {
                return;
            }
            if (!field.hasModifierProperty("static") || field.hasModifierProperty("final")) {
                return;
            }
            this.registerFieldError(field, field);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "field", "com/siyeh/ig/classlayout/StaticNonFinalFieldInspection$StaticNonFinalFieldVisitor", "visitField"));
        }
    }
}

