/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.classmetrics;

import com.intellij.codeInspection.options.OptPane;
import com.intellij.codeInspection.options.OptRegularComponent;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiMethod;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.classmetrics.ClassMetricInspection;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;

public final class ConstructorCountInspection
extends ClassMetricInspection {
    private static final int CONSTRUCTOR_COUNT_LIMIT = 5;
    public boolean ignoreDeprecatedConstructors = false;

    @NotNull
    public String getID() {
        return "ClassWithTooManyConstructors";
    }

    @Override
    protected int getDefaultLimit() {
        return 5;
    }

    @Override
    @Nls
    protected String getConfigurationLabel() {
        return InspectionGadgetsBundle.message("too.many.constructors.count.limit.option", new Object[0]);
    }

    @Override
    @NotNull
    public OptPane getOptionsPane() {
        OptPane optPane = OptPane.pane((OptRegularComponent[])new OptRegularComponent[]{OptPane.number((String)"m_limit", (String)this.getConfigurationLabel(), (int)0, (int)Integer.MAX_VALUE), OptPane.checkbox((String)"ignoreDeprecatedConstructors", (String)InspectionGadgetsBundle.message("too.many.constructors.ignore.deprecated.option", new Object[0]), (OptRegularComponent[])new OptRegularComponent[0])});
        if (optPane == null) {
            ConstructorCountInspection.$$$reportNull$$$0(0);
        }
        return optPane;
    }

    @Override
    @NotNull
    public String buildErrorString(Object ... infos) {
        Integer count = (Integer)infos[0];
        String string = InspectionGadgetsBundle.message("too.many.constructors.problem.descriptor", count);
        if (string == null) {
            ConstructorCountInspection.$$$reportNull$$$0(1);
        }
        return string;
    }

    @Override
    @NotNull
    public BaseInspectionVisitor buildVisitor() {
        return new ConstructorCountVisitor();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[2];
        objectArray2[0] = "com/siyeh/ig/classmetrics/ConstructorCountInspection";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getOptionsPane";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "buildErrorString";
                break;
            }
        }
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
    }

    private class ConstructorCountVisitor
    extends BaseInspectionVisitor {
        private ConstructorCountVisitor() {
        }

        public void visitClass(@NotNull PsiClass aClass) {
            int constructorCount;
            if (aClass == null) {
                ConstructorCountVisitor.$$$reportNull$$$0(0);
            }
            if ((constructorCount = this.calculateTotalConstructorCount(aClass)) <= ConstructorCountInspection.this.getLimit()) {
                return;
            }
            this.registerClassError(aClass, constructorCount);
        }

        private int calculateTotalConstructorCount(PsiClass aClass) {
            PsiMethod[] constructors = aClass.getConstructors();
            if (!ConstructorCountInspection.this.ignoreDeprecatedConstructors) {
                return constructors.length;
            }
            int count = 0;
            for (PsiMethod constructor : constructors) {
                if (constructor.isDeprecated()) continue;
                ++count;
            }
            return count;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "aClass", "com/siyeh/ig/classmetrics/ConstructorCountInspection$ConstructorCountVisitor", "visitClass"));
        }
    }
}

