/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.classmetrics;

import com.intellij.codeInspection.options.OptPane;
import com.intellij.codeInspection.options.OptRegularComponent;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.util.PropertyUtil;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.psiutils.MethodUtils;
import org.jetbrains.annotations.NotNull;

public final class MethodCountInspection
extends BaseInspection {
    private static final int DEFAULT_METHOD_COUNT_LIMIT = 20;
    public int m_limit = 20;
    public boolean ignoreGettersAndSetters = false;
    public boolean ignoreOverridingMethods = false;

    @NotNull
    public String getID() {
        return "ClassWithTooManyMethods";
    }

    @NotNull
    public OptPane getOptionsPane() {
        OptPane optPane = OptPane.pane((OptRegularComponent[])new OptRegularComponent[]{OptPane.number((String)"m_limit", (String)InspectionGadgetsBundle.message("method.count.limit.option", new Object[0]), (int)1, (int)1000), OptPane.checkbox((String)"ignoreGettersAndSetters", (String)InspectionGadgetsBundle.message("method.count.ignore.getters.setters.option", new Object[0]), (OptRegularComponent[])new OptRegularComponent[0]), OptPane.checkbox((String)"ignoreOverridingMethods", (String)InspectionGadgetsBundle.message("ignore.methods.overriding.super.method", new Object[0]), (OptRegularComponent[])new OptRegularComponent[0])});
        if (optPane == null) {
            MethodCountInspection.$$$reportNull$$$0(0);
        }
        return optPane;
    }

    @Override
    @NotNull
    public String buildErrorString(Object ... infos) {
        Integer count = (Integer)infos[0];
        String string = InspectionGadgetsBundle.message("too.many.methods.problem.descriptor", count);
        if (string == null) {
            MethodCountInspection.$$$reportNull$$$0(1);
        }
        return string;
    }

    @Override
    @NotNull
    public BaseInspectionVisitor buildVisitor() {
        return new MethodCountVisitor();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[2];
        objectArray2[0] = "com/siyeh/ig/classmetrics/MethodCountInspection";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getOptionsPane";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "buildErrorString";
                break;
            }
        }
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
    }

    private class MethodCountVisitor
    extends BaseInspectionVisitor {
        private MethodCountVisitor() {
        }

        public void visitClass(@NotNull PsiClass aClass) {
            int methodCount;
            if (aClass == null) {
                MethodCountVisitor.$$$reportNull$$$0(0);
            }
            if ((methodCount = this.calculateTotalMethodCount(aClass)) <= MethodCountInspection.this.m_limit) {
                return;
            }
            this.registerClassError(aClass, methodCount);
        }

        private int calculateTotalMethodCount(PsiClass aClass) {
            int totalCount = 0;
            for (PsiMethod method : aClass.getMethods()) {
                if (method.isConstructor() || !method.isPhysical() || MethodCountInspection.this.ignoreGettersAndSetters && (PropertyUtil.isSimpleGetter(method) || PropertyUtil.isSimpleSetter(method)) || MethodCountInspection.this.ignoreOverridingMethods && MethodUtils.hasSuper(method)) continue;
                ++totalCount;
            }
            return totalCount;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "aClass", "com/siyeh/ig/classmetrics/MethodCountInspection$MethodCountVisitor", "visitClass"));
        }
    }
}

