/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.cloneable;

import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.modcommand.ModPsiUpdater;
import com.intellij.modcommand.PsiUpdateModCommandQuickFix;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.JavaRecursiveElementVisitor;
import com.intellij.psi.JavaRecursiveElementWalkingVisitor;
import com.intellij.psi.PsiAnonymousClass;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiLambdaExpression;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiReturnStatement;
import com.intellij.psi.PsiStatement;
import com.intellij.psi.PsiThrowStatement;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeElement;
import com.intellij.psi.PsiTypes;
import com.intellij.psi.util.PsiUtil;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.PsiReplacementUtil;
import com.siyeh.ig.psiutils.CloneUtils;
import com.siyeh.ig.psiutils.CommentTracker;
import com.siyeh.ig.psiutils.ControlFlowUtils;
import com.siyeh.ig.psiutils.ExpressionUtils;
import java.util.function.Predicate;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class CloneReturnsClassTypeInspection
extends BaseInspection {
    @Override
    @NotNull
    protected String buildErrorString(Object ... infos) {
        String string = InspectionGadgetsBundle.message("clone.returns.class.type.problem.descriptor", infos[0]);
        if (string == null) {
            CloneReturnsClassTypeInspection.$$$reportNull$$$0(0);
        }
        return string;
    }

    @Override
    @Nullable
    protected LocalQuickFix buildFix(Object ... infos) {
        String className = (String)infos[0];
        boolean buildFix = (Boolean)infos[1];
        if (!buildFix) {
            return null;
        }
        return new CloneReturnsClassTypeFix(className);
    }

    @Override
    @NotNull
    public BaseInspectionVisitor buildVisitor() {
        return new CloneReturnsClassTypeVisitor();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/cloneable/CloneReturnsClassTypeInspection", "buildErrorString"));
    }

    private static class CloneReturnsClassTypeFix
    extends PsiUpdateModCommandQuickFix {
        final String myClassName;

        CloneReturnsClassTypeFix(String className) {
            this.myClassName = className;
        }

        @Nls
        @NotNull
        public String getName() {
            String string = InspectionGadgetsBundle.message("clone.returns.class.type.quickfix", this.myClassName);
            if (string == null) {
                CloneReturnsClassTypeFix.$$$reportNull$$$0(0);
            }
            return string;
        }

        @NotNull
        public String getFamilyName() {
            String string = InspectionGadgetsBundle.message("clone.returns.class.type.family.quickfix", new Object[0]);
            if (string == null) {
                CloneReturnsClassTypeFix.$$$reportNull$$$0(1);
            }
            return string;
        }

        protected void applyFix(@NotNull Project project, @NotNull PsiElement element, @NotNull ModPsiUpdater updater) {
            if (project == null) {
                CloneReturnsClassTypeFix.$$$reportNull$$$0(2);
            }
            if (element == null) {
                CloneReturnsClassTypeFix.$$$reportNull$$$0(3);
            }
            if (updater == null) {
                CloneReturnsClassTypeFix.$$$reportNull$$$0(4);
            }
            if (!(element instanceof PsiTypeElement)) {
                return;
            }
            PsiTypeElement typeElement = (PsiTypeElement)element;
            PsiElement parent = typeElement.getParent();
            if (!(parent instanceof PsiMethod)) {
                return;
            }
            PsiElementFactory factory = JavaPsiFacade.getElementFactory((Project)project);
            PsiTypeElement newTypeElement = factory.createTypeElementFromText(this.myClassName, element);
            final PsiType newType = newTypeElement.getType();
            parent.accept((PsiElementVisitor)new JavaRecursiveElementVisitor(){

                public void visitClass(@NotNull PsiClass aClass) {
                    if (aClass == null) {
                        1.$$$reportNull$$$0(0);
                    }
                }

                public void visitLambdaExpression(@NotNull PsiLambdaExpression expression) {
                    if (expression == null) {
                        1.$$$reportNull$$$0(1);
                    }
                }

                public void visitReturnStatement(@NotNull PsiReturnStatement statement) {
                    if (statement == null) {
                        1.$$$reportNull$$$0(2);
                    }
                    super.visitReturnStatement(statement);
                    PsiExpression returnValue = PsiUtil.deparenthesizeExpression((PsiExpression)statement.getReturnValue());
                    if (returnValue == null) {
                        return;
                    }
                    PsiType type = returnValue.getType();
                    if (newType.equals(type) || PsiTypes.nullType().equals(type)) {
                        return;
                    }
                    CommentTracker commentTracker = new CommentTracker();
                    PsiReplacementUtil.replaceStatement((PsiStatement)statement, "return (" + myClassName + ")" + commentTracker.text((PsiElement)returnValue) + ";", commentTracker);
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    Object[] objectArray;
                    Object[] objectArray2;
                    Object[] objectArray3 = new Object[3];
                    switch (n) {
                        default: {
                            objectArray2 = objectArray3;
                            objectArray3[0] = "aClass";
                            break;
                        }
                        case 1: {
                            objectArray2 = objectArray3;
                            objectArray3[0] = "expression";
                            break;
                        }
                        case 2: {
                            objectArray2 = objectArray3;
                            objectArray3[0] = "statement";
                            break;
                        }
                    }
                    objectArray2[1] = "com/siyeh/ig/cloneable/CloneReturnsClassTypeInspection$CloneReturnsClassTypeFix$1";
                    switch (n) {
                        default: {
                            objectArray = objectArray2;
                            objectArray2[2] = "visitClass";
                            break;
                        }
                        case 1: {
                            objectArray = objectArray2;
                            objectArray2[2] = "visitLambdaExpression";
                            break;
                        }
                        case 2: {
                            objectArray = objectArray2;
                            objectArray2[2] = "visitReturnStatement";
                            break;
                        }
                    }
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
                }
            });
            typeElement.getFirstChild().replace(newTypeElement.getFirstChild());
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 2;
                case 2, 3, 4 -> 3;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/siyeh/ig/cloneable/CloneReturnsClassTypeInspection$CloneReturnsClassTypeFix";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "element";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "updater";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getName";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFamilyName";
                    break;
                }
                case 2: 
                case 3: 
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/siyeh/ig/cloneable/CloneReturnsClassTypeInspection$CloneReturnsClassTypeFix";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 2: 
                case 3: 
                case 4: {
                    objectArray = objectArray;
                    objectArray[2] = "applyFix";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalStateException(string);
                case 2, 3, 4 -> new IllegalArgumentException(string);
            };
        }
    }

    private static class CloneReturnsClassTypeVisitor
    extends BaseInspectionVisitor {
        private CloneReturnsClassTypeVisitor() {
        }

        public void visitMethod(@NotNull PsiMethod method) {
            if (method == null) {
                CloneReturnsClassTypeVisitor.$$$reportNull$$$0(0);
            }
            if (!CloneUtils.isClone(method) || !PsiUtil.isLanguageLevel5OrHigher((PsiElement)method)) {
                return;
            }
            PsiTypeElement typeElement = method.getReturnTypeElement();
            if (typeElement == null) {
                return;
            }
            PsiType returnType = typeElement.getType();
            PsiClass aClass = PsiUtil.resolveClassInClassTypeOnly((PsiType)returnType);
            PsiClass containingClass = method.getContainingClass();
            if (containingClass instanceof PsiAnonymousClass) {
                PsiAnonymousClass anonymousClass = (PsiAnonymousClass)containingClass;
                PsiClassType baseClassType = anonymousClass.getBaseClassType();
                containingClass = PsiUtil.resolveClassInClassTypeOnly((PsiType)baseClassType);
            }
            if (containingClass == null || containingClass.equals((Object)aClass)) {
                return;
            }
            if (CloneReturnsClassTypeVisitor.methodAlwaysReturnsNullOrThrowsException(method)) {
                return;
            }
            if (!CloneUtils.isCloneable(containingClass)) {
                if (JavaPsiFacade.getElementFactory((Project)method.getProject()).createType(containingClass).isConvertibleFrom(returnType)) {
                    return;
                }
                this.registerError((PsiElement)typeElement, containingClass.getName(), Boolean.FALSE);
            } else {
                this.registerError((PsiElement)typeElement, containingClass.getName(), Boolean.TRUE);
            }
        }

        private static boolean methodAlwaysReturnsNullOrThrowsException(@NotNull PsiMethod method) {
            PsiCodeBlock body;
            if (method == null) {
                CloneReturnsClassTypeVisitor.$$$reportNull$$$0(1);
            }
            if ((body = method.getBody()) == null) {
                return false;
            }
            ReturnChecker checker = new ReturnChecker(r -> ExpressionUtils.isNullLiteral(r.getReturnValue()));
            body.accept((PsiElementVisitor)checker);
            return checker.isReturnFound() ? checker.allReturnsMatchPredicate() : !ControlFlowUtils.codeBlockMayCompleteNormally(body);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            objectArray2[0] = "method";
            objectArray2[1] = "com/siyeh/ig/cloneable/CloneReturnsClassTypeInspection$CloneReturnsClassTypeVisitor";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "visitMethod";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "methodAlwaysReturnsNullOrThrowsException";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static class ReturnChecker
    extends JavaRecursiveElementWalkingVisitor {
        private final Predicate<? super PsiReturnStatement> myPredicate;
        private boolean myReturnFound = false;
        private boolean myallReturnsMatchPredicate = true;

        ReturnChecker(Predicate<? super PsiReturnStatement> predicate) {
            this.myPredicate = predicate;
        }

        public void visitClass(@NotNull PsiClass aClass) {
            if (aClass == null) {
                ReturnChecker.$$$reportNull$$$0(0);
            }
        }

        public void visitLambdaExpression(@NotNull PsiLambdaExpression expression) {
            if (expression == null) {
                ReturnChecker.$$$reportNull$$$0(1);
            }
        }

        public void visitThrowStatement(@NotNull PsiThrowStatement statement) {
            if (statement == null) {
                ReturnChecker.$$$reportNull$$$0(2);
            }
            super.visitThrowStatement(statement);
            this.myallReturnsMatchPredicate = false;
            this.stopWalking();
        }

        public void visitReturnStatement(@NotNull PsiReturnStatement statement) {
            if (statement == null) {
                ReturnChecker.$$$reportNull$$$0(3);
            }
            super.visitReturnStatement(statement);
            this.myReturnFound = true;
            this.myallReturnsMatchPredicate &= this.myPredicate.test((PsiReturnStatement)statement);
            if (!this.myallReturnsMatchPredicate) {
                this.stopWalking();
            }
        }

        public boolean allReturnsMatchPredicate() {
            return this.myallReturnsMatchPredicate;
        }

        public boolean isReturnFound() {
            return this.myReturnFound;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "aClass";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "expression";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "statement";
                    break;
                }
            }
            objectArray2[1] = "com/siyeh/ig/cloneable/CloneReturnsClassTypeInspection$ReturnChecker";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "visitClass";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "visitLambdaExpression";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "visitThrowStatement";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[2] = "visitReturnStatement";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

