/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.cloneable;

import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiMethod;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.fixes.ChangeModifierFix;
import com.siyeh.ig.psiutils.CloneUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class NonPublicCloneInspection
extends BaseInspection {
    @Override
    @NotNull
    protected String buildErrorString(Object ... infos) {
        String string = InspectionGadgetsBundle.message("non.public.clone.problem.descriptor", new Object[0]);
        if (string == null) {
            NonPublicCloneInspection.$$$reportNull$$$0(0);
        }
        return string;
    }

    @Override
    @Nullable
    protected LocalQuickFix buildFix(Object ... infos) {
        return new ChangeModifierFix("public");
    }

    @Override
    @NotNull
    public BaseInspectionVisitor buildVisitor() {
        return new NonPublicCloneVisitor();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/cloneable/NonPublicCloneInspection", "buildErrorString"));
    }

    private static class NonPublicCloneVisitor
    extends BaseInspectionVisitor {
        private NonPublicCloneVisitor() {
        }

        public void visitMethod(@NotNull PsiMethod method) {
            if (method == null) {
                NonPublicCloneVisitor.$$$reportNull$$$0(0);
            }
            if (method.hasModifierProperty("public") || !CloneUtils.isClone(method)) {
                return;
            }
            PsiClass containingClass = method.getContainingClass();
            if (!CloneUtils.isCloneable(containingClass)) {
                return;
            }
            this.registerMethodError(method, new Object[0]);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "method", "com/siyeh/ig/cloneable/NonPublicCloneInspection$NonPublicCloneVisitor", "visitMethod"));
        }
    }
}

