/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.controlflow;

import com.intellij.codeInspection.JavaSuppressionUtil;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.modcommand.ModPsiUpdater;
import com.intellij.modcommand.PsiUpdateModCommandQuickFix;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiStatement;
import com.intellij.psi.PsiSwitchBlock;
import com.intellij.psi.PsiSwitchExpression;
import com.intellij.psi.PsiSwitchLabelStatement;
import com.intellij.psi.PsiSwitchLabeledRuleStatement;
import com.intellij.psi.PsiSwitchStatement;
import com.intellij.psi.PsiType;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiTypesUtil;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.psiutils.ControlFlowUtils;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class FallthruInSwitchStatementInspection
extends BaseInspection {
    @NotNull
    public String getID() {
        return "fallthrough";
    }

    @Override
    @NotNull
    protected String buildErrorString(Object ... infos) {
        String string = InspectionGadgetsBundle.message("fallthru.in.switch.statement.problem.descriptor", new Object[0]);
        if (string == null) {
            FallthruInSwitchStatementInspection.$$$reportNull$$$0(0);
        }
        return string;
    }

    @Override
    @Nullable
    protected LocalQuickFix buildFix(Object ... infos) {
        return (Boolean)infos[0] != false ? new FallthruInSwitchStatementFix((String)infos[1]) : null;
    }

    @Override
    @NotNull
    public BaseInspectionVisitor buildVisitor() {
        return new FallthroughInSwitchStatementVisitor();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/controlflow/FallthruInSwitchStatementInspection", "buildErrorString"));
    }

    private static class FallthruInSwitchStatementFix
    extends PsiUpdateModCommandQuickFix {
        private final String myKeyword;

        private FallthruInSwitchStatementFix(String keyword) {
            this.myKeyword = keyword;
        }

        @NotNull
        public String getFamilyName() {
            String string = InspectionGadgetsBundle.message("fallthru.in.switch.statement.quickfix", "break");
            if (string == null) {
                FallthruInSwitchStatementFix.$$$reportNull$$$0(0);
            }
            return string;
        }

        @NotNull
        public String getName() {
            String string = InspectionGadgetsBundle.message("fallthru.in.switch.statement.quickfix", this.myKeyword);
            if (string == null) {
                FallthruInSwitchStatementFix.$$$reportNull$$$0(1);
            }
            return string;
        }

        protected void applyFix(@NotNull Project project, @NotNull PsiElement startElement, @NotNull ModPsiUpdater updater) {
            if (project == null) {
                FallthruInSwitchStatementFix.$$$reportNull$$$0(2);
            }
            if (startElement == null) {
                FallthruInSwitchStatementFix.$$$reportNull$$$0(3);
            }
            if (updater == null) {
                FallthruInSwitchStatementFix.$$$reportNull$$$0(4);
            }
            PsiSwitchLabelStatement labelStatement = (PsiSwitchLabelStatement)startElement;
            JavaPsiFacade psiFacade = JavaPsiFacade.getInstance((Project)project);
            PsiElementFactory factory = psiFacade.getElementFactory();
            PsiSwitchBlock switchBlock = labelStatement.getEnclosingSwitchBlock();
            String stmt = switchBlock instanceof PsiSwitchExpression ? "yield " + PsiTypesUtil.getDefaultValueOfType((PsiType)((PsiSwitchExpression)switchBlock).getType()) + ";" : "break;";
            PsiStatement breakStatement = factory.createStatementFromText(stmt, (PsiElement)labelStatement);
            PsiElement parent = labelStatement.getParent();
            parent.addBefore((PsiElement)breakStatement, (PsiElement)labelStatement);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 2;
                case 2, 3, 4 -> 3;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/siyeh/ig/controlflow/FallthruInSwitchStatementInspection$FallthruInSwitchStatementFix";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "startElement";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "updater";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFamilyName";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getName";
                    break;
                }
                case 2: 
                case 3: 
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/siyeh/ig/controlflow/FallthruInSwitchStatementInspection$FallthruInSwitchStatementFix";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 2: 
                case 3: 
                case 4: {
                    objectArray = objectArray;
                    objectArray[2] = "applyFix";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalStateException(string);
                case 2, 3, 4 -> new IllegalArgumentException(string);
            };
        }
    }

    private static class FallthroughInSwitchStatementVisitor
    extends BaseInspectionVisitor {
        private static final Pattern commentPattern = Pattern.compile("(?i)falls?\\s*-?thro?u");

        private FallthroughInSwitchStatementVisitor() {
        }

        public void visitSwitchStatement(@NotNull PsiSwitchStatement switchStatement) {
            if (switchStatement == null) {
                FallthroughInSwitchStatementVisitor.$$$reportNull$$$0(0);
            }
            super.visitSwitchStatement(switchStatement);
            this.doCheckSwitchBlock((PsiSwitchBlock)switchStatement);
        }

        public void visitSwitchExpression(@NotNull PsiSwitchExpression expression) {
            if (expression == null) {
                FallthroughInSwitchStatementVisitor.$$$reportNull$$$0(1);
            }
            super.visitSwitchExpression(expression);
            this.doCheckSwitchBlock((PsiSwitchBlock)expression);
        }

        private void doCheckSwitchBlock(@NotNull PsiSwitchBlock switchBlock) {
            PsiCodeBlock body;
            if (switchBlock == null) {
                FallthroughInSwitchStatementVisitor.$$$reportNull$$$0(2);
            }
            if ((body = switchBlock.getBody()) == null) {
                return;
            }
            PsiStatement[] statements = body.getStatements();
            for (int i = 1; i < statements.length; ++i) {
                PsiStatement previousStatement;
                PsiComment comment;
                String commentText;
                PsiStatement statement = statements[i];
                if (!(statement instanceof PsiSwitchLabelStatement)) continue;
                if (statement instanceof PsiSwitchLabeledRuleStatement) {
                    return;
                }
                PsiElement previousSibling = PsiTreeUtil.skipWhitespacesBackward((PsiElement)statement);
                if (previousSibling instanceof PsiComment && commentPattern.matcher(commentText = (comment = (PsiComment)previousSibling).getText()).find() && JavaSuppressionUtil.getSuppressedInspectionIdsIn((PsiElement)comment) == null || (previousStatement = (PsiStatement)PsiTreeUtil.getPrevSiblingOfType((PsiElement)statement, PsiStatement.class)) instanceof PsiSwitchLabelStatement || !ControlFlowUtils.statementMayCompleteNormally(previousStatement)) continue;
                this.registerError((PsiElement)statement, switchBlock instanceof PsiSwitchStatement || this.isOnTheFly(), switchBlock instanceof PsiSwitchExpression ? "yield" : "break");
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "switchStatement";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "expression";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "switchBlock";
                    break;
                }
            }
            objectArray2[1] = "com/siyeh/ig/controlflow/FallthruInSwitchStatementInspection$FallthroughInSwitchStatementVisitor";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "visitSwitchStatement";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "visitSwitchExpression";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "doCheckSwitchBlock";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

