/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.controlflow;

import com.intellij.codeInsight.BlockUtils;
import com.intellij.codeInspection.CleanupLocalInspectionTool;
import com.intellij.codeInspection.CommonQuickFixBundle;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.options.OptPane;
import com.intellij.codeInspection.options.OptRegularComponent;
import com.intellij.modcommand.ModPsiUpdater;
import com.intellij.modcommand.PsiUpdateModCommandQuickFix;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Predicates;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiBlockStatement;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiContinueStatement;
import com.intellij.psi.PsiDeclarationStatement;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiEmptyStatement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionList;
import com.intellij.psi.PsiExpressionListStatement;
import com.intellij.psi.PsiForStatement;
import com.intellij.psi.PsiNamedElement;
import com.intellij.psi.PsiStatement;
import com.intellij.psi.PsiWhileStatement;
import com.intellij.psi.codeStyle.JavaCodeStyleManager;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.util.ObjectUtils;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.psiutils.BoolUtils;
import com.siyeh.ig.psiutils.CommentTracker;
import java.util.Collection;
import one.util.streamex.StreamEx;
import org.intellij.lang.annotations.Pattern;
import org.jetbrains.annotations.NotNull;

public final class ForLoopReplaceableByWhileInspection
extends BaseInspection
implements CleanupLocalInspectionTool {
    public boolean m_ignoreLoopsWithoutConditions = true;

    @Pattern(value="[a-zA-Z_0-9.-]+")
    @NotNull
    public String getID() {
        return "ForLoopReplaceableByWhile";
    }

    @Override
    @NotNull
    protected String buildErrorString(Object ... infos) {
        String string = InspectionGadgetsBundle.message("for.loop.replaceable.by.while.problem.descriptor", new Object[0]);
        if (string == null) {
            ForLoopReplaceableByWhileInspection.$$$reportNull$$$0(0);
        }
        return string;
    }

    @NotNull
    public OptPane getOptionsPane() {
        OptPane optPane = OptPane.pane((OptRegularComponent[])new OptRegularComponent[]{OptPane.checkbox((String)"m_ignoreLoopsWithoutConditions", (String)InspectionGadgetsBundle.message("for.loop.replaceable.by.while.ignore.option", new Object[0]), (OptRegularComponent[])new OptRegularComponent[0])});
        if (optPane == null) {
            ForLoopReplaceableByWhileInspection.$$$reportNull$$$0(1);
        }
        return optPane;
    }

    @Override
    public LocalQuickFix buildFix(Object ... infos) {
        return new ReplaceForByWhileFix();
    }

    @Override
    @NotNull
    public BaseInspectionVisitor buildVisitor() {
        return new ForLoopReplaceableByWhileVisitor();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[2];
        objectArray2[0] = "com/siyeh/ig/controlflow/ForLoopReplaceableByWhileInspection";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "buildErrorString";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getOptionsPane";
                break;
            }
        }
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
    }

    private static class ReplaceForByWhileFix
    extends PsiUpdateModCommandQuickFix {
        private ReplaceForByWhileFix() {
        }

        @NotNull
        public String getFamilyName() {
            String string = CommonQuickFixBundle.message((String)"fix.replace.with.x", (Object[])new Object[]{"while"});
            if (string == null) {
                ReplaceForByWhileFix.$$$reportNull$$$0(0);
            }
            return string;
        }

        protected void applyFix(@NotNull Project project, @NotNull PsiElement element, @NotNull ModPsiUpdater updater) {
            PsiCodeBlock loopBody;
            PsiBlockStatement blockStatement;
            PsiForStatement forStatement;
            if (project == null) {
                ReplaceForByWhileFix.$$$reportNull$$$0(1);
            }
            if (element == null) {
                ReplaceForByWhileFix.$$$reportNull$$$0(2);
            }
            if (updater == null) {
                ReplaceForByWhileFix.$$$reportNull$$$0(3);
            }
            if ((forStatement = (PsiForStatement)ObjectUtils.tryCast((Object)element.getParent(), PsiForStatement.class)) == null) {
                return;
            }
            CommentTracker commentTracker = new CommentTracker();
            PsiStatement initialization = forStatement.getInitialization();
            PsiElementFactory factory = JavaPsiFacade.getElementFactory((Project)element.getProject());
            PsiWhileStatement whileStatement = (PsiWhileStatement)factory.createStatementFromText("while(true) {}", element);
            PsiExpression forCondition = forStatement.getCondition();
            PsiExpression whileCondition = whileStatement.getCondition();
            if (forCondition != null) {
                assert (whileCondition != null);
                commentTracker.replace((PsiElement)whileCondition, (PsiElement)forCondition);
            }
            if ((blockStatement = (PsiBlockStatement)whileStatement.getBody()) == null) {
                return;
            }
            PsiStatement forStatementBody = forStatement.getBody();
            if (forStatementBody instanceof PsiBlockStatement) {
                PsiBlockStatement newWhileBody = (PsiBlockStatement)blockStatement.replace((PsiElement)commentTracker.markUnchanged(forStatementBody));
                loopBody = newWhileBody.getCodeBlock();
            } else {
                PsiCodeBlock codeBlock = blockStatement.getCodeBlock();
                if (forStatementBody != null && !(forStatementBody instanceof PsiEmptyStatement)) {
                    codeBlock.add((PsiElement)commentTracker.markUnchanged(forStatementBody));
                }
                loopBody = codeBlock;
            }
            PsiStatement update = forStatement.getUpdate();
            if (update != null) {
                PsiStatement[] updateStatements;
                if (update instanceof PsiExpressionListStatement) {
                    PsiExpressionListStatement expressionListStatement = (PsiExpressionListStatement)update;
                    PsiExpressionList expressionList = expressionListStatement.getExpressionList();
                    PsiExpression[] expressions = expressionList.getExpressions();
                    updateStatements = new PsiStatement[expressions.length];
                    for (int i = 0; i < expressions.length; ++i) {
                        updateStatements[i] = factory.createStatementFromText(commentTracker.text((PsiElement)expressions[i]) + ";", element);
                    }
                } else {
                    PsiStatement updateStatement = factory.createStatementFromText(commentTracker.markUnchanged(update).getText() + ";", element);
                    updateStatements = new PsiStatement[]{updateStatement};
                }
                Collection continueStatements = PsiTreeUtil.findChildrenOfType((PsiElement)loopBody, PsiContinueStatement.class);
                for (PsiContinueStatement continueStatement : continueStatements) {
                    BlockUtils.addBefore((PsiStatement)continueStatement, (PsiStatement[])updateStatements);
                }
                for (PsiStatement updateStatement : updateStatements) {
                    loopBody.addBefore((PsiElement)updateStatement, loopBody.getLastChild());
                }
            }
            if (initialization == null || initialization instanceof PsiEmptyStatement) {
                commentTracker.replaceAndRestoreComments((PsiElement)forStatement, (PsiElement)whileStatement);
            } else {
                JavaCodeStyleManager manager;
                initialization = (PsiStatement)commentTracker.markUnchanged(initialization).copy();
                PsiStatement newStatement = (PsiStatement)commentTracker.replaceAndRestoreComments((PsiElement)forStatement, (PsiElement)whileStatement);
                if (initialization instanceof PsiDeclarationStatement && ReplaceForByWhileFix.hasConflictingName((PsiDeclarationStatement)initialization, newStatement, manager = JavaCodeStyleManager.getInstance((Project)newStatement.getProject()))) {
                    PsiBlockStatement emptyBlockStatement = (PsiBlockStatement)factory.createStatementFromText("{}", (PsiElement)newStatement);
                    emptyBlockStatement.getCodeBlock().add((PsiElement)newStatement);
                    newStatement = ((PsiBlockStatement)newStatement.replace((PsiElement)emptyBlockStatement)).getCodeBlock().getStatements()[0];
                }
                BlockUtils.addBefore((PsiStatement)newStatement, (PsiStatement[])new PsiStatement[]{initialization});
            }
        }

        private static boolean hasConflictingName(PsiDeclarationStatement initialization, PsiStatement newStatement, JavaCodeStyleManager manager) {
            return ((StreamEx)StreamEx.of((Object[])initialization.getDeclaredElements()).select(PsiNamedElement.class).map(namedElement -> namedElement.getName()).filter(Predicates.nonNull())).anyMatch(name -> !name.equals(manager.suggestUniqueVariableName(name, (PsiElement)newStatement, true)));
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 2;
                case 1, 2, 3 -> 3;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/siyeh/ig/controlflow/ForLoopReplaceableByWhileInspection$ReplaceForByWhileFix";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "element";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "updater";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFamilyName";
                    break;
                }
                case 1: 
                case 2: 
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/siyeh/ig/controlflow/ForLoopReplaceableByWhileInspection$ReplaceForByWhileFix";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 1: 
                case 2: 
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "applyFix";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalStateException(string);
                case 1, 2, 3 -> new IllegalArgumentException(string);
            };
        }
    }

    private class ForLoopReplaceableByWhileVisitor
    extends BaseInspectionVisitor {
        private ForLoopReplaceableByWhileVisitor() {
        }

        public void visitForStatement(@NotNull PsiForStatement statement) {
            ProblemHighlightType highlightType;
            if (statement == null) {
                ForLoopReplaceableByWhileVisitor.$$$reportNull$$$0(0);
            }
            super.visitForStatement(statement);
            if (PsiUtilCore.hasErrorElementChild((PsiElement)statement)) {
                return;
            }
            if (this.highlightLoop(statement)) {
                highlightType = ProblemHighlightType.GENERIC_ERROR_OR_WARNING;
            } else {
                if (!this.isOnTheFly()) {
                    return;
                }
                highlightType = ProblemHighlightType.INFORMATION;
            }
            this.registerError(statement.getFirstChild(), highlightType, new Object[0]);
        }

        private boolean highlightLoop(@NotNull PsiForStatement statement) {
            PsiStatement initialization;
            if (statement == null) {
                ForLoopReplaceableByWhileVisitor.$$$reportNull$$$0(1);
            }
            if ((initialization = statement.getInitialization()) != null && !(initialization instanceof PsiEmptyStatement)) {
                return false;
            }
            PsiStatement update = statement.getUpdate();
            if (update != null && !(update instanceof PsiEmptyStatement)) {
                return false;
            }
            if (ForLoopReplaceableByWhileInspection.this.m_ignoreLoopsWithoutConditions) {
                PsiExpression condition = statement.getCondition();
                return condition != null && !BoolUtils.isTrue(condition);
            }
            return true;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            objectArray2[0] = "statement";
            objectArray2[1] = "com/siyeh/ig/controlflow/ForLoopReplaceableByWhileInspection$ForLoopReplaceableByWhileVisitor";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "visitForStatement";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "highlightLoop";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

