/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.controlflow;

import com.intellij.codeInspection.options.OptPane;
import com.intellij.codeInspection.options.OptRegularComponent;
import com.intellij.psi.PsiDeclarationStatement;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiEmptyStatement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiForStatement;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiPolyadicExpression;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiStatement;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypes;
import com.intellij.psi.PsiVariable;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.psiutils.MethodCallUtils;
import com.siyeh.ig.psiutils.TypeUtils;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public final class ForLoopWithMissingComponentInspection
extends BaseInspection {
    public boolean ignoreCollectionLoops = false;

    @Override
    @NotNull
    public String buildErrorString(Object ... infos) {
        boolean hasInitializer = (Boolean)infos[0];
        boolean hasCondition = (Boolean)infos[1];
        boolean hasUpdate = (Boolean)infos[2];
        if (hasInitializer) {
            if (hasCondition) {
                String string = InspectionGadgetsBundle.message("for.loop.with.missing.component.problem.descriptor3", new Object[0]);
                if (string == null) {
                    ForLoopWithMissingComponentInspection.$$$reportNull$$$0(0);
                }
                return string;
            }
            if (hasUpdate) {
                String string = InspectionGadgetsBundle.message("for.loop.with.missing.component.problem.descriptor2", new Object[0]);
                if (string == null) {
                    ForLoopWithMissingComponentInspection.$$$reportNull$$$0(1);
                }
                return string;
            }
            String string = InspectionGadgetsBundle.message("for.loop.with.missing.component.problem.descriptor6", new Object[0]);
            if (string == null) {
                ForLoopWithMissingComponentInspection.$$$reportNull$$$0(2);
            }
            return string;
        }
        if (hasCondition) {
            if (hasUpdate) {
                String string = InspectionGadgetsBundle.message("for.loop.with.missing.component.problem.descriptor1", new Object[0]);
                if (string == null) {
                    ForLoopWithMissingComponentInspection.$$$reportNull$$$0(3);
                }
                return string;
            }
            String string = InspectionGadgetsBundle.message("for.loop.with.missing.component.problem.descriptor5", new Object[0]);
            if (string == null) {
                ForLoopWithMissingComponentInspection.$$$reportNull$$$0(4);
            }
            return string;
        }
        if (hasUpdate) {
            String string = InspectionGadgetsBundle.message("for.loop.with.missing.component.problem.descriptor4", new Object[0]);
            if (string == null) {
                ForLoopWithMissingComponentInspection.$$$reportNull$$$0(5);
            }
            return string;
        }
        String string = InspectionGadgetsBundle.message("for.loop.with.missing.component.problem.descriptor7", new Object[0]);
        if (string == null) {
            ForLoopWithMissingComponentInspection.$$$reportNull$$$0(6);
        }
        return string;
    }

    @NotNull
    public OptPane getOptionsPane() {
        OptPane optPane = OptPane.pane((OptRegularComponent[])new OptRegularComponent[]{OptPane.checkbox((String)"ignoreCollectionLoops", (String)InspectionGadgetsBundle.message("for.loop.with.missing.component.collection.loop.option", new Object[0]), (OptRegularComponent[])new OptRegularComponent[0])});
        if (optPane == null) {
            ForLoopWithMissingComponentInspection.$$$reportNull$$$0(7);
        }
        return optPane;
    }

    @Override
    @NotNull
    public BaseInspectionVisitor buildVisitor() {
        return new ForLoopWithMissingComponentVisitor();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[2];
        objectArray2[0] = "com/siyeh/ig/controlflow/ForLoopWithMissingComponentInspection";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "buildErrorString";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getOptionsPane";
                break;
            }
        }
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
    }

    private class ForLoopWithMissingComponentVisitor
    extends BaseInspectionVisitor {
        private ForLoopWithMissingComponentVisitor() {
        }

        public void visitForStatement(@NotNull PsiForStatement statement) {
            if (statement == null) {
                ForLoopWithMissingComponentVisitor.$$$reportNull$$$0(0);
            }
            super.visitForStatement(statement);
            boolean hasCondition = ForLoopWithMissingComponentVisitor.hasCondition(statement);
            boolean hasInitializer = ForLoopWithMissingComponentVisitor.hasInitializer(statement);
            boolean hasUpdate = ForLoopWithMissingComponentVisitor.hasUpdate(statement);
            if (hasCondition && hasInitializer && hasUpdate) {
                return;
            }
            if (ForLoopWithMissingComponentInspection.this.ignoreCollectionLoops && this.isCollectionLoopStatement(statement)) {
                return;
            }
            this.registerStatementError((PsiStatement)statement, hasInitializer, hasCondition, hasUpdate);
        }

        private static boolean hasCondition(PsiForStatement statement) {
            return statement.getCondition() != null;
        }

        private static boolean hasInitializer(PsiForStatement statement) {
            PsiStatement initialization = statement.getInitialization();
            return initialization != null && !(initialization instanceof PsiEmptyStatement);
        }

        private static boolean hasUpdate(PsiForStatement statement) {
            PsiStatement update = statement.getUpdate();
            return update != null && !(update instanceof PsiEmptyStatement);
        }

        private boolean isCollectionLoopStatement(PsiForStatement forStatement) {
            PsiStatement initialization = forStatement.getInitialization();
            if (!(initialization instanceof PsiDeclarationStatement)) {
                return false;
            }
            PsiDeclarationStatement declaration = (PsiDeclarationStatement)initialization;
            PsiElement[] declaredElements = declaration.getDeclaredElements();
            PsiExpression condition = forStatement.getCondition();
            for (PsiElement declaredElement : declaredElements) {
                if (!(declaredElement instanceof PsiVariable)) continue;
                PsiVariable variable = (PsiVariable)declaredElement;
                if (TypeUtils.variableHasTypeOrSubtype(variable, "java.util.ListIterator") && (this.isHasNext(condition, variable) || this.isHasPrevious(condition, variable))) {
                    return true;
                }
                if (!(TypeUtils.variableHasTypeOrSubtype(variable, "java.util.Iterator") ? this.isHasNext(condition, variable) : TypeUtils.variableHasTypeOrSubtype(variable, "java.util.Enumeration") && this.isHasMoreElements(condition, variable))) continue;
                return true;
            }
            return false;
        }

        private boolean isHasNext(PsiExpression condition, PsiVariable iterator) {
            return ForLoopWithMissingComponentVisitor.isCallToBooleanZeroArgumentMethod("hasNext", condition, iterator);
        }

        private boolean isHasPrevious(PsiExpression condition, PsiVariable iterator) {
            return ForLoopWithMissingComponentVisitor.isCallToBooleanZeroArgumentMethod("hasPrevious", condition, iterator);
        }

        private boolean isHasMoreElements(PsiExpression condition, PsiVariable enumeration) {
            return ForLoopWithMissingComponentVisitor.isCallToBooleanZeroArgumentMethod("hasMoreElements", condition, enumeration);
        }

        private static boolean isCallToBooleanZeroArgumentMethod(@NonNls String methodName, PsiExpression expression, PsiVariable calledOn) {
            if (expression instanceof PsiPolyadicExpression) {
                PsiPolyadicExpression polyadicExpression = (PsiPolyadicExpression)expression;
                for (PsiExpression operand : polyadicExpression.getOperands()) {
                    if (!ForLoopWithMissingComponentVisitor.isCallToBooleanZeroArgumentMethod(methodName, operand, calledOn)) continue;
                    return true;
                }
                return false;
            }
            if (!(expression instanceof PsiMethodCallExpression)) {
                return false;
            }
            PsiMethodCallExpression call = (PsiMethodCallExpression)expression;
            if (!MethodCallUtils.isCallToMethod(call, null, (PsiType)PsiTypes.booleanType(), methodName, new PsiType[0])) {
                return false;
            }
            PsiReferenceExpression methodExpression = call.getMethodExpression();
            PsiExpression qualifier = methodExpression.getQualifierExpression();
            if (!(qualifier instanceof PsiReferenceExpression)) {
                return true;
            }
            PsiReferenceExpression referenceExpression = (PsiReferenceExpression)qualifier;
            PsiElement target = referenceExpression.resolve();
            return calledOn.equals((Object)target);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "statement", "com/siyeh/ig/controlflow/ForLoopWithMissingComponentInspection$ForLoopWithMissingComponentVisitor", "visitForStatement"));
        }
    }
}

