/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.controlflow;

import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.options.OptPane;
import com.intellij.codeInspection.options.OptRegularComponent;
import com.intellij.modcommand.ModPsiUpdater;
import com.intellij.modcommand.PsiUpdateModCommandQuickFix;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiConditionalExpression;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.PsiReplacementUtil;
import com.siyeh.ig.psiutils.BoolUtils;
import com.siyeh.ig.psiutils.CommentTracker;
import com.siyeh.ig.psiutils.ExpressionUtils;
import org.intellij.lang.annotations.Pattern;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;

public final class NegatedConditionalInspection
extends BaseInspection {
    public boolean m_ignoreNegatedNullComparison = true;
    public boolean m_ignoreNegatedZeroComparison = true;

    @Pattern(value="[a-zA-Z_0-9.-]+")
    @NotNull
    public String getID() {
        return "ConditionalExpressionWithNegatedCondition";
    }

    @Override
    @NotNull
    protected String buildErrorString(Object ... infos) {
        String string = InspectionGadgetsBundle.message("negated.conditional.problem.descriptor", new Object[0]);
        if (string == null) {
            NegatedConditionalInspection.$$$reportNull$$$0(0);
        }
        return string;
    }

    @Override
    @NotNull
    public BaseInspectionVisitor buildVisitor() {
        return new NegatedConditionalVisitor();
    }

    @NotNull
    public OptPane getOptionsPane() {
        OptPane optPane = OptPane.pane((OptRegularComponent[])new OptRegularComponent[]{OptPane.checkbox((String)"m_ignoreNegatedNullComparison", (String)InspectionGadgetsBundle.message("negated.if.else.ignore.negated.null.option", new Object[0]), (OptRegularComponent[])new OptRegularComponent[0]), OptPane.checkbox((String)"m_ignoreNegatedZeroComparison", (String)InspectionGadgetsBundle.message("negated.if.else.ignore.negated.zero.option", new Object[0]), (OptRegularComponent[])new OptRegularComponent[0])});
        if (optPane == null) {
            NegatedConditionalInspection.$$$reportNull$$$0(1);
        }
        return optPane;
    }

    public void writeSettings(@NotNull Element node) {
        if (node == null) {
            NegatedConditionalInspection.$$$reportNull$$$0(2);
        }
        this.defaultWriteSettings(node, "m_ignoreNegatedZeroComparison");
        this.writeBooleanOption(node, "m_ignoreNegatedZeroComparison", true);
    }

    @Override
    protected LocalQuickFix buildFix(Object ... infos) {
        return new NegatedConditionalFix();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 2 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/siyeh/ig/controlflow/NegatedConditionalInspection";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "node";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "buildErrorString";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getOptionsPane";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "com/siyeh/ig/controlflow/NegatedConditionalInspection";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "writeSettings";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 2 -> new IllegalArgumentException(string);
        };
    }

    private class NegatedConditionalVisitor
    extends BaseInspectionVisitor {
        private NegatedConditionalVisitor() {
        }

        public void visitConditionalExpression(@NotNull PsiConditionalExpression expression) {
            if (expression == null) {
                NegatedConditionalVisitor.$$$reportNull$$$0(0);
            }
            super.visitConditionalExpression(expression);
            PsiExpression thenBranch = expression.getThenExpression();
            if (thenBranch == null) {
                return;
            }
            PsiExpression elseBranch = expression.getElseExpression();
            if (elseBranch == null) {
                return;
            }
            PsiExpression condition = expression.getCondition();
            if (!ExpressionUtils.isNegation(condition, NegatedConditionalInspection.this.m_ignoreNegatedNullComparison, NegatedConditionalInspection.this.m_ignoreNegatedZeroComparison)) {
                return;
            }
            this.registerError((PsiElement)condition, new Object[0]);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "com/siyeh/ig/controlflow/NegatedConditionalInspection$NegatedConditionalVisitor", "visitConditionalExpression"));
        }
    }

    private static class NegatedConditionalFix
    extends PsiUpdateModCommandQuickFix {
        private NegatedConditionalFix() {
        }

        @NotNull
        public String getFamilyName() {
            String string = InspectionGadgetsBundle.message("negated.conditional.invert.quickfix", new Object[0]);
            if (string == null) {
                NegatedConditionalFix.$$$reportNull$$$0(0);
            }
            return string;
        }

        protected void applyFix(@NotNull Project project, @NotNull PsiElement element, @NotNull ModPsiUpdater updater) {
            if (project == null) {
                NegatedConditionalFix.$$$reportNull$$$0(1);
            }
            if (element == null) {
                NegatedConditionalFix.$$$reportNull$$$0(2);
            }
            if (updater == null) {
                NegatedConditionalFix.$$$reportNull$$$0(3);
            }
            PsiConditionalExpression conditionalExpression = (PsiConditionalExpression)element.getParent();
            assert (conditionalExpression != null);
            PsiExpression elseBranch = conditionalExpression.getElseExpression();
            PsiExpression thenBranch = conditionalExpression.getThenExpression();
            PsiExpression condition = conditionalExpression.getCondition();
            CommentTracker tracker = new CommentTracker();
            String negatedCondition = BoolUtils.getNegatedExpressionText(condition, tracker);
            assert (elseBranch != null);
            assert (thenBranch != null);
            String newStatement = negatedCondition + "?" + tracker.text((PsiElement)elseBranch) + ":" + tracker.text((PsiElement)thenBranch);
            PsiReplacementUtil.replaceExpression((PsiExpression)conditionalExpression, newStatement, tracker);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 2;
                case 1, 2, 3 -> 3;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/siyeh/ig/controlflow/NegatedConditionalInspection$NegatedConditionalFix";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "element";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "updater";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFamilyName";
                    break;
                }
                case 1: 
                case 2: 
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/siyeh/ig/controlflow/NegatedConditionalInspection$NegatedConditionalFix";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 1: 
                case 2: 
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "applyFix";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalStateException(string);
                case 1, 2, 3 -> new IllegalArgumentException(string);
            };
        }
    }
}

