/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.controlflow;

import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.options.OptPane;
import com.intellij.codeInspection.options.OptRegularComponent;
import com.intellij.modcommand.ModPsiUpdater;
import com.intellij.modcommand.PsiUpdateModCommandQuickFix;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaTokenType;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiIfStatement;
import com.intellij.psi.PsiStatement;
import com.intellij.psi.tree.IElementType;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.PsiReplacementUtil;
import com.siyeh.ig.psiutils.BoolUtils;
import com.siyeh.ig.psiutils.CommentTracker;
import com.siyeh.ig.psiutils.ExpressionUtils;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public final class NegatedIfElseInspection
extends BaseInspection {
    public boolean m_ignoreNegatedNullComparison = true;
    public boolean m_ignoreNegatedZeroComparison = false;

    @NotNull
    public String getID() {
        return "IfStatementWithNegatedCondition";
    }

    @Override
    @NotNull
    public String buildErrorString(Object ... infos) {
        String string = InspectionGadgetsBundle.message("negated.if.else.problem.descriptor", new Object[0]);
        if (string == null) {
            NegatedIfElseInspection.$$$reportNull$$$0(0);
        }
        return string;
    }

    @Override
    @NotNull
    public BaseInspectionVisitor buildVisitor() {
        return new NegatedIfElseVisitor();
    }

    @NotNull
    public OptPane getOptionsPane() {
        OptPane optPane = OptPane.pane((OptRegularComponent[])new OptRegularComponent[]{OptPane.checkbox((String)"m_ignoreNegatedNullComparison", (String)InspectionGadgetsBundle.message("negated.if.else.ignore.negated.null.option", new Object[0]), (OptRegularComponent[])new OptRegularComponent[0]), OptPane.checkbox((String)"m_ignoreNegatedZeroComparison", (String)InspectionGadgetsBundle.message("negated.if.else.ignore.negated.zero.option", new Object[0]), (OptRegularComponent[])new OptRegularComponent[0])});
        if (optPane == null) {
            NegatedIfElseInspection.$$$reportNull$$$0(1);
        }
        return optPane;
    }

    @Override
    protected LocalQuickFix buildFix(Object ... infos) {
        return new NegatedIfElseFix();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[2];
        objectArray2[0] = "com/siyeh/ig/controlflow/NegatedIfElseInspection";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "buildErrorString";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getOptionsPane";
                break;
            }
        }
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
    }

    private class NegatedIfElseVisitor
    extends BaseInspectionVisitor {
        private NegatedIfElseVisitor() {
        }

        public void visitIfStatement(@NotNull PsiIfStatement statement) {
            if (statement == null) {
                NegatedIfElseVisitor.$$$reportNull$$$0(0);
            }
            super.visitIfStatement(statement);
            PsiStatement thenBranch = statement.getThenBranch();
            if (thenBranch == null) {
                return;
            }
            PsiStatement elseBranch = statement.getElseBranch();
            if (elseBranch == null) {
                return;
            }
            if (elseBranch instanceof PsiIfStatement) {
                return;
            }
            PsiExpression condition = statement.getCondition();
            if (condition == null) {
                return;
            }
            if (!ExpressionUtils.isNegation(condition, NegatedIfElseInspection.this.m_ignoreNegatedNullComparison, NegatedIfElseInspection.this.m_ignoreNegatedZeroComparison)) {
                return;
            }
            PsiElement parent = statement.getParent();
            if (parent instanceof PsiIfStatement) {
                return;
            }
            this.registerStatementError((PsiStatement)statement, new Object[0]);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "statement", "com/siyeh/ig/controlflow/NegatedIfElseInspection$NegatedIfElseVisitor", "visitIfStatement"));
        }
    }

    private static class NegatedIfElseFix
    extends PsiUpdateModCommandQuickFix {
        private NegatedIfElseFix() {
        }

        @NotNull
        public String getFamilyName() {
            String string = InspectionGadgetsBundle.message("negated.if.else.invert.quickfix", new Object[0]);
            if (string == null) {
                NegatedIfElseFix.$$$reportNull$$$0(0);
            }
            return string;
        }

        protected void applyFix(@NotNull Project project, @NotNull PsiElement ifToken, @NotNull ModPsiUpdater updater) {
            PsiComment comment;
            IElementType tokenType;
            if (project == null) {
                NegatedIfElseFix.$$$reportNull$$$0(1);
            }
            if (ifToken == null) {
                NegatedIfElseFix.$$$reportNull$$$0(2);
            }
            if (updater == null) {
                NegatedIfElseFix.$$$reportNull$$$0(3);
            }
            PsiIfStatement ifStatement = (PsiIfStatement)ifToken.getParent();
            assert (ifStatement != null);
            PsiStatement elseBranch = ifStatement.getElseBranch();
            if (elseBranch == null) {
                return;
            }
            PsiStatement thenBranch = ifStatement.getThenBranch();
            if (thenBranch == null) {
                return;
            }
            PsiExpression condition = ifStatement.getCondition();
            if (condition == null) {
                return;
            }
            CommentTracker tracker = new CommentTracker();
            String negatedCondition = BoolUtils.getNegatedExpressionText(condition, tracker);
            Object elseText = tracker.text((PsiElement)elseBranch);
            PsiElement lastChild = elseBranch.getLastChild();
            if (lastChild instanceof PsiComment && JavaTokenType.END_OF_LINE_COMMENT.equals(tokenType = (comment = (PsiComment)lastChild).getTokenType())) {
                elseText = (String)elseText + "\n";
            }
            @NonNls String newStatement = "if(" + negatedCondition + ")" + (String)elseText + " else " + tracker.text((PsiElement)thenBranch);
            PsiReplacementUtil.replaceStatement((PsiStatement)ifStatement, newStatement, tracker);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 2;
                case 1, 2, 3 -> 3;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/siyeh/ig/controlflow/NegatedIfElseInspection$NegatedIfElseFix";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "ifToken";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "updater";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFamilyName";
                    break;
                }
                case 1: 
                case 2: 
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/siyeh/ig/controlflow/NegatedIfElseInspection$NegatedIfElseFix";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 1: 
                case 2: 
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "applyFix";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalStateException(string);
                case 1, 2, 3 -> new IllegalArgumentException(string);
            };
        }
    }
}

