/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.controlflow;

import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiStatement;
import com.intellij.psi.PsiSwitchBlock;
import com.intellij.psi.PsiSwitchExpression;
import com.intellij.psi.PsiSwitchStatement;
import com.intellij.psi.util.JavaElementKind;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.psiutils.ControlFlowUtils;
import org.jetbrains.annotations.NotNull;

public final class NestedSwitchStatementInspection
extends BaseInspection {
    @Override
    @NotNull
    protected String buildErrorString(Object ... infos) {
        String string = InspectionGadgetsBundle.message("nested.switch.statement.problem.descriptor", JavaElementKind.fromElement((PsiElement)((PsiElement)infos[0])).subject());
        if (string == null) {
            NestedSwitchStatementInspection.$$$reportNull$$$0(0);
        }
        return string;
    }

    @Override
    @NotNull
    public BaseInspectionVisitor buildVisitor() {
        return new NestedSwitchStatementVisitor();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/controlflow/NestedSwitchStatementInspection", "buildErrorString"));
    }

    private static class NestedSwitchStatementVisitor
    extends BaseInspectionVisitor {
        private NestedSwitchStatementVisitor() {
        }

        public void visitSwitchStatement(@NotNull PsiSwitchStatement statement) {
            if (statement == null) {
                NestedSwitchStatementVisitor.$$$reportNull$$$0(0);
            }
            super.visitSwitchStatement(statement);
            if (ControlFlowUtils.isNestedElement(statement, PsiSwitchBlock.class)) {
                this.registerStatementError((PsiStatement)statement, statement);
            }
        }

        public void visitSwitchExpression(@NotNull PsiSwitchExpression expression) {
            if (expression == null) {
                NestedSwitchStatementVisitor.$$$reportNull$$$0(1);
            }
            super.visitSwitchExpression(expression);
            if (ControlFlowUtils.isNestedElement(expression, PsiSwitchBlock.class)) {
                this.registerError(expression.getFirstChild(), expression);
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "statement";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "expression";
                    break;
                }
            }
            objectArray2[1] = "com/siyeh/ig/controlflow/NestedSwitchStatementInspection$NestedSwitchStatementVisitor";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "visitSwitchStatement";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "visitSwitchExpression";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

